#if !defined (__VISITOR_HPP)
#define __VISITOR_HPP

/*
  CoreLinux++ 
  Copyright (C) 1999,2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if !defined(__COMMON_HPP)
#include <Common.hpp>
#endif


namespace corelinux
{

   DECLARE_CLASS( Visitor );

   /**
   Represent an operation to be performed on the components of an
   object structure. Visitor lets you define a new operation 
   without changing the classes of the components on which it
   operates.
   */

   class Visitor
   {
   public:

                           /// Default Constructor

                           Visitor( void );

                           /** Copy Constructor
                           @param Visitor const reference
                           */

                           Visitor( VisitorCref );

                           /// Virtual Destructor  

      virtual              ~Visitor( void );

      //
      // Operator overloads
      //
               /**
               Assignment operator overload
               @param  Visitor const reference
               @return Visitor reference to self
               */
            
               VisitorRef  operator=( VisitorCref );

               /**
               Equality operator overload
               @param Visitor const reference
               @return true if equal, false otherwise
               */

               bool        operator==( VisitorCref ) const;

               /**
               Non-equality operator overload
               @param Visitor const reference
               @return false if equal, true otherwise
               */

               bool        operator!=( VisitorCref ) const;

   };

}
          
#endif   // if !defined(__VISITOR_HPP)

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.1 $
   $Date: 2000/05/12 03:27:47 $
   $Locker:  $
*/


