/*****************************************************************************
 * camcapt.h
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 *
 * Copyright (C) 2006 Stefan Sikora and Zoltan Csala
 *
 * Released under the terms of the GPL.
 * *NO WARRANTY*
 *****************************************************************************/

#ifndef _CAMCAPT_H_
#define _CAMCAPT_H_

#include <stdlib.h>

/***** Variables for frame recording */
extern int  capture_auto_on;           /* Whether to start capture in record more, or not */
extern int  max_fps;                   /* capture throttle rate */
extern void read_capturc();
extern void write_capturc();

/***** End of variables for frame recording */

/* Module's own exported functions */

extern GtkWidget *capt_menu_item(GtkWidget *main_window);
extern GtkWidget *record_quit_bar(GtkWidget *main_window, void *on_shutdown_app);
extern void set_debug_state(int debug_state);
extern int is_recording();
extern char* setCapturedFilename(char *name, GtkWidget *FrameLabel);
extern GtkWidget *get_pixmapped_button(char *button_label, const gchar *stock_id);
extern void write_image_to_file(char *jpg_buf, int packet_size, char *name, GtkWidget *FrameLabel, char *ui_name, GtkWidget *main_window);
extern GtkWidget *but_record();
extern char *frame_dir_path();

extern void show_ok_dialog(char *mymsg, GtkWidget *parent, char *ui_name, int error, void *callback);
extern void set_dummy_image(GtkWidget *current_image);
extern void set_dummy_image_start(GtkWidget *current_image);
extern void set_dummy_image_start2(GtkWidget *current_image);
extern unsigned char * image_2_jpg(char *in_img, int size, char *format);

extern void set_local_addresses();
extern char *local_address;

#endif
