/*****************************************************************************
 * gy_config.c
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 *
 * Copyright (C) 2003-2005, Erica Andrews
 * (Phrozensmoke ['at'] yahoo.com)
 * http://phpaint.sourceforge.net/pyvoicechat/
 * 
 * Copyright (C) 2000-2002 Chris Pinkham
 * cpinkham@corp.infi.net, cpinkham@bc2va.org
 * http://www4.infi.net/~cpinkham/gyach/
 * 
 * Released under the terms of the GPL.
 * *NO WARRANTY*
 *
 *****************************************************************************/

#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include <gtk/gtk.h>

#include "config.h"
#include "yahoochat.h"

#include "parsecfg.h"
#include "gy_config.h"
#include "gyachi_lib.h"
#include "theme_support.h"


/* globals referenced by gyachi, but also in the write_config */
char *cfg_filename         = NULL;
char *GYACH_CFG_DIR        = NULL;
char *GYACH_CFG_COMMON_DIR = NULL;
GList *login_list = NULL;
GList *room_list = NULL;
GList *chat_tab_list = NULL;
char *chat_tabs[4] = {0, 0, 0, 0};

/* config variables */
/* below are configuration parameter definitions with their default value set */

cfgList *username_list          = NULL;
cfgList *fav_room_list          = NULL;
cfgList *fav_room_id_list       = NULL;
cfgList *chat_tabname_list      = NULL;
int  show_blended_colors        = 1;
int  show_colors                = 1;
int  show_fonts                 = 1;
int  def_user                   = -1;
int  auto_away                  = 20;
int  auto_login                 = 1;
int  pm_brings_back             = 0;
int  buffer_size                = 10;
int  show_html                  = 1;
int  show_statuses              = 1;
int  show_enters                = 1;
int  profile_viewer             = 1;
int  ignore_on_mults            = 0;
int  mute_on_mults              = 0;
int  use_bold                   = 0;
int  use_italics                = 0;
int  use_underline              = 0;
int  force_lowercase            = 0;
int  suppress_mult              = 0;
int  ping_minutes               = 5;
int  auto_leave_chatroom        = 1;
int  chat_text_width            = 580;
int  chat_user_height           = 200;
int  disp_auto_ignored          = 1;
int  remember_tab_settings      = 0;
int  remember_password          = 1;
int  remember_position          = 1;
int  chat_window_x              = 0;
int  chat_window_y              = 0;
int  chat_window_width          = 800;
int  chat_window_height         = 600;
int  remember_notebook_position = 1;
int  notebook_window_x          = 0;
int  notebook_window_y          = 0;
int  notebook_window_width      = 512;
int  notebook_window_height     = 365;
int  notebook_current_page      = -1;
int  disable_emotes             = 1;
int  emotes_window_height       = 0;
int  limit_lfs                  = 8;
int  auto_reply_when_away       = 0;
int  pm_in_sep_windows          = 1;
int  pm_in_notebook             = 1;
int  pm_auto_logging            = 1;
int  pm_from_friends            = 1;
int  pm_from_users              = 1;
int  pm_from_all                = 1;
int  chat_window_logging        = 0;
int  debug_logging              = 0;
int  debug_packets              = 0;
int  enable_encryption          = 1;
int  auto_raise_pm              = 0;
int  auto_close_roomlist        = 1;
int  cache_room_list            = 1;
int  cache_room_captcha         = 0;
int  chat_timestamp             = 0;
int  chat_timestamp_pm          = 0;
int  ignore_guests              = 0;
int  auto_reconnect             = 1;
int  history_limit              = 50;
int  custom_color_red           = 0;
int  custom_color_green         = 0;
int  custom_color_blue          = 0;
char *auto_reply_msg            = NULL;
char *use_color                 = NULL;
char *custom_away_message       = NULL;
int   custom_away_icon          = 0;
char *logfile_directory         = NULL; /* initialized in gyach_init() */
char *logfile_template          = NULL;  /* initialized in gyach_init() */
char *browser_command           = NULL;
char *filter_command            = NULL;
char *font_name                 = NULL;
char *font_family               = NULL;
int  font_size                  = 14;
char *display_font_name         = NULL;
char *display_font_family       = NULL;
int  display_font_size          = 14;
int  indent_wrapped             = 1;
char *last_chatserver           = NULL;
char *last_chatroom             = NULL;
char *last_loginname            = NULL;
int  login_invisible            = 0;
int  login_noroom               = 1;
int  show_offline_buddies       = 1; /* default */
int  show_offline_in_online     = 0;
int  dont_show_offline_buddies  = 0;
int  show_empty_groups          = 1;    /* default to yes */

/* added 5 July 2007, to support collapsing buddy display */
/* the next 3 are radio style. only 1 can be set at a time */
int  expand_all_groups          = 1;
int  expand_only_online_groups  = 0;
int  expand_no_groups           = 0;

static char *fader_text_end_str        = NULL;		// deprecated 1.1.36
static char *fader_text_start_str      = NULL;		// deprecated 1.1.36
static int  use_chat_fader_val         = 1;		// deprecated 1.1.36
int  use_chat_fader             = 1;
char *fader_string              = NULL;
char *fader_type                = NULL;

char *password                  = NULL;
char *ymsgr_token               = NULL;
char *def_room                  = NULL;
int  show_adult                 = 1;
char *webcam_viewer_app         = NULL;
char *webcam_device             = NULL;
char *contact_first             = NULL;
char *contact_last              = NULL;
char *contact_email             = NULL;
char *contact_home              = NULL;
char *contact_work              = NULL;
char *contact_mobile            = NULL;
int  locale_status              = 1;
int  highlight_friends_in_chat  = 1;
int  highlight_me_in_chat       = 1;
int  enable_tab_icons           = 1;
int  enable_sound_events        = 1;
int  enable_sound_events_pm     = 1;
int  enable_trayicon            = 1;
int  enable_webcam_features     = 1;
int  show_cam_is_on             = 1;
char *webcamtext                = NULL;
int  enable_tuxvironments       = 1;
int  enter_leave_timestamp      = 1;
int  enable_chat_spam_filter    = 1;
int  mute_noage                 = 0;
int  mute_minors                = 0;
int  mute_nogender              = 0;
int  mute_males                 = 0;
int  mute_females               = 0;
int  allow_py_voice_helper      = 1;
int  max_sim_animations         = 2;
int  enable_animations          = 1;
int  enable_preemptive_strike   = 0;   /* fight fire with file ??
					* This is KNOWN to get you kicked off... */
int  enable_basic_protection    = 1;   /* enabled additional flow control
					* if boot attemtps detected */
int  disallow_random_friend_add = 0;
int  never_ignore_a_friend      = 1;
int  allow_no_sent_files        = 0;
int  show_avatars               = 1;
char *send_avatar               = NULL;
int  show_emoticons             = 1;
int  support_scentral_smileys   = 1;
int  use_proxy                  = 0;
char *proxy_host                = NULL;
int  proxy_port                 = 80;
char *custom_scale_text         = NULL;
int  first_post_is_url          = 0;
int  first_post_is_pm           = 0;
int  url_from_nonroom_user      = 0;
int  highlight_friends          = 0;
int  popup_buzz                 = 1;
int  popup_buddy_on             = 1;
int  popup_buddy_off            = 1;
int  popup_new_mail             = 1;
int  popup_news_bulletin        = 1;
int  popup_attach_systray       = 1;
int  transparent_bg             = 0;
int  shading_r                  = 0;
int  shading_g                  = 0;
int  shading_b                  = 0;
int  use_buddy_list_font        = 1;
int  show_quick_access_toolbar  = 1;
int  pm_nick_names              = 0;
int  show_my_status_in_chat     = 1;
int  bimage_share               = 0;
int  share_blist_avatar         = 1;
int  bimage_size                = 1;
int  auto_reject_invitations    = 0;
int  pmb_audibles               = 1;
int  pmb_smileys                = 1;
int  pmb_send_erase             = 1;
int  bimage_friend_only         = 0;
int  show_yavatars              = 1;
int  enable_audibles            = 1;
int  activate_profnames         = 1;
int  show_bimages               = 1;
int  show_bicon                 = 1;
int  pm_window_style            = 1;
char *bimage_file               = NULL;
char *flash_player_cmd          = NULL;
char *mp3_player                = NULL;
int  messy_ver                  = YMSG_VER_16;
int  pmb_toolbar1               = 1;
int  pmb_toolbar2               = 1;
int  chatwin_smileys            = 1;
int  chatwin_send_erase         = 1;
int  show_tabs_at_bottom        = 0;
char *file_transfer_server      = NULL;
int  allow_pm_buzzes            = 1;
int  enable_addressbook         = 1;
int  enable_pm_searches         = 1;
int  buddy_image_upload_method  = 0;  /* 0=normal, 1=reflective */ 
int  fxfr_close_meter_when_done = 0;
char *selected_theme            = NULL;
char *photoshare_dir            = NULL;
char *file_upload_dir           = NULL;
char *file_download_dir         = NULL;
int  auto_open_dl_manager       = 1;
char *gyachi_sound_device       = NULL;
int  gtk_spellcheck             = 1;

cfgStruct cfg[] = {
	/* parameter  type address of variable */
	{ "username",			CFG_STRING_LIST,	&username_list },
	{ "fav_room",			CFG_STRING_LIST,	&fav_room_list },
	{ "fav_room_id",		CFG_STRING_LIST,	&fav_room_id_list },
	{ "chat_tab_name",		CFG_STRING_LIST,	&chat_tabname_list },
	{ "show_blended_colors",	CFG_INT,		&show_blended_colors },
	{ "show_colors",		CFG_INT,		&show_colors },
	{ "show_fonts",			CFG_INT,		&show_fonts },
	{ "def_user",			CFG_INT,		&def_user },
	{ "auto_away",			CFG_INT,		&auto_away },
	{ "auto_login",			CFG_INT,		&auto_login },
	{ "pm_brings_back",		CFG_INT,		&pm_brings_back },
	{ "buffer_size",		CFG_INT,		&buffer_size },
	{ "show_html",			CFG_INT,		&show_html },
	{ "show_statuses",		CFG_INT,		&show_statuses },
	{ "show_enters",		CFG_INT,		&show_enters },
	{ "profile_viewer",		CFG_INT,		&profile_viewer },
	{ "ignore_on_mults",		CFG_INT,		&ignore_on_mults },
	{ "mute_on_mults",		CFG_INT,		&mute_on_mults },
	{ "use_bold",			CFG_INT,		&use_bold },
	{ "use_italics",		CFG_INT,		&use_italics },
	{ "use_underline",		CFG_INT,		&use_underline },
	{ "force_lowercase",		CFG_INT,		&force_lowercase },
	{ "suppress_mult",		CFG_INT,		&suppress_mult },
	{ "ping_minutes",		CFG_INT,		&ping_minutes },
	{ "auto_leave_chatroom",	CFG_INT,		&auto_leave_chatroom },
	{ "chat_text_width",		CFG_INT,		&chat_text_width },
	{ "chat_user_height",		CFG_INT,		&chat_user_height },
	{ "disp_auto_ignored",		CFG_INT,		&disp_auto_ignored },
	{ "remember_tab_settings",	CFG_INT,		&remember_tab_settings },
	{ "remember_password",		CFG_INT,		&remember_password },
	{ "remember_position",		CFG_INT,		&remember_position },
	{ "chat_window_x",		CFG_INT,		&chat_window_x },
	{ "chat_window_y",		CFG_INT,		&chat_window_y },
	{ "chat_window_width",		CFG_INT,		&chat_window_width },
	{ "chat_window_height",		CFG_INT,		&chat_window_height },
	{ "remember_notebook_position",	CFG_INT,		&remember_notebook_position },
	{ "notebook_window_x",		CFG_INT,		&notebook_window_x },
	{ "notebook_window_y",		CFG_INT,		&notebook_window_y },
	{ "notebook_window_width",	CFG_INT,		&notebook_window_width },
	{ "notebook_window_height",	CFG_INT,		&notebook_window_height },
	{ "notebook_current_page",	CFG_INT,		&notebook_current_page },
	{ "disable_emotes",		CFG_INT,		&disable_emotes },
	{ "emotes_window_height",	CFG_INT,		&emotes_window_height },
	{ "limit_lfs",			CFG_INT,		&limit_lfs },
	{ "auto_reply_when_away",	CFG_INT,		&auto_reply_when_away },
	{ "pm_in_sep_windows",		CFG_INT,		&pm_in_sep_windows },
	{ "pm_in_notebook",		CFG_INT,		&pm_in_notebook },
	{ "pm_auto_logging",		CFG_INT,		&pm_auto_logging },
	{ "pm_from_friends",		CFG_INT,		&pm_from_friends },
	{ "pm_from_users",		CFG_INT,		&pm_from_users },
	{ "pm_from_all",		CFG_INT,		&pm_from_all },
	{ "chat_window_logging",	CFG_INT,		&chat_window_logging },
	{ "debug_logging",		CFG_INT,		&debug_logging },
	{ "debug_packets",		CFG_INT,		&debug_packets },
	{ "enable_encryption",		CFG_INT,		&enable_encryption},
	{ "auto_raise_pm",		CFG_INT,		&auto_raise_pm },
	{ "auto_close_roomlist",	CFG_INT,		&auto_close_roomlist },
	{ "cache_room_list",		CFG_INT,		&cache_room_list },
	{ "cache_room_captcha",		CFG_INT,		&cache_room_captcha },
	{ "chat_timestamp",		CFG_INT,		&chat_timestamp },
	{ "chat_timestamp_pm",		CFG_INT,		&chat_timestamp_pm },
	{ "ignore_guests",		CFG_INT,		&ignore_guests },
	{ "auto_reconnect",		CFG_INT,		&auto_reconnect },
	{ "history_limit",		CFG_INT,		&history_limit },
	{ "custom_color_red",		CFG_INT,		&custom_color_red },
	{ "custom_color_blue",		CFG_INT,		&custom_color_blue },
	{ "custom_color_green",		CFG_INT,		&custom_color_green },
	{ "auto_reply_msg",		CFG_STRING,		&auto_reply_msg },
	{ "use_color",			CFG_STRING,		&use_color },
	{ "custom_away_message",	CFG_STRING,		&custom_away_message },
	{ "custom_away_icon",		CFG_INT,		&custom_away_icon },
	{ "logfile_directory",		CFG_STRING,		&logfile_directory },
	{ "logfile_template",		CFG_STRING,		&logfile_template },
	{ "browser_command",		CFG_STRING,		&browser_command },
	{ "filter_command",		CFG_STRING,		&filter_command },
	{ "font_name",			CFG_STRING,		&font_name },
	{ "font_family",		CFG_STRING,		&font_family },
	{ "font_size",			CFG_INT,		&font_size },
	{ "display_font_name",		CFG_STRING,		&display_font_name },
	{ "display_font_family",	CFG_STRING,		&display_font_family },
	{ "display_font_size",		CFG_INT,		&display_font_size },
	{ "indent_wrapped",		CFG_INT,		&indent_wrapped },
	{ "last_chatserver",		CFG_STRING,		&last_chatserver },
	{ "last_chatroom",		CFG_STRING,		&last_chatroom  },
	{ "last_loginname",		CFG_STRING,		&last_loginname  },
	{ "login_invisible",		CFG_INT,		&login_invisible },
	{ "login_noroom",		CFG_INT,		&login_noroom },

	{ "show_offline_buddies",	CFG_INT,		&show_offline_buddies },
	{ "show_offline_in_online",	CFG_INT,		&show_offline_in_online },
	{ "dont_show_offline_buddies",	CFG_INT,		&dont_show_offline_buddies },
	{ "show_empty_groups",		CFG_INT,		&show_empty_groups },
	{ "expand_all_groups",		CFG_INT,		&expand_all_groups },
	{ "expand_only_online_groups",	CFG_INT,		&expand_only_online_groups },
	{ "expand_no_groups",		CFG_INT,		&expand_no_groups },

	{ "use_chat_fader_val",		CFG_INT,		&use_chat_fader_val },	// deprecated 1.1.36
	{ "fader_text_end_str",		CFG_STRING,		&fader_text_end_str },	// deprecated 1.1.36
	{ "fader_text_start_str",	CFG_STRING,		&fader_text_start_str},	// deprecated 1.1.36
	{ "use_chat_fader",		CFG_INT,		&use_chat_fader },
	{ "fader_string",		CFG_STRING,		&fader_string  },
	{ "fader_type",			CFG_STRING,		&fader_type  },

	{ "password",			CFG_STRING,		&password },
	{ "ymsgr_token",		CFG_STRING,		&ymsgr_token },
	{ "def_room",			CFG_STRING,		&def_room },
	{ "show_adult",			CFG_INT,		&show_adult },
	{ "webcam_viewer_app",		CFG_STRING,		&webcam_viewer_app },
	{ "webcam_device",		CFG_STRING,		&webcam_device },
	{ "contact_first",		CFG_STRING,		&contact_first },
	{ "contact_last",		CFG_STRING,		&contact_last },
	{ "contact_email",		CFG_STRING,		&contact_email },
	{ "contact_home",		CFG_STRING,		&contact_home },
	{ "contact_work",		CFG_STRING,		&contact_work },
	{ "contact_mobile",		CFG_STRING,		&contact_mobile },
	{ "locale_status",		CFG_INT,		&locale_status },
	{ "highlight_friends_in_chat",	CFG_INT,		&highlight_friends_in_chat },
	{ "highlight_me_in_chat",	CFG_INT,		&highlight_me_in_chat },
	{ "enable_tab_icons",		CFG_INT,		&enable_tab_icons },
	{ "enable_sound_events",	CFG_INT,		&enable_sound_events },
	{ "enable_sound_events_pm",	CFG_INT,		&enable_sound_events_pm },
	{ "enable_trayicon",		CFG_INT,		&enable_trayicon},
	{ "enable_webcam_features",	CFG_INT,		&enable_webcam_features},
	{ "show_cam_is_on",		CFG_INT,		&show_cam_is_on},
	{ "webcamtext",			CFG_STRING,		&webcamtext},
	{ "enable_tuxvironments",	CFG_INT,		&enable_tuxvironments},
	{ "enter_leave_timestamp",	CFG_INT,		&enter_leave_timestamp },
	{ "enable_chat_spam_filter",	CFG_INT,		&enable_chat_spam_filter},
	{ "mute_noage",			CFG_INT,		&mute_noage },
	{ "mute_minors",		CFG_INT,		&mute_minors },
	{ "mute_nogender",		CFG_INT,		&mute_nogender },
	{ "mute_males",			CFG_INT,		&mute_males },
	{ "mute_females",		CFG_INT,		&mute_females },
	{ "allow_py_voice_helper",	CFG_INT,		&allow_py_voice_helper },
	{ "max_sim_animations",		CFG_INT,		&max_sim_animations},
	{ "enable_animations",		CFG_INT,		&enable_animations},
	{ "enable_preemptive_strike",	CFG_INT,		&enable_preemptive_strike },
	{ "enable_basic_protection",	CFG_INT,		&enable_basic_protection},
	{ "disallow_random_friend_add",	CFG_INT,		&disallow_random_friend_add},
	{ "never_ignore_a_friend",	CFG_INT,		&never_ignore_a_friend},
	{ "allow_no_sent_files",	CFG_INT,		&allow_no_sent_files},
	{ "show_avatars",		CFG_INT,		&show_avatars },
	{ "send_avatar",		CFG_STRING,		&send_avatar },
	{ "show_emoticons",		CFG_INT,		&show_emoticons },
	{ "support_scentral_smileys",	CFG_INT,		&support_scentral_smileys },
	{ "use_proxy",			CFG_INT,		&use_proxy },
	{ "proxy_host",			CFG_STRING,		&proxy_host },
	{ "proxy_port",			CFG_INT,		&proxy_port },
	{ "custom_scale_text",		CFG_STRING,		&custom_scale_text },
	{ "first_post_is_url",		CFG_INT,		&first_post_is_url },
	{ "first_post_is_pm",		CFG_INT,		&first_post_is_pm },
	{ "url_from_nonroom_user",	CFG_INT,		&url_from_nonroom_user },
	{ "highlight_friends",		CFG_INT,		&highlight_friends },
	{ "popup_buzz",			CFG_INT,		&popup_buzz },
	{ "popup_buddy_on",		CFG_INT,		&popup_buddy_on },
	{ "popup_buddy_off",		CFG_INT,		&popup_buddy_off },
	{ "popup_new_mail",		CFG_INT,		&popup_new_mail },
	{ "popup_news_bulletin",	CFG_INT,		&popup_news_bulletin },
	{ "popup_attach_systray",	CFG_INT,		&popup_attach_systray },
	{ "transparent_bg",		CFG_INT,		&transparent_bg },
	{ "shading_r",			CFG_INT,		&shading_r },
	{ "shading_g",			CFG_INT,		&shading_g },
	{ "shading_b",			CFG_INT,		&shading_b },
	{ "use_buddy_list_font",	CFG_INT,		&use_buddy_list_font },
	{ "show_quick_access_toolbar",	CFG_INT,		&show_quick_access_toolbar },
	{ "pm_nick_names",		CFG_INT,		&pm_nick_names },
	{ "show_my_status_in_chat",	CFG_INT,		&show_my_status_in_chat },

	{ "bimage_share",		CFG_INT,		&bimage_share }, 
	{ "share_blist_avatar",		CFG_INT,		&share_blist_avatar }, 
	{ "bimage_size",		CFG_INT,		&bimage_size }, 
	{ "auto_reject_invitations",	CFG_INT,		&auto_reject_invitations }, 
	{ "pmb_audibles",		CFG_INT,		&pmb_audibles }, 
	{ "pmb_smileys",		CFG_INT,		&pmb_smileys }, 
	{ "pmb_send_erase",		CFG_INT,		&pmb_send_erase }, 
	{ "bimage_friend_only",		CFG_INT,		&bimage_friend_only }, 
	{ "show_yavatars",		CFG_INT,		&show_yavatars }, 
	{ "enable_audibles",		CFG_INT,		&enable_audibles }, 
	{ "activate_profnames",		CFG_INT,		&activate_profnames}, 
	{ "show_bimages",		CFG_INT,		&show_bimages }, 
	{ "show_bicon",			CFG_INT,		&show_bicon }, 
	{ "pm_window_style",		CFG_INT,		&pm_window_style }, 
	{ "bimage_file",		CFG_STRING,		&bimage_file}, 
	{ "flash_player_cmd",		CFG_STRING,		&flash_player_cmd}, 
	{ "mp3_player",			CFG_STRING,		&mp3_player }, 
	{ "messy_ver",			CFG_INT,		&messy_ver }, 
	{ "pmb_toolbar1",		CFG_INT,		&pmb_toolbar1 }, 
	{ "pmb_toolbar2",		CFG_INT,		&pmb_toolbar2 }, 
	{ "chatwin_smileys",		CFG_INT,		&chatwin_smileys }, 
	{ "chatwin_send_erase",		CFG_INT,		&chatwin_send_erase }, 
	{ "show_tabs_at_bottom",	CFG_INT,		&show_tabs_at_bottom }, 

	{ "file_transfer_server",	CFG_STRING,		&file_transfer_server }, 
	{ "allow_pm_buzzes",		CFG_INT,		&allow_pm_buzzes }, 

	{ "enable_addressbook",		CFG_INT,		&enable_addressbook }, 
	{ "enable_pm_searches",		CFG_INT,		&enable_pm_searches }, 
	{ "buddy_image_upload_method",	CFG_INT,		&buddy_image_upload_method }, 

	{ "fxfr_close_meter_when_done",	CFG_INT,		&fxfr_close_meter_when_done }, 

	{ "selected_theme",		CFG_STRING,		&selected_theme },

	{ "photoshare_dir",		CFG_STRING,		&photoshare_dir },
	{ "file_upload_dir",		CFG_STRING,		&file_upload_dir },
	{ "file_download_dir",		CFG_STRING,		&file_download_dir },
	{ "auto_open_dl_manager",	CFG_INT,		&auto_open_dl_manager },
	{ "gyachi_sound_device",	CFG_STRING,		&gyachi_sound_device },

	{ "gtk_spellcheck",		CFG_INT,		&gtk_spellcheck },

	{ NULL,				CFG_END,		NULL }
};


/*
 * Converts a 6 bit number to a Base64 encoded letter.
 * Taken from base64.c, public domain code 
*/

static char itob64(int n)
{
	/* Encode A-B */
	if(n <= 25) return('A' + n);
	/* Encode a-b */
	else if(n <= 51) return('a' + n - 26);
	/* Encode 0-9 */
	else if(n <= 61) return('0' + n - 52);
	/* Encode the weird ones */
	else if(n == 62) return '+';
	else if(n == 63) return '/';
	/* Not a 6 bit number */
	else return 'a';
}

/* implement basic password decoding, PhrozenSmoke */
char *decode_pass(char *some_p) {
	int stopit=0;
	char inbuf[355]="";
	char obuf[102]="";
	char tbuf[6]="";
	char nbuf[6]="";
	char *inb=inbuf;
	char *findit=NULL;
	int iletto=12;
	int letwh=0;
	char *retc=obuf;
	snprintf(retc, 3, "%s","");
	if (some_p==NULL) {  return strdup("");}
	if (strlen(some_p)==0) {  return strdup("");}

	stopit=snprintf(inbuf,353,"%s",some_p);
	inbuf[stopit]='\0';

	findit=strstr(inbuf,"1p7127143319");
	if (!findit) {  return strdup("");}

	sprintf(obuf,"%s","");
	while (findit != NULL)  {
		*findit='\0';
		snprintf(nbuf,5, "%s", inb);
		snprintf(tbuf,5,"%c", itob64( atoi( nbuf )-89) );
		strncat(obuf,tbuf,5);
		letwh=0;
		while (letwh<iletto){ letwh++; findit++;}
		inb=findit;
		findit=strstr(inb,"1p7127143319");
		if (findit==NULL ) {break;}
		if (strlen(obuf)>80) {break;}		
	}
	return strdup(retc);
}



/*
 * this function serves the purpose of upgrading Gyach user's config files
 * to the new *nix client chat standard at:
 * http://www.edge-op.org/files/chatstandard
 *
 * this standard should be supported by curphoo and hopefully curfloo in
 * due time
 */
void upgrade_config_to_standard() {
	char filename[256];
	char filename2[256];
	char filename3[256];
	struct stat sbuf;
	struct stat sbuf2;
	struct stat sbuf3;

	snprintf( filename, 254, "%s/.gyach/gyachrc", getenv( "HOME" ));
	snprintf( filename2, 254, "%s/.yahoorc/gyach/gyachrc", getenv( "HOME" ));

	if (( ! stat( filename, &sbuf )) &&
		( stat( filename2, &sbuf2 ))) {
		/* Convert from ~/.gyach directory to ~/.yahoorc format */
		/* make ~/.yahoorc dir if doesn't exist */
		snprintf( filename3,254,  "%s/.yahoorc", getenv( "HOME" ));
		if ( stat( filename3, &sbuf3 )) {
			mkdir( filename3, 0700 );
		}

		/* remove ~/.yahoorc/gyach dir if exists */
		/* only do this since we know no ~/.yahoorc/gyach/gyachrc file exists */
		snprintf( filename3,254,  "%s/.yahoorc/gyach", getenv( "HOME" ));
		if ( ! stat( filename3, &sbuf3 )) {
			rmdir( filename3 );
		}

		/* move gyachrc file */
		rename( filename, filename2 );

		/* move aliases/commands file */
		snprintf( filename, 254, "%s/.gyach/aliases", getenv( "HOME" ));
		snprintf( filename2, 254, "%s/.gyach/commands", getenv( "HOME" ));
		/* waiting on this for fan to implement standard
		snprintf( filename2, 254, "%s/.yahoorc/gyach/commands", getenv( "HOME" ));
		*/
		if ( stat( filename2, &sbuf2 )) {
			/* if commands doesn't exist then move aliases file */
			rename( filename, filename2 );
		}

		/* move ignore.list file */
		snprintf( filename, 254, "%s/.gyach/ignore.list", getenv( "HOME" ));
		snprintf( filename2,254,  "%s/.gyach/ignore", getenv( "HOME" ));
		/* waiting on this for fan to implement standard
		snprintf( filename2, 254, "%s/.yahoorc/ignore", getenv( "HOME" ));
		*/
		if ( stat( filename2, &sbuf2 )) {
			/* if ignore list doesn't exist them move ignore.list file */
			rename( filename, filename2 );
		}

		/* finally move the gyach directory itself */
		snprintf( filename,254,  "%s/.gyach", getenv( "HOME" ));
		snprintf( filename2,254,  "%s/.yahoorc/gyach", getenv( "HOME" ));
		rename( filename, filename2 );
	}

	/* convert from 0.9.1-pre3 */
	snprintf( filename, 254, "%s/.yahoorc/ignore", getenv( "HOME" ));
	snprintf( filename2, 254, "%s/.yahoorc/gyach/ignore", getenv( "HOME" ));
	if (( ! stat( filename, &sbuf )) &&
		( stat( filename2, &sbuf2 ))) {
		rename( filename, filename2 );
	}

	snprintf( filename, 254, "%s/.yahoorc/commands", getenv( "HOME" ));
	snprintf( filename2, 254, "%s/.yahoorc/gyach/commands", getenv( "HOME" ));
	if (( ! stat( filename, &sbuf )) &&
		( stat( filename2, &sbuf2 ))) {
		rename( filename, filename2 );
	}
}

/* This routine manages the changes to the fader strings between pre-1.1.36 and 1.1.36 */
void gyachi_convert_fader_strings() {
	if (!fader_string &&
	    fader_text_start_str &&
	    (fader_text_start_str[strlen(fader_text_start_str)-1] == '>')) {
		if (!strncmp(fader_text_start_str, "<FADE ", 6)) {
			if (fader_type) free(fader_type);
			fader_type = strdup("FADE");
			fader_text_start_str[strlen(fader_text_start_str)-1] = 0;
			fader_string=strdup(fader_text_start_str+6);
			use_chat_fader = use_chat_fader_val;
		}

		if (!strncmp(fader_text_start_str, "<ALT ", 5)) {
			if (fader_type) free(fader_type);
			fader_type = strdup("ALT");
			fader_text_start_str[strlen(fader_text_start_str)-1] = 0;
			fader_string=strdup(fader_text_start_str+5);
			use_chat_fader = use_chat_fader_val;
		}
  	}
}

void gyach_copy( char *src, char *dest ) {
	FILE *in, *out;
	int ch;
	char fn_src[256];
	char fn_dest[256];

	snprintf( fn_src, 254, "%s/.yahoorc/%s", getenv( "HOME" ), src );
	snprintf( fn_dest, 254, "%s/.yahoorc/%s", getenv( "HOME" ), dest );

	in = fopen( fn_src, "r" );
	if ( in ) {
		out = fopen( fn_dest, "w" );
		if ( out ) {
			while(( ch = fgetc( in )) != EOF ) {
				fputc( ch, out );
			}
			fclose( out );
		}
		fclose( in );
	}
}

void gyach_backup() {
	char  *(pieces[4]);
	char t_current[5];
	char t_next[5];
	char *t_filename1;
	char *t_filename2;
	char *t_backup_dir;
	struct stat sbuf;
	int i;

	pieces[0]=GYACH_CFG_DIR;
	pieces[1]="/backups";
	pieces[2]=NULL;
	t_backup_dir=gyachi_filename(pieces);

	if ( stat(t_backup_dir, &sbuf )) {
		mkdir(t_backup_dir, 0700 );
	}

	pieces[0]=t_backup_dir;
	for( i = 8; i >= 0; i-- ) {
		sprintf(t_current, "%d", i);
		sprintf(t_next,    "%d", i+1);

		pieces[1]="/gyachrc.";
		pieces[2]=t_current;
		pieces[3]=NULL;
		t_filename1 = gyachi_filename(pieces);
		pieces[2]=t_next;
		t_filename2 = gyachi_filename(pieces);
		rename(t_filename1, t_filename2);
		free(t_filename1);
		free(t_filename2);

		pieces[1]="/ignore.";
		pieces[2]=t_current;
		t_filename1 = gyachi_filename(pieces);
		pieces[2]=t_next;
		t_filename2 = gyachi_filename(pieces);
		rename(t_filename1, t_filename2);
		free(t_filename1);
		free(t_filename2);

		pieces[1]="/commands.";
		pieces[2]=t_current;
		t_filename1 = gyachi_filename(pieces);
		pieces[2]=t_next;
		t_filename2 = gyachi_filename(pieces);
		rename(t_filename1, t_filename2);
		free(t_filename1);
		free(t_filename2);
	}

	free(t_backup_dir);

	/* now copy originals to *.0 in backups dir */
	gyach_copy( "gyach/gyachrc",  "gyach/backups/gyachrc.0" );
	gyach_copy( "gyach/ignore",   "gyach/backups/ignore.0" );
	gyach_copy( "gyach/commands", "gyach/backups/commands.0" );
}


int gyach_init() {
	char  *(pieces[3]);
	struct stat sbuf;
	int rv;

	// DBG( 1, "gyach_init()\n" );

	upgrade_config_to_standard();

	pieces[0]=getenv("HOME");
	pieces[1]="/.yahoorc";
	pieces[2]=NULL;

	if (GYACH_CFG_COMMON_DIR) free(GYACH_CFG_COMMON_DIR);
	GYACH_CFG_COMMON_DIR = gyachi_filename(pieces);

	if ( stat( GYACH_CFG_COMMON_DIR, &sbuf )) {
		mkdir( GYACH_CFG_COMMON_DIR, 0700 );
	}

	pieces[0]=GYACH_CFG_COMMON_DIR;
	pieces[1]="/gyach";
	pieces[2]=NULL;

	if (GYACH_CFG_DIR) free(GYACH_CFG_DIR);
	GYACH_CFG_DIR=gyachi_filename(pieces);

	if ( stat( GYACH_CFG_DIR, &sbuf )) {
		mkdir( GYACH_CFG_DIR, 0700 );
	}

	pieces[0]=GYACH_CFG_DIR;
	pieces[1]="/gyachrc";
	pieces[2]=NULL;

	if (cfg_filename) free(cfg_filename);
	cfg_filename=gyachi_filename(pieces);

	/* overrides until we get the standard in place */
	pieces[0]=getenv("HOME");
	pieces[1]="/.yahoorc/gyach";
	pieces[2]=NULL;

	if (GYACH_CFG_COMMON_DIR) free(GYACH_CFG_COMMON_DIR);
	GYACH_CFG_COMMON_DIR=gyachi_filename(pieces);

	gyach_backup();
	rv = read_config();
	load_gyachi_theme(selected_theme);

	gyachi_convert_fader_strings();

	return(rv);
}


int read_config() {
	struct stat sbuf;
	cfgList *this_item;
	cfgList *id_item;
	char temp_string[300];
	const char *temp_str;
	char *tab_names[] = {CHAT_TAB, BUDDY_TAB, YAHOO_TAB, CONTACT_TAB};
	int i, j;

	// DBG( 1, "read_config()\n" );

	if ( ! getenv( "HOME" )) {
		return 0;
	}

	if ( stat( cfg_filename, &sbuf )) {
		return 0;
	}

	cfgParse( cfg_filename, cfg, CFG_SIMPLE );

	if (!webcamtext) {
		webcamtext=strdup("View My Webcam");
	}

	if (!contact_first) {
		contact_first=strdup("");
	}

	if (!contact_last) {
		contact_last=strdup("");
	}

	if (!contact_email) {
		contact_email=strdup("");
	}

	if (!contact_home) {
		contact_home=strdup("555-555-5555");
	}

	if (!contact_work) {
		contact_work=strdup("555-555-5555");
	}

	if (!contact_mobile) {
		contact_mobile=strdup("555-555-5555");
	}

	if (!flash_player_cmd) {
		flash_player_cmd=strdup("gflashplayer");
	}

	if (!mp3_player) {
		mp3_player=strdup("mplayer -ao esd -quiet");
	}

	if (proxy_host) {
		temp_str = proxy_host;
		proxy_host = strdup(temp_str);
	}

	if (!selected_theme) {
		selected_theme=strdup("gyachi-classic");
	}

	if (!logfile_directory) {
		snprintf( temp_string, 290, "%s/log", GYACH_CFG_DIR);
		logfile_directory = strdup(temp_string);
		if ( stat(logfile_directory, &sbuf) ) {
			mkdir( logfile_directory, 0700 );
		}
	}

	if (!logfile_template) {
		snprintf( temp_string, 290, "%s/log", GYACH_CFG_DIR);
		logfile_template  = strdup("%Y-%m-%d.%H%M%S.txt");
	}

	if (password)  {
		/* This comes to us strdup'ed, as we need it */
		password=decode_pass(password);
		/* printf("\ngot pass: %s\n",password); fflush(stdout);  */ /* testing */
	}

	if ( ! use_color )
		use_color = strdup( "black" );

	this_item = username_list;
	while( this_item ) {
		login_list = g_list_append( login_list, strdup( this_item->str ));
		this_item = this_item->next;
	}

	id_item   = fav_room_id_list;
	for (this_item=fav_room_list; this_item; this_item=this_item->next ) {
		add_room(this_item->str, id_item?id_item->str:"0", 1);
		if (id_item) {
			id_item = id_item->next;
		}
	}

	/* build the chat_tabs array.
	 * - Only the 4 chat ui tab titles may appear.
	 * - a char ui tab title may appear exactly one time.
	 * - If a tab is missing from the config file, add it
	 */

	/* first load the tabs from the config file */
	for (this_item=chat_tabname_list, i=0; i<4; i++) {
		if (chat_tabs[i]) {
			free(chat_tabs[i]);
			chat_tabs[i] = NULL;
		}

		if (this_item && remember_tab_settings) {
			for (j=0; j<4; j++) {
				if (tab_names[j] && !strcmp(tab_names[j], this_item->str)) {
					chat_tabs[i] = strdup(this_item->str);
					tab_names[j] = NULL;
					break;
				}
			}
			this_item = this_item->next;
		}
	}

	/* now, if any tabs not loaded, add them in... */
	for (i=0; i<4; i++) {
		if (tab_names[i]) {
			for (j=0; j<4; j++) {
				if (!chat_tabs[j]) {
					chat_tabs[j] = strdup(tab_names[i]);
					break;
				}
			}
		}
	}

	temp_str = yprotocol_to_name(messy_ver);
	if (temp_str == 0) {
		/* check for invalid value in config file, and reset to default */
		messy_ver = 0;
	}

	if ( ! messy_ver ) {
		/* default to Y-16 */
		messy_ver=YMSG_VER_16;
	}

	if ( !photoshare_dir) {
		photoshare_dir = strdup(getenv("HOME"));
	}
	if ( !file_upload_dir) {
		file_upload_dir = strdup(getenv("HOME"));
	}
	if ( !file_download_dir) {
		file_download_dir = strdup(getenv("HOME"));
	}

	if (gyachi_sound_device && !strcmp(gyachi_sound_device, "(null)")) {
		free(gyachi_sound_device);
		gyachi_sound_device = NULL;
	}

	return 1;
}



