/* DBCS (double-byte) charset to unicode. 0x0000 means no mapping */
/* hi = (code >> 6) */
/* lo = code & 0x3F */
/* rawoff = cp950_to_unicode_hitbl[hi] */
/* if (rawoff != 0xFFFF) ucode = _raw[rawoff+lo] */

// Note: This is the ChinaSea extended CP950 table;
// The standard CP950 table is made from it automatically. 
const uint16_t cp950ext_to_unicode_raw[24320] = {
	/* codebase=0x0000 rawbase=0x0000 */
	0x0000,0x0001,0x0002,0x0003,0x0004,0x0005,0x0006,0x0007, /* 0x0000-0x0007 */
	0x0008,0x0009,0x000a,0x000b,0x000c,0x000d,0x000e,0x000f, /* 0x0008-0x000F */
	0x0010,0x0011,0x0012,0x0013,0x0014,0x0015,0x0016,0x0017, /* 0x0010-0x0017 */
	0x0018,0x0019,0x001a,0x001b,0x001c,0x001d,0x001e,0x001f, /* 0x0018-0x001F */
	0x0020,0x0021,0x0022,0x0023,0x0024,0x0025,0x0026,0x0027, /* 0x0020-0x0027 */
	0x0028,0x0029,0x002a,0x002b,0x002c,0x002d,0x002e,0x002f, /* 0x0028-0x002F */
	0x0030,0x0031,0x0032,0x0033,0x0034,0x0035,0x0036,0x0037, /* 0x0030-0x0037 */
	0x0038,0x0039,0x003a,0x003b,0x003c,0x003d,0x003e,0x003f, /* 0x0038-0x003F */
	/* codebase=0x0040 rawbase=0x0040 */
	0x0040,0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047, /* 0x0040-0x0047 */
	0x0048,0x0049,0x004a,0x004b,0x004c,0x004d,0x004e,0x004f, /* 0x0048-0x004F */
	0x0050,0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057, /* 0x0050-0x0057 */
	0x0058,0x0059,0x005a,0x005b,0x005c,0x005d,0x005e,0x005f, /* 0x0058-0x005F */
	0x0060,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,0x0067, /* 0x0060-0x0067 */
	0x0068,0x0069,0x006a,0x006b,0x006c,0x006d,0x006e,0x006f, /* 0x0068-0x006F */
	0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,0x0077, /* 0x0070-0x0077 */
	0x0078,0x0079,0x007a,0x007b,0x007c,0x007d,0x007e,0x007f, /* 0x0078-0x007F */
	/* codebase=0x8140 rawbase=0x0080 */
	0xeeb8,0xeeb9,0xeeba,0xeebb,0xeebc,0xeebd,0xeebe,0xeebf, /* 0x8140-0x8147 */
	0xeec0,0xeec1,0xeec2,0xeec3,0xeec4,0xeec5,0xeec6,0xeec7, /* 0x8148-0x814F */
	0xeec8,0xeec9,0xeeca,0xeecb,0xeecc,0xeecd,0xeece,0xeecf, /* 0x8150-0x8157 */
	0xeed0,0xeed1,0xeed2,0xeed3,0xeed4,0xeed5,0xeed6,0xeed7, /* 0x8158-0x815F */
	0xeed8,0xeed9,0xeeda,0xeedb,0xeedc,0xeedd,0xeede,0xeedf, /* 0x8160-0x8167 */
	0xeee0,0xeee1,0xeee2,0xeee3,0xeee4,0xeee5,0xeee6,0xeee7, /* 0x8168-0x816F */
	0xeee8,0xeee9,0xeeea,0xeeeb,0xeeec,0xeeed,0xeeee,0xeeef, /* 0x8170-0x8177 */
	0xeef0,0xeef1,0xeef2,0xeef3,0xeef4,0xeef5,0xeef6,0x0000, /* 0x8178-0x817F */
	/* codebase=0x8180 rawbase=0x00c0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8180-0x8187 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8188-0x818F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8190-0x8197 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8198-0x819F */
	0x0000,0xeef7,0xeef8,0xeef9,0xeefa,0xeefb,0xeefc,0xeefd, /* 0x81A0-0x81A7 */
	0xeefe,0xeeff,0xef00,0xef01,0xef02,0xef03,0xef04,0xef05, /* 0x81A8-0x81AF */
	0xef06,0xef07,0xef08,0xef09,0xef0a,0xef0b,0xef0c,0xef0d, /* 0x81B0-0x81B7 */
	0xef0e,0xef0f,0xef10,0xef11,0xef12,0xef13,0xef14,0xef15, /* 0x81B8-0x81BF */
	/* codebase=0x81c0 rawbase=0x0100 */
	0xef16,0xef17,0xef18,0xef19,0xef1a,0xef1b,0xef1c,0xef1d, /* 0x81C0-0x81C7 */
	0xef1e,0xef1f,0xef20,0xef21,0xef22,0xef23,0xef24,0xef25, /* 0x81C8-0x81CF */
	0xef26,0xef27,0xef28,0xef29,0xef2a,0xef2b,0xef2c,0xef2d, /* 0x81D0-0x81D7 */
	0xef2e,0xef2f,0xef30,0xef31,0xef32,0xef33,0xef34,0xef35, /* 0x81D8-0x81DF */
	0xef36,0xef37,0xef38,0xef39,0xef3a,0xef3b,0xef3c,0xef3d, /* 0x81E0-0x81E7 */
	0xef3e,0xef3f,0xef40,0xef41,0xef42,0xef43,0xef44,0xef45, /* 0x81E8-0x81EF */
	0xef46,0xef47,0xef48,0xef49,0xef4a,0xef4b,0xef4c,0xef4d, /* 0x81F0-0x81F7 */
	0xef4e,0xef4f,0xef50,0xef51,0xef52,0xef53,0xef54,0x0000, /* 0x81F8-0x81FF */
	/* codebase=0x8240 rawbase=0x0140 */
	0xef55,0xef56,0xef57,0xef58,0xef59,0xef5a,0xef5b,0xef5c, /* 0x8240-0x8247 */
	0xef5d,0xef5e,0xef5f,0xef60,0xef61,0xef62,0xef63,0xef64, /* 0x8248-0x824F */
	0xef65,0xef66,0xef67,0xef68,0xef69,0xef6a,0xef6b,0xef6c, /* 0x8250-0x8257 */
	0xef6d,0xef6e,0xef6f,0xef70,0xef71,0xef72,0xef73,0xef74, /* 0x8258-0x825F */
	0xef75,0xef76,0xef77,0xef78,0xef79,0xef7a,0xef7b,0xef7c, /* 0x8260-0x8267 */
	0xef7d,0xef7e,0xef7f,0xef80,0xef81,0xef82,0xef83,0xef84, /* 0x8268-0x826F */
	0xef85,0xef86,0xef87,0xef88,0xef89,0xef8a,0xef8b,0xef8c, /* 0x8270-0x8277 */
	0xef8d,0xef8e,0xef8f,0xef90,0xef91,0xef92,0xef93,0x0000, /* 0x8278-0x827F */
	/* codebase=0x8280 rawbase=0x0180 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8280-0x8287 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8288-0x828F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8290-0x8297 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8298-0x829F */
	0x0000,0xef94,0xef95,0xef96,0xef97,0xef98,0xef99,0xef9a, /* 0x82A0-0x82A7 */
	0xef9b,0xef9c,0xef9d,0xef9e,0xef9f,0xefa0,0xefa1,0xefa2, /* 0x82A8-0x82AF */
	0xefa3,0xefa4,0xefa5,0xefa6,0xefa7,0xefa8,0xefa9,0xefaa, /* 0x82B0-0x82B7 */
	0xefab,0xefac,0xefad,0xefae,0xefaf,0xefb0,0xefb1,0xefb2, /* 0x82B8-0x82BF */
	/* codebase=0x82c0 rawbase=0x01c0 */
	0xefb3,0xefb4,0xefb5,0xefb6,0xefb7,0xefb8,0xefb9,0xefba, /* 0x82C0-0x82C7 */
	0xefbb,0xefbc,0xefbd,0xefbe,0xefbf,0xefc0,0xefc1,0xefc2, /* 0x82C8-0x82CF */
	0xefc3,0xefc4,0xefc5,0xefc6,0xefc7,0xefc8,0xefc9,0xefca, /* 0x82D0-0x82D7 */
	0xefcb,0xefcc,0xefcd,0xefce,0xefcf,0xefd0,0xefd1,0xefd2, /* 0x82D8-0x82DF */
	0xefd3,0xefd4,0xefd5,0xefd6,0xefd7,0xefd8,0xefd9,0xefda, /* 0x82E0-0x82E7 */
	0xefdb,0xefdc,0xefdd,0xefde,0xefdf,0xefe0,0xefe1,0xefe2, /* 0x82E8-0x82EF */
	0xefe3,0xefe4,0xefe5,0xefe6,0xefe7,0xefe8,0xefe9,0xefea, /* 0x82F0-0x82F7 */
	0xefeb,0xefec,0xefed,0xefee,0xefef,0xeff0,0xeff1,0x0000, /* 0x82F8-0x82FF */
	/* codebase=0x8340 rawbase=0x0200 */
	0xeff2,0xeff3,0xeff4,0xeff5,0xeff6,0xeff7,0xeff8,0xeff9, /* 0x8340-0x8347 */
	0xeffa,0xeffb,0xeffc,0xeffd,0xeffe,0xefff,0xf000,0xf001, /* 0x8348-0x834F */
	0xf002,0xf003,0xf004,0xf005,0xf006,0xf007,0xf008,0xf009, /* 0x8350-0x8357 */
	0xf00a,0xf00b,0xf00c,0xf00d,0xf00e,0xf00f,0xf010,0xf011, /* 0x8358-0x835F */
	0xf012,0xf013,0xf014,0xf015,0xf016,0xf017,0xf018,0xf019, /* 0x8360-0x8367 */
	0xf01a,0xf01b,0xf01c,0xf01d,0xf01e,0xf01f,0xf020,0xf021, /* 0x8368-0x836F */
	0xf022,0xf023,0xf024,0xf025,0xf026,0xf027,0xf028,0xf029, /* 0x8370-0x8377 */
	0xf02a,0xf02b,0xf02c,0xf02d,0xf02e,0xf02f,0xf030,0x0000, /* 0x8378-0x837F */
	/* codebase=0x8380 rawbase=0x0240 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8380-0x8387 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8388-0x838F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8390-0x8397 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8398-0x839F */
	0x0000,0xf031,0xf032,0xf033,0xf034,0xf035,0xf036,0xf037, /* 0x83A0-0x83A7 */
	0xf038,0xf039,0xf03a,0xf03b,0xf03c,0xf03d,0xf03e,0xf03f, /* 0x83A8-0x83AF */
	0xf040,0xf041,0xf042,0xf043,0xf044,0xf045,0xf046,0xf047, /* 0x83B0-0x83B7 */
	0xf048,0xf049,0xf04a,0xf04b,0xf04c,0xf04d,0xf04e,0xf04f, /* 0x83B8-0x83BF */
	/* codebase=0x83c0 rawbase=0x0280 */
	0xf050,0xf051,0xf052,0xf053,0xf054,0xf055,0xf056,0xf057, /* 0x83C0-0x83C7 */
	0xf058,0xf059,0xf05a,0xf05b,0xf05c,0xf05d,0xf05e,0xf05f, /* 0x83C8-0x83CF */
	0xf060,0xf061,0xf062,0xf063,0xf064,0xf065,0xf066,0xf067, /* 0x83D0-0x83D7 */
	0xf068,0xf069,0xf06a,0xf06b,0xf06c,0xf06d,0xf06e,0xf06f, /* 0x83D8-0x83DF */
	0xf070,0xf071,0xf072,0xf073,0xf074,0xf075,0xf076,0xf077, /* 0x83E0-0x83E7 */
	0xf078,0xf079,0xf07a,0xf07b,0xf07c,0xf07d,0xf07e,0xf07f, /* 0x83E8-0x83EF */
	0xf080,0xf081,0xf082,0xf083,0xf084,0xf085,0xf086,0xf087, /* 0x83F0-0x83F7 */
	0xf088,0xf089,0xf08a,0xf08b,0xf08c,0xf08d,0xf08e,0x0000, /* 0x83F8-0x83FF */
	/* codebase=0x8440 rawbase=0x02c0 */
	0xf08f,0xf090,0xf091,0xf092,0xf093,0xf094,0xf095,0xf096, /* 0x8440-0x8447 */
	0xf097,0xf098,0xf099,0xf09a,0xf09b,0xf09c,0xf09d,0xf09e, /* 0x8448-0x844F */
	0xf09f,0xf0a0,0xf0a1,0xf0a2,0xf0a3,0xf0a4,0xf0a5,0xf0a6, /* 0x8450-0x8457 */
	0xf0a7,0xf0a8,0xf0a9,0xf0aa,0xf0ab,0xf0ac,0xf0ad,0xf0ae, /* 0x8458-0x845F */
	0xf0af,0xf0b0,0xf0b1,0xf0b2,0xf0b3,0xf0b4,0xf0b5,0xf0b6, /* 0x8460-0x8467 */
	0xf0b7,0xf0b8,0xf0b9,0xf0ba,0xf0bb,0xf0bc,0xf0bd,0xf0be, /* 0x8468-0x846F */
	0xf0bf,0xf0c0,0xf0c1,0xf0c2,0xf0c3,0xf0c4,0xf0c5,0xf0c6, /* 0x8470-0x8477 */
	0xf0c7,0xf0c8,0xf0c9,0xf0ca,0xf0cb,0xf0cc,0xf0cd,0x0000, /* 0x8478-0x847F */
	/* codebase=0x8480 rawbase=0x0300 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8480-0x8487 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8488-0x848F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8490-0x8497 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8498-0x849F */
	0x0000,0xf0ce,0xf0cf,0xf0d0,0xf0d1,0xf0d2,0xf0d3,0xf0d4, /* 0x84A0-0x84A7 */
	0xf0d5,0xf0d6,0xf0d7,0xf0d8,0xf0d9,0xf0da,0xf0db,0xf0dc, /* 0x84A8-0x84AF */
	0xf0dd,0xf0de,0xf0df,0xf0e0,0xf0e1,0xf0e2,0xf0e3,0xf0e4, /* 0x84B0-0x84B7 */
	0xf0e5,0xf0e6,0xf0e7,0xf0e8,0xf0e9,0xf0ea,0xf0eb,0xf0ec, /* 0x84B8-0x84BF */
	/* codebase=0x84c0 rawbase=0x0340 */
	0xf0ed,0xf0ee,0xf0ef,0xf0f0,0xf0f1,0xf0f2,0xf0f3,0xf0f4, /* 0x84C0-0x84C7 */
	0xf0f5,0xf0f6,0xf0f7,0xf0f8,0xf0f9,0xf0fa,0xf0fb,0xf0fc, /* 0x84C8-0x84CF */
	0xf0fd,0xf0fe,0xf0ff,0xf100,0xf101,0xf102,0xf103,0xf104, /* 0x84D0-0x84D7 */
	0xf105,0xf106,0xf107,0xf108,0xf109,0xf10a,0xf10b,0xf10c, /* 0x84D8-0x84DF */
	0xf10d,0xf10e,0xf10f,0xf110,0xf111,0xf112,0xf113,0xf114, /* 0x84E0-0x84E7 */
	0xf115,0xf116,0xf117,0xf118,0xf119,0xf11a,0xf11b,0xf11c, /* 0x84E8-0x84EF */
	0xf11d,0xf11e,0xf11f,0xf120,0xf121,0xf122,0xf123,0xf124, /* 0x84F0-0x84F7 */
	0xf125,0xf126,0xf127,0xf128,0xf129,0xf12a,0xf12b,0x0000, /* 0x84F8-0x84FF */
	/* codebase=0x8540 rawbase=0x0380 */
	0xf12c,0xf12d,0xf12e,0xf12f,0xf130,0xf131,0xf132,0xf133, /* 0x8540-0x8547 */
	0xf134,0xf135,0xf136,0xf137,0xf138,0xf139,0xf13a,0xf13b, /* 0x8548-0x854F */
	0xf13c,0xf13d,0xf13e,0xf13f,0xf140,0xf141,0xf142,0xf143, /* 0x8550-0x8557 */
	0xf144,0xf145,0xf146,0xf147,0xf148,0xf149,0xf14a,0xf14b, /* 0x8558-0x855F */
	0xf14c,0xf14d,0xf14e,0xf14f,0xf150,0xf151,0xf152,0xf153, /* 0x8560-0x8567 */
	0xf154,0xf155,0xf156,0xf157,0xf158,0xf159,0xf15a,0xf15b, /* 0x8568-0x856F */
	0xf15c,0xf15d,0xf15e,0xf15f,0xf160,0xf161,0xf162,0xf163, /* 0x8570-0x8577 */
	0xf164,0xf165,0xf166,0xf167,0xf168,0xf169,0xf16a,0x0000, /* 0x8578-0x857F */
	/* codebase=0x8580 rawbase=0x03c0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8580-0x8587 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8588-0x858F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8590-0x8597 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8598-0x859F */
	0x0000,0xf16b,0xf16c,0xf16d,0xf16e,0xf16f,0xf170,0xf171, /* 0x85A0-0x85A7 */
	0xf172,0xf173,0xf174,0xf175,0xf176,0xf177,0xf178,0xf179, /* 0x85A8-0x85AF */
	0xf17a,0xf17b,0xf17c,0xf17d,0xf17e,0xf17f,0xf180,0xf181, /* 0x85B0-0x85B7 */
	0xf182,0xf183,0xf184,0xf185,0xf186,0xf187,0xf188,0xf189, /* 0x85B8-0x85BF */
	/* codebase=0x85c0 rawbase=0x0400 */
	0xf18a,0xf18b,0xf18c,0xf18d,0xf18e,0xf18f,0xf190,0xf191, /* 0x85C0-0x85C7 */
	0xf192,0xf193,0xf194,0xf195,0xf196,0xf197,0xf198,0xf199, /* 0x85C8-0x85CF */
	0xf19a,0xf19b,0xf19c,0xf19d,0xf19e,0xf19f,0xf1a0,0xf1a1, /* 0x85D0-0x85D7 */
	0xf1a2,0xf1a3,0xf1a4,0xf1a5,0xf1a6,0xf1a7,0xf1a8,0xf1a9, /* 0x85D8-0x85DF */
	0xf1aa,0xf1ab,0xf1ac,0xf1ad,0xf1ae,0xf1af,0xf1b0,0xf1b1, /* 0x85E0-0x85E7 */
	0xf1b2,0xf1b3,0xf1b4,0xf1b5,0xf1b6,0xf1b7,0xf1b8,0xf1b9, /* 0x85E8-0x85EF */
	0xf1ba,0xf1bb,0xf1bc,0xf1bd,0xf1be,0xf1bf,0xf1c0,0xf1c1, /* 0x85F0-0x85F7 */
	0xf1c2,0xf1c3,0xf1c4,0xf1c5,0xf1c6,0xf1c7,0xf1c8,0x0000, /* 0x85F8-0x85FF */
	/* codebase=0x8640 rawbase=0x0440 */
	0xf1c9,0xf1ca,0xf1cb,0xf1cc,0xf1cd,0xf1ce,0xf1cf,0xf1d0, /* 0x8640-0x8647 */
	0xf1d1,0xf1d2,0xf1d3,0xf1d4,0xf1d5,0xf1d6,0xf1d7,0xf1d8, /* 0x8648-0x864F */
	0xf1d9,0xf1da,0xf1db,0xf1dc,0xf1dd,0xf1de,0xf1df,0xf1e0, /* 0x8650-0x8657 */
	0xf1e1,0xf1e2,0xf1e3,0xf1e4,0xf1e5,0xf1e6,0xf1e7,0xf1e8, /* 0x8658-0x865F */
	0xf1e9,0xf1ea,0xf1eb,0xf1ec,0xf1ed,0xf1ee,0xf1ef,0xf1f0, /* 0x8660-0x8667 */
	0xf1f1,0xf1f2,0xf1f3,0xf1f4,0xf1f5,0xf1f6,0xf1f7,0xf1f8, /* 0x8668-0x866F */
	0xf1f9,0xf1fa,0xf1fb,0xf1fc,0xf1fd,0xf1fe,0xf1ff,0xf200, /* 0x8670-0x8677 */
	0xf201,0xf202,0xf203,0xf204,0xf205,0xf206,0xf207,0x0000, /* 0x8678-0x867F */
	/* codebase=0x8680 rawbase=0x0480 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8680-0x8687 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8688-0x868F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8690-0x8697 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8698-0x869F */
	0x0000,0xf208,0xf209,0xf20a,0xf20b,0xf20c,0xf20d,0xf20e, /* 0x86A0-0x86A7 */
	0xf20f,0xf210,0xf211,0xf212,0xf213,0xf214,0xf215,0xf216, /* 0x86A8-0x86AF */
	0xf217,0xf218,0xf219,0xf21a,0xf21b,0xf21c,0xf21d,0xf21e, /* 0x86B0-0x86B7 */
	0xf21f,0xf220,0xf221,0xf222,0xf223,0xf224,0xf225,0xf226, /* 0x86B8-0x86BF */
	/* codebase=0x86c0 rawbase=0x04c0 */
	0xf227,0xf228,0xf229,0xf22a,0xf22b,0xf22c,0xf22d,0xf22e, /* 0x86C0-0x86C7 */
	0xf22f,0xf230,0xf231,0xf232,0xf233,0xf234,0xf235,0xf236, /* 0x86C8-0x86CF */
	0xf237,0xf238,0xf239,0xf23a,0xf23b,0xf23c,0xf23d,0xf23e, /* 0x86D0-0x86D7 */
	0xf23f,0xf240,0xf241,0xf242,0xf243,0xf244,0xf245,0xf246, /* 0x86D8-0x86DF */
	0xf247,0xf248,0xf249,0xf24a,0xf24b,0xf24c,0xf24d,0xf24e, /* 0x86E0-0x86E7 */
	0xf24f,0xf250,0xf251,0xf252,0xf253,0xf254,0xf255,0xf256, /* 0x86E8-0x86EF */
	0xf257,0xf258,0xf259,0xf25a,0xf25b,0xf25c,0xf25d,0xf25e, /* 0x86F0-0x86F7 */
	0xf25f,0xf260,0xf261,0xf262,0xf263,0xf264,0xf265,0x0000, /* 0x86F8-0x86FF */
	/* codebase=0x8740 rawbase=0x0500 */
	0xf266,0xf267,0xf268,0xf269,0xf26a,0xf26b,0xf26c,0xf26d, /* 0x8740-0x8747 */
	0xf26e,0xf26f,0xf270,0xf271,0xf272,0xf273,0xf274,0xf275, /* 0x8748-0x874F */
	0xf276,0xf277,0xf278,0xf279,0xf27a,0xf27b,0xf27c,0xf27d, /* 0x8750-0x8757 */
	0xf27e,0xf27f,0xf280,0xf281,0xf282,0xf283,0xf284,0xf285, /* 0x8758-0x875F */
	0xf286,0xf287,0xf288,0xf289,0xf28a,0xf28b,0xf28c,0xf28d, /* 0x8760-0x8767 */
	0xf28e,0xf28f,0xf290,0xf291,0xf292,0xf293,0xf294,0xf295, /* 0x8768-0x876F */
	0xf296,0xf297,0xf298,0xf299,0xf29a,0xf29b,0xf29c,0xf29d, /* 0x8770-0x8777 */
	0xf29e,0xf29f,0xf2a0,0xf2a1,0xf2a2,0xf2a3,0xf2a4,0x0000, /* 0x8778-0x877F */
	/* codebase=0x8780 rawbase=0x0540 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8780-0x8787 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8788-0x878F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8790-0x8797 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8798-0x879F */
	0x0000,0xf2a5,0xf2a6,0xf2a7,0xf2a8,0xf2a9,0xf2aa,0xf2ab, /* 0x87A0-0x87A7 */
	0xf2ac,0xf2ad,0xf2ae,0xf2af,0xf2b0,0xf2b1,0xf2b2,0xf2b3, /* 0x87A8-0x87AF */
	0xf2b4,0xf2b5,0xf2b6,0xf2b7,0xf2b8,0xf2b9,0xf2ba,0xf2bb, /* 0x87B0-0x87B7 */
	0xf2bc,0xf2bd,0xf2be,0xf2bf,0xf2c0,0xf2c1,0xf2c2,0xf2c3, /* 0x87B8-0x87BF */
	/* codebase=0x87c0 rawbase=0x0580 */
	0xf2c4,0xf2c5,0xf2c6,0xf2c7,0xf2c8,0xf2c9,0xf2ca,0xf2cb, /* 0x87C0-0x87C7 */
	0xf2cc,0xf2cd,0xf2ce,0xf2cf,0xf2d0,0xf2d1,0xf2d2,0xf2d3, /* 0x87C8-0x87CF */
	0xf2d4,0xf2d5,0xf2d6,0xf2d7,0xf2d8,0xf2d9,0xf2da,0xf2db, /* 0x87D0-0x87D7 */
	0xf2dc,0xf2dd,0xf2de,0xf2df,0xf2e0,0xf2e1,0xf2e2,0xf2e3, /* 0x87D8-0x87DF */
	0xf2e4,0xf2e5,0xf2e6,0xf2e7,0xf2e8,0xf2e9,0xf2ea,0xf2eb, /* 0x87E0-0x87E7 */
	0xf2ec,0xf2ed,0xf2ee,0xf2ef,0xf2f0,0xf2f1,0xf2f2,0xf2f3, /* 0x87E8-0x87EF */
	0xf2f4,0xf2f5,0xf2f6,0xf2f7,0xf2f8,0xf2f9,0xf2fa,0xf2fb, /* 0x87F0-0x87F7 */
	0xf2fc,0xf2fd,0xf2fe,0xf2ff,0xf300,0xf301,0xf302,0x0000, /* 0x87F8-0x87FF */
	/* codebase=0x8840 rawbase=0x05c0 */
	0xf303,0xf304,0xf305,0xf306,0xf307,0xf308,0xf309,0xf30a, /* 0x8840-0x8847 */
	0xf30b,0xf30c,0xf30d,0xf30e,0xf30f,0xf310,0xf311,0xf312, /* 0x8848-0x884F */
	0xf313,0xf314,0xf315,0xf316,0xf317,0xf318,0xf319,0xf31a, /* 0x8850-0x8857 */
	0xf31b,0xf31c,0xf31d,0xf31e,0xf31f,0xf320,0xf321,0xf322, /* 0x8858-0x885F */
	0xf323,0xf324,0xf325,0xf326,0xf327,0xf328,0xf329,0xf32a, /* 0x8860-0x8867 */
	0xf32b,0xf32c,0xf32d,0xf32e,0xf32f,0xf330,0xf331,0xf332, /* 0x8868-0x886F */
	0xf333,0xf334,0xf335,0xf336,0xf337,0xf338,0xf339,0xf33a, /* 0x8870-0x8877 */
	0xf33b,0xf33c,0xf33d,0xf33e,0xf33f,0xf340,0xf341,0x0000, /* 0x8878-0x887F */
	/* codebase=0x8880 rawbase=0x0600 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8880-0x8887 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8888-0x888F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8890-0x8897 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8898-0x889F */
	0x0000,0xf342,0xf343,0xf344,0xf345,0xf346,0xf347,0xf348, /* 0x88A0-0x88A7 */
	0xf349,0xf34a,0xf34b,0xf34c,0xf34d,0xf34e,0xf34f,0xf350, /* 0x88A8-0x88AF */
	0xf351,0xf352,0xf353,0xf354,0xf355,0xf356,0xf357,0xf358, /* 0x88B0-0x88B7 */
	0xf359,0xf35a,0xf35b,0xf35c,0xf35d,0xf35e,0xf35f,0xf360, /* 0x88B8-0x88BF */
	/* codebase=0x88c0 rawbase=0x0640 */
	0xf361,0xf362,0xf363,0xf364,0xf365,0xf366,0xf367,0xf368, /* 0x88C0-0x88C7 */
	0xf369,0xf36a,0xf36b,0xf36c,0xf36d,0xf36e,0xf36f,0xf370, /* 0x88C8-0x88CF */
	0xf371,0xf372,0xf373,0xf374,0xf375,0xf376,0xf377,0xf378, /* 0x88D0-0x88D7 */
	0xf379,0xf37a,0xf37b,0xf37c,0xf37d,0xf37e,0xf37f,0xf380, /* 0x88D8-0x88DF */
	0xf381,0xf382,0xf383,0xf384,0xf385,0xf386,0xf387,0xf388, /* 0x88E0-0x88E7 */
	0xf389,0xf38a,0xf38b,0xf38c,0xf38d,0xf38e,0xf38f,0xf390, /* 0x88E8-0x88EF */
	0xf391,0xf392,0xf393,0xf394,0xf395,0xf396,0xf397,0xf398, /* 0x88F0-0x88F7 */
	0xf399,0xf39a,0xf39b,0xf39c,0xf39d,0xf39e,0xf39f,0x0000, /* 0x88F8-0x88FF */
	/* codebase=0x8940 rawbase=0x0680 */
	0xf3a0,0xf3a1,0xf3a2,0xf3a3,0xf3a4,0xf3a5,0xf3a6,0xf3a7, /* 0x8940-0x8947 */
	0xf3a8,0xf3a9,0xf3aa,0xf3ab,0xf3ac,0xf3ad,0xf3ae,0xf3af, /* 0x8948-0x894F */
	0xf3b0,0xf3b1,0xf3b2,0xf3b3,0xf3b4,0xf3b5,0xf3b6,0xf3b7, /* 0x8950-0x8957 */
	0xf3b8,0xf3b9,0xf3ba,0xf3bb,0xf3bc,0xf3bd,0xf3be,0xf3bf, /* 0x8958-0x895F */
	0xf3c0,0xf3c1,0xf3c2,0xf3c3,0xf3c4,0xf3c5,0xf3c6,0xf3c7, /* 0x8960-0x8967 */
	0xf3c8,0xf3c9,0xf3ca,0xf3cb,0xf3cc,0xf3cd,0xf3ce,0xf3cf, /* 0x8968-0x896F */
	0xf3d0,0xf3d1,0xf3d2,0xf3d3,0xf3d4,0xf3d5,0xf3d6,0xf3d7, /* 0x8970-0x8977 */
	0xf3d8,0xf3d9,0xf3da,0xf3db,0xf3dc,0xf3dd,0xf3de,0x0000, /* 0x8978-0x897F */
	/* codebase=0x8980 rawbase=0x06c0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8980-0x8987 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8988-0x898F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8990-0x8997 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8998-0x899F */
	0x0000,0xf3df,0xf3e0,0xf3e1,0xf3e2,0xf3e3,0xf3e4,0xf3e5, /* 0x89A0-0x89A7 */
	0xf3e6,0xf3e7,0xf3e8,0xf3e9,0xf3ea,0xf3eb,0xf3ec,0xf3ed, /* 0x89A8-0x89AF */
	0xf3ee,0xf3ef,0xf3f0,0xf3f1,0xf3f2,0xf3f3,0xf3f4,0xf3f5, /* 0x89B0-0x89B7 */
	0xf3f6,0xf3f7,0xf3f8,0xf3f9,0xf3fa,0xf3fb,0xf3fc,0xf3fd, /* 0x89B8-0x89BF */
	/* codebase=0x89c0 rawbase=0x0700 */
	0xf3fe,0xf3ff,0xf400,0xf401,0xf402,0xf403,0xf404,0xf405, /* 0x89C0-0x89C7 */
	0xf406,0xf407,0xf408,0xf409,0xf40a,0xf40b,0xf40c,0xf40d, /* 0x89C8-0x89CF */
	0xf40e,0xf40f,0xf410,0xf411,0xf412,0xf413,0xf414,0xf415, /* 0x89D0-0x89D7 */
	0xf416,0xf417,0xf418,0xf419,0xf41a,0xf41b,0xf41c,0xf41d, /* 0x89D8-0x89DF */
	0xf41e,0xf41f,0xf420,0xf421,0xf422,0xf423,0xf424,0xf425, /* 0x89E0-0x89E7 */
	0xf426,0xf427,0xf428,0xf429,0xf42a,0xf42b,0xf42c,0xf42d, /* 0x89E8-0x89EF */
	0xf42e,0xf42f,0xf430,0xf431,0xf432,0xf433,0xf434,0xf435, /* 0x89F0-0x89F7 */
	0xf436,0xf437,0xf438,0xf439,0xf43a,0xf43b,0xf43c,0x0000, /* 0x89F8-0x89FF */
	/* codebase=0x8a40 rawbase=0x0740 */
	0xf43d,0xf43e,0xf43f,0xf440,0xf441,0xf442,0xf443,0xf444, /* 0x8A40-0x8A47 */
	0xf445,0xf446,0xf447,0xf448,0xf449,0xf44a,0xf44b,0xf44c, /* 0x8A48-0x8A4F */
	0xf44d,0xf44e,0xf44f,0xf450,0xf451,0xf452,0xf453,0xf454, /* 0x8A50-0x8A57 */
	0xf455,0xf456,0xf457,0xf458,0xf459,0xf45a,0xf45b,0xf45c, /* 0x8A58-0x8A5F */
	0xf45d,0xf45e,0xf45f,0xf460,0xf461,0xf462,0xf463,0xf464, /* 0x8A60-0x8A67 */
	0xf465,0xf466,0xf467,0xf468,0xf469,0xf46a,0xf46b,0xf46c, /* 0x8A68-0x8A6F */
	0xf46d,0xf46e,0xf46f,0xf470,0xf471,0xf472,0xf473,0xf474, /* 0x8A70-0x8A77 */
	0xf475,0xf476,0xf477,0xf478,0xf479,0xf47a,0xf47b,0x0000, /* 0x8A78-0x8A7F */
	/* codebase=0x8a80 rawbase=0x0780 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8A80-0x8A87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8A88-0x8A8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8A90-0x8A97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8A98-0x8A9F */
	0x0000,0xf47c,0xf47d,0xf47e,0xf47f,0xf480,0xf481,0xf482, /* 0x8AA0-0x8AA7 */
	0xf483,0xf484,0xf485,0xf486,0xf487,0xf488,0xf489,0xf48a, /* 0x8AA8-0x8AAF */
	0xf48b,0xf48c,0xf48d,0xf48e,0xf48f,0xf490,0xf491,0xf492, /* 0x8AB0-0x8AB7 */
	0xf493,0xf494,0xf495,0xf496,0xf497,0xf498,0xf499,0xf49a, /* 0x8AB8-0x8ABF */
	/* codebase=0x8ac0 rawbase=0x07c0 */
	0xf49b,0xf49c,0xf49d,0xf49e,0xf49f,0xf4a0,0xf4a1,0xf4a2, /* 0x8AC0-0x8AC7 */
	0xf4a3,0xf4a4,0xf4a5,0xf4a6,0xf4a7,0xf4a8,0xf4a9,0xf4aa, /* 0x8AC8-0x8ACF */
	0xf4ab,0xf4ac,0xf4ad,0xf4ae,0xf4af,0xf4b0,0xf4b1,0xf4b2, /* 0x8AD0-0x8AD7 */
	0xf4b3,0xf4b4,0xf4b5,0xf4b6,0xf4b7,0xf4b8,0xf4b9,0xf4ba, /* 0x8AD8-0x8ADF */
	0xf4bb,0xf4bc,0xf4bd,0xf4be,0xf4bf,0xf4c0,0xf4c1,0xf4c2, /* 0x8AE0-0x8AE7 */
	0xf4c3,0xf4c4,0xf4c5,0xf4c6,0xf4c7,0xf4c8,0xf4c9,0xf4ca, /* 0x8AE8-0x8AEF */
	0xf4cb,0xf4cc,0xf4cd,0xf4ce,0xf4cf,0xf4d0,0xf4d1,0xf4d2, /* 0x8AF0-0x8AF7 */
	0xf4d3,0xf4d4,0xf4d5,0xf4d6,0xf4d7,0xf4d8,0xf4d9,0x0000, /* 0x8AF8-0x8AFF */
	/* codebase=0x8b40 rawbase=0x0800 */
	0xf4da,0xf4db,0xf4dc,0xf4dd,0xf4de,0xf4df,0xf4e0,0xf4e1, /* 0x8B40-0x8B47 */
	0xf4e2,0xf4e3,0xf4e4,0xf4e5,0xf4e6,0xf4e7,0xf4e8,0xf4e9, /* 0x8B48-0x8B4F */
	0xf4ea,0xf4eb,0xf4ec,0xf4ed,0xf4ee,0xf4ef,0xf4f0,0xf4f1, /* 0x8B50-0x8B57 */
	0xf4f2,0xf4f3,0xf4f4,0xf4f5,0xf4f6,0xf4f7,0xf4f8,0xf4f9, /* 0x8B58-0x8B5F */
	0xf4fa,0xf4fb,0xf4fc,0xf4fd,0xf4fe,0xf4ff,0xf500,0xf501, /* 0x8B60-0x8B67 */
	0xf502,0xf503,0xf504,0xf505,0xf506,0xf507,0xf508,0xf509, /* 0x8B68-0x8B6F */
	0xf50a,0xf50b,0xf50c,0xf50d,0xf50e,0xf50f,0xf510,0xf511, /* 0x8B70-0x8B77 */
	0xf512,0xf513,0xf514,0xf515,0xf516,0xf517,0xf518,0x0000, /* 0x8B78-0x8B7F */
	/* codebase=0x8b80 rawbase=0x0840 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8B80-0x8B87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8B88-0x8B8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8B90-0x8B97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8B98-0x8B9F */
	0x0000,0xf519,0xf51a,0xf51b,0xf51c,0xf51d,0xf51e,0xf51f, /* 0x8BA0-0x8BA7 */
	0xf520,0xf521,0xf522,0xf523,0xf524,0xf525,0xf526,0xf527, /* 0x8BA8-0x8BAF */
	0xf528,0xf529,0xf52a,0xf52b,0xf52c,0xf52d,0xf52e,0xf52f, /* 0x8BB0-0x8BB7 */
	0xf530,0xf531,0xf532,0xf533,0xf534,0xf535,0xf536,0xf537, /* 0x8BB8-0x8BBF */
	/* codebase=0x8bc0 rawbase=0x0880 */
	0xf538,0xf539,0xf53a,0xf53b,0xf53c,0xf53d,0xf53e,0xf53f, /* 0x8BC0-0x8BC7 */
	0xf540,0xf541,0xf542,0xf543,0xf544,0xf545,0xf546,0xf547, /* 0x8BC8-0x8BCF */
	0xf548,0xf549,0xf54a,0xf54b,0xf54c,0xf54d,0xf54e,0xf54f, /* 0x8BD0-0x8BD7 */
	0xf550,0xf551,0xf552,0xf553,0xf554,0xf555,0xf556,0xf557, /* 0x8BD8-0x8BDF */
	0xf558,0xf559,0xf55a,0xf55b,0xf55c,0xf55d,0xf55e,0xf55f, /* 0x8BE0-0x8BE7 */
	0xf560,0xf561,0xf562,0xf563,0xf564,0xf565,0xf566,0xf567, /* 0x8BE8-0x8BEF */
	0xf568,0xf569,0xf56a,0xf56b,0xf56c,0xf56d,0xf56e,0xf56f, /* 0x8BF0-0x8BF7 */
	0xf570,0xf571,0xf572,0xf573,0xf574,0xf575,0xf576,0x0000, /* 0x8BF8-0x8BFF */
	/* codebase=0x8c40 rawbase=0x08c0 */
	0xf577,0xf578,0xf579,0xf57a,0xf57b,0xf57c,0xf57d,0xf57e, /* 0x8C40-0x8C47 */
	0xf57f,0xf580,0xf581,0xf582,0xf583,0xf584,0xf585,0xf586, /* 0x8C48-0x8C4F */
	0xf587,0xf588,0xf589,0xf58a,0xf58b,0xf58c,0xf58d,0xf58e, /* 0x8C50-0x8C57 */
	0xf58f,0xf590,0xf591,0xf592,0xf593,0xf594,0xf595,0xf596, /* 0x8C58-0x8C5F */
	0xf597,0xf598,0xf599,0xf59a,0xf59b,0xf59c,0xf59d,0xf59e, /* 0x8C60-0x8C67 */
	0xf59f,0xf5a0,0xf5a1,0xf5a2,0xf5a3,0xf5a4,0xf5a5,0xf5a6, /* 0x8C68-0x8C6F */
	0xf5a7,0xf5a8,0xf5a9,0xf5aa,0xf5ab,0xf5ac,0xf5ad,0xf5ae, /* 0x8C70-0x8C77 */
	0xf5af,0xf5b0,0xf5b1,0xf5b2,0xf5b3,0xf5b4,0xf5b5,0x0000, /* 0x8C78-0x8C7F */
	/* codebase=0x8c80 rawbase=0x0900 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8C80-0x8C87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8C88-0x8C8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8C90-0x8C97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8C98-0x8C9F */
	0x0000,0xf5b6,0xf5b7,0xf5b8,0xf5b9,0xf5ba,0xf5bb,0xf5bc, /* 0x8CA0-0x8CA7 */
	0xf5bd,0xf5be,0xf5bf,0xf5c0,0xf5c1,0xf5c2,0xf5c3,0xf5c4, /* 0x8CA8-0x8CAF */
	0xf5c5,0xf5c6,0xf5c7,0xf5c8,0xf5c9,0xf5ca,0xf5cb,0xf5cc, /* 0x8CB0-0x8CB7 */
	0xf5cd,0xf5ce,0xf5cf,0xf5d0,0xf5d1,0xf5d2,0xf5d3,0xf5d4, /* 0x8CB8-0x8CBF */
	/* codebase=0x8cc0 rawbase=0x0940 */
	0xf5d5,0xf5d6,0xf5d7,0xf5d8,0xf5d9,0xf5da,0xf5db,0xf5dc, /* 0x8CC0-0x8CC7 */
	0xf5dd,0xf5de,0xf5df,0xf5e0,0xf5e1,0xf5e2,0xf5e3,0xf5e4, /* 0x8CC8-0x8CCF */
	0xf5e5,0xf5e6,0xf5e7,0xf5e8,0xf5e9,0xf5ea,0xf5eb,0xf5ec, /* 0x8CD0-0x8CD7 */
	0xf5ed,0xf5ee,0xf5ef,0xf5f0,0xf5f1,0xf5f2,0xf5f3,0xf5f4, /* 0x8CD8-0x8CDF */
	0xf5f5,0xf5f6,0xf5f7,0xf5f8,0xf5f9,0xf5fa,0xf5fb,0xf5fc, /* 0x8CE0-0x8CE7 */
	0xf5fd,0xf5fe,0xf5ff,0xf600,0xf601,0xf602,0xf603,0xf604, /* 0x8CE8-0x8CEF */
	0xf605,0xf606,0xf607,0xf608,0xf609,0xf60a,0xf60b,0xf60c, /* 0x8CF0-0x8CF7 */
	0xf60d,0xf60e,0xf60f,0xf610,0xf611,0xf612,0xf613,0x0000, /* 0x8CF8-0x8CFF */
	/* codebase=0x8d40 rawbase=0x0980 */
	0xf614,0xf615,0xf616,0xf617,0xf618,0xf619,0xf61a,0xf61b, /* 0x8D40-0x8D47 */
	0xf61c,0xf61d,0xf61e,0xf61f,0xf620,0xf621,0xf622,0xf623, /* 0x8D48-0x8D4F */
	0xf624,0xf625,0xf626,0xf627,0xf628,0xf629,0xf62a,0xf62b, /* 0x8D50-0x8D57 */
	0xf62c,0xf62d,0xf62e,0xf62f,0xf630,0xf631,0xf632,0xf633, /* 0x8D58-0x8D5F */
	0xf634,0xf635,0xf636,0xf637,0xf638,0xf639,0xf63a,0xf63b, /* 0x8D60-0x8D67 */
	0xf63c,0xf63d,0xf63e,0xf63f,0xf640,0xf641,0xf642,0xf643, /* 0x8D68-0x8D6F */
	0xf644,0xf645,0xf646,0xf647,0xf648,0xf649,0xf64a,0xf64b, /* 0x8D70-0x8D77 */
	0xf64c,0xf64d,0xf64e,0xf64f,0xf650,0xf651,0xf652,0x0000, /* 0x8D78-0x8D7F */
	/* codebase=0x8d80 rawbase=0x09c0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8D80-0x8D87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8D88-0x8D8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8D90-0x8D97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8D98-0x8D9F */
	0x0000,0xf653,0xf654,0xf655,0xf656,0xf657,0xf658,0xf659, /* 0x8DA0-0x8DA7 */
	0xf65a,0xf65b,0xf65c,0xf65d,0xf65e,0xf65f,0xf660,0xf661, /* 0x8DA8-0x8DAF */
	0xf662,0xf663,0xf664,0xf665,0xf666,0xf667,0xf668,0xf669, /* 0x8DB0-0x8DB7 */
	0xf66a,0xf66b,0xf66c,0xf66d,0xf66e,0xf66f,0xf670,0xf671, /* 0x8DB8-0x8DBF */
	/* codebase=0x8dc0 rawbase=0x0a00 */
	0xf672,0xf673,0xf674,0xf675,0xf676,0xf677,0xf678,0xf679, /* 0x8DC0-0x8DC7 */
	0xf67a,0xf67b,0xf67c,0xf67d,0xf67e,0xf67f,0xf680,0xf681, /* 0x8DC8-0x8DCF */
	0xf682,0xf683,0xf684,0xf685,0xf686,0xf687,0xf688,0xf689, /* 0x8DD0-0x8DD7 */
	0xf68a,0xf68b,0xf68c,0xf68d,0xf68e,0xf68f,0xf690,0xf691, /* 0x8DD8-0x8DDF */
	0xf692,0xf693,0xf694,0xf695,0xf696,0xf697,0xf698,0xf699, /* 0x8DE0-0x8DE7 */
	0xf69a,0xf69b,0xf69c,0xf69d,0xf69e,0xf69f,0xf6a0,0xf6a1, /* 0x8DE8-0x8DEF */
	0xf6a2,0xf6a3,0xf6a4,0xf6a5,0xf6a6,0xf6a7,0xf6a8,0xf6a9, /* 0x8DF0-0x8DF7 */
	0xf6aa,0xf6ab,0xf6ac,0xf6ad,0xf6ae,0xf6af,0xf6b0,0x0000, /* 0x8DF8-0x8DFF */
	/* codebase=0x8e40 rawbase=0x0a40 */
	0xe311,0xe312,0xe313,0xe314,0xe315,0xe316,0xe317,0xe318, /* 0x8E40-0x8E47 */
	0xe319,0xe31a,0xe31b,0xe31c,0xe31d,0xe31e,0xe31f,0xe320, /* 0x8E48-0x8E4F */
	0xe321,0xe322,0xe323,0xe324,0xe325,0xe326,0xe327,0xe328, /* 0x8E50-0x8E57 */
	0xe329,0xe32a,0xe32b,0xe32c,0xe32d,0xe32e,0xe32f,0xe330, /* 0x8E58-0x8E5F */
	0xe331,0xe332,0xe333,0xe334,0xe335,0xe336,0xe337,0xe338, /* 0x8E60-0x8E67 */
	0xe339,0xe33a,0xe33b,0xe33c,0xe33d,0xe33e,0xe33f,0xe340, /* 0x8E68-0x8E6F */
	0xe341,0xe342,0xe343,0xe344,0xe345,0xe346,0xe347,0xe348, /* 0x8E70-0x8E77 */
	0xe349,0xe34a,0xe34b,0xe34c,0xe34d,0xe34e,0xe34f,0x0000, /* 0x8E78-0x8E7F */
	/* codebase=0x8e80 rawbase=0x0a80 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8E80-0x8E87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8E88-0x8E8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8E90-0x8E97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8E98-0x8E9F */
	0x0000,0xe350,0xe351,0xe352,0xe353,0xe354,0xe355,0xe356, /* 0x8EA0-0x8EA7 */
	0xe357,0xe358,0xe359,0xe35a,0xe35b,0xe35c,0xe35d,0xe35e, /* 0x8EA8-0x8EAF */
	0xe35f,0xe360,0xe361,0xe362,0xe363,0xe364,0xe365,0xe366, /* 0x8EB0-0x8EB7 */
	0xe367,0xe368,0xe369,0xe36a,0xe36b,0xe36c,0xe36d,0xe36e, /* 0x8EB8-0x8EBF */
	/* codebase=0x8ec0 rawbase=0x0ac0 */
	0xe36f,0xe370,0xe371,0xe372,0xe373,0xe374,0xe375,0xe376, /* 0x8EC0-0x8EC7 */
	0xe377,0xe378,0xe379,0xe37a,0xe37b,0xe37c,0xe37d,0xe37e, /* 0x8EC8-0x8ECF */
	0xe37f,0xe380,0xe381,0xe382,0xe383,0xe384,0xe385,0xe386, /* 0x8ED0-0x8ED7 */
	0xe387,0xe388,0xe389,0xe38a,0xe38b,0xe38c,0xe38d,0xe38e, /* 0x8ED8-0x8EDF */
	0xe38f,0xe390,0xe391,0xe392,0xe393,0xe394,0xe395,0xe396, /* 0x8EE0-0x8EE7 */
	0xe397,0xe398,0xe399,0xe39a,0xe39b,0xe39c,0xe39d,0xe39e, /* 0x8EE8-0x8EEF */
	0xe39f,0xe3a0,0xe3a1,0xe3a2,0xe3a3,0xe3a4,0xe3a5,0xe3a6, /* 0x8EF0-0x8EF7 */
	0xe3a7,0xe3a8,0xe3a9,0xe3aa,0xe3ab,0xe3ac,0xe3ad,0x0000, /* 0x8EF8-0x8EFF */
	/* codebase=0x8f40 rawbase=0x0b00 */
	0xe3ae,0xe3af,0xe3b0,0xe3b1,0xe3b2,0xe3b3,0xe3b4,0xe3b5, /* 0x8F40-0x8F47 */
	0xe3b6,0xe3b7,0xe3b8,0xe3b9,0xe3ba,0xe3bb,0xe3bc,0xe3bd, /* 0x8F48-0x8F4F */
	0xe3be,0xe3bf,0xe3c0,0xe3c1,0xe3c2,0xe3c3,0xe3c4,0xe3c5, /* 0x8F50-0x8F57 */
	0xe3c6,0xe3c7,0xe3c8,0xe3c9,0xe3ca,0xe3cb,0xe3cc,0xe3cd, /* 0x8F58-0x8F5F */
	0xe3ce,0xe3cf,0xe3d0,0xe3d1,0xe3d2,0xe3d3,0xe3d4,0xe3d5, /* 0x8F60-0x8F67 */
	0xe3d6,0xe3d7,0xe3d8,0xe3d9,0xe3da,0xe3db,0xe3dc,0xe3dd, /* 0x8F68-0x8F6F */
	0xe3de,0xe3df,0xe3e0,0xe3e1,0xe3e2,0xe3e3,0xe3e4,0xe3e5, /* 0x8F70-0x8F77 */
	0xe3e6,0xe3e7,0xe3e8,0xe3e9,0xe3ea,0xe3eb,0xe3ec,0x0000, /* 0x8F78-0x8F7F */
	/* codebase=0x8f80 rawbase=0x0b40 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8F80-0x8F87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8F88-0x8F8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8F90-0x8F97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8F98-0x8F9F */
	0x0000,0xe3ed,0xe3ee,0xe3ef,0xe3f0,0xe3f1,0xe3f2,0xe3f3, /* 0x8FA0-0x8FA7 */
	0xe3f4,0xe3f5,0xe3f6,0xe3f7,0xe3f8,0xe3f9,0xe3fa,0xe3fb, /* 0x8FA8-0x8FAF */
	0xe3fc,0xe3fd,0xe3fe,0xe3ff,0xe400,0xe401,0xe402,0xe403, /* 0x8FB0-0x8FB7 */
	0xe404,0xe405,0xe406,0xe407,0xe408,0xe409,0xe40a,0xe40b, /* 0x8FB8-0x8FBF */
	/* codebase=0x8fc0 rawbase=0x0b80 */
	0xe40c,0xe40d,0xe40e,0xe40f,0xe410,0xe411,0xe412,0xe413, /* 0x8FC0-0x8FC7 */
	0xe414,0xe415,0xe416,0xe417,0xe418,0xe419,0xe41a,0xe41b, /* 0x8FC8-0x8FCF */
	0xe41c,0xe41d,0xe41e,0xe41f,0xe420,0xe421,0xe422,0xe423, /* 0x8FD0-0x8FD7 */
	0xe424,0xe425,0xe426,0xe427,0xe428,0xe429,0xe42a,0xe42b, /* 0x8FD8-0x8FDF */
	0xe42c,0xe42d,0xe42e,0xe42f,0xe430,0xe431,0xe432,0xe433, /* 0x8FE0-0x8FE7 */
	0xe434,0xe435,0xe436,0xe437,0xe438,0xe439,0xe43a,0xe43b, /* 0x8FE8-0x8FEF */
	0xe43c,0xe43d,0xe43e,0xe43f,0xe440,0xe441,0xe442,0xe443, /* 0x8FF0-0x8FF7 */
	0xe444,0xe445,0xe446,0xe447,0xe448,0xe449,0xe44a,0x0000, /* 0x8FF8-0x8FFF */
	/* codebase=0x9040 rawbase=0x0bc0 */
	0xe44b,0xe44c,0xe44d,0xe44e,0xe44f,0xe450,0xe451,0xe452, /* 0x9040-0x9047 */
	0xe453,0xe454,0xe455,0xe456,0xe457,0xe458,0xe459,0xe45a, /* 0x9048-0x904F */
	0xe45b,0xe45c,0xe45d,0xe45e,0xe45f,0xe460,0xe461,0xe462, /* 0x9050-0x9057 */
	0xe463,0xe464,0xe465,0xe466,0xe467,0xe468,0xe469,0xe46a, /* 0x9058-0x905F */
	0xe46b,0xe46c,0xe46d,0xe46e,0xe46f,0xe470,0xe471,0xe472, /* 0x9060-0x9067 */
	0xe473,0xe474,0xe475,0xe476,0xe477,0xe478,0xe479,0xe47a, /* 0x9068-0x906F */
	0xe47b,0xe47c,0xe47d,0xe47e,0xe47f,0xe480,0xe481,0xe482, /* 0x9070-0x9077 */
	0xe483,0xe484,0xe485,0xe486,0xe487,0xe488,0xe489,0x0000, /* 0x9078-0x907F */
	/* codebase=0x9080 rawbase=0x0c00 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9080-0x9087 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9088-0x908F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9090-0x9097 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9098-0x909F */
	0x0000,0xe48a,0xe48b,0xe48c,0xe48d,0xe48e,0xe48f,0xe490, /* 0x90A0-0x90A7 */
	0xe491,0xe492,0xe493,0xe494,0xe495,0xe496,0xe497,0xe498, /* 0x90A8-0x90AF */
	0xe499,0xe49a,0xe49b,0xe49c,0xe49d,0xe49e,0xe49f,0xe4a0, /* 0x90B0-0x90B7 */
	0xe4a1,0xe4a2,0xe4a3,0xe4a4,0xe4a5,0xe4a6,0xe4a7,0xe4a8, /* 0x90B8-0x90BF */
	/* codebase=0x90c0 rawbase=0x0c40 */
	0xe4a9,0xe4aa,0xe4ab,0xe4ac,0xe4ad,0xe4ae,0xe4af,0xe4b0, /* 0x90C0-0x90C7 */
	0xe4b1,0xe4b2,0xe4b3,0xe4b4,0xe4b5,0xe4b6,0xe4b7,0xe4b8, /* 0x90C8-0x90CF */
	0xe4b9,0xe4ba,0xe4bb,0xe4bc,0xe4bd,0xe4be,0xe4bf,0xe4c0, /* 0x90D0-0x90D7 */
	0xe4c1,0xe4c2,0xe4c3,0xe4c4,0xe4c5,0xe4c6,0xe4c7,0xe4c8, /* 0x90D8-0x90DF */
	0xe4c9,0xe4ca,0xe4cb,0xe4cc,0xe4cd,0xe4ce,0xe4cf,0xe4d0, /* 0x90E0-0x90E7 */
	0xe4d1,0xe4d2,0xe4d3,0xe4d4,0xe4d5,0xe4d6,0xe4d7,0xe4d8, /* 0x90E8-0x90EF */
	0xe4d9,0xe4da,0xe4db,0xe4dc,0xe4dd,0xe4de,0xe4df,0xe4e0, /* 0x90F0-0x90F7 */
	0xe4e1,0xe4e2,0xe4e3,0xe4e4,0xe4e5,0xe4e6,0xe4e7,0x0000, /* 0x90F8-0x90FF */
	/* codebase=0x9140 rawbase=0x0c80 */
	0xe4e8,0xe4e9,0xe4ea,0xe4eb,0xe4ec,0xe4ed,0xe4ee,0xe4ef, /* 0x9140-0x9147 */
	0xe4f0,0xe4f1,0xe4f2,0xe4f3,0xe4f4,0xe4f5,0xe4f6,0xe4f7, /* 0x9148-0x914F */
	0xe4f8,0xe4f9,0xe4fa,0xe4fb,0xe4fc,0xe4fd,0xe4fe,0xe4ff, /* 0x9150-0x9157 */
	0xe500,0xe501,0xe502,0xe503,0xe504,0xe505,0xe506,0xe507, /* 0x9158-0x915F */
	0xe508,0xe509,0xe50a,0xe50b,0xe50c,0xe50d,0xe50e,0xe50f, /* 0x9160-0x9167 */
	0xe510,0xe511,0xe512,0xe513,0xe514,0xe515,0xe516,0xe517, /* 0x9168-0x916F */
	0xe518,0xe519,0xe51a,0xe51b,0xe51c,0xe51d,0xe51e,0xe51f, /* 0x9170-0x9177 */
	0xe520,0xe521,0xe522,0xe523,0xe524,0xe525,0xe526,0x0000, /* 0x9178-0x917F */
	/* codebase=0x9180 rawbase=0x0cc0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9180-0x9187 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9188-0x918F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9190-0x9197 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9198-0x919F */
	0x0000,0xe527,0xe528,0xe529,0xe52a,0xe52b,0xe52c,0xe52d, /* 0x91A0-0x91A7 */
	0xe52e,0xe52f,0xe530,0xe531,0xe532,0xe533,0xe534,0xe535, /* 0x91A8-0x91AF */
	0xe536,0xe537,0xe538,0xe539,0xe53a,0xe53b,0xe53c,0xe53d, /* 0x91B0-0x91B7 */
	0xe53e,0xe53f,0xe540,0xe541,0xe542,0xe543,0xe544,0xe545, /* 0x91B8-0x91BF */
	/* codebase=0x91c0 rawbase=0x0d00 */
	0xe546,0xe547,0xe548,0xe549,0xe54a,0xe54b,0xe54c,0xe54d, /* 0x91C0-0x91C7 */
	0xe54e,0xe54f,0xe550,0xe551,0xe552,0xe553,0xe554,0xe555, /* 0x91C8-0x91CF */
	0xe556,0xe557,0xe558,0xe559,0xe55a,0xe55b,0xe55c,0xe55d, /* 0x91D0-0x91D7 */
	0xe55e,0xe55f,0xe560,0xe561,0xe562,0xe563,0xe564,0xe565, /* 0x91D8-0x91DF */
	0xe566,0xe567,0xe568,0xe569,0xe56a,0xe56b,0xe56c,0xe56d, /* 0x91E0-0x91E7 */
	0xe56e,0xe56f,0xe570,0xe571,0xe572,0xe573,0xe574,0xe575, /* 0x91E8-0x91EF */
	0xe576,0xe577,0xe578,0xe579,0xe57a,0xe57b,0xe57c,0xe57d, /* 0x91F0-0x91F7 */
	0xe57e,0xe57f,0xe580,0xe581,0xe582,0xe583,0xe584,0x0000, /* 0x91F8-0x91FF */
	/* codebase=0x9240 rawbase=0x0d40 */
	0xe585,0xe586,0xe587,0xe588,0xe589,0xe58a,0xe58b,0xe58c, /* 0x9240-0x9247 */
	0xe58d,0xe58e,0xe58f,0xe590,0xe591,0xe592,0xe593,0xe594, /* 0x9248-0x924F */
	0xe595,0xe596,0xe597,0xe598,0xe599,0xe59a,0xe59b,0xe59c, /* 0x9250-0x9257 */
	0xe59d,0xe59e,0xe59f,0xe5a0,0xe5a1,0xe5a2,0xe5a3,0xe5a4, /* 0x9258-0x925F */
	0xe5a5,0xe5a6,0xe5a7,0xe5a8,0xe5a9,0xe5aa,0xe5ab,0xe5ac, /* 0x9260-0x9267 */
	0xe5ad,0xe5ae,0xe5af,0xe5b0,0xe5b1,0xe5b2,0xe5b3,0xe5b4, /* 0x9268-0x926F */
	0xe5b5,0xe5b6,0xe5b7,0xe5b8,0xe5b9,0xe5ba,0xe5bb,0xe5bc, /* 0x9270-0x9277 */
	0xe5bd,0xe5be,0xe5bf,0xe5c0,0xe5c1,0xe5c2,0xe5c3,0x0000, /* 0x9278-0x927F */
	/* codebase=0x9280 rawbase=0x0d80 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9280-0x9287 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9288-0x928F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9290-0x9297 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9298-0x929F */
	0x0000,0xe5c4,0xe5c5,0xe5c6,0xe5c7,0xe5c8,0xe5c9,0xe5ca, /* 0x92A0-0x92A7 */
	0xe5cb,0xe5cc,0xe5cd,0xe5ce,0xe5cf,0xe5d0,0xe5d1,0xe5d2, /* 0x92A8-0x92AF */
	0xe5d3,0xe5d4,0xe5d5,0xe5d6,0xe5d7,0xe5d8,0xe5d9,0xe5da, /* 0x92B0-0x92B7 */
	0xe5db,0xe5dc,0xe5dd,0xe5de,0xe5df,0xe5e0,0xe5e1,0xe5e2, /* 0x92B8-0x92BF */
	/* codebase=0x92c0 rawbase=0x0dc0 */
	0xe5e3,0xe5e4,0xe5e5,0xe5e6,0xe5e7,0xe5e8,0xe5e9,0xe5ea, /* 0x92C0-0x92C7 */
	0xe5eb,0xe5ec,0xe5ed,0xe5ee,0xe5ef,0xe5f0,0xe5f1,0xe5f2, /* 0x92C8-0x92CF */
	0xe5f3,0xe5f4,0xe5f5,0xe5f6,0xe5f7,0xe5f8,0xe5f9,0xe5fa, /* 0x92D0-0x92D7 */
	0xe5fb,0xe5fc,0xe5fd,0xe5fe,0xe5ff,0xe600,0xe601,0xe602, /* 0x92D8-0x92DF */
	0xe603,0xe604,0xe605,0xe606,0xe607,0xe608,0xe609,0xe60a, /* 0x92E0-0x92E7 */
	0xe60b,0xe60c,0xe60d,0xe60e,0xe60f,0xe610,0xe611,0xe612, /* 0x92E8-0x92EF */
	0xe613,0xe614,0xe615,0xe616,0xe617,0xe618,0xe619,0xe61a, /* 0x92F0-0x92F7 */
	0xe61b,0xe61c,0xe61d,0xe61e,0xe61f,0xe620,0xe621,0x0000, /* 0x92F8-0x92FF */
	/* codebase=0x9340 rawbase=0x0e00 */
	0xe622,0xe623,0xe624,0xe625,0xe626,0xe627,0xe628,0xe629, /* 0x9340-0x9347 */
	0xe62a,0xe62b,0xe62c,0xe62d,0xe62e,0xe62f,0xe630,0xe631, /* 0x9348-0x934F */
	0xe632,0xe633,0xe634,0xe635,0xe636,0xe637,0xe638,0xe639, /* 0x9350-0x9357 */
	0xe63a,0xe63b,0xe63c,0xe63d,0xe63e,0xe63f,0xe640,0xe641, /* 0x9358-0x935F */
	0xe642,0xe643,0xe644,0xe645,0xe646,0xe647,0xe648,0xe649, /* 0x9360-0x9367 */
	0xe64a,0xe64b,0xe64c,0xe64d,0xe64e,0xe64f,0xe650,0xe651, /* 0x9368-0x936F */
	0xe652,0xe653,0xe654,0xe655,0xe656,0xe657,0xe658,0xe659, /* 0x9370-0x9377 */
	0xe65a,0xe65b,0xe65c,0xe65d,0xe65e,0xe65f,0xe660,0x0000, /* 0x9378-0x937F */
	/* codebase=0x9380 rawbase=0x0e40 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9380-0x9387 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9388-0x938F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9390-0x9397 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9398-0x939F */
	0x0000,0xe661,0xe662,0xe663,0xe664,0xe665,0xe666,0xe667, /* 0x93A0-0x93A7 */
	0xe668,0xe669,0xe66a,0xe66b,0xe66c,0xe66d,0xe66e,0xe66f, /* 0x93A8-0x93AF */
	0xe670,0xe671,0xe672,0xe673,0xe674,0xe675,0xe676,0xe677, /* 0x93B0-0x93B7 */
	0xe678,0xe679,0xe67a,0xe67b,0xe67c,0xe67d,0xe67e,0xe67f, /* 0x93B8-0x93BF */
	/* codebase=0x93c0 rawbase=0x0e80 */
	0xe680,0xe681,0xe682,0xe683,0xe684,0xe685,0xe686,0xe687, /* 0x93C0-0x93C7 */
	0xe688,0xe689,0xe68a,0xe68b,0xe68c,0xe68d,0xe68e,0xe68f, /* 0x93C8-0x93CF */
	0xe690,0xe691,0xe692,0xe693,0xe694,0xe695,0xe696,0xe697, /* 0x93D0-0x93D7 */
	0xe698,0xe699,0xe69a,0xe69b,0xe69c,0xe69d,0xe69e,0xe69f, /* 0x93D8-0x93DF */
	0xe6a0,0xe6a1,0xe6a2,0xe6a3,0xe6a4,0xe6a5,0xe6a6,0xe6a7, /* 0x93E0-0x93E7 */
	0xe6a8,0xe6a9,0xe6aa,0xe6ab,0xe6ac,0xe6ad,0xe6ae,0xe6af, /* 0x93E8-0x93EF */
	0xe6b0,0xe6b1,0xe6b2,0xe6b3,0xe6b4,0xe6b5,0xe6b6,0xe6b7, /* 0x93F0-0x93F7 */
	0xe6b8,0xe6b9,0xe6ba,0xe6bb,0xe6bc,0xe6bd,0xe6be,0x0000, /* 0x93F8-0x93FF */
	/* codebase=0x9440 rawbase=0x0ec0 */
	0xe6bf,0xe6c0,0xe6c1,0xe6c2,0xe6c3,0xe6c4,0xe6c5,0xe6c6, /* 0x9440-0x9447 */
	0xe6c7,0xe6c8,0xe6c9,0xe6ca,0xe6cb,0xe6cc,0xe6cd,0xe6ce, /* 0x9448-0x944F */
	0xe6cf,0xe6d0,0xe6d1,0xe6d2,0xe6d3,0xe6d4,0xe6d5,0xe6d6, /* 0x9450-0x9457 */
	0xe6d7,0xe6d8,0xe6d9,0xe6da,0xe6db,0xe6dc,0xe6dd,0xe6de, /* 0x9458-0x945F */
	0xe6df,0xe6e0,0xe6e1,0xe6e2,0xe6e3,0xe6e4,0xe6e5,0xe6e6, /* 0x9460-0x9467 */
	0xe6e7,0xe6e8,0xe6e9,0xe6ea,0xe6eb,0xe6ec,0xe6ed,0xe6ee, /* 0x9468-0x946F */
	0xe6ef,0xe6f0,0xe6f1,0xe6f2,0xe6f3,0xe6f4,0xe6f5,0xe6f6, /* 0x9470-0x9477 */
	0xe6f7,0xe6f8,0xe6f9,0xe6fa,0xe6fb,0xe6fc,0xe6fd,0x0000, /* 0x9478-0x947F */
	/* codebase=0x9480 rawbase=0x0f00 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9480-0x9487 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9488-0x948F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9490-0x9497 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9498-0x949F */
	0x0000,0xe6fe,0xe6ff,0xe700,0xe701,0xe702,0xe703,0xe704, /* 0x94A0-0x94A7 */
	0xe705,0xe706,0xe707,0xe708,0xe709,0xe70a,0xe70b,0xe70c, /* 0x94A8-0x94AF */
	0xe70d,0xe70e,0xe70f,0xe710,0xe711,0xe712,0xe713,0xe714, /* 0x94B0-0x94B7 */
	0xe715,0xe716,0xe717,0xe718,0xe719,0xe71a,0xe71b,0xe71c, /* 0x94B8-0x94BF */
	/* codebase=0x94c0 rawbase=0x0f40 */
	0xe71d,0xe71e,0xe71f,0xe720,0xe721,0xe722,0xe723,0xe724, /* 0x94C0-0x94C7 */
	0xe725,0xe726,0xe727,0xe728,0xe729,0xe72a,0xe72b,0xe72c, /* 0x94C8-0x94CF */
	0xe72d,0xe72e,0xe72f,0xe730,0xe731,0xe732,0xe733,0xe734, /* 0x94D0-0x94D7 */
	0xe735,0xe736,0xe737,0xe738,0xe739,0xe73a,0xe73b,0xe73c, /* 0x94D8-0x94DF */
	0xe73d,0xe73e,0xe73f,0xe740,0xe741,0xe742,0xe743,0xe744, /* 0x94E0-0x94E7 */
	0xe745,0xe746,0xe747,0xe748,0xe749,0xe74a,0xe74b,0xe74c, /* 0x94E8-0x94EF */
	0xe74d,0xe74e,0xe74f,0xe750,0xe751,0xe752,0xe753,0xe754, /* 0x94F0-0x94F7 */
	0xe755,0xe756,0xe757,0xe758,0xe759,0xe75a,0xe75b,0x0000, /* 0x94F8-0x94FF */
	/* codebase=0x9540 rawbase=0x0f80 */
	0xe75c,0xe75d,0xe75e,0xe75f,0xe760,0xe761,0xe762,0xe763, /* 0x9540-0x9547 */
	0xe764,0xe765,0xe766,0xe767,0xe768,0xe769,0xe76a,0xe76b, /* 0x9548-0x954F */
	0xe76c,0xe76d,0xe76e,0xe76f,0xe770,0xe771,0xe772,0xe773, /* 0x9550-0x9557 */
	0xe774,0xe775,0xe776,0xe777,0xe778,0xe779,0xe77a,0xe77b, /* 0x9558-0x955F */
	0xe77c,0xe77d,0xe77e,0xe77f,0xe780,0xe781,0xe782,0xe783, /* 0x9560-0x9567 */
	0xe784,0xe785,0xe786,0xe787,0xe788,0xe789,0xe78a,0xe78b, /* 0x9568-0x956F */
	0xe78c,0xe78d,0xe78e,0xe78f,0xe790,0xe791,0xe792,0xe793, /* 0x9570-0x9577 */
	0xe794,0xe795,0xe796,0xe797,0xe798,0xe799,0xe79a,0x0000, /* 0x9578-0x957F */
	/* codebase=0x9580 rawbase=0x0fc0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9580-0x9587 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9588-0x958F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9590-0x9597 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9598-0x959F */
	0x0000,0xe79b,0xe79c,0xe79d,0xe79e,0xe79f,0xe7a0,0xe7a1, /* 0x95A0-0x95A7 */
	0xe7a2,0xe7a3,0xe7a4,0xe7a5,0xe7a6,0xe7a7,0xe7a8,0xe7a9, /* 0x95A8-0x95AF */
	0xe7aa,0xe7ab,0xe7ac,0xe7ad,0xe7ae,0xe7af,0xe7b0,0xe7b1, /* 0x95B0-0x95B7 */
	0xe7b2,0xe7b3,0xe7b4,0xe7b5,0xe7b6,0xe7b7,0xe7b8,0xe7b9, /* 0x95B8-0x95BF */
	/* codebase=0x95c0 rawbase=0x1000 */
	0xe7ba,0xe7bb,0xe7bc,0xe7bd,0xe7be,0xe7bf,0xe7c0,0xe7c1, /* 0x95C0-0x95C7 */
	0xe7c2,0xe7c3,0xe7c4,0xe7c5,0xe7c6,0xe7c7,0xe7c8,0xe7c9, /* 0x95C8-0x95CF */
	0xe7ca,0xe7cb,0xe7cc,0xe7cd,0xe7ce,0xe7cf,0xe7d0,0xe7d1, /* 0x95D0-0x95D7 */
	0xe7d2,0xe7d3,0xe7d4,0xe7d5,0xe7d6,0xe7d7,0xe7d8,0xe7d9, /* 0x95D8-0x95DF */
	0xe7da,0xe7db,0xe7dc,0xe7dd,0xe7de,0xe7df,0xe7e0,0xe7e1, /* 0x95E0-0x95E7 */
	0xe7e2,0xe7e3,0xe7e4,0xe7e5,0xe7e6,0xe7e7,0xe7e8,0xe7e9, /* 0x95E8-0x95EF */
	0xe7ea,0xe7eb,0xe7ec,0xe7ed,0xe7ee,0xe7ef,0xe7f0,0xe7f1, /* 0x95F0-0x95F7 */
	0xe7f2,0xe7f3,0xe7f4,0xe7f5,0xe7f6,0xe7f7,0xe7f8,0x0000, /* 0x95F8-0x95FF */
	/* codebase=0x9640 rawbase=0x1040 */
	0xe7f9,0xe7fa,0xe7fb,0xe7fc,0xe7fd,0xe7fe,0xe7ff,0xe800, /* 0x9640-0x9647 */
	0xe801,0xe802,0xe803,0xe804,0xe805,0xe806,0xe807,0xe808, /* 0x9648-0x964F */
	0xe809,0xe80a,0xe80b,0xe80c,0xe80d,0xe80e,0xe80f,0xe810, /* 0x9650-0x9657 */
	0xe811,0xe812,0xe813,0xe814,0xe815,0xe816,0xe817,0xe818, /* 0x9658-0x965F */
	0xe819,0xe81a,0xe81b,0xe81c,0xe81d,0xe81e,0xe81f,0xe820, /* 0x9660-0x9667 */
	0xe821,0xe822,0xe823,0xe824,0xe825,0xe826,0xe827,0xe828, /* 0x9668-0x966F */
	0xe829,0xe82a,0xe82b,0xe82c,0xe82d,0xe82e,0xe82f,0xe830, /* 0x9670-0x9677 */
	0xe831,0xe832,0xe833,0xe834,0xe835,0xe836,0xe837,0x0000, /* 0x9678-0x967F */
	/* codebase=0x9680 rawbase=0x1080 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9680-0x9687 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9688-0x968F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9690-0x9697 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9698-0x969F */
	0x0000,0xe838,0xe839,0xe83a,0xe83b,0xe83c,0xe83d,0xe83e, /* 0x96A0-0x96A7 */
	0xe83f,0xe840,0xe841,0xe842,0xe843,0xe844,0xe845,0xe846, /* 0x96A8-0x96AF */
	0xe847,0xe848,0xe849,0xe84a,0xe84b,0xe84c,0xe84d,0xe84e, /* 0x96B0-0x96B7 */
	0xe84f,0xe850,0xe851,0xe852,0xe853,0xe854,0xe855,0xe856, /* 0x96B8-0x96BF */
	/* codebase=0x96c0 rawbase=0x10c0 */
	0xe857,0xe858,0xe859,0xe85a,0xe85b,0xe85c,0xe85d,0xe85e, /* 0x96C0-0x96C7 */
	0xe85f,0xe860,0xe861,0xe862,0xe863,0xe864,0xe865,0xe866, /* 0x96C8-0x96CF */
	0xe867,0xe868,0xe869,0xe86a,0xe86b,0xe86c,0xe86d,0xe86e, /* 0x96D0-0x96D7 */
	0xe86f,0xe870,0xe871,0xe872,0xe873,0xe874,0xe875,0xe876, /* 0x96D8-0x96DF */
	0xe877,0xe878,0xe879,0xe87a,0xe87b,0xe87c,0xe87d,0xe87e, /* 0x96E0-0x96E7 */
	0xe87f,0xe880,0xe881,0xe882,0xe883,0xe884,0xe885,0xe886, /* 0x96E8-0x96EF */
	0xe887,0xe888,0xe889,0xe88a,0xe88b,0xe88c,0xe88d,0xe88e, /* 0x96F0-0x96F7 */
	0xe88f,0xe890,0xe891,0xe892,0xe893,0xe894,0xe895,0x0000, /* 0x96F8-0x96FF */
	/* codebase=0x9740 rawbase=0x1100 */
	0xe896,0xe897,0xe898,0xe899,0xe89a,0xe89b,0xe89c,0xe89d, /* 0x9740-0x9747 */
	0xe89e,0xe89f,0xe8a0,0xe8a1,0xe8a2,0xe8a3,0xe8a4,0xe8a5, /* 0x9748-0x974F */
	0xe8a6,0xe8a7,0xe8a8,0xe8a9,0xe8aa,0xe8ab,0xe8ac,0xe8ad, /* 0x9750-0x9757 */
	0xe8ae,0xe8af,0xe8b0,0xe8b1,0xe8b2,0xe8b3,0xe8b4,0xe8b5, /* 0x9758-0x975F */
	0xe8b6,0xe8b7,0xe8b8,0xe8b9,0xe8ba,0xe8bb,0xe8bc,0xe8bd, /* 0x9760-0x9767 */
	0xe8be,0xe8bf,0xe8c0,0xe8c1,0xe8c2,0xe8c3,0xe8c4,0xe8c5, /* 0x9768-0x976F */
	0xe8c6,0xe8c7,0xe8c8,0xe8c9,0xe8ca,0xe8cb,0xe8cc,0xe8cd, /* 0x9770-0x9777 */
	0xe8ce,0xe8cf,0xe8d0,0xe8d1,0xe8d2,0xe8d3,0xe8d4,0x0000, /* 0x9778-0x977F */
	/* codebase=0x9780 rawbase=0x1140 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9780-0x9787 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9788-0x978F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9790-0x9797 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9798-0x979F */
	0x0000,0xe8d5,0xe8d6,0xe8d7,0xe8d8,0xe8d9,0xe8da,0xe8db, /* 0x97A0-0x97A7 */
	0xe8dc,0xe8dd,0xe8de,0xe8df,0xe8e0,0xe8e1,0xe8e2,0xe8e3, /* 0x97A8-0x97AF */
	0xe8e4,0xe8e5,0xe8e6,0xe8e7,0xe8e8,0xe8e9,0xe8ea,0xe8eb, /* 0x97B0-0x97B7 */
	0xe8ec,0xe8ed,0xe8ee,0xe8ef,0xe8f0,0xe8f1,0xe8f2,0xe8f3, /* 0x97B8-0x97BF */
	/* codebase=0x97c0 rawbase=0x1180 */
	0xe8f4,0xe8f5,0xe8f6,0xe8f7,0xe8f8,0xe8f9,0xe8fa,0xe8fb, /* 0x97C0-0x97C7 */
	0xe8fc,0xe8fd,0xe8fe,0xe8ff,0xe900,0xe901,0xe902,0xe903, /* 0x97C8-0x97CF */
	0xe904,0xe905,0xe906,0xe907,0xe908,0xe909,0xe90a,0xe90b, /* 0x97D0-0x97D7 */
	0xe90c,0xe90d,0xe90e,0xe90f,0xe910,0xe911,0xe912,0xe913, /* 0x97D8-0x97DF */
	0xe914,0xe915,0xe916,0xe917,0xe918,0xe919,0xe91a,0xe91b, /* 0x97E0-0x97E7 */
	0xe91c,0xe91d,0xe91e,0xe91f,0xe920,0xe921,0xe922,0xe923, /* 0x97E8-0x97EF */
	0xe924,0xe925,0xe926,0xe927,0xe928,0xe929,0xe92a,0xe92b, /* 0x97F0-0x97F7 */
	0xe92c,0xe92d,0xe92e,0xe92f,0xe930,0xe931,0xe932,0x0000, /* 0x97F8-0x97FF */
	/* codebase=0x9840 rawbase=0x11c0 */
	0xe933,0xe934,0xe935,0xe936,0xe937,0xe938,0xe939,0xe93a, /* 0x9840-0x9847 */
	0xe93b,0xe93c,0xe93d,0xe93e,0xe93f,0xe940,0xe941,0xe942, /* 0x9848-0x984F */
	0xe943,0xe944,0xe945,0xe946,0xe947,0xe948,0xe949,0xe94a, /* 0x9850-0x9857 */
	0xe94b,0xe94c,0xe94d,0xe94e,0xe94f,0xe950,0xe951,0xe952, /* 0x9858-0x985F */
	0xe953,0xe954,0xe955,0xe956,0xe957,0xe958,0xe959,0xe95a, /* 0x9860-0x9867 */
	0xe95b,0xe95c,0xe95d,0xe95e,0xe95f,0xe960,0xe961,0xe962, /* 0x9868-0x986F */
	0xe963,0xe964,0xe965,0xe966,0xe967,0xe968,0xe969,0xe96a, /* 0x9870-0x9877 */
	0xe96b,0xe96c,0xe96d,0xe96e,0xe96f,0xe970,0xe971,0x0000, /* 0x9878-0x987F */
	/* codebase=0x9880 rawbase=0x1200 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9880-0x9887 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9888-0x988F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9890-0x9897 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9898-0x989F */
	0x0000,0xe972,0xe973,0xe974,0xe975,0xe976,0xe977,0xe978, /* 0x98A0-0x98A7 */
	0xe979,0xe97a,0xe97b,0xe97c,0xe97d,0xe97e,0xe97f,0xe980, /* 0x98A8-0x98AF */
	0xe981,0xe982,0xe983,0xe984,0xe985,0xe986,0xe987,0xe988, /* 0x98B0-0x98B7 */
	0xe989,0xe98a,0xe98b,0xe98c,0xe98d,0xe98e,0xe98f,0xe990, /* 0x98B8-0x98BF */
	/* codebase=0x98c0 rawbase=0x1240 */
	0xe991,0xe992,0xe993,0xe994,0xe995,0xe996,0xe997,0xe998, /* 0x98C0-0x98C7 */
	0xe999,0xe99a,0xe99b,0xe99c,0xe99d,0xe99e,0xe99f,0xe9a0, /* 0x98C8-0x98CF */
	0xe9a1,0xe9a2,0xe9a3,0xe9a4,0xe9a5,0xe9a6,0xe9a7,0xe9a8, /* 0x98D0-0x98D7 */
	0xe9a9,0xe9aa,0xe9ab,0xe9ac,0xe9ad,0xe9ae,0xe9af,0xe9b0, /* 0x98D8-0x98DF */
	0xe9b1,0xe9b2,0xe9b3,0xe9b4,0xe9b5,0xe9b6,0xe9b7,0xe9b8, /* 0x98E0-0x98E7 */
	0xe9b9,0xe9ba,0xe9bb,0xe9bc,0xe9bd,0xe9be,0xe9bf,0xe9c0, /* 0x98E8-0x98EF */
	0xe9c1,0xe9c2,0xe9c3,0xe9c4,0xe9c5,0xe9c6,0xe9c7,0xe9c8, /* 0x98F0-0x98F7 */
	0xe9c9,0xe9ca,0xe9cb,0xe9cc,0xe9cd,0xe9ce,0xe9cf,0x0000, /* 0x98F8-0x98FF */
	/* codebase=0x9940 rawbase=0x1280 */
	0xe9d0,0xe9d1,0xe9d2,0xe9d3,0xe9d4,0xe9d5,0xe9d6,0xe9d7, /* 0x9940-0x9947 */
	0xe9d8,0xe9d9,0xe9da,0xe9db,0xe9dc,0xe9dd,0xe9de,0xe9df, /* 0x9948-0x994F */
	0xe9e0,0xe9e1,0xe9e2,0xe9e3,0xe9e4,0xe9e5,0xe9e6,0xe9e7, /* 0x9950-0x9957 */
	0xe9e8,0xe9e9,0xe9ea,0xe9eb,0xe9ec,0xe9ed,0xe9ee,0xe9ef, /* 0x9958-0x995F */
	0xe9f0,0xe9f1,0xe9f2,0xe9f3,0xe9f4,0xe9f5,0xe9f6,0xe9f7, /* 0x9960-0x9967 */
	0xe9f8,0xe9f9,0xe9fa,0xe9fb,0xe9fc,0xe9fd,0xe9fe,0xe9ff, /* 0x9968-0x996F */
	0xea00,0xea01,0xea02,0xea03,0xea04,0xea05,0xea06,0xea07, /* 0x9970-0x9977 */
	0xea08,0xea09,0xea0a,0xea0b,0xea0c,0xea0d,0xea0e,0x0000, /* 0x9978-0x997F */
	/* codebase=0x9980 rawbase=0x12c0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9980-0x9987 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9988-0x998F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9990-0x9997 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9998-0x999F */
	0x0000,0xea0f,0xea10,0xea11,0xea12,0xea13,0xea14,0xea15, /* 0x99A0-0x99A7 */
	0xea16,0xea17,0xea18,0xea19,0xea1a,0xea1b,0xea1c,0xea1d, /* 0x99A8-0x99AF */
	0xea1e,0xea1f,0xea20,0xea21,0xea22,0xea23,0xea24,0xea25, /* 0x99B0-0x99B7 */
	0xea26,0xea27,0xea28,0xea29,0xea2a,0xea2b,0xea2c,0xea2d, /* 0x99B8-0x99BF */
	/* codebase=0x99c0 rawbase=0x1300 */
	0xea2e,0xea2f,0xea30,0xea31,0xea32,0xea33,0xea34,0xea35, /* 0x99C0-0x99C7 */
	0xea36,0xea37,0xea38,0xea39,0xea3a,0xea3b,0xea3c,0xea3d, /* 0x99C8-0x99CF */
	0xea3e,0xea3f,0xea40,0xea41,0xea42,0xea43,0xea44,0xea45, /* 0x99D0-0x99D7 */
	0xea46,0xea47,0xea48,0xea49,0xea4a,0xea4b,0xea4c,0xea4d, /* 0x99D8-0x99DF */
	0xea4e,0xea4f,0xea50,0xea51,0xea52,0xea53,0xea54,0xea55, /* 0x99E0-0x99E7 */
	0xea56,0xea57,0xea58,0xea59,0xea5a,0xea5b,0xea5c,0xea5d, /* 0x99E8-0x99EF */
	0xea5e,0xea5f,0xea60,0xea61,0xea62,0xea63,0xea64,0xea65, /* 0x99F0-0x99F7 */
	0xea66,0xea67,0xea68,0xea69,0xea6a,0xea6b,0xea6c,0x0000, /* 0x99F8-0x99FF */
	/* codebase=0x9a40 rawbase=0x1340 */
	0xea6d,0xea6e,0xea6f,0xea70,0xea71,0xea72,0xea73,0xea74, /* 0x9A40-0x9A47 */
	0xea75,0xea76,0xea77,0xea78,0xea79,0xea7a,0xea7b,0xea7c, /* 0x9A48-0x9A4F */
	0xea7d,0xea7e,0xea7f,0xea80,0xea81,0xea82,0xea83,0xea84, /* 0x9A50-0x9A57 */
	0xea85,0xea86,0xea87,0xea88,0xea89,0xea8a,0xea8b,0xea8c, /* 0x9A58-0x9A5F */
	0xea8d,0xea8e,0xea8f,0xea90,0xea91,0xea92,0xea93,0xea94, /* 0x9A60-0x9A67 */
	0xea95,0xea96,0xea97,0xea98,0xea99,0xea9a,0xea9b,0xea9c, /* 0x9A68-0x9A6F */
	0xea9d,0xea9e,0xea9f,0xeaa0,0xeaa1,0xeaa2,0xeaa3,0xeaa4, /* 0x9A70-0x9A77 */
	0xeaa5,0xeaa6,0xeaa7,0xeaa8,0xeaa9,0xeaaa,0xeaab,0x0000, /* 0x9A78-0x9A7F */
	/* codebase=0x9a80 rawbase=0x1380 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9A80-0x9A87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9A88-0x9A8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9A90-0x9A97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9A98-0x9A9F */
	0x0000,0xeaac,0xeaad,0xeaae,0xeaaf,0xeab0,0xeab1,0xeab2, /* 0x9AA0-0x9AA7 */
	0xeab3,0xeab4,0xeab5,0xeab6,0xeab7,0xeab8,0xeab9,0xeaba, /* 0x9AA8-0x9AAF */
	0xeabb,0xeabc,0xeabd,0xeabe,0xeabf,0xeac0,0xeac1,0xeac2, /* 0x9AB0-0x9AB7 */
	0xeac3,0xeac4,0xeac5,0xeac6,0xeac7,0xeac8,0xeac9,0xeaca, /* 0x9AB8-0x9ABF */
	/* codebase=0x9ac0 rawbase=0x13c0 */
	0xeacb,0xeacc,0xeacd,0xeace,0xeacf,0xead0,0xead1,0xead2, /* 0x9AC0-0x9AC7 */
	0xead3,0xead4,0xead5,0xead6,0xead7,0xead8,0xead9,0xeada, /* 0x9AC8-0x9ACF */
	0xeadb,0xeadc,0xeadd,0xeade,0xeadf,0xeae0,0xeae1,0xeae2, /* 0x9AD0-0x9AD7 */
	0xeae3,0xeae4,0xeae5,0xeae6,0xeae7,0xeae8,0xeae9,0xeaea, /* 0x9AD8-0x9ADF */
	0xeaeb,0xeaec,0xeaed,0xeaee,0xeaef,0xeaf0,0xeaf1,0xeaf2, /* 0x9AE0-0x9AE7 */
	0xeaf3,0xeaf4,0xeaf5,0xeaf6,0xeaf7,0xeaf8,0xeaf9,0xeafa, /* 0x9AE8-0x9AEF */
	0xeafb,0xeafc,0xeafd,0xeafe,0xeaff,0xeb00,0xeb01,0xeb02, /* 0x9AF0-0x9AF7 */
	0xeb03,0xeb04,0xeb05,0xeb06,0xeb07,0xeb08,0xeb09,0x0000, /* 0x9AF8-0x9AFF */
	/* codebase=0x9b40 rawbase=0x1400 */
	0xeb0a,0xeb0b,0xeb0c,0xeb0d,0xeb0e,0xeb0f,0xeb10,0xeb11, /* 0x9B40-0x9B47 */
	0xeb12,0xeb13,0xeb14,0xeb15,0xeb16,0xeb17,0xeb18,0xeb19, /* 0x9B48-0x9B4F */
	0xeb1a,0xeb1b,0xeb1c,0xeb1d,0xeb1e,0xeb1f,0xeb20,0xeb21, /* 0x9B50-0x9B57 */
	0xeb22,0xeb23,0xeb24,0xeb25,0xeb26,0xeb27,0xeb28,0xeb29, /* 0x9B58-0x9B5F */
	0xeb2a,0xeb2b,0xeb2c,0xeb2d,0xeb2e,0xeb2f,0xeb30,0xeb31, /* 0x9B60-0x9B67 */
	0xeb32,0xeb33,0xeb34,0xeb35,0xeb36,0xeb37,0xeb38,0xeb39, /* 0x9B68-0x9B6F */
	0xeb3a,0xeb3b,0xeb3c,0xeb3d,0xeb3e,0xeb3f,0xeb40,0xeb41, /* 0x9B70-0x9B77 */
	0xeb42,0xeb43,0xeb44,0xeb45,0xeb46,0xeb47,0xeb48,0x0000, /* 0x9B78-0x9B7F */
	/* codebase=0x9b80 rawbase=0x1440 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9B80-0x9B87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9B88-0x9B8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9B90-0x9B97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9B98-0x9B9F */
	0x0000,0xeb49,0xeb4a,0xeb4b,0xeb4c,0xeb4d,0xeb4e,0xeb4f, /* 0x9BA0-0x9BA7 */
	0xeb50,0xeb51,0xeb52,0xeb53,0xeb54,0xeb55,0xeb56,0xeb57, /* 0x9BA8-0x9BAF */
	0xeb58,0xeb59,0xeb5a,0xeb5b,0xeb5c,0xeb5d,0xeb5e,0xeb5f, /* 0x9BB0-0x9BB7 */
	0xeb60,0xeb61,0xeb62,0xeb63,0xeb64,0xeb65,0xeb66,0xeb67, /* 0x9BB8-0x9BBF */
	/* codebase=0x9bc0 rawbase=0x1480 */
	0xeb68,0xeb69,0xeb6a,0xeb6b,0xeb6c,0xeb6d,0xeb6e,0xeb6f, /* 0x9BC0-0x9BC7 */
	0xeb70,0xeb71,0xeb72,0xeb73,0xeb74,0xeb75,0xeb76,0xeb77, /* 0x9BC8-0x9BCF */
	0xeb78,0xeb79,0xeb7a,0xeb7b,0xeb7c,0xeb7d,0xeb7e,0xeb7f, /* 0x9BD0-0x9BD7 */
	0xeb80,0xeb81,0xeb82,0xeb83,0xeb84,0xeb85,0xeb86,0xeb87, /* 0x9BD8-0x9BDF */
	0xeb88,0xeb89,0xeb8a,0xeb8b,0xeb8c,0xeb8d,0xeb8e,0xeb8f, /* 0x9BE0-0x9BE7 */
	0xeb90,0xeb91,0xeb92,0xeb93,0xeb94,0xeb95,0xeb96,0xeb97, /* 0x9BE8-0x9BEF */
	0xeb98,0xeb99,0xeb9a,0xeb9b,0xeb9c,0xeb9d,0xeb9e,0xeb9f, /* 0x9BF0-0x9BF7 */
	0xeba0,0xeba1,0xeba2,0xeba3,0xeba4,0xeba5,0xeba6,0x0000, /* 0x9BF8-0x9BFF */
	/* codebase=0x9c40 rawbase=0x14c0 */
	0xeba7,0xeba8,0xeba9,0xebaa,0xebab,0xebac,0xebad,0xebae, /* 0x9C40-0x9C47 */
	0xebaf,0xebb0,0xebb1,0xebb2,0xebb3,0xebb4,0xebb5,0xebb6, /* 0x9C48-0x9C4F */
	0xebb7,0xebb8,0xebb9,0xebba,0xebbb,0xebbc,0xebbd,0xebbe, /* 0x9C50-0x9C57 */
	0xebbf,0xebc0,0xebc1,0xebc2,0xebc3,0xebc4,0xebc5,0xebc6, /* 0x9C58-0x9C5F */
	0xebc7,0xebc8,0xebc9,0xebca,0xebcb,0xebcc,0xebcd,0xebce, /* 0x9C60-0x9C67 */
	0xebcf,0xebd0,0xebd1,0xebd2,0xebd3,0xebd4,0xebd5,0xebd6, /* 0x9C68-0x9C6F */
	0xebd7,0xebd8,0xebd9,0xebda,0xebdb,0xebdc,0xebdd,0xebde, /* 0x9C70-0x9C77 */
	0xebdf,0xebe0,0xebe1,0xebe2,0xebe3,0xebe4,0xebe5,0x0000, /* 0x9C78-0x9C7F */
	/* codebase=0x9c80 rawbase=0x1500 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9C80-0x9C87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9C88-0x9C8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9C90-0x9C97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9C98-0x9C9F */
	0x0000,0xebe6,0xebe7,0xebe8,0xebe9,0xebea,0xebeb,0xebec, /* 0x9CA0-0x9CA7 */
	0xebed,0xebee,0xebef,0xebf0,0xebf1,0xebf2,0xebf3,0xebf4, /* 0x9CA8-0x9CAF */
	0xebf5,0xebf6,0xebf7,0xebf8,0xebf9,0xebfa,0xebfb,0xebfc, /* 0x9CB0-0x9CB7 */
	0xebfd,0xebfe,0xebff,0xec00,0xec01,0xec02,0xec03,0xec04, /* 0x9CB8-0x9CBF */
	/* codebase=0x9cc0 rawbase=0x1540 */
	0xec05,0xec06,0xec07,0xec08,0xec09,0xec0a,0xec0b,0xec0c, /* 0x9CC0-0x9CC7 */
	0xec0d,0xec0e,0xec0f,0xec10,0xec11,0xec12,0xec13,0xec14, /* 0x9CC8-0x9CCF */
	0xec15,0xec16,0xec17,0xec18,0xec19,0xec1a,0xec1b,0xec1c, /* 0x9CD0-0x9CD7 */
	0xec1d,0xec1e,0xec1f,0xec20,0xec21,0xec22,0xec23,0xec24, /* 0x9CD8-0x9CDF */
	0xec25,0xec26,0xec27,0xec28,0xec29,0xec2a,0xec2b,0xec2c, /* 0x9CE0-0x9CE7 */
	0xec2d,0xec2e,0xec2f,0xec30,0xec31,0xec32,0xec33,0xec34, /* 0x9CE8-0x9CEF */
	0xec35,0xec36,0xec37,0xec38,0xec39,0xec3a,0xec3b,0xec3c, /* 0x9CF0-0x9CF7 */
	0xec3d,0xec3e,0xec3f,0xec40,0xec41,0xec42,0xec43,0x0000, /* 0x9CF8-0x9CFF */
	/* codebase=0x9d40 rawbase=0x1580 */
	0xec44,0xec45,0xec46,0xec47,0xec48,0xec49,0xec4a,0xec4b, /* 0x9D40-0x9D47 */
	0xec4c,0xec4d,0xec4e,0xec4f,0xec50,0xec51,0xec52,0xec53, /* 0x9D48-0x9D4F */
	0xec54,0xec55,0xec56,0xec57,0xec58,0xec59,0xec5a,0xec5b, /* 0x9D50-0x9D57 */
	0xec5c,0xec5d,0xec5e,0xec5f,0xec60,0xec61,0xec62,0xec63, /* 0x9D58-0x9D5F */
	0xec64,0xec65,0xec66,0xec67,0xec68,0xec69,0xec6a,0xec6b, /* 0x9D60-0x9D67 */
	0xec6c,0xec6d,0xec6e,0xec6f,0xec70,0xec71,0xec72,0xec73, /* 0x9D68-0x9D6F */
	0xec74,0xec75,0xec76,0xec77,0xec78,0xec79,0xec7a,0xec7b, /* 0x9D70-0x9D77 */
	0xec7c,0xec7d,0xec7e,0xec7f,0xec80,0xec81,0xec82,0x0000, /* 0x9D78-0x9D7F */
	/* codebase=0x9d80 rawbase=0x15c0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9D80-0x9D87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9D88-0x9D8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9D90-0x9D97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9D98-0x9D9F */
	0x0000,0xec83,0xec84,0xec85,0xec86,0xec87,0xec88,0xec89, /* 0x9DA0-0x9DA7 */
	0xec8a,0xec8b,0xec8c,0xec8d,0xec8e,0xec8f,0xec90,0xec91, /* 0x9DA8-0x9DAF */
	0xec92,0xec93,0xec94,0xec95,0xec96,0xec97,0xec98,0xec99, /* 0x9DB0-0x9DB7 */
	0xec9a,0xec9b,0xec9c,0xec9d,0xec9e,0xec9f,0xeca0,0xeca1, /* 0x9DB8-0x9DBF */
	/* codebase=0x9dc0 rawbase=0x1600 */
	0xeca2,0xeca3,0xeca4,0xeca5,0xeca6,0xeca7,0xeca8,0xeca9, /* 0x9DC0-0x9DC7 */
	0xecaa,0xecab,0xecac,0xecad,0xecae,0xecaf,0xecb0,0xecb1, /* 0x9DC8-0x9DCF */
	0xecb2,0xecb3,0xecb4,0xecb5,0xecb6,0xecb7,0xecb8,0xecb9, /* 0x9DD0-0x9DD7 */
	0xecba,0xecbb,0xecbc,0xecbd,0xecbe,0xecbf,0xecc0,0xecc1, /* 0x9DD8-0x9DDF */
	0xecc2,0xecc3,0xecc4,0xecc5,0xecc6,0xecc7,0xecc8,0xecc9, /* 0x9DE0-0x9DE7 */
	0xecca,0xeccb,0xeccc,0xeccd,0xecce,0xeccf,0xecd0,0xecd1, /* 0x9DE8-0x9DEF */
	0xecd2,0xecd3,0xecd4,0xecd5,0xecd6,0xecd7,0xecd8,0xecd9, /* 0x9DF0-0x9DF7 */
	0xecda,0xecdb,0xecdc,0xecdd,0xecde,0xecdf,0xece0,0x0000, /* 0x9DF8-0x9DFF */
	/* codebase=0x9e40 rawbase=0x1640 */
	0xece1,0xece2,0xece3,0xece4,0xece5,0xece6,0xece7,0xece8, /* 0x9E40-0x9E47 */
	0xece9,0xecea,0xeceb,0xecec,0xeced,0xecee,0xecef,0xecf0, /* 0x9E48-0x9E4F */
	0xecf1,0xecf2,0xecf3,0xecf4,0xecf5,0xecf6,0xecf7,0xecf8, /* 0x9E50-0x9E57 */
	0xecf9,0xecfa,0xecfb,0xecfc,0xecfd,0xecfe,0xecff,0xed00, /* 0x9E58-0x9E5F */
	0xed01,0xed02,0xed03,0xed04,0xed05,0xed06,0xed07,0xed08, /* 0x9E60-0x9E67 */
	0xed09,0xed0a,0xed0b,0xed0c,0xed0d,0xed0e,0xed0f,0xed10, /* 0x9E68-0x9E6F */
	0xed11,0xed12,0xed13,0xed14,0xed15,0xed16,0xed17,0xed18, /* 0x9E70-0x9E77 */
	0xed19,0xed1a,0xed1b,0xed1c,0xed1d,0xed1e,0xed1f,0x0000, /* 0x9E78-0x9E7F */
	/* codebase=0x9e80 rawbase=0x1680 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9E80-0x9E87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9E88-0x9E8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9E90-0x9E97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9E98-0x9E9F */
	0x0000,0xed20,0xed21,0xed22,0xed23,0xed24,0xed25,0xed26, /* 0x9EA0-0x9EA7 */
	0xed27,0xed28,0xed29,0xed2a,0xed2b,0xed2c,0xed2d,0xed2e, /* 0x9EA8-0x9EAF */
	0xed2f,0xed30,0xed31,0xed32,0xed33,0xed34,0xed35,0xed36, /* 0x9EB0-0x9EB7 */
	0xed37,0xed38,0xed39,0xed3a,0xed3b,0xed3c,0xed3d,0xed3e, /* 0x9EB8-0x9EBF */
	/* codebase=0x9ec0 rawbase=0x16c0 */
	0xed3f,0xed40,0xed41,0xed42,0xed43,0xed44,0xed45,0xed46, /* 0x9EC0-0x9EC7 */
	0xed47,0xed48,0xed49,0xed4a,0xed4b,0xed4c,0xed4d,0xed4e, /* 0x9EC8-0x9ECF */
	0xed4f,0xed50,0xed51,0xed52,0xed53,0xed54,0xed55,0xed56, /* 0x9ED0-0x9ED7 */
	0xed57,0xed58,0xed59,0xed5a,0xed5b,0xed5c,0xed5d,0xed5e, /* 0x9ED8-0x9EDF */
	0xed5f,0xed60,0xed61,0xed62,0xed63,0xed64,0xed65,0xed66, /* 0x9EE0-0x9EE7 */
	0xed67,0xed68,0xed69,0xed6a,0xed6b,0xed6c,0xed6d,0xed6e, /* 0x9EE8-0x9EEF */
	0xed6f,0xed70,0xed71,0xed72,0xed73,0xed74,0xed75,0xed76, /* 0x9EF0-0x9EF7 */
	0xed77,0xed78,0xed79,0xed7a,0xed7b,0xed7c,0xed7d,0x0000, /* 0x9EF8-0x9EFF */
	/* codebase=0x9f40 rawbase=0x1700 */
	0xed7e,0xed7f,0xed80,0xed81,0xed82,0xed83,0xed84,0xed85, /* 0x9F40-0x9F47 */
	0xed86,0xed87,0xed88,0xed89,0xed8a,0xed8b,0xed8c,0xed8d, /* 0x9F48-0x9F4F */
	0xed8e,0xed8f,0xed90,0xed91,0xed92,0xed93,0xed94,0xed95, /* 0x9F50-0x9F57 */
	0xed96,0xed97,0xed98,0xed99,0xed9a,0xed9b,0xed9c,0xed9d, /* 0x9F58-0x9F5F */
	0xed9e,0xed9f,0xeda0,0xeda1,0xeda2,0xeda3,0xeda4,0xeda5, /* 0x9F60-0x9F67 */
	0xeda6,0xeda7,0xeda8,0xeda9,0xedaa,0xedab,0xedac,0xedad, /* 0x9F68-0x9F6F */
	0xedae,0xedaf,0xedb0,0xedb1,0xedb2,0xedb3,0xedb4,0xedb5, /* 0x9F70-0x9F77 */
	0xedb6,0xedb7,0xedb8,0xedb9,0xedba,0xedbb,0xedbc,0x0000, /* 0x9F78-0x9F7F */
	/* codebase=0x9f80 rawbase=0x1740 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9F80-0x9F87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9F88-0x9F8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9F90-0x9F97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9F98-0x9F9F */
	0x0000,0xedbd,0xedbe,0xedbf,0xedc0,0xedc1,0xedc2,0xedc3, /* 0x9FA0-0x9FA7 */
	0xedc4,0xedc5,0xedc6,0xedc7,0xedc8,0xedc9,0xedca,0xedcb, /* 0x9FA8-0x9FAF */
	0xedcc,0xedcd,0xedce,0xedcf,0xedd0,0xedd1,0xedd2,0xedd3, /* 0x9FB0-0x9FB7 */
	0xedd4,0xedd5,0xedd6,0xedd7,0xedd8,0xedd9,0xedda,0xeddb, /* 0x9FB8-0x9FBF */
	/* codebase=0x9fc0 rawbase=0x1780 */
	0xeddc,0xeddd,0xedde,0xeddf,0xede0,0xede1,0xede2,0xede3, /* 0x9FC0-0x9FC7 */
	0xede4,0xede5,0xede6,0xede7,0xede8,0xede9,0xedea,0xedeb, /* 0x9FC8-0x9FCF */
	0xedec,0xeded,0xedee,0xedef,0xedf0,0xedf1,0xedf2,0xedf3, /* 0x9FD0-0x9FD7 */
	0xedf4,0xedf5,0xedf6,0xedf7,0xedf8,0xedf9,0xedfa,0xedfb, /* 0x9FD8-0x9FDF */
	0xedfc,0xedfd,0xedfe,0xedff,0xee00,0xee01,0xee02,0xee03, /* 0x9FE0-0x9FE7 */
	0xee04,0xee05,0xee06,0xee07,0xee08,0xee09,0xee0a,0xee0b, /* 0x9FE8-0x9FEF */
	0xee0c,0xee0d,0xee0e,0xee0f,0xee10,0xee11,0xee12,0xee13, /* 0x9FF0-0x9FF7 */
	0xee14,0xee15,0xee16,0xee17,0xee18,0xee19,0xee1a,0x0000, /* 0x9FF8-0x9FFF */
	/* codebase=0xa040 rawbase=0x17c0 */
	0xee1b,0xee1c,0xee1d,0xee1e,0xee1f,0xee20,0xee21,0xee22, /* 0xA040-0xA047 */
	0xee23,0xee24,0xee25,0xee26,0xee27,0xee28,0xee29,0xee2a, /* 0xA048-0xA04F */
	0xee2b,0xee2c,0xee2d,0xee2e,0xee2f,0xee30,0xee31,0xee32, /* 0xA050-0xA057 */
	0xee33,0xee34,0xee35,0xee36,0xee37,0xee38,0xee39,0xee3a, /* 0xA058-0xA05F */
	0xee3b,0xee3c,0xee3d,0xee3e,0xee3f,0xee40,0xee41,0xee42, /* 0xA060-0xA067 */
	0xee43,0xee44,0xee45,0xee46,0xee47,0xee48,0xee49,0xee4a, /* 0xA068-0xA06F */
	0xee4b,0xee4c,0xee4d,0xee4e,0xee4f,0xee50,0xee51,0xee52, /* 0xA070-0xA077 */
	0xee53,0xee54,0xee55,0xee56,0xee57,0xee58,0xee59,0x0000, /* 0xA078-0xA07F */
	/* codebase=0xa080 rawbase=0x1800 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA080-0xA087 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA088-0xA08F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA090-0xA097 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA098-0xA09F */
	0x0000,0xee5a,0xee5b,0xee5c,0xee5d,0xee5e,0xee5f,0xee60, /* 0xA0A0-0xA0A7 */
	0xee61,0xee62,0xee63,0xee64,0xee65,0xee66,0xee67,0xee68, /* 0xA0A8-0xA0AF */
	0xee69,0xee6a,0xee6b,0xee6c,0xee6d,0xee6e,0xee6f,0xee70, /* 0xA0B0-0xA0B7 */
	0xee71,0xee72,0xee73,0xee74,0xee75,0xee76,0xee77,0xee78, /* 0xA0B8-0xA0BF */
	/* codebase=0xa0c0 rawbase=0x1840 */
	0xee79,0xee7a,0xee7b,0xee7c,0xee7d,0xee7e,0xee7f,0xee80, /* 0xA0C0-0xA0C7 */
	0xee81,0xee82,0xee83,0xee84,0xee85,0xee86,0xee87,0xee88, /* 0xA0C8-0xA0CF */
	0xee89,0xee8a,0xee8b,0xee8c,0xee8d,0xee8e,0xee8f,0xee90, /* 0xA0D0-0xA0D7 */
	0xee91,0xee92,0xee93,0xee94,0xee95,0xee96,0xee97,0xee98, /* 0xA0D8-0xA0DF */
	0xee99,0xee9a,0xee9b,0xee9c,0xee9d,0xee9e,0xee9f,0xeea0, /* 0xA0E0-0xA0E7 */
	0xeea1,0xeea2,0xeea3,0xeea4,0xeea5,0xeea6,0xeea7,0xeea8, /* 0xA0E8-0xA0EF */
	0xeea9,0xeeaa,0xeeab,0xeeac,0xeead,0xeeae,0xeeaf,0xeeb0, /* 0xA0F0-0xA0F7 */
	0xeeb1,0xeeb2,0xeeb3,0xeeb4,0xeeb5,0xeeb6,0xeeb7,0x0000, /* 0xA0F8-0xA0FF */
	/* codebase=0xa140 rawbase=0x1880 */
	0x3000,0xff0c,0x3001,0x3002,0xff0e,0x2027,0xff1b,0xff1a, /* 0xA140-0xA147 */
	0xff1f,0xff01,0xfe30,0x2026,0x2025,0xfe50,0xfe51,0xfe52, /* 0xA148-0xA14F */
	0x00b7,0xfe54,0xfe55,0xfe56,0xfe57,0xff5c,0x2015,0xfe31, /* 0xA150-0xA157 */
	0x2014,0xfe33,0x2574,0xfe34,0xfe4f,0xff08,0xff09,0xfe35, /* 0xA158-0xA15F */
	0xfe36,0xff5b,0xff5d,0xfe37,0xfe38,0x3014,0x3015,0xfe39, /* 0xA160-0xA167 */
	0xfe3a,0x3010,0x3011,0xfe3b,0xfe3c,0x300a,0x300b,0xfe3d, /* 0xA168-0xA16F */
	0xfe3e,0x3008,0x3009,0xfe3f,0xfe40,0x300c,0x300d,0xfe41, /* 0xA170-0xA177 */
	0xfe42,0x300e,0x300f,0xfe43,0xfe44,0xfe59,0xfe5a,0x0000, /* 0xA178-0xA17F */
	/* codebase=0xa180 rawbase=0x18c0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA180-0xA187 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA188-0xA18F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA190-0xA197 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA198-0xA19F */
	0x0000,0xfe5b,0xfe5c,0xfe5d,0xfe5e,0x2018,0x2019,0x201c, /* 0xA1A0-0xA1A7 */
	0x201d,0x301d,0x301e,0x2035,0x2032,0xff03,0xff06,0xff0a, /* 0xA1A8-0xA1AF */
	0x203b,0x00a7,0x3003,0x25cb,0x25cf,0x25b3,0x25b2,0x25ce, /* 0xA1B0-0xA1B7 */
	0x2606,0x2605,0x25c7,0x25c6,0x25a1,0x25a0,0x25bd,0x25bc, /* 0xA1B8-0xA1BF */
	/* codebase=0xa1c0 rawbase=0x1900 */
	0x32a3,0x2105,0x203e,0xffe3,0xff3f,0x02cd,0xfe49,0xfe4a, /* 0xA1C0-0xA1C7 */
	0xfe4d,0xfe4e,0xfe4b,0xfe4c,0xfe5f,0xfe60,0xfe61,0xff0b, /* 0xA1C8-0xA1CF */
	0xff0d,0x00d7,0x00f7,0x00b1,0x221a,0xff1c,0xff1e,0xff1d, /* 0xA1D0-0xA1D7 */
	0x2266,0x2267,0x2260,0x221e,0x2252,0x2261,0xfe62,0xfe63, /* 0xA1D8-0xA1DF */
	0xfe64,0xfe65,0xfe66,0xff5e,0x2229,0x222a,0x22a5,0x2220, /* 0xA1E0-0xA1E7 */
	0x221f,0x22bf,0x33d2,0x33d1,0x222b,0x222e,0x2235,0x2234, /* 0xA1E8-0xA1EF */
	0x2640,0x2642,0x2295,0x2299,0x2191,0x2193,0x2190,0x2192, /* 0xA1F0-0xA1F7 */
	0x2196,0x2197,0x2199,0x2198,0x2225,0x2223,0xff0f,0x0000, /* 0xA1F8-0xA1FF */
	/* codebase=0xa240 rawbase=0x1940 */
	0xff3c,0x2215,0xfe68,0xff04,0xffe5,0x3012,0xffe0,0xffe1, /* 0xA240-0xA247 */
	0xff05,0xff20,0x2103,0x2109,0xfe69,0xfe6a,0xfe6b,0x33d5, /* 0xA248-0xA24F */
	0x339c,0x339d,0x339e,0x33ce,0x33a1,0x338e,0x338f,0x33c4, /* 0xA250-0xA257 */
	0x00b0,0x5159,0x515b,0x515e,0x515d,0x5161,0x5163,0x55e7, /* 0xA258-0xA25F */
	0x74e9,0x7cce,0x2581,0x2582,0x2583,0x2584,0x2585,0x2586, /* 0xA260-0xA267 */
	0x2587,0x2588,0x258f,0x258e,0x258d,0x258c,0x258b,0x258a, /* 0xA268-0xA26F */
	0x2589,0x253c,0x2534,0x252c,0x2524,0x251c,0x2594,0x2500, /* 0xA270-0xA277 */
	0x2502,0x2595,0x250c,0x2510,0x2514,0x2518,0x256d,0x0000, /* 0xA278-0xA27F */
	/* codebase=0xa280 rawbase=0x1980 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA280-0xA287 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA288-0xA28F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA290-0xA297 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA298-0xA29F */
	0x0000,0x256e,0x2570,0x256f,0x2501,0x251d,0x253f,0x2525, /* 0xA2A0-0xA2A7 */
	0x25e2,0x25e3,0x25e5,0x25e4,0x2571,0x2572,0x2573,0xff10, /* 0xA2A8-0xA2AF */
	0xff11,0xff12,0xff13,0xff14,0xff15,0xff16,0xff17,0xff18, /* 0xA2B0-0xA2B7 */
	0xff19,0x2160,0x2161,0x2162,0x2163,0x2164,0x2165,0x2166, /* 0xA2B8-0xA2BF */
	/* codebase=0xa2c0 rawbase=0x19c0 */
	0x2167,0x2168,0x2169,0x3021,0x3022,0x3023,0x3024,0x3025, /* 0xA2C0-0xA2C7 */
	0x3026,0x3027,0x3028,0x3029,0x3038,0x3039,0x303a,0xff21, /* 0xA2C8-0xA2CF */
	0xff22,0xff23,0xff24,0xff25,0xff26,0xff27,0xff28,0xff29, /* 0xA2D0-0xA2D7 */
	0xff2a,0xff2b,0xff2c,0xff2d,0xff2e,0xff2f,0xff30,0xff31, /* 0xA2D8-0xA2DF */
	0xff32,0xff33,0xff34,0xff35,0xff36,0xff37,0xff38,0xff39, /* 0xA2E0-0xA2E7 */
	0xff3a,0xff41,0xff42,0xff43,0xff44,0xff45,0xff46,0xff47, /* 0xA2E8-0xA2EF */
	0xff48,0xff49,0xff4a,0xff4b,0xff4c,0xff4d,0xff4e,0xff4f, /* 0xA2F0-0xA2F7 */
	0xff50,0xff51,0xff52,0xff53,0xff54,0xff55,0xff56,0x0000, /* 0xA2F8-0xA2FF */
	/* codebase=0xa340 rawbase=0x1a00 */
	0xff57,0xff58,0xff59,0xff5a,0x0391,0x0392,0x0393,0x0394, /* 0xA340-0xA347 */
	0x0395,0x0396,0x0397,0x0398,0x0399,0x039a,0x039b,0x039c, /* 0xA348-0xA34F */
	0x039d,0x039e,0x039f,0x03a0,0x03a1,0x03a3,0x03a4,0x03a5, /* 0xA350-0xA357 */
	0x03a6,0x03a7,0x03a8,0x03a9,0x03b1,0x03b2,0x03b3,0x03b4, /* 0xA358-0xA35F */
	0x03b5,0x03b6,0x03b7,0x03b8,0x03b9,0x03ba,0x03bb,0x03bc, /* 0xA360-0xA367 */
	0x03bd,0x03be,0x03bf,0x03c0,0x03c1,0x03c3,0x03c4,0x03c5, /* 0xA368-0xA36F */
	0x03c6,0x03c7,0x03c8,0x03c9,0x3105,0x3106,0x3107,0x3108, /* 0xA370-0xA377 */
	0x3109,0x310a,0x310b,0x310c,0x310d,0x310e,0x310f,0x0000, /* 0xA378-0xA37F */
	/* codebase=0xa380 rawbase=0x1a40 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA380-0xA387 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA388-0xA38F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA390-0xA397 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA398-0xA39F */
	0x0000,0x3110,0x3111,0x3112,0x3113,0x3114,0x3115,0x3116, /* 0xA3A0-0xA3A7 */
	0x3117,0x3118,0x3119,0x311a,0x311b,0x311c,0x311d,0x311e, /* 0xA3A8-0xA3AF */
	0x311f,0x3120,0x3121,0x3122,0x3123,0x3124,0x3125,0x3126, /* 0xA3B0-0xA3B7 */
	0x3127,0x3128,0x3129,0x02d9,0x02c9,0x02ca,0x02c7,0x02cb, /* 0xA3B8-0xA3BF */
	/* codebase=0xa3c0 rawbase=0x1a80 */
	0x2400,0x2401,0x2402,0x2403,0x2404,0x2405,0x2406,0x2407, /* 0xA3C0-0xA3C7 */
	0x2408,0x2409,0x240a,0x240b,0x240c,0x240d,0x240e,0x240f, /* 0xA3C8-0xA3CF */
	0x2410,0x2411,0x2412,0x2413,0x2414,0x2415,0x2416,0x2417, /* 0xA3D0-0xA3D7 */
	0x2418,0x2419,0x241a,0x241b,0x241c,0x241d,0x241e,0x241f, /* 0xA3D8-0xA3DF */
	0x2421,0x20ac,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA3E0-0xA3E7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA3E8-0xA3EF */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA3F0-0xA3F7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA3F8-0xA3FF */
	/* codebase=0xa440 rawbase=0x1ac0 */
	0x4e00,0x4e59,0x4e01,0x4e03,0x4e43,0x4e5d,0x4e86,0x4e8c, /* 0xA440-0xA447 */
	0x4eba,0x513f,0x5165,0x516b,0x51e0,0x5200,0x5201,0x529b, /* 0xA448-0xA44F */
	0x5315,0x5341,0x535c,0x53c8,0x4e09,0x4e0b,0x4e08,0x4e0a, /* 0xA450-0xA457 */
	0x4e2b,0x4e38,0x51e1,0x4e45,0x4e48,0x4e5f,0x4e5e,0x4e8e, /* 0xA458-0xA45F */
	0x4ea1,0x5140,0x5203,0x52fa,0x5343,0x53c9,0x53e3,0x571f, /* 0xA460-0xA467 */
	0x58eb,0x5915,0x5927,0x5973,0x5b50,0x5b51,0x5b53,0x5bf8, /* 0xA468-0xA46F */
	0x5c0f,0x5c22,0x5c38,0x5c71,0x5ddd,0x5de5,0x5df1,0x5df2, /* 0xA470-0xA477 */
	0x5df3,0x5dfe,0x5e72,0x5efe,0x5f0b,0x5f13,0x624d,0x0000, /* 0xA478-0xA47F */
	/* codebase=0xa480 rawbase=0x1b00 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA480-0xA487 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA488-0xA48F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA490-0xA497 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA498-0xA49F */
	0x0000,0x4e11,0x4e10,0x4e0d,0x4e2d,0x4e30,0x4e39,0x4e4b, /* 0xA4A0-0xA4A7 */
	0x5c39,0x4e88,0x4e91,0x4e95,0x4e92,0x4e94,0x4ea2,0x4ec1, /* 0xA4A8-0xA4AF */
	0x4ec0,0x4ec3,0x4ec6,0x4ec7,0x4ecd,0x4eca,0x4ecb,0x4ec4, /* 0xA4B0-0xA4B7 */
	0x5143,0x5141,0x5167,0x516d,0x516e,0x516c,0x5197,0x51f6, /* 0xA4B8-0xA4BF */
	/* codebase=0xa4c0 rawbase=0x1b40 */
	0x5206,0x5207,0x5208,0x52fb,0x52fe,0x52ff,0x5316,0x5339, /* 0xA4C0-0xA4C7 */
	0x5348,0x5347,0x5345,0x535e,0x5384,0x53cb,0x53ca,0x53cd, /* 0xA4C8-0xA4CF */
	0x58ec,0x5929,0x592b,0x592a,0x592d,0x5b54,0x5c11,0x5c24, /* 0xA4D0-0xA4D7 */
	0x5c3a,0x5c6f,0x5df4,0x5e7b,0x5eff,0x5f14,0x5f15,0x5fc3, /* 0xA4D8-0xA4DF */
	0x6208,0x6236,0x624b,0x624e,0x652f,0x6587,0x6597,0x65a4, /* 0xA4E0-0xA4E7 */
	0x65b9,0x65e5,0x66f0,0x6708,0x6728,0x6b20,0x6b62,0x6b79, /* 0xA4E8-0xA4EF */
	0x6bcb,0x6bd4,0x6bdb,0x6c0f,0x6c34,0x706b,0x722a,0x7236, /* 0xA4F0-0xA4F7 */
	0x723b,0x7247,0x7259,0x725b,0x72ac,0x738b,0x4e19,0x0000, /* 0xA4F8-0xA4FF */
	/* codebase=0xa540 rawbase=0x1b80 */
	0x4e16,0x4e15,0x4e14,0x4e18,0x4e3b,0x4e4d,0x4e4f,0x4e4e, /* 0xA540-0xA547 */
	0x4ee5,0x4ed8,0x4ed4,0x4ed5,0x4ed6,0x4ed7,0x4ee3,0x4ee4, /* 0xA548-0xA54F */
	0x4ed9,0x4ede,0x5145,0x5144,0x5189,0x518a,0x51ac,0x51f9, /* 0xA550-0xA557 */
	0x51fa,0x51f8,0x520a,0x52a0,0x529f,0x5305,0x5306,0x5317, /* 0xA558-0xA55F */
	0x531d,0x4edf,0x534a,0x5349,0x5361,0x5360,0x536f,0x536e, /* 0xA560-0xA567 */
	0x53bb,0x53ef,0x53e4,0x53f3,0x53ec,0x53ee,0x53e9,0x53e8, /* 0xA568-0xA56F */
	0x53fc,0x53f8,0x53f5,0x53eb,0x53e6,0x53ea,0x53f2,0x53f1, /* 0xA570-0xA577 */
	0x53f0,0x53e5,0x53ed,0x53fb,0x56db,0x56da,0x5916,0x0000, /* 0xA578-0xA57F */
	/* codebase=0xa580 rawbase=0x1bc0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA580-0xA587 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA588-0xA58F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA590-0xA597 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA598-0xA59F */
	0x0000,0x592e,0x5931,0x5974,0x5976,0x5b55,0x5b83,0x5c3c, /* 0xA5A0-0xA5A7 */
	0x5de8,0x5de7,0x5de6,0x5e02,0x5e03,0x5e73,0x5e7c,0x5f01, /* 0xA5A8-0xA5AF */
	0x5f18,0x5f17,0x5fc5,0x620a,0x6253,0x6254,0x6252,0x6251, /* 0xA5B0-0xA5B7 */
	0x65a5,0x65e6,0x672e,0x672c,0x672a,0x672b,0x672d,0x6b63, /* 0xA5B8-0xA5BF */
	/* codebase=0xa5c0 rawbase=0x1c00 */
	0x6bcd,0x6c11,0x6c10,0x6c38,0x6c41,0x6c40,0x6c3e,0x72af, /* 0xA5C0-0xA5C7 */
	0x7384,0x7389,0x74dc,0x74e6,0x7518,0x751f,0x7528,0x7529, /* 0xA5C8-0xA5CF */
	0x7530,0x7531,0x7532,0x7533,0x758b,0x767d,0x76ae,0x76bf, /* 0xA5D0-0xA5D7 */
	0x76ee,0x77db,0x77e2,0x77f3,0x793a,0x79be,0x7a74,0x7acb, /* 0xA5D8-0xA5DF */
	0x4e1e,0x4e1f,0x4e52,0x4e53,0x4e69,0x4e99,0x4ea4,0x4ea6, /* 0xA5E0-0xA5E7 */
	0x4ea5,0x4eff,0x4f09,0x4f19,0x4f0a,0x4f15,0x4f0d,0x4f10, /* 0xA5E8-0xA5EF */
	0x4f11,0x4f0f,0x4ef2,0x4ef6,0x4efb,0x4ef0,0x4ef3,0x4efd, /* 0xA5F0-0xA5F7 */
	0x4f01,0x4f0b,0x5149,0x5147,0x5146,0x5148,0x5168,0x0000, /* 0xA5F8-0xA5FF */
	/* codebase=0xa640 rawbase=0x1c40 */
	0x5171,0x518d,0x51b0,0x5217,0x5211,0x5212,0x520e,0x5216, /* 0xA640-0xA647 */
	0x52a3,0x5308,0x5321,0x5320,0x5370,0x5371,0x5409,0x540f, /* 0xA648-0xA64F */
	0x540c,0x540a,0x5410,0x5401,0x540b,0x5404,0x5411,0x540d, /* 0xA650-0xA657 */
	0x5408,0x5403,0x540e,0x5406,0x5412,0x56e0,0x56de,0x56dd, /* 0xA658-0xA65F */
	0x5733,0x5730,0x5728,0x572d,0x572c,0x572f,0x5729,0x5919, /* 0xA660-0xA667 */
	0x591a,0x5937,0x5938,0x5984,0x5978,0x5983,0x597d,0x5979, /* 0xA668-0xA66F */
	0x5982,0x5981,0x5b57,0x5b58,0x5b87,0x5b88,0x5b85,0x5b89, /* 0xA670-0xA677 */
	0x5bfa,0x5c16,0x5c79,0x5dde,0x5e06,0x5e76,0x5e74,0x0000, /* 0xA678-0xA67F */
	/* codebase=0xa680 rawbase=0x1c80 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA680-0xA687 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA688-0xA68F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA690-0xA697 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA698-0xA69F */
	0x0000,0x5f0f,0x5f1b,0x5fd9,0x5fd6,0x620e,0x620c,0x620d, /* 0xA6A0-0xA6A7 */
	0x6210,0x6263,0x625b,0x6258,0x6536,0x65e9,0x65e8,0x65ec, /* 0xA6A8-0xA6AF */
	0x65ed,0x66f2,0x66f3,0x6709,0x673d,0x6734,0x6731,0x6735, /* 0xA6B0-0xA6B7 */
	0x6b21,0x6b64,0x6b7b,0x6c16,0x6c5d,0x6c57,0x6c59,0x6c5f, /* 0xA6B8-0xA6BF */
	/* codebase=0xa6c0 rawbase=0x1cc0 */
	0x6c60,0x6c50,0x6c55,0x6c61,0x6c5b,0x6c4d,0x6c4e,0x7070, /* 0xA6C0-0xA6C7 */
	0x725f,0x725d,0x767e,0x7af9,0x7c73,0x7cf8,0x7f36,0x7f8a, /* 0xA6C8-0xA6CF */
	0x7fbd,0x8001,0x8003,0x800c,0x8012,0x8033,0x807f,0x8089, /* 0xA6D0-0xA6D7 */
	0x808b,0x808c,0x81e3,0x81ea,0x81f3,0x81fc,0x820c,0x821b, /* 0xA6D8-0xA6DF */
	0x821f,0x826e,0x8272,0x827e,0x866b,0x8840,0x884c,0x8863, /* 0xA6E0-0xA6E7 */
	0x897f,0x9621,0x4e32,0x4ea8,0x4f4d,0x4f4f,0x4f47,0x4f57, /* 0xA6E8-0xA6EF */
	0x4f5e,0x4f34,0x4f5b,0x4f55,0x4f30,0x4f50,0x4f51,0x4f3d, /* 0xA6F0-0xA6F7 */
	0x4f3a,0x4f38,0x4f43,0x4f54,0x4f3c,0x4f46,0x4f63,0x0000, /* 0xA6F8-0xA6FF */
	/* codebase=0xa740 rawbase=0x1d00 */
	0x4f5c,0x4f60,0x4f2f,0x4f4e,0x4f36,0x4f59,0x4f5d,0x4f48, /* 0xA740-0xA747 */
	0x4f5a,0x514c,0x514b,0x514d,0x5175,0x51b6,0x51b7,0x5225, /* 0xA748-0xA74F */
	0x5224,0x5229,0x522a,0x5228,0x52ab,0x52a9,0x52aa,0x52ac, /* 0xA750-0xA757 */
	0x5323,0x5373,0x5375,0x541d,0x542d,0x541e,0x543e,0x5426, /* 0xA758-0xA75F */
	0x544e,0x5427,0x5446,0x5443,0x5433,0x5448,0x5442,0x541b, /* 0xA760-0xA767 */
	0x5429,0x544a,0x5439,0x543b,0x5438,0x542e,0x5435,0x5436, /* 0xA768-0xA76F */
	0x5420,0x543c,0x5440,0x5431,0x542b,0x541f,0x542c,0x56ea, /* 0xA770-0xA777 */
	0x56f0,0x56e4,0x56eb,0x574a,0x5751,0x5740,0x574d,0x0000, /* 0xA778-0xA77F */
	/* codebase=0xa780 rawbase=0x1d40 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA780-0xA787 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA788-0xA78F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA790-0xA797 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA798-0xA79F */
	0x0000,0x5747,0x574e,0x573e,0x5750,0x574f,0x573b,0x58ef, /* 0xA7A0-0xA7A7 */
	0x593e,0x599d,0x5992,0x59a8,0x599e,0x59a3,0x5999,0x5996, /* 0xA7A8-0xA7AF */
	0x598d,0x59a4,0x5993,0x598a,0x59a5,0x5b5d,0x5b5c,0x5b5a, /* 0xA7B0-0xA7B7 */
	0x5b5b,0x5b8c,0x5b8b,0x5b8f,0x5c2c,0x5c40,0x5c41,0x5c3f, /* 0xA7B8-0xA7BF */
	/* codebase=0xa7c0 rawbase=0x1d80 */
	0x5c3e,0x5c90,0x5c91,0x5c94,0x5c8c,0x5deb,0x5e0c,0x5e8f, /* 0xA7C0-0xA7C7 */
	0x5e87,0x5e8a,0x5ef7,0x5f04,0x5f1f,0x5f64,0x5f62,0x5f77, /* 0xA7C8-0xA7CF */
	0x5f79,0x5fd8,0x5fcc,0x5fd7,0x5fcd,0x5ff1,0x5feb,0x5ff8, /* 0xA7D0-0xA7D7 */
	0x5fea,0x6212,0x6211,0x6284,0x6297,0x6296,0x6280,0x6276, /* 0xA7D8-0xA7DF */
	0x6289,0x626d,0x628a,0x627c,0x627e,0x6279,0x6273,0x6292, /* 0xA7E0-0xA7E7 */
	0x626f,0x6298,0x626e,0x6295,0x6293,0x6291,0x6286,0x6539, /* 0xA7E8-0xA7EF */
	0x653b,0x6538,0x65f1,0x66f4,0x675f,0x674e,0x674f,0x6750, /* 0xA7F0-0xA7F7 */
	0x6751,0x675c,0x6756,0x675e,0x6749,0x6746,0x6760,0x0000, /* 0xA7F8-0xA7FF */
	/* codebase=0xa840 rawbase=0x1dc0 */
	0x6753,0x6757,0x6b65,0x6bcf,0x6c42,0x6c5e,0x6c99,0x6c81, /* 0xA840-0xA847 */
	0x6c88,0x6c89,0x6c85,0x6c9b,0x6c6a,0x6c7a,0x6c90,0x6c70, /* 0xA848-0xA84F */
	0x6c8c,0x6c68,0x6c96,0x6c92,0x6c7d,0x6c83,0x6c72,0x6c7e, /* 0xA850-0xA857 */
	0x6c74,0x6c86,0x6c76,0x6c8d,0x6c94,0x6c98,0x6c82,0x7076, /* 0xA858-0xA85F */
	0x707c,0x707d,0x7078,0x7262,0x7261,0x7260,0x72c4,0x72c2, /* 0xA860-0xA867 */
	0x7396,0x752c,0x752b,0x7537,0x7538,0x7682,0x76ef,0x77e3, /* 0xA868-0xA86F */
	0x79c1,0x79c0,0x79bf,0x7a76,0x7cfb,0x7f55,0x8096,0x8093, /* 0xA870-0xA877 */
	0x809d,0x8098,0x809b,0x809a,0x80b2,0x826f,0x8292,0x0000, /* 0xA878-0xA87F */
	/* codebase=0xa880 rawbase=0x1e00 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA880-0xA887 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA888-0xA88F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA890-0xA897 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA898-0xA89F */
	0x0000,0x828b,0x828d,0x898b,0x89d2,0x8a00,0x8c37,0x8c46, /* 0xA8A0-0xA8A7 */
	0x8c55,0x8c9d,0x8d64,0x8d70,0x8db3,0x8eab,0x8eca,0x8f9b, /* 0xA8A8-0xA8AF */
	0x8fb0,0x8fc2,0x8fc6,0x8fc5,0x8fc4,0x5de1,0x9091,0x90a2, /* 0xA8B0-0xA8B7 */
	0x90aa,0x90a6,0x90a3,0x9149,0x91c6,0x91cc,0x9632,0x962e, /* 0xA8B8-0xA8BF */
	/* codebase=0xa8c0 rawbase=0x1e40 */
	0x9631,0x962a,0x962c,0x4e26,0x4e56,0x4e73,0x4e8b,0x4e9b, /* 0xA8C0-0xA8C7 */
	0x4e9e,0x4eab,0x4eac,0x4f6f,0x4f9d,0x4f8d,0x4f73,0x4f7f, /* 0xA8C8-0xA8CF */
	0x4f6c,0x4f9b,0x4f8b,0x4f86,0x4f83,0x4f70,0x4f75,0x4f88, /* 0xA8D0-0xA8D7 */
	0x4f69,0x4f7b,0x4f96,0x4f7e,0x4f8f,0x4f91,0x4f7a,0x5154, /* 0xA8D8-0xA8DF */
	0x5152,0x5155,0x5169,0x5177,0x5176,0x5178,0x51bd,0x51fd, /* 0xA8E0-0xA8E7 */
	0x523b,0x5238,0x5237,0x523a,0x5230,0x522e,0x5236,0x5241, /* 0xA8E8-0xA8EF */
	0x52be,0x52bb,0x5352,0x5354,0x5353,0x5351,0x5366,0x5377, /* 0xA8F0-0xA8F7 */
	0x5378,0x5379,0x53d6,0x53d4,0x53d7,0x5473,0x5475,0x0000, /* 0xA8F8-0xA8FF */
	/* codebase=0xa940 rawbase=0x1e80 */
	0x5496,0x5478,0x5495,0x5480,0x547b,0x5477,0x5484,0x5492, /* 0xA940-0xA947 */
	0x5486,0x547c,0x5490,0x5471,0x5476,0x548c,0x549a,0x5462, /* 0xA948-0xA94F */
	0x5468,0x548b,0x547d,0x548e,0x56fa,0x5783,0x5777,0x576a, /* 0xA950-0xA957 */
	0x5769,0x5761,0x5766,0x5764,0x577c,0x591c,0x5949,0x5947, /* 0xA958-0xA95F */
	0x5948,0x5944,0x5954,0x59be,0x59bb,0x59d4,0x59b9,0x59ae, /* 0xA960-0xA967 */
	0x59d1,0x59c6,0x59d0,0x59cd,0x59cb,0x59d3,0x59ca,0x59af, /* 0xA968-0xA96F */
	0x59b3,0x59d2,0x59c5,0x5b5f,0x5b64,0x5b63,0x5b97,0x5b9a, /* 0xA970-0xA977 */
	0x5b98,0x5b9c,0x5b99,0x5b9b,0x5c1a,0x5c48,0x5c45,0x0000, /* 0xA978-0xA97F */
	/* codebase=0xa980 rawbase=0x1ec0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA980-0xA987 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA988-0xA98F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA990-0xA997 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA998-0xA99F */
	0x0000,0x5c46,0x5cb7,0x5ca1,0x5cb8,0x5ca9,0x5cab,0x5cb1, /* 0xA9A0-0xA9A7 */
	0x5cb3,0x5e18,0x5e1a,0x5e16,0x5e15,0x5e1b,0x5e11,0x5e78, /* 0xA9A8-0xA9AF */
	0x5e9a,0x5e97,0x5e9c,0x5e95,0x5e96,0x5ef6,0x5f26,0x5f27, /* 0xA9B0-0xA9B7 */
	0x5f29,0x5f80,0x5f81,0x5f7f,0x5f7c,0x5fdd,0x5fe0,0x5ffd, /* 0xA9B8-0xA9BF */
	/* codebase=0xa9c0 rawbase=0x1f00 */
	0x5ff5,0x5fff,0x600f,0x6014,0x602f,0x6035,0x6016,0x602a, /* 0xA9C0-0xA9C7 */
	0x6015,0x6021,0x6027,0x6029,0x602b,0x601b,0x6216,0x6215, /* 0xA9C8-0xA9CF */
	0x623f,0x623e,0x6240,0x627f,0x62c9,0x62cc,0x62c4,0x62bf, /* 0xA9D0-0xA9D7 */
	0x62c2,0x62b9,0x62d2,0x62db,0x62ab,0x62d3,0x62d4,0x62cb, /* 0xA9D8-0xA9DF */
	0x62c8,0x62a8,0x62bd,0x62bc,0x62d0,0x62d9,0x62c7,0x62cd, /* 0xA9E0-0xA9E7 */
	0x62b5,0x62da,0x62b1,0x62d8,0x62d6,0x62d7,0x62c6,0x62ac, /* 0xA9E8-0xA9EF */
	0x62ce,0x653e,0x65a7,0x65bc,0x65fa,0x6614,0x6613,0x660c, /* 0xA9F0-0xA9F7 */
	0x6606,0x6602,0x660e,0x6600,0x660f,0x6615,0x660a,0x0000, /* 0xA9F8-0xA9FF */
	/* codebase=0xaa40 rawbase=0x1f40 */
	0x6607,0x670d,0x670b,0x676d,0x678b,0x6795,0x6771,0x679c, /* 0xAA40-0xAA47 */
	0x6773,0x6777,0x6787,0x679d,0x6797,0x676f,0x6770,0x677f, /* 0xAA48-0xAA4F */
	0x6789,0x677e,0x6790,0x6775,0x679a,0x6793,0x677c,0x676a, /* 0xAA50-0xAA57 */
	0x6772,0x6b23,0x6b66,0x6b67,0x6b7f,0x6c13,0x6c1b,0x6ce3, /* 0xAA58-0xAA5F */
	0x6ce8,0x6cf3,0x6cb1,0x6ccc,0x6ce5,0x6cb3,0x6cbd,0x6cbe, /* 0xAA60-0xAA67 */
	0x6cbc,0x6ce2,0x6cab,0x6cd5,0x6cd3,0x6cb8,0x6cc4,0x6cb9, /* 0xAA68-0xAA6F */
	0x6cc1,0x6cae,0x6cd7,0x6cc5,0x6cf1,0x6cbf,0x6cbb,0x6ce1, /* 0xAA70-0xAA77 */
	0x6cdb,0x6cca,0x6cac,0x6cef,0x6cdc,0x6cd6,0x6ce0,0x0000, /* 0xAA78-0xAA7F */
	/* codebase=0xaa80 rawbase=0x1f80 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xAA80-0xAA87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xAA88-0xAA8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xAA90-0xAA97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xAA98-0xAA9F */
	0x0000,0x7095,0x708e,0x7092,0x708a,0x7099,0x722c,0x722d, /* 0xAAA0-0xAAA7 */
	0x7238,0x7248,0x7267,0x7269,0x72c0,0x72ce,0x72d9,0x72d7, /* 0xAAA8-0xAAAF */
	0x72d0,0x73a9,0x73a8,0x739f,0x73ab,0x73a5,0x753d,0x759d, /* 0xAAB0-0xAAB7 */
	0x7599,0x759a,0x7684,0x76c2,0x76f2,0x76f4,0x77e5,0x77fd, /* 0xAAB8-0xAABF */
	/* codebase=0xaac0 rawbase=0x1fc0 */
	0x793e,0x7940,0x7941,0x79c9,0x79c8,0x7a7a,0x7a79,0x7afa, /* 0xAAC0-0xAAC7 */
	0x7cfe,0x7f54,0x7f8c,0x7f8b,0x8005,0x80ba,0x80a5,0x80a2, /* 0xAAC8-0xAACF */
	0x80b1,0x80a1,0x80ab,0x80a9,0x80b4,0x80aa,0x80af,0x81e5, /* 0xAAD0-0xAAD7 */
	0x81fe,0x820d,0x82b3,0x829d,0x8299,0x82ad,0x82bd,0x829f, /* 0xAAD8-0xAADF */
	0x82b9,0x82b1,0x82ac,0x82a5,0x82af,0x82b8,0x82a3,0x82b0, /* 0xAAE0-0xAAE7 */
	0x82be,0x82b7,0x864e,0x8671,0x521d,0x8868,0x8ecb,0x8fce, /* 0xAAE8-0xAAEF */
	0x8fd4,0x8fd1,0x90b5,0x90b8,0x90b1,0x90b6,0x91c7,0x91d1, /* 0xAAF0-0xAAF7 */
	0x9577,0x9580,0x961c,0x9640,0x963f,0x963b,0x9644,0x0000, /* 0xAAF8-0xAAFF */
	/* codebase=0xab40 rawbase=0x2000 */
	0x9642,0x96b9,0x96e8,0x9752,0x975e,0x4e9f,0x4ead,0x4eae, /* 0xAB40-0xAB47 */
	0x4fe1,0x4fb5,0x4faf,0x4fbf,0x4fe0,0x4fd1,0x4fcf,0x4fdd, /* 0xAB48-0xAB4F */
	0x4fc3,0x4fb6,0x4fd8,0x4fdf,0x4fca,0x4fd7,0x4fae,0x4fd0, /* 0xAB50-0xAB57 */
	0x4fc4,0x4fc2,0x4fda,0x4fce,0x4fde,0x4fb7,0x5157,0x5192, /* 0xAB58-0xAB5F */
	0x5191,0x51a0,0x524e,0x5243,0x524a,0x524d,0x524c,0x524b, /* 0xAB60-0xAB67 */
	0x5247,0x52c7,0x52c9,0x52c3,0x52c1,0x530d,0x5357,0x537b, /* 0xAB68-0xAB6F */
	0x539a,0x53db,0x54ac,0x54c0,0x54a8,0x54ce,0x54c9,0x54b8, /* 0xAB70-0xAB77 */
	0x54a6,0x54b3,0x54c7,0x54c2,0x54bd,0x54aa,0x54c1,0x0000, /* 0xAB78-0xAB7F */
	/* codebase=0xab80 rawbase=0x2040 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xAB80-0xAB87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xAB88-0xAB8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xAB90-0xAB97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xAB98-0xAB9F */
	0x0000,0x54c4,0x54c8,0x54af,0x54ab,0x54b1,0x54bb,0x54a9, /* 0xABA0-0xABA7 */
	0x54a7,0x54bf,0x56ff,0x5782,0x578b,0x57a0,0x57a3,0x57a2, /* 0xABA8-0xABAF */
	0x57ce,0x57ae,0x5793,0x5955,0x5951,0x594f,0x594e,0x5950, /* 0xABB0-0xABB7 */
	0x59dc,0x59d8,0x59ff,0x59e3,0x59e8,0x5a03,0x59e5,0x59ea, /* 0xABB8-0xABBF */
	/* codebase=0xabc0 rawbase=0x2080 */
	0x59da,0x59e6,0x5a01,0x59fb,0x5b69,0x5ba3,0x5ba6,0x5ba4, /* 0xABC0-0xABC7 */
	0x5ba2,0x5ba5,0x5c01,0x5c4e,0x5c4f,0x5c4d,0x5c4b,0x5cd9, /* 0xABC8-0xABCF */
	0x5cd2,0x5df7,0x5e1d,0x5e25,0x5e1f,0x5e7d,0x5ea0,0x5ea6, /* 0xABD0-0xABD7 */
	0x5efa,0x5f08,0x5f2d,0x5f65,0x5f88,0x5f85,0x5f8a,0x5f8b, /* 0xABD8-0xABDF */
	0x5f87,0x5f8c,0x5f89,0x6012,0x601d,0x6020,0x6025,0x600e, /* 0xABE0-0xABE7 */
	0x6028,0x604d,0x6070,0x6068,0x6062,0x6046,0x6043,0x606c, /* 0xABE8-0xABEF */
	0x606b,0x606a,0x6064,0x6241,0x62dc,0x6316,0x6309,0x62fc, /* 0xABF0-0xABF7 */
	0x62ed,0x6301,0x62ee,0x62fd,0x6307,0x62f1,0x62f7,0x0000, /* 0xABF8-0xABFF */
	/* codebase=0xac40 rawbase=0x20c0 */
	0x62ef,0x62ec,0x62fe,0x62f4,0x6311,0x6302,0x653f,0x6545, /* 0xAC40-0xAC47 */
	0x65ab,0x65bd,0x65e2,0x6625,0x662d,0x6620,0x6627,0x662f, /* 0xAC48-0xAC4F */
	0x661f,0x6628,0x6631,0x6624,0x66f7,0x67ff,0x67d3,0x67f1, /* 0xAC50-0xAC57 */
	0x67d4,0x67d0,0x67ec,0x67b6,0x67af,0x67f5,0x67e9,0x67ef, /* 0xAC58-0xAC5F */
	0x67c4,0x67d1,0x67b4,0x67da,0x67e5,0x67b8,0x67cf,0x67de, /* 0xAC60-0xAC67 */
	0x67f3,0x67b0,0x67d9,0x67e2,0x67dd,0x67d2,0x6b6a,0x6b83, /* 0xAC68-0xAC6F */
	0x6b86,0x6bb5,0x6bd2,0x6bd7,0x6c1f,0x6cc9,0x6d0b,0x6d32, /* 0xAC70-0xAC77 */
	0x6d2a,0x6d41,0x6d25,0x6d0c,0x6d31,0x6d1e,0x6d17,0x0000, /* 0xAC78-0xAC7F */
	/* codebase=0xac80 rawbase=0x2100 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xAC80-0xAC87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xAC88-0xAC8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xAC90-0xAC97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xAC98-0xAC9F */
	0x0000,0x6d3b,0x6d3d,0x6d3e,0x6d36,0x6d1b,0x6cf5,0x6d39, /* 0xACA0-0xACA7 */
	0x6d27,0x6d38,0x6d29,0x6d2e,0x6d35,0x6d0e,0x6d2b,0x70ab, /* 0xACA8-0xACAF */
	0x70ba,0x70b3,0x70ac,0x70af,0x70ad,0x70b8,0x70ae,0x70a4, /* 0xACB0-0xACB7 */
	0x7230,0x7272,0x726f,0x7274,0x72e9,0x72e0,0x72e1,0x73b7, /* 0xACB8-0xACBF */
	/* codebase=0xacc0 rawbase=0x2140 */
	0x73ca,0x73bb,0x73b2,0x73cd,0x73c0,0x73b3,0x751a,0x752d, /* 0xACC0-0xACC7 */
	0x754f,0x754c,0x754e,0x754b,0x75ab,0x75a4,0x75a5,0x75a2, /* 0xACC8-0xACCF */
	0x75a3,0x7678,0x7686,0x7687,0x7688,0x76c8,0x76c6,0x76c3, /* 0xACD0-0xACD7 */
	0x76c5,0x7701,0x76f9,0x76f8,0x7709,0x770b,0x76fe,0x76fc, /* 0xACD8-0xACDF */
	0x7707,0x77dc,0x7802,0x7814,0x780c,0x780d,0x7946,0x7949, /* 0xACE0-0xACE7 */
	0x7948,0x7947,0x79b9,0x79ba,0x79d1,0x79d2,0x79cb,0x7a7f, /* 0xACE8-0xACEF */
	0x7a81,0x7aff,0x7afd,0x7c7d,0x7d02,0x7d05,0x7d00,0x7d09, /* 0xACF0-0xACF7 */
	0x7d07,0x7d04,0x7d06,0x7f38,0x7f8e,0x7fbf,0x8004,0x0000, /* 0xACF8-0xACFF */
	/* codebase=0xad40 rawbase=0x2180 */
	0x8010,0x800d,0x8011,0x8036,0x80d6,0x80e5,0x80da,0x80c3, /* 0xAD40-0xAD47 */
	0x80c4,0x80cc,0x80e1,0x80db,0x80ce,0x80de,0x80e4,0x80dd, /* 0xAD48-0xAD4F */
	0x81f4,0x8222,0x82e7,0x8303,0x8305,0x82e3,0x82db,0x82e6, /* 0xAD50-0xAD57 */
	0x8304,0x82e5,0x8302,0x8309,0x82d2,0x82d7,0x82f1,0x8301, /* 0xAD58-0xAD5F */
	0x82dc,0x82d4,0x82d1,0x82de,0x82d3,0x82df,0x82ef,0x8306, /* 0xAD60-0xAD67 */
	0x8650,0x8679,0x867b,0x867a,0x884d,0x886b,0x8981,0x89d4, /* 0xAD68-0xAD6F */
	0x8a08,0x8a02,0x8a03,0x8c9e,0x8ca0,0x8d74,0x8d73,0x8db4, /* 0xAD70-0xAD77 */
	0x8ecd,0x8ecc,0x8ff0,0x8fe6,0x8fe2,0x8fea,0x8fe5,0x0000, /* 0xAD78-0xAD7F */
	/* codebase=0xad80 rawbase=0x21c0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xAD80-0xAD87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xAD88-0xAD8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xAD90-0xAD97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xAD98-0xAD9F */
	0x0000,0x8fed,0x8feb,0x8fe4,0x8fe8,0x90ca,0x90ce,0x90c1, /* 0xADA0-0xADA7 */
	0x90c3,0x914b,0x914a,0x91cd,0x9582,0x9650,0x964b,0x964c, /* 0xADA8-0xADAF */
	0x964d,0x9762,0x9769,0x97cb,0x97ed,0x97f3,0x9801,0x98a8, /* 0xADB0-0xADB7 */
	0x98db,0x98df,0x9996,0x9999,0x4e58,0x4eb3,0x500c,0x500d, /* 0xADB8-0xADBF */
	/* codebase=0xadc0 rawbase=0x2200 */
	0x5023,0x4fef,0x5026,0x5025,0x4ff8,0x5029,0x5016,0x5006, /* 0xADC0-0xADC7 */
	0x503c,0x501f,0x501a,0x5012,0x5011,0x4ffa,0x5000,0x5014, /* 0xADC8-0xADCF */
	0x5028,0x4ff1,0x5021,0x500b,0x5019,0x5018,0x4ff3,0x4fee, /* 0xADD0-0xADD7 */
	0x502d,0x502a,0x4ffe,0x502b,0x5009,0x517c,0x51a4,0x51a5, /* 0xADD8-0xADDF */
	0x51a2,0x51cd,0x51cc,0x51c6,0x51cb,0x5256,0x525c,0x5254, /* 0xADE0-0xADE7 */
	0x525b,0x525d,0x532a,0x537f,0x539f,0x539d,0x53df,0x54e8, /* 0xADE8-0xADEF */
	0x5510,0x5501,0x5537,0x54fc,0x54e5,0x54f2,0x5506,0x54fa, /* 0xADF0-0xADF7 */
	0x5514,0x54e9,0x54ed,0x54e1,0x5509,0x54ee,0x54ea,0x0000, /* 0xADF8-0xADFF */
	/* codebase=0xae40 rawbase=0x2240 */
	0x54e6,0x5527,0x5507,0x54fd,0x550f,0x5703,0x5704,0x57c2, /* 0xAE40-0xAE47 */
	0x57d4,0x57cb,0x57c3,0x5809,0x590f,0x5957,0x5958,0x595a, /* 0xAE48-0xAE4F */
	0x5a11,0x5a18,0x5a1c,0x5a1f,0x5a1b,0x5a13,0x59ec,0x5a20, /* 0xAE50-0xAE57 */
	0x5a23,0x5a29,0x5a25,0x5a0c,0x5a09,0x5b6b,0x5c58,0x5bb0, /* 0xAE58-0xAE5F */
	0x5bb3,0x5bb6,0x5bb4,0x5bae,0x5bb5,0x5bb9,0x5bb8,0x5c04, /* 0xAE60-0xAE67 */
	0x5c51,0x5c55,0x5c50,0x5ced,0x5cfd,0x5cfb,0x5cea,0x5ce8, /* 0xAE68-0xAE6F */
	0x5cf0,0x5cf6,0x5d01,0x5cf4,0x5dee,0x5e2d,0x5e2b,0x5eab, /* 0xAE70-0xAE77 */
	0x5ead,0x5ea7,0x5f31,0x5f92,0x5f91,0x5f90,0x6059,0x0000, /* 0xAE78-0xAE7F */
	/* codebase=0xae80 rawbase=0x2280 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xAE80-0xAE87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xAE88-0xAE8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xAE90-0xAE97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xAE98-0xAE9F */
	0x0000,0x6063,0x6065,0x6050,0x6055,0x606d,0x6069,0x606f, /* 0xAEA0-0xAEA7 */
	0x6084,0x609f,0x609a,0x608d,0x6094,0x608c,0x6085,0x6096, /* 0xAEA8-0xAEAF */
	0x6247,0x62f3,0x6308,0x62ff,0x634e,0x633e,0x632f,0x6355, /* 0xAEB0-0xAEB7 */
	0x6342,0x6346,0x634f,0x6349,0x633a,0x6350,0x633d,0x632a, /* 0xAEB8-0xAEBF */
	/* codebase=0xaec0 rawbase=0x22c0 */
	0x632b,0x6328,0x634d,0x634c,0x6548,0x6549,0x6599,0x65c1, /* 0xAEC0-0xAEC7 */
	0x65c5,0x6642,0x6649,0x664f,0x6643,0x6652,0x664c,0x6645, /* 0xAEC8-0xAECF */
	0x6641,0x66f8,0x6714,0x6715,0x6717,0x6821,0x6838,0x6848, /* 0xAED0-0xAED7 */
	0x6846,0x6853,0x6839,0x6842,0x6854,0x6829,0x68b3,0x6817, /* 0xAED8-0xAEDF */
	0x684c,0x6851,0x683d,0x67f4,0x6850,0x6840,0x683c,0x6843, /* 0xAEE0-0xAEE7 */
	0x682a,0x6845,0x6813,0x6818,0x6841,0x6b8a,0x6b89,0x6bb7, /* 0xAEE8-0xAEEF */
	0x6c23,0x6c27,0x6c28,0x6c26,0x6c24,0x6cf0,0x6d6a,0x6d95, /* 0xAEF0-0xAEF7 */
	0x6d88,0x6d87,0x6d66,0x6d78,0x6d77,0x6d59,0x6d93,0x0000, /* 0xAEF8-0xAEFF */
	/* codebase=0xaf40 rawbase=0x2300 */
	0x6d6c,0x6d89,0x6d6e,0x6d5a,0x6d74,0x6d69,0x6d8c,0x6d8a, /* 0xAF40-0xAF47 */
	0x6d79,0x6d85,0x6d65,0x6d94,0x70ca,0x70d8,0x70e4,0x70d9, /* 0xAF48-0xAF4F */
	0x70c8,0x70cf,0x7239,0x7279,0x72fc,0x72f9,0x72fd,0x72f8, /* 0xAF50-0xAF57 */
	0x72f7,0x7386,0x73ed,0x7409,0x73ee,0x73e0,0x73ea,0x73de, /* 0xAF58-0xAF5F */
	0x7554,0x755d,0x755c,0x755a,0x7559,0x75be,0x75c5,0x75c7, /* 0xAF60-0xAF67 */
	0x75b2,0x75b3,0x75bd,0x75bc,0x75b9,0x75c2,0x75b8,0x768b, /* 0xAF68-0xAF6F */
	0x76b0,0x76ca,0x76cd,0x76ce,0x7729,0x771f,0x7720,0x7728, /* 0xAF70-0xAF77 */
	0x77e9,0x7830,0x7827,0x7838,0x781d,0x7834,0x7837,0x0000, /* 0xAF78-0xAF7F */
	/* codebase=0xaf80 rawbase=0x2340 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xAF80-0xAF87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xAF88-0xAF8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xAF90-0xAF97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xAF98-0xAF9F */
	0x0000,0x7825,0x782d,0x7820,0x781f,0x7832,0x7955,0x7950, /* 0xAFA0-0xAFA7 */
	0x7960,0x795f,0x7956,0x795e,0x795d,0x7957,0x795a,0x79e4, /* 0xAFA8-0xAFAF */
	0x79e3,0x79e7,0x79df,0x79e6,0x79e9,0x79d8,0x7a84,0x7a88, /* 0xAFB0-0xAFB7 */
	0x7ad9,0x7b06,0x7b11,0x7c89,0x7d21,0x7d17,0x7d0b,0x7d0a, /* 0xAFB8-0xAFBF */
	/* codebase=0xafc0 rawbase=0x2380 */
	0x7d20,0x7d22,0x7d14,0x7d10,0x7d15,0x7d1a,0x7d1c,0x7d0d, /* 0xAFC0-0xAFC7 */
	0x7d19,0x7d1b,0x7f3a,0x7f5f,0x7f94,0x7fc5,0x7fc1,0x8006, /* 0xAFC8-0xAFCF */
	0x8018,0x8015,0x8019,0x8017,0x803d,0x803f,0x80f1,0x8102, /* 0xAFD0-0xAFD7 */
	0x80f0,0x8105,0x80ed,0x80f4,0x8106,0x80f8,0x80f3,0x8108, /* 0xAFD8-0xAFDF */
	0x80fd,0x810a,0x80fc,0x80ef,0x81ed,0x81ec,0x8200,0x8210, /* 0xAFE0-0xAFE7 */
	0x822a,0x822b,0x8228,0x822c,0x82bb,0x832b,0x8352,0x8354, /* 0xAFE8-0xAFEF */
	0x834a,0x8338,0x8350,0x8349,0x8335,0x8334,0x834f,0x8332, /* 0xAFF0-0xAFF7 */
	0x8339,0x8336,0x8317,0x8340,0x8331,0x8328,0x8343,0x0000, /* 0xAFF8-0xAFFF */
	/* codebase=0xb040 rawbase=0x23c0 */
	0x8654,0x868a,0x86aa,0x8693,0x86a4,0x86a9,0x868c,0x86a3, /* 0xB040-0xB047 */
	0x869c,0x8870,0x8877,0x8881,0x8882,0x887d,0x8879,0x8a18, /* 0xB048-0xB04F */
	0x8a10,0x8a0e,0x8a0c,0x8a15,0x8a0a,0x8a17,0x8a13,0x8a16, /* 0xB050-0xB057 */
	0x8a0f,0x8a11,0x8c48,0x8c7a,0x8c79,0x8ca1,0x8ca2,0x8d77, /* 0xB058-0xB05F */
	0x8eac,0x8ed2,0x8ed4,0x8ecf,0x8fb1,0x9001,0x9006,0x8ff7, /* 0xB060-0xB067 */
	0x9000,0x8ffa,0x8ff4,0x9003,0x8ffd,0x9005,0x8ff8,0x9095, /* 0xB068-0xB06F */
	0x90e1,0x90dd,0x90e2,0x9152,0x914d,0x914c,0x91d8,0x91dd, /* 0xB070-0xB077 */
	0x91d7,0x91dc,0x91d9,0x9583,0x9662,0x9663,0x9661,0x0000, /* 0xB078-0xB07F */
	/* codebase=0xb080 rawbase=0x2400 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB080-0xB087 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB088-0xB08F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB090-0xB097 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB098-0xB09F */
	0x0000,0x965b,0x965d,0x9664,0x9658,0x965e,0x96bb,0x98e2, /* 0xB0A0-0xB0A7 */
	0x99ac,0x9aa8,0x9ad8,0x9b25,0x9b32,0x9b3c,0x4e7e,0x507a, /* 0xB0A8-0xB0AF */
	0x507d,0x505c,0x5047,0x5043,0x504c,0x505a,0x5049,0x5065, /* 0xB0B0-0xB0B7 */
	0x5076,0x504e,0x5055,0x5075,0x5074,0x5077,0x504f,0x500f, /* 0xB0B8-0xB0BF */
	/* codebase=0xb0c0 rawbase=0x2440 */
	0x506f,0x506d,0x515c,0x5195,0x51f0,0x526a,0x526f,0x52d2, /* 0xB0C0-0xB0C7 */
	0x52d9,0x52d8,0x52d5,0x5310,0x530f,0x5319,0x533f,0x5340, /* 0xB0C8-0xB0CF */
	0x533e,0x53c3,0x66fc,0x5546,0x556a,0x5566,0x5544,0x555e, /* 0xB0D0-0xB0D7 */
	0x5561,0x5543,0x554a,0x5531,0x5556,0x554f,0x5555,0x552f, /* 0xB0D8-0xB0DF */
	0x5564,0x5538,0x552e,0x555c,0x552c,0x5563,0x5533,0x5541, /* 0xB0E0-0xB0E7 */
	0x5557,0x5708,0x570b,0x5709,0x57df,0x5805,0x580a,0x5806, /* 0xB0E8-0xB0EF */
	0x57e0,0x57e4,0x57fa,0x5802,0x5835,0x57f7,0x57f9,0x5920, /* 0xB0F0-0xB0F7 */
	0x5962,0x5a36,0x5a41,0x5a49,0x5a66,0x5a6a,0x5a40,0x0000, /* 0xB0F8-0xB0FF */
	/* codebase=0xb140 rawbase=0x2480 */
	0x5a3c,0x5a62,0x5a5a,0x5a46,0x5a4a,0x5b70,0x5bc7,0x5bc5, /* 0xB140-0xB147 */
	0x5bc4,0x5bc2,0x5bbf,0x5bc6,0x5c09,0x5c08,0x5c07,0x5c60, /* 0xB148-0xB14F */
	0x5c5c,0x5c5d,0x5d07,0x5d06,0x5d0e,0x5d1b,0x5d16,0x5d22, /* 0xB150-0xB157 */
	0x5d11,0x5d29,0x5d14,0x5d19,0x5d24,0x5d27,0x5d17,0x5de2, /* 0xB158-0xB15F */
	0x5e38,0x5e36,0x5e33,0x5e37,0x5eb7,0x5eb8,0x5eb6,0x5eb5, /* 0xB160-0xB167 */
	0x5ebe,0x5f35,0x5f37,0x5f57,0x5f6c,0x5f69,0x5f6b,0x5f97, /* 0xB168-0xB16F */
	0x5f99,0x5f9e,0x5f98,0x5fa1,0x5fa0,0x5f9c,0x607f,0x60a3, /* 0xB170-0xB177 */
	0x6089,0x60a0,0x60a8,0x60cb,0x60b4,0x60e6,0x60bd,0x0000, /* 0xB178-0xB17F */
	/* codebase=0xb180 rawbase=0x24c0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB180-0xB187 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB188-0xB18F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB190-0xB197 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB198-0xB19F */
	0x0000,0x60c5,0x60bb,0x60b5,0x60dc,0x60bc,0x60d8,0x60d5, /* 0xB1A0-0xB1A7 */
	0x60c6,0x60df,0x60b8,0x60da,0x60c7,0x621a,0x621b,0x6248, /* 0xB1A8-0xB1AF */
	0x63a0,0x63a7,0x6372,0x6396,0x63a2,0x63a5,0x6377,0x6367, /* 0xB1B0-0xB1B7 */
	0x6398,0x63aa,0x6371,0x63a9,0x6389,0x6383,0x639b,0x636b, /* 0xB1B8-0xB1BF */
	/* codebase=0xb1c0 rawbase=0x2500 */
	0x63a8,0x6384,0x6388,0x6399,0x63a1,0x63ac,0x6392,0x638f, /* 0xB1C0-0xB1C7 */
	0x6380,0x637b,0x6369,0x6368,0x637a,0x655d,0x6556,0x6551, /* 0xB1C8-0xB1CF */
	0x6559,0x6557,0x555f,0x654f,0x6558,0x6555,0x6554,0x659c, /* 0xB1D0-0xB1D7 */
	0x659b,0x65ac,0x65cf,0x65cb,0x65cc,0x65ce,0x665d,0x665a, /* 0xB1D8-0xB1DF */
	0x6664,0x6668,0x6666,0x665e,0x66f9,0x52d7,0x671b,0x6881, /* 0xB1E0-0xB1E7 */
	0x68af,0x68a2,0x6893,0x68b5,0x687f,0x6876,0x68b1,0x68a7, /* 0xB1E8-0xB1EF */
	0x6897,0x68b0,0x6883,0x68c4,0x68ad,0x6886,0x6885,0x6894, /* 0xB1F0-0xB1F7 */
	0x689d,0x68a8,0x689f,0x68a1,0x6882,0x6b32,0x6bba,0x0000, /* 0xB1F8-0xB1FF */
	/* codebase=0xb240 rawbase=0x2540 */
	0x6beb,0x6bec,0x6c2b,0x6d8e,0x6dbc,0x6df3,0x6dd9,0x6db2, /* 0xB240-0xB247 */
	0x6de1,0x6dcc,0x6de4,0x6dfb,0x6dfa,0x6e05,0x6dc7,0x6dcb, /* 0xB248-0xB24F */
	0x6daf,0x6dd1,0x6dae,0x6dde,0x6df9,0x6db8,0x6df7,0x6df5, /* 0xB250-0xB257 */
	0x6dc5,0x6dd2,0x6e1a,0x6db5,0x6dda,0x6deb,0x6dd8,0x6dea, /* 0xB258-0xB25F */
	0x6df1,0x6dee,0x6de8,0x6dc6,0x6dc4,0x6daa,0x6dec,0x6dbf, /* 0xB260-0xB267 */
	0x6de6,0x70f9,0x7109,0x710a,0x70fd,0x70ef,0x723d,0x727d, /* 0xB268-0xB26F */
	0x7281,0x731c,0x731b,0x7316,0x7313,0x7319,0x7387,0x7405, /* 0xB270-0xB277 */
	0x740a,0x7403,0x7406,0x73fe,0x740d,0x74e0,0x74f6,0x0000, /* 0xB278-0xB27F */
	/* codebase=0xb280 rawbase=0x2580 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB280-0xB287 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB288-0xB28F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB290-0xB297 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB298-0xB29F */
	0x0000,0x74f7,0x751c,0x7522,0x7565,0x7566,0x7562,0x7570, /* 0xB2A0-0xB2A7 */
	0x758f,0x75d4,0x75d5,0x75b5,0x75ca,0x75cd,0x768e,0x76d4, /* 0xB2A8-0xB2AF */
	0x76d2,0x76db,0x7737,0x773e,0x773c,0x7736,0x7738,0x773a, /* 0xB2B0-0xB2B7 */
	0x786b,0x7843,0x784e,0x7965,0x7968,0x796d,0x79fb,0x7a92, /* 0xB2B8-0xB2BF */
	/* codebase=0xb2c0 rawbase=0x25c0 */
	0x7a95,0x7b20,0x7b28,0x7b1b,0x7b2c,0x7b26,0x7b19,0x7b1e, /* 0xB2C0-0xB2C7 */
	0x7b2e,0x7c92,0x7c97,0x7c95,0x7d46,0x7d43,0x7d71,0x7d2e, /* 0xB2C8-0xB2CF */
	0x7d39,0x7d3c,0x7d40,0x7d30,0x7d33,0x7d44,0x7d2f,0x7d42, /* 0xB2D0-0xB2D7 */
	0x7d32,0x7d31,0x7f3d,0x7f9e,0x7f9a,0x7fcc,0x7fce,0x7fd2, /* 0xB2D8-0xB2DF */
	0x801c,0x804a,0x8046,0x812f,0x8116,0x8123,0x812b,0x8129, /* 0xB2E0-0xB2E7 */
	0x8130,0x8124,0x8202,0x8235,0x8237,0x8236,0x8239,0x838e, /* 0xB2E8-0xB2EF */
	0x839e,0x8398,0x8378,0x83a2,0x8396,0x83bd,0x83ab,0x8392, /* 0xB2F0-0xB2F7 */
	0x838a,0x8393,0x8389,0x83a0,0x8377,0x837b,0x837c,0x0000, /* 0xB2F8-0xB2FF */
	/* codebase=0xb340 rawbase=0x2600 */
	0x8386,0x83a7,0x8655,0x5f6a,0x86c7,0x86c0,0x86b6,0x86c4, /* 0xB340-0xB347 */
	0x86b5,0x86c6,0x86cb,0x86b1,0x86af,0x86c9,0x8853,0x889e, /* 0xB348-0xB34F */
	0x8888,0x88ab,0x8892,0x8896,0x888d,0x888b,0x8993,0x898f, /* 0xB350-0xB357 */
	0x8a2a,0x8a1d,0x8a23,0x8a25,0x8a31,0x8a2d,0x8a1f,0x8a1b, /* 0xB358-0xB35F */
	0x8a22,0x8c49,0x8c5a,0x8ca9,0x8cac,0x8cab,0x8ca8,0x8caa, /* 0xB360-0xB367 */
	0x8ca7,0x8d67,0x8d66,0x8dbe,0x8dba,0x8edb,0x8edf,0x9019, /* 0xB368-0xB36F */
	0x900d,0x901a,0x9017,0x9023,0x901f,0x901d,0x9010,0x9015, /* 0xB370-0xB377 */
	0x901e,0x9020,0x900f,0x9022,0x9016,0x901b,0x9014,0x0000, /* 0xB378-0xB37F */
	/* codebase=0xb380 rawbase=0x2640 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB380-0xB387 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB388-0xB38F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB390-0xB397 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB398-0xB39F */
	0x0000,0x90e8,0x90ed,0x90fd,0x9157,0x91ce,0x91f5,0x91e6, /* 0xB3A0-0xB3A7 */
	0x91e3,0x91e7,0x91ed,0x91e9,0x9589,0x966a,0x9675,0x9673, /* 0xB3A8-0xB3AF */
	0x9678,0x9670,0x9674,0x9676,0x9677,0x966c,0x96c0,0x96ea, /* 0xB3B0-0xB3B7 */
	0x96e9,0x7ae0,0x7adf,0x9802,0x9803,0x9b5a,0x9ce5,0x9e75, /* 0xB3B8-0xB3BF */
	/* codebase=0xb3c0 rawbase=0x2680 */
	0x9e7f,0x9ea5,0x9ebb,0x50a2,0x508d,0x5085,0x5099,0x5091, /* 0xB3C0-0xB3C7 */
	0x5080,0x5096,0x5098,0x509a,0x6700,0x51f1,0x5272,0x5274, /* 0xB3C8-0xB3CF */
	0x5275,0x5269,0x52de,0x52dd,0x52db,0x535a,0x53a5,0x557b, /* 0xB3D0-0xB3D7 */
	0x5580,0x55a7,0x557c,0x558a,0x559d,0x5598,0x5582,0x559c, /* 0xB3D8-0xB3DF */
	0x55aa,0x5594,0x5587,0x558b,0x5583,0x55b3,0x55ae,0x559f, /* 0xB3E0-0xB3E7 */
	0x553e,0x55b2,0x559a,0x55bb,0x55ac,0x55b1,0x557e,0x5589, /* 0xB3E8-0xB3EF */
	0x55ab,0x5599,0x570d,0x582f,0x582a,0x5834,0x5824,0x5830, /* 0xB3F0-0xB3F7 */
	0x5831,0x5821,0x581d,0x5820,0x58f9,0x58fa,0x5960,0x0000, /* 0xB3F8-0xB3FF */
	/* codebase=0xb440 rawbase=0x26c0 */
	0x5a77,0x5a9a,0x5a7f,0x5a92,0x5a9b,0x5aa7,0x5b73,0x5b71, /* 0xB440-0xB447 */
	0x5bd2,0x5bcc,0x5bd3,0x5bd0,0x5c0a,0x5c0b,0x5c31,0x5d4c, /* 0xB448-0xB44F */
	0x5d50,0x5d34,0x5d47,0x5dfd,0x5e45,0x5e3d,0x5e40,0x5e43, /* 0xB450-0xB457 */
	0x5e7e,0x5eca,0x5ec1,0x5ec2,0x5ec4,0x5f3c,0x5f6d,0x5fa9, /* 0xB458-0xB45F */
	0x5faa,0x5fa8,0x60d1,0x60e1,0x60b2,0x60b6,0x60e0,0x611c, /* 0xB460-0xB467 */
	0x6123,0x60fa,0x6115,0x60f0,0x60fb,0x60f4,0x6168,0x60f1, /* 0xB468-0xB46F */
	0x610e,0x60f6,0x6109,0x6100,0x6112,0x621f,0x6249,0x63a3, /* 0xB470-0xB477 */
	0x638c,0x63cf,0x63c0,0x63e9,0x63c9,0x63c6,0x63cd,0x0000, /* 0xB478-0xB47F */
	/* codebase=0xb480 rawbase=0x2700 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB480-0xB487 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB488-0xB48F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB490-0xB497 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB498-0xB49F */
	0x0000,0x63d2,0x63e3,0x63d0,0x63e1,0x63d6,0x63ed,0x63ee, /* 0xB4A0-0xB4A7 */
	0x6376,0x63f4,0x63ea,0x63db,0x6452,0x63da,0x63f9,0x655e, /* 0xB4A8-0xB4AF */
	0x6566,0x6562,0x6563,0x6591,0x6590,0x65af,0x666e,0x6670, /* 0xB4B0-0xB4B7 */
	0x6674,0x6676,0x666f,0x6691,0x667a,0x667e,0x6677,0x66fe, /* 0xB4B8-0xB4BF */
	/* codebase=0xb4c0 rawbase=0x2740 */
	0x66ff,0x671f,0x671d,0x68fa,0x68d5,0x68e0,0x68d8,0x68d7, /* 0xB4C0-0xB4C7 */
	0x6905,0x68df,0x68f5,0x68ee,0x68e7,0x68f9,0x68d2,0x68f2, /* 0xB4C8-0xB4CF */
	0x68e3,0x68cb,0x68cd,0x690d,0x6912,0x690e,0x68c9,0x68da, /* 0xB4D0-0xB4D7 */
	0x696e,0x68fb,0x6b3e,0x6b3a,0x6b3d,0x6b98,0x6b96,0x6bbc, /* 0xB4D8-0xB4DF */
	0x6bef,0x6c2e,0x6c2f,0x6c2c,0x6e2f,0x6e38,0x6e54,0x6e21, /* 0xB4E0-0xB4E7 */
	0x6e32,0x6e67,0x6e4a,0x6e20,0x6e25,0x6e23,0x6e1b,0x6e5b, /* 0xB4E8-0xB4EF */
	0x6e58,0x6e24,0x6e56,0x6e6e,0x6e2d,0x6e26,0x6e6f,0x6e34, /* 0xB4F0-0xB4F7 */
	0x6e4d,0x6e3a,0x6e2c,0x6e43,0x6e1d,0x6e3e,0x6ecb,0x0000, /* 0xB4F8-0xB4FF */
	/* codebase=0xb540 rawbase=0x2780 */
	0x6e89,0x6e19,0x6e4e,0x6e63,0x6e44,0x6e72,0x6e69,0x6e5f, /* 0xB540-0xB547 */
	0x7119,0x711a,0x7126,0x7130,0x7121,0x7136,0x716e,0x711c, /* 0xB548-0xB54F */
	0x724c,0x7284,0x7280,0x7336,0x7325,0x7334,0x7329,0x743a, /* 0xB550-0xB557 */
	0x742a,0x7433,0x7422,0x7425,0x7435,0x7436,0x7434,0x742f, /* 0xB558-0xB55F */
	0x741b,0x7426,0x7428,0x7525,0x7526,0x756b,0x756a,0x75e2, /* 0xB560-0xB567 */
	0x75db,0x75e3,0x75d9,0x75d8,0x75de,0x75e0,0x767b,0x767c, /* 0xB568-0xB56F */
	0x7696,0x7693,0x76b4,0x76dc,0x774f,0x77ed,0x785d,0x786c, /* 0xB570-0xB577 */
	0x786f,0x7a0d,0x7a08,0x7a0b,0x7a05,0x7a00,0x7a98,0x0000, /* 0xB578-0xB57F */
	/* codebase=0xb580 rawbase=0x27c0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB580-0xB587 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB588-0xB58F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB590-0xB597 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB598-0xB59F */
	0x0000,0x7a97,0x7a96,0x7ae5,0x7ae3,0x7b49,0x7b56,0x7b46, /* 0xB5A0-0xB5A7 */
	0x7b50,0x7b52,0x7b54,0x7b4d,0x7b4b,0x7b4f,0x7b51,0x7c9f, /* 0xB5A8-0xB5AF */
	0x7ca5,0x7d5e,0x7d50,0x7d68,0x7d55,0x7d2b,0x7d6e,0x7d72, /* 0xB5B0-0xB5B7 */
	0x7d61,0x7d66,0x7d62,0x7d70,0x7d73,0x5584,0x7fd4,0x7fd5, /* 0xB5B8-0xB5BF */
	/* codebase=0xb5c0 rawbase=0x2800 */
	0x800b,0x8052,0x8085,0x8155,0x8154,0x814b,0x8151,0x814e, /* 0xB5C0-0xB5C7 */
	0x8139,0x8146,0x813e,0x814c,0x8153,0x8174,0x8212,0x821c, /* 0xB5C8-0xB5CF */
	0x83e9,0x8403,0x83f8,0x840d,0x83e0,0x83c5,0x840b,0x83c1, /* 0xB5D0-0xB5D7 */
	0x83ef,0x83f1,0x83f4,0x8457,0x840a,0x83f0,0x840c,0x83cc, /* 0xB5D8-0xB5DF */
	0x83fd,0x83f2,0x83ca,0x8438,0x840e,0x8404,0x83dc,0x8407, /* 0xB5E0-0xB5E7 */
	0x83d4,0x83df,0x865b,0x86df,0x86d9,0x86ed,0x86d4,0x86db, /* 0xB5E8-0xB5EF */
	0x86e4,0x86d0,0x86de,0x8857,0x88c1,0x88c2,0x88b1,0x8983, /* 0xB5F0-0xB5F7 */
	0x8996,0x8a3b,0x8a60,0x8a55,0x8a5e,0x8a3c,0x8a41,0x0000, /* 0xB5F8-0xB5FF */
	/* codebase=0xb640 rawbase=0x2840 */
	0x8a54,0x8a5b,0x8a50,0x8a46,0x8a34,0x8a3a,0x8a36,0x8a56, /* 0xB640-0xB647 */
	0x8c61,0x8c82,0x8caf,0x8cbc,0x8cb3,0x8cbd,0x8cc1,0x8cbb, /* 0xB648-0xB64F */
	0x8cc0,0x8cb4,0x8cb7,0x8cb6,0x8cbf,0x8cb8,0x8d8a,0x8d85, /* 0xB650-0xB657 */
	0x8d81,0x8dce,0x8ddd,0x8dcb,0x8dda,0x8dd1,0x8dcc,0x8ddb, /* 0xB658-0xB65F */
	0x8dc6,0x8efb,0x8ef8,0x8efc,0x8f9c,0x902e,0x9035,0x9031, /* 0xB660-0xB667 */
	0x9038,0x9032,0x9036,0x9102,0x90f5,0x9109,0x90fe,0x9163, /* 0xB668-0xB66F */
	0x9165,0x91cf,0x9214,0x9215,0x9223,0x9209,0x921e,0x920d, /* 0xB670-0xB677 */
	0x9210,0x9207,0x9211,0x9594,0x958f,0x958b,0x9591,0x0000, /* 0xB678-0xB67F */
	/* codebase=0xb680 rawbase=0x2880 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB680-0xB687 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB688-0xB68F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB690-0xB697 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB698-0xB69F */
	0x0000,0x9593,0x9592,0x958e,0x968a,0x968e,0x968b,0x967d, /* 0xB6A0-0xB6A7 */
	0x9685,0x9686,0x968d,0x9672,0x9684,0x96c1,0x96c5,0x96c4, /* 0xB6A8-0xB6AF */
	0x96c6,0x96c7,0x96ef,0x96f2,0x97cc,0x9805,0x9806,0x9808, /* 0xB6B0-0xB6B7 */
	0x98e7,0x98ea,0x98ef,0x98e9,0x98f2,0x98ed,0x99ae,0x99ad, /* 0xB6B8-0xB6BF */
	/* codebase=0xb6c0 rawbase=0x28c0 */
	0x9ec3,0x9ecd,0x9ed1,0x4e82,0x50ad,0x50b5,0x50b2,0x50b3, /* 0xB6C0-0xB6C7 */
	0x50c5,0x50be,0x50ac,0x50b7,0x50bb,0x50af,0x50c7,0x527f, /* 0xB6C8-0xB6CF */
	0x5277,0x527d,0x52df,0x52e6,0x52e4,0x52e2,0x52e3,0x532f, /* 0xB6D0-0xB6D7 */
	0x55df,0x55e8,0x55d3,0x55e6,0x55ce,0x55dc,0x55c7,0x55d1, /* 0xB6D8-0xB6DF */
	0x55e3,0x55e4,0x55ef,0x55da,0x55e1,0x55c5,0x55c6,0x55e5, /* 0xB6E0-0xB6E7 */
	0x55c9,0x5712,0x5713,0x585e,0x5851,0x5858,0x5857,0x585a, /* 0xB6E8-0xB6EF */
	0x5854,0x586b,0x584c,0x586d,0x584a,0x5862,0x5852,0x584b, /* 0xB6F0-0xB6F7 */
	0x5967,0x5ac1,0x5ac9,0x5acc,0x5abe,0x5abd,0x5abc,0x0000, /* 0xB6F8-0xB6FF */
	/* codebase=0xb740 rawbase=0x2900 */
	0x5ab3,0x5ac2,0x5ab2,0x5d69,0x5d6f,0x5e4c,0x5e79,0x5ec9, /* 0xB740-0xB747 */
	0x5ec8,0x5f12,0x5f59,0x5fac,0x5fae,0x611a,0x610f,0x6148, /* 0xB748-0xB74F */
	0x611f,0x60f3,0x611b,0x60f9,0x6101,0x6108,0x614e,0x614c, /* 0xB750-0xB757 */
	0x6144,0x614d,0x613e,0x6134,0x6127,0x610d,0x6106,0x6137, /* 0xB758-0xB75F */
	0x6221,0x6222,0x6413,0x643e,0x641e,0x642a,0x642d,0x643d, /* 0xB760-0xB767 */
	0x642c,0x640f,0x641c,0x6414,0x640d,0x6436,0x6416,0x6417, /* 0xB768-0xB76F */
	0x6406,0x656c,0x659f,0x65b0,0x6697,0x6689,0x6687,0x6688, /* 0xB770-0xB777 */
	0x6696,0x6684,0x6698,0x668d,0x6703,0x6994,0x696d,0x0000, /* 0xB778-0xB77F */
	/* codebase=0xb780 rawbase=0x2940 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB780-0xB787 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB788-0xB78F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB790-0xB797 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB798-0xB79F */
	0x0000,0x695a,0x6977,0x6960,0x6954,0x6975,0x6930,0x6982, /* 0xB7A0-0xB7A7 */
	0x694a,0x6968,0x696b,0x695e,0x6953,0x6979,0x6986,0x695d, /* 0xB7A8-0xB7AF */
	0x6963,0x695b,0x6b47,0x6b72,0x6bc0,0x6bbf,0x6bd3,0x6bfd, /* 0xB7B0-0xB7B7 */
	0x6ea2,0x6eaf,0x6ed3,0x6eb6,0x6ec2,0x6e90,0x6e9d,0x6ec7, /* 0xB7B8-0xB7BF */
	/* codebase=0xb7c0 rawbase=0x2980 */
	0x6ec5,0x6ea5,0x6e98,0x6ebc,0x6eba,0x6eab,0x6ed1,0x6e96, /* 0xB7C0-0xB7C7 */
	0x6e9c,0x6ec4,0x6ed4,0x6eaa,0x6ea7,0x6eb4,0x714e,0x7159, /* 0xB7C8-0xB7CF */
	0x7169,0x7164,0x7149,0x7167,0x715c,0x716c,0x7166,0x714c, /* 0xB7D0-0xB7D7 */
	0x7165,0x715e,0x7146,0x7168,0x7156,0x723a,0x7252,0x7337, /* 0xB7D8-0xB7DF */
	0x7345,0x733f,0x733e,0x746f,0x745a,0x7455,0x745f,0x745e, /* 0xB7E0-0xB7E7 */
	0x7441,0x743f,0x7459,0x745b,0x745c,0x7576,0x7578,0x7600, /* 0xB7E8-0xB7EF */
	0x75f0,0x7601,0x75f2,0x75f1,0x75fa,0x75ff,0x75f4,0x75f3, /* 0xB7F0-0xB7F7 */
	0x76de,0x76df,0x775b,0x776b,0x7766,0x775e,0x7763,0x0000, /* 0xB7F8-0xB7FF */
	/* codebase=0xb840 rawbase=0x29c0 */
	0x7779,0x776a,0x776c,0x775c,0x7765,0x7768,0x7762,0x77ee, /* 0xB840-0xB847 */
	0x788e,0x78b0,0x7897,0x7898,0x788c,0x7889,0x787c,0x7891, /* 0xB848-0xB84F */
	0x7893,0x787f,0x797a,0x797f,0x7981,0x842c,0x79bd,0x7a1c, /* 0xB850-0xB857 */
	0x7a1a,0x7a20,0x7a14,0x7a1f,0x7a1e,0x7a9f,0x7aa0,0x7b77, /* 0xB858-0xB85F */
	0x7bc0,0x7b60,0x7b6e,0x7b67,0x7cb1,0x7cb3,0x7cb5,0x7d93, /* 0xB860-0xB867 */
	0x7d79,0x7d91,0x7d81,0x7d8f,0x7d5b,0x7f6e,0x7f69,0x7f6a, /* 0xB868-0xB86F */
	0x7f72,0x7fa9,0x7fa8,0x7fa4,0x8056,0x8058,0x8086,0x8084, /* 0xB870-0xB877 */
	0x8171,0x8170,0x8178,0x8165,0x816e,0x8173,0x816b,0x0000, /* 0xB878-0xB87F */
	/* codebase=0xb880 rawbase=0x2a00 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB880-0xB887 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB888-0xB88F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB890-0xB897 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB898-0xB89F */
	0x0000,0x8179,0x817a,0x8166,0x8205,0x8247,0x8482,0x8477, /* 0xB8A0-0xB8A7 */
	0x843d,0x8431,0x8475,0x8466,0x846b,0x8449,0x846c,0x845b, /* 0xB8A8-0xB8AF */
	0x843c,0x8435,0x8461,0x8463,0x8469,0x846d,0x8446,0x865e, /* 0xB8B0-0xB8B7 */
	0x865c,0x865f,0x86f9,0x8713,0x8708,0x8707,0x8700,0x86fe, /* 0xB8B8-0xB8BF */
	/* codebase=0xb8c0 rawbase=0x2a40 */
	0x86fb,0x8702,0x8703,0x8706,0x870a,0x8859,0x88df,0x88d4, /* 0xB8C0-0xB8C7 */
	0x88d9,0x88dc,0x88d8,0x88dd,0x88e1,0x88ca,0x88d5,0x88d2, /* 0xB8C8-0xB8CF */
	0x899c,0x89e3,0x8a6b,0x8a72,0x8a73,0x8a66,0x8a69,0x8a70, /* 0xB8D0-0xB8D7 */
	0x8a87,0x8a7c,0x8a63,0x8aa0,0x8a71,0x8a85,0x8a6d,0x8a62, /* 0xB8D8-0xB8DF */
	0x8a6e,0x8a6c,0x8a79,0x8a7b,0x8a3e,0x8a68,0x8c62,0x8c8a, /* 0xB8E0-0xB8E7 */
	0x8c89,0x8cca,0x8cc7,0x8cc8,0x8cc4,0x8cb2,0x8cc3,0x8cc2, /* 0xB8E8-0xB8EF */
	0x8cc5,0x8de1,0x8ddf,0x8de8,0x8def,0x8df3,0x8dfa,0x8dea, /* 0xB8F0-0xB8F7 */
	0x8de4,0x8de6,0x8eb2,0x8f03,0x8f09,0x8efe,0x8f0a,0x0000, /* 0xB8F8-0xB8FF */
	/* codebase=0xb940 rawbase=0x2a80 */
	0x8f9f,0x8fb2,0x904b,0x904a,0x9053,0x9042,0x9054,0x903c, /* 0xB940-0xB947 */
	0x9055,0x9050,0x9047,0x904f,0x904e,0x904d,0x9051,0x903e, /* 0xB948-0xB94F */
	0x9041,0x9112,0x9117,0x916c,0x916a,0x9169,0x91c9,0x9237, /* 0xB950-0xB957 */
	0x9257,0x9238,0x923d,0x9240,0x923e,0x925b,0x924b,0x9264, /* 0xB958-0xB95F */
	0x9251,0x9234,0x9249,0x924d,0x9245,0x9239,0x923f,0x925a, /* 0xB960-0xB967 */
	0x9598,0x9698,0x9694,0x9695,0x96cd,0x96cb,0x96c9,0x96ca, /* 0xB968-0xB96F */
	0x96f7,0x96fb,0x96f9,0x96f6,0x9756,0x9774,0x9776,0x9810, /* 0xB970-0xB977 */
	0x9811,0x9813,0x980a,0x9812,0x980c,0x98fc,0x98f4,0x0000, /* 0xB978-0xB97F */
	/* codebase=0xb980 rawbase=0x2ac0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB980-0xB987 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB988-0xB98F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB990-0xB997 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB998-0xB99F */
	0x0000,0x98fd,0x98fe,0x99b3,0x99b1,0x99b4,0x9ae1,0x9ce9, /* 0xB9A0-0xB9A7 */
	0x9e82,0x9f0e,0x9f13,0x9f20,0x50e7,0x50ee,0x50e5,0x50d6, /* 0xB9A8-0xB9AF */
	0x50ed,0x50da,0x50d5,0x50cf,0x50d1,0x50f1,0x50ce,0x50e9, /* 0xB9B0-0xB9B7 */
	0x5162,0x51f3,0x5283,0x5282,0x5331,0x53ad,0x55fe,0x5600, /* 0xB9B8-0xB9BF */
	/* codebase=0xb9c0 rawbase=0x2b00 */
	0x561b,0x5617,0x55fd,0x5614,0x5606,0x5609,0x560d,0x560e, /* 0xB9C0-0xB9C7 */
	0x55f7,0x5616,0x561f,0x5608,0x5610,0x55f6,0x5718,0x5716, /* 0xB9C8-0xB9CF */
	0x5875,0x587e,0x5883,0x5893,0x588a,0x5879,0x5885,0x587d, /* 0xB9D0-0xB9D7 */
	0x58fd,0x5925,0x5922,0x5924,0x596a,0x5969,0x5ae1,0x5ae6, /* 0xB9D8-0xB9DF */
	0x5ae9,0x5ad7,0x5ad6,0x5ad8,0x5ae3,0x5b75,0x5bde,0x5be7, /* 0xB9E0-0xB9E7 */
	0x5be1,0x5be5,0x5be6,0x5be8,0x5be2,0x5be4,0x5bdf,0x5c0d, /* 0xB9E8-0xB9EF */
	0x5c62,0x5d84,0x5d87,0x5e5b,0x5e63,0x5e55,0x5e57,0x5e54, /* 0xB9F0-0xB9F7 */
	0x5ed3,0x5ed6,0x5f0a,0x5f46,0x5f70,0x5fb9,0x6147,0x0000, /* 0xB9F8-0xB9FF */
	/* codebase=0xba40 rawbase=0x2b40 */
	0x613f,0x614b,0x6177,0x6162,0x6163,0x615f,0x615a,0x6158, /* 0xBA40-0xBA47 */
	0x6175,0x622a,0x6487,0x6458,0x6454,0x64a4,0x6478,0x645f, /* 0xBA48-0xBA4F */
	0x647a,0x6451,0x6467,0x6434,0x646d,0x647b,0x6572,0x65a1, /* 0xBA50-0xBA57 */
	0x65d7,0x65d6,0x66a2,0x66a8,0x669d,0x699c,0x69a8,0x6995, /* 0xBA58-0xBA5F */
	0x69c1,0x69ae,0x69d3,0x69cb,0x699b,0x69b7,0x69bb,0x69ab, /* 0xBA60-0xBA67 */
	0x69b4,0x69d0,0x69cd,0x69ad,0x69cc,0x69a6,0x69c3,0x69a3, /* 0xBA68-0xBA6F */
	0x6b49,0x6b4c,0x6c33,0x6f33,0x6f14,0x6efe,0x6f13,0x6ef4, /* 0xBA70-0xBA77 */
	0x6f29,0x6f3e,0x6f20,0x6f2c,0x6f0f,0x6f02,0x6f22,0x0000, /* 0xBA78-0xBA7F */
	/* codebase=0xba80 rawbase=0x2b80 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xBA80-0xBA87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xBA88-0xBA8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xBA90-0xBA97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xBA98-0xBA9F */
	0x0000,0x6eff,0x6eef,0x6f06,0x6f31,0x6f38,0x6f32,0x6f23, /* 0xBAA0-0xBAA7 */
	0x6f15,0x6f2b,0x6f2f,0x6f88,0x6f2a,0x6eec,0x6f01,0x6ef2, /* 0xBAA8-0xBAAF */
	0x6ecc,0x6ef7,0x7194,0x7199,0x717d,0x718a,0x7184,0x7192, /* 0xBAB0-0xBAB7 */
	0x723e,0x7292,0x7296,0x7344,0x7350,0x7464,0x7463,0x746a, /* 0xBAB8-0xBABF */
	/* codebase=0xbac0 rawbase=0x2bc0 */
	0x7470,0x746d,0x7504,0x7591,0x7627,0x760d,0x760b,0x7609, /* 0xBAC0-0xBAC7 */
	0x7613,0x76e1,0x76e3,0x7784,0x777d,0x777f,0x7761,0x78c1, /* 0xBAC8-0xBACF */
	0x789f,0x78a7,0x78b3,0x78a9,0x78a3,0x798e,0x798f,0x798d, /* 0xBAD0-0xBAD7 */
	0x7a2e,0x7a31,0x7aaa,0x7aa9,0x7aed,0x7aef,0x7ba1,0x7b95, /* 0xBAD8-0xBADF */
	0x7b8b,0x7b75,0x7b97,0x7b9d,0x7b94,0x7b8f,0x7bb8,0x7b87, /* 0xBAE0-0xBAE7 */
	0x7b84,0x7cb9,0x7cbd,0x7cbe,0x7dbb,0x7db0,0x7d9c,0x7dbd, /* 0xBAE8-0xBAEF */
	0x7dbe,0x7da0,0x7dca,0x7db4,0x7db2,0x7db1,0x7dba,0x7da2, /* 0xBAF0-0xBAF7 */
	0x7dbf,0x7db5,0x7db8,0x7dad,0x7dd2,0x7dc7,0x7dac,0x0000, /* 0xBAF8-0xBAFF */
	/* codebase=0xbb40 rawbase=0x2c00 */
	0x7f70,0x7fe0,0x7fe1,0x7fdf,0x805e,0x805a,0x8087,0x8150, /* 0xBB40-0xBB47 */
	0x8180,0x818f,0x8188,0x818a,0x817f,0x8182,0x81e7,0x81fa, /* 0xBB48-0xBB4F */
	0x8207,0x8214,0x821e,0x824b,0x84c9,0x84bf,0x84c6,0x84c4, /* 0xBB50-0xBB57 */
	0x8499,0x849e,0x84b2,0x849c,0x84cb,0x84b8,0x84c0,0x84d3, /* 0xBB58-0xBB5F */
	0x8490,0x84bc,0x84d1,0x84ca,0x873f,0x871c,0x873b,0x8722, /* 0xBB60-0xBB67 */
	0x8725,0x8734,0x8718,0x8755,0x8737,0x8729,0x88f3,0x8902, /* 0xBB68-0xBB6F */
	0x88f4,0x88f9,0x88f8,0x88fd,0x88e8,0x891a,0x88ef,0x8aa6, /* 0xBB70-0xBB77 */
	0x8a8c,0x8a9e,0x8aa3,0x8a8d,0x8aa1,0x8a93,0x8aa4,0x0000, /* 0xBB78-0xBB7F */
	/* codebase=0xbb80 rawbase=0x2c40 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xBB80-0xBB87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xBB88-0xBB8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xBB90-0xBB97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xBB98-0xBB9F */
	0x0000,0x8aaa,0x8aa5,0x8aa8,0x8a98,0x8a91,0x8a9a,0x8aa7, /* 0xBBA0-0xBBA7 */
	0x8c6a,0x8c8d,0x8c8c,0x8cd3,0x8cd1,0x8cd2,0x8d6b,0x8d99, /* 0xBBA8-0xBBAF */
	0x8d95,0x8dfc,0x8f14,0x8f12,0x8f15,0x8f13,0x8fa3,0x9060, /* 0xBBB0-0xBBB7 */
	0x9058,0x905c,0x9063,0x9059,0x905e,0x9062,0x905d,0x905b, /* 0xBBB8-0xBBBF */
	/* codebase=0xbbc0 rawbase=0x2c80 */
	0x9119,0x9118,0x911e,0x9175,0x9178,0x9177,0x9174,0x9278, /* 0xBBC0-0xBBC7 */
	0x9280,0x9285,0x9298,0x9296,0x927b,0x9293,0x929c,0x92a8, /* 0xBBC8-0xBBCF */
	0x927c,0x9291,0x95a1,0x95a8,0x95a9,0x95a3,0x95a5,0x95a4, /* 0xBBD0-0xBBD7 */
	0x9699,0x969c,0x969b,0x96cc,0x96d2,0x9700,0x977c,0x9785, /* 0xBBD8-0xBBDF */
	0x97f6,0x9817,0x9818,0x98af,0x98b1,0x9903,0x9905,0x990c, /* 0xBBE0-0xBBE7 */
	0x9909,0x99c1,0x9aaf,0x9ab0,0x9ae6,0x9b41,0x9b42,0x9cf4, /* 0xBBE8-0xBBEF */
	0x9cf6,0x9cf3,0x9ebc,0x9f3b,0x9f4a,0x5104,0x5100,0x50fb, /* 0xBBF0-0xBBF7 */
	0x50f5,0x50f9,0x5102,0x5108,0x5109,0x5105,0x51dc,0x0000, /* 0xBBF8-0xBBFF */
	/* codebase=0xbc40 rawbase=0x2cc0 */
	0x5287,0x5288,0x5289,0x528d,0x528a,0x52f0,0x53b2,0x562e, /* 0xBC40-0xBC47 */
	0x563b,0x5639,0x5632,0x563f,0x5634,0x5629,0x5653,0x564e, /* 0xBC48-0xBC4F */
	0x5657,0x5674,0x5636,0x562f,0x5630,0x5880,0x589f,0x589e, /* 0xBC50-0xBC57 */
	0x58b3,0x589c,0x58ae,0x58a9,0x58a6,0x596d,0x5b09,0x5afb, /* 0xBC58-0xBC5F */
	0x5b0b,0x5af5,0x5b0c,0x5b08,0x5bee,0x5bec,0x5be9,0x5beb, /* 0xBC60-0xBC67 */
	0x5c64,0x5c65,0x5d9d,0x5d94,0x5e62,0x5e5f,0x5e61,0x5ee2, /* 0xBC68-0xBC6F */
	0x5eda,0x5edf,0x5edd,0x5ee3,0x5ee0,0x5f48,0x5f71,0x5fb7, /* 0xBC70-0xBC77 */
	0x5fb5,0x6176,0x6167,0x616e,0x615d,0x6155,0x6182,0x0000, /* 0xBC78-0xBC7F */
	/* codebase=0xbc80 rawbase=0x2d00 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xBC80-0xBC87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xBC88-0xBC8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xBC90-0xBC97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xBC98-0xBC9F */
	0x0000,0x617c,0x6170,0x616b,0x617e,0x61a7,0x6190,0x61ab, /* 0xBCA0-0xBCA7 */
	0x618e,0x61ac,0x619a,0x61a4,0x6194,0x61ae,0x622e,0x6469, /* 0xBCA8-0xBCAF */
	0x646f,0x6479,0x649e,0x64b2,0x6488,0x6490,0x64b0,0x64a5, /* 0xBCB0-0xBCB7 */
	0x6493,0x6495,0x64a9,0x6492,0x64ae,0x64ad,0x64ab,0x649a, /* 0xBCB8-0xBCBF */
	/* codebase=0xbcc0 rawbase=0x2d40 */
	0x64ac,0x6499,0x64a2,0x64b3,0x6575,0x6577,0x6578,0x66ae, /* 0xBCC0-0xBCC7 */
	0x66ab,0x66b4,0x66b1,0x6a23,0x6a1f,0x69e8,0x6a01,0x6a1e, /* 0xBCC8-0xBCCF */
	0x6a19,0x69fd,0x6a21,0x6a13,0x6a0a,0x69f3,0x6a02,0x6a05, /* 0xBCD0-0xBCD7 */
	0x69ed,0x6a11,0x6b50,0x6b4e,0x6ba4,0x6bc5,0x6bc6,0x6f3f, /* 0xBCD8-0xBCDF */
	0x6f7c,0x6f84,0x6f51,0x6f66,0x6f54,0x6f86,0x6f6d,0x6f5b, /* 0xBCE0-0xBCE7 */
	0x6f78,0x6f6e,0x6f8e,0x6f7a,0x6f70,0x6f64,0x6f97,0x6f58, /* 0xBCE8-0xBCEF */
	0x6ed5,0x6f6f,0x6f60,0x6f5f,0x719f,0x71ac,0x71b1,0x71a8, /* 0xBCF0-0xBCF7 */
	0x7256,0x729b,0x734e,0x7357,0x7469,0x748b,0x7483,0x0000, /* 0xBCF8-0xBCFF */
	/* codebase=0xbd40 rawbase=0x2d80 */
	0x747e,0x7480,0x757f,0x7620,0x7629,0x761f,0x7624,0x7626, /* 0xBD40-0xBD47 */
	0x7621,0x7622,0x769a,0x76ba,0x76e4,0x778e,0x7787,0x778c, /* 0xBD48-0xBD4F */
	0x7791,0x778b,0x78cb,0x78c5,0x78ba,0x78ca,0x78be,0x78d5, /* 0xBD50-0xBD57 */
	0x78bc,0x78d0,0x7a3f,0x7a3c,0x7a40,0x7a3d,0x7a37,0x7a3b, /* 0xBD58-0xBD5F */
	0x7aaf,0x7aae,0x7bad,0x7bb1,0x7bc4,0x7bb4,0x7bc6,0x7bc7, /* 0xBD60-0xBD67 */
	0x7bc1,0x7ba0,0x7bcc,0x7cca,0x7de0,0x7df4,0x7def,0x7dfb, /* 0xBD68-0xBD6F */
	0x7dd8,0x7dec,0x7ddd,0x7de8,0x7de3,0x7dda,0x7dde,0x7de9, /* 0xBD70-0xBD77 */
	0x7d9e,0x7dd9,0x7df2,0x7df9,0x7f75,0x7f77,0x7faf,0x0000, /* 0xBD78-0xBD7F */
	/* codebase=0xbd80 rawbase=0x2dc0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xBD80-0xBD87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xBD88-0xBD8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xBD90-0xBD97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xBD98-0xBD9F */
	0x0000,0x7fe9,0x8026,0x819b,0x819c,0x819d,0x81a0,0x819a, /* 0xBDA0-0xBDA7 */
	0x8198,0x8517,0x853d,0x851a,0x84ee,0x852c,0x852d,0x8513, /* 0xBDA8-0xBDAF */
	0x8511,0x8523,0x8521,0x8514,0x84ec,0x8525,0x84ff,0x8506, /* 0xBDB0-0xBDB7 */
	0x8782,0x8774,0x8776,0x8760,0x8766,0x8778,0x8768,0x8759, /* 0xBDB8-0xBDBF */
	/* codebase=0xbdc0 rawbase=0x2e00 */
	0x8757,0x874c,0x8753,0x885b,0x885d,0x8910,0x8907,0x8912, /* 0xBDC0-0xBDC7 */
	0x8913,0x8915,0x890a,0x8abc,0x8ad2,0x8ac7,0x8ac4,0x8a95, /* 0xBDC8-0xBDCF */
	0x8acb,0x8af8,0x8ab2,0x8ac9,0x8ac2,0x8abf,0x8ab0,0x8ad6, /* 0xBDD0-0xBDD7 */
	0x8acd,0x8ab6,0x8ab9,0x8adb,0x8c4c,0x8c4e,0x8c6c,0x8ce0, /* 0xBDD8-0xBDDF */
	0x8cde,0x8ce6,0x8ce4,0x8cec,0x8ced,0x8ce2,0x8ce3,0x8cdc, /* 0xBDE0-0xBDE7 */
	0x8cea,0x8ce1,0x8d6d,0x8d9f,0x8da3,0x8e2b,0x8e10,0x8e1d, /* 0xBDE8-0xBDEF */
	0x8e22,0x8e0f,0x8e29,0x8e1f,0x8e21,0x8e1e,0x8eba,0x8f1d, /* 0xBDF0-0xBDF7 */
	0x8f1b,0x8f1f,0x8f29,0x8f26,0x8f2a,0x8f1c,0x8f1e,0x0000, /* 0xBDF8-0xBDFF */
	/* codebase=0xbe40 rawbase=0x2e40 */
	0x8f25,0x9069,0x906e,0x9068,0x906d,0x9077,0x9130,0x912d, /* 0xBE40-0xBE47 */
	0x9127,0x9131,0x9187,0x9189,0x918b,0x9183,0x92c5,0x92bb, /* 0xBE48-0xBE4F */
	0x92b7,0x92ea,0x92ac,0x92e4,0x92c1,0x92b3,0x92bc,0x92d2, /* 0xBE50-0xBE57 */
	0x92c7,0x92f0,0x92b2,0x95ad,0x95b1,0x9704,0x9706,0x9707, /* 0xBE58-0xBE5F */
	0x9709,0x9760,0x978d,0x978b,0x978f,0x9821,0x982b,0x981c, /* 0xBE60-0xBE67 */
	0x98b3,0x990a,0x9913,0x9912,0x9918,0x99dd,0x99d0,0x99df, /* 0xBE68-0xBE6F */
	0x99db,0x99d1,0x99d5,0x99d2,0x99d9,0x9ab7,0x9aee,0x9aef, /* 0xBE70-0xBE77 */
	0x9b27,0x9b45,0x9b44,0x9b77,0x9b6f,0x9d06,0x9d09,0x0000, /* 0xBE78-0xBE7F */
	/* codebase=0xbe80 rawbase=0x2e80 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xBE80-0xBE87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xBE88-0xBE8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xBE90-0xBE97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xBE98-0xBE9F */
	0x0000,0x9d03,0x9ea9,0x9ebe,0x9ece,0x58a8,0x9f52,0x5112, /* 0xBEA0-0xBEA7 */
	0x5118,0x5114,0x5110,0x5115,0x5180,0x51aa,0x51dd,0x5291, /* 0xBEA8-0xBEAF */
	0x5293,0x52f3,0x5659,0x566b,0x5679,0x5669,0x5664,0x5678, /* 0xBEB0-0xBEB7 */
	0x566a,0x5668,0x5665,0x5671,0x566f,0x566c,0x5662,0x5676, /* 0xBEB8-0xBEBF */
	/* codebase=0xbec0 rawbase=0x2ec0 */
	0x58c1,0x58be,0x58c7,0x58c5,0x596e,0x5b1d,0x5b34,0x5b78, /* 0xBEC0-0xBEC7 */
	0x5bf0,0x5c0e,0x5f4a,0x61b2,0x6191,0x61a9,0x618a,0x61cd, /* 0xBEC8-0xBECF */
	0x61b6,0x61be,0x61ca,0x61c8,0x6230,0x64c5,0x64c1,0x64cb, /* 0xBED0-0xBED7 */
	0x64bb,0x64bc,0x64da,0x64c4,0x64c7,0x64c2,0x64cd,0x64bf, /* 0xBED8-0xBEDF */
	0x64d2,0x64d4,0x64be,0x6574,0x66c6,0x66c9,0x66b9,0x66c4, /* 0xBEE0-0xBEE7 */
	0x66c7,0x66b8,0x6a3d,0x6a38,0x6a3a,0x6a59,0x6a6b,0x6a58, /* 0xBEE8-0xBEEF */
	0x6a39,0x6a44,0x6a62,0x6a61,0x6a4b,0x6a47,0x6a35,0x6a5f, /* 0xBEF0-0xBEF7 */
	0x6a48,0x6b59,0x6b77,0x6c05,0x6fc2,0x6fb1,0x6fa1,0x0000, /* 0xBEF8-0xBEFF */
	/* codebase=0xbf40 rawbase=0x2f00 */
	0x6fc3,0x6fa4,0x6fc1,0x6fa7,0x6fb3,0x6fc0,0x6fb9,0x6fb6, /* 0xBF40-0xBF47 */
	0x6fa6,0x6fa0,0x6fb4,0x71be,0x71c9,0x71d0,0x71d2,0x71c8, /* 0xBF48-0xBF4F */
	0x71d5,0x71b9,0x71ce,0x71d9,0x71dc,0x71c3,0x71c4,0x7368, /* 0xBF50-0xBF57 */
	0x749c,0x74a3,0x7498,0x749f,0x749e,0x74e2,0x750c,0x750d, /* 0xBF58-0xBF5F */
	0x7634,0x7638,0x763a,0x76e7,0x76e5,0x77a0,0x779e,0x779f, /* 0xBF60-0xBF67 */
	0x77a5,0x78e8,0x78da,0x78ec,0x78e7,0x79a6,0x7a4d,0x7a4e, /* 0xBF68-0xBF6F */
	0x7a46,0x7a4c,0x7a4b,0x7aba,0x7bd9,0x7c11,0x7bc9,0x7be4, /* 0xBF70-0xBF77 */
	0x7bdb,0x7be1,0x7be9,0x7be6,0x7cd5,0x7cd6,0x7e0a,0x0000, /* 0xBF78-0xBF7F */
	/* codebase=0xbf80 rawbase=0x2f40 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xBF80-0xBF87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xBF88-0xBF8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xBF90-0xBF97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xBF98-0xBF9F */
	0x0000,0x7e11,0x7e08,0x7e1b,0x7e23,0x7e1e,0x7e1d,0x7e09, /* 0xBFA0-0xBFA7 */
	0x7e10,0x7f79,0x7fb2,0x7ff0,0x7ff1,0x7fee,0x8028,0x81b3, /* 0xBFA8-0xBFAF */
	0x81a9,0x81a8,0x81fb,0x8208,0x8258,0x8259,0x854a,0x8559, /* 0xBFB0-0xBFB7 */
	0x8548,0x8568,0x8569,0x8543,0x8549,0x856d,0x856a,0x855e, /* 0xBFB8-0xBFBF */
	/* codebase=0xbfc0 rawbase=0x2f80 */
	0x8783,0x879f,0x879e,0x87a2,0x878d,0x8861,0x892a,0x8932, /* 0xBFC0-0xBFC7 */
	0x8925,0x892b,0x8921,0x89aa,0x89a6,0x8ae6,0x8afa,0x8aeb, /* 0xBFC8-0xBFCF */
	0x8af1,0x8b00,0x8adc,0x8ae7,0x8aee,0x8afe,0x8b01,0x8b02, /* 0xBFD0-0xBFD7 */
	0x8af7,0x8aed,0x8af3,0x8af6,0x8afc,0x8c6b,0x8c6d,0x8c93, /* 0xBFD8-0xBFDF */
	0x8cf4,0x8e44,0x8e31,0x8e34,0x8e42,0x8e39,0x8e35,0x8f3b, /* 0xBFE0-0xBFE7 */
	0x8f2f,0x8f38,0x8f33,0x8fa8,0x8fa6,0x9075,0x9074,0x9078, /* 0xBFE8-0xBFEF */
	0x9072,0x907c,0x907a,0x9134,0x9192,0x9320,0x9336,0x92f8, /* 0xBFF0-0xBFF7 */
	0x9333,0x932f,0x9322,0x92fc,0x932b,0x9304,0x931a,0x0000, /* 0xBFF8-0xBFFF */
	/* codebase=0xc040 rawbase=0x2fc0 */
	0x9310,0x9326,0x9321,0x9315,0x932e,0x9319,0x95bb,0x96a7, /* 0xC040-0xC047 */
	0x96a8,0x96aa,0x96d5,0x970e,0x9711,0x9716,0x970d,0x9713, /* 0xC048-0xC04F */
	0x970f,0x975b,0x975c,0x9766,0x9798,0x9830,0x9838,0x983b, /* 0xC050-0xC057 */
	0x9837,0x982d,0x9839,0x9824,0x9910,0x9928,0x991e,0x991b, /* 0xC058-0xC05F */
	0x9921,0x991a,0x99ed,0x99e2,0x99f1,0x9ab8,0x9abc,0x9afb, /* 0xC060-0xC067 */
	0x9aed,0x9b28,0x9b91,0x9d15,0x9d23,0x9d26,0x9d28,0x9d12, /* 0xC068-0xC06F */
	0x9d1b,0x9ed8,0x9ed4,0x9f8d,0x9f9c,0x512a,0x511f,0x5121, /* 0xC070-0xC077 */
	0x5132,0x52f5,0x568e,0x5680,0x5690,0x5685,0x5687,0x0000, /* 0xC078-0xC07F */
	/* codebase=0xc080 rawbase=0x3000 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC080-0xC087 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC088-0xC08F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC090-0xC097 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC098-0xC09F */
	0x0000,0x568f,0x58d5,0x58d3,0x58d1,0x58ce,0x5b30,0x5b2a, /* 0xC0A0-0xC0A7 */
	0x5b24,0x5b7a,0x5c37,0x5c68,0x5dbc,0x5dba,0x5dbd,0x5db8, /* 0xC0A8-0xC0AF */
	0x5e6b,0x5f4c,0x5fbd,0x61c9,0x61c2,0x61c7,0x61e6,0x61cb, /* 0xC0B0-0xC0B7 */
	0x6232,0x6234,0x64ce,0x64ca,0x64d8,0x64e0,0x64f0,0x64e6, /* 0xC0B8-0xC0BF */
	/* codebase=0xc0c0 rawbase=0x3040 */
	0x64ec,0x64f1,0x64e2,0x64ed,0x6582,0x6583,0x66d9,0x66d6, /* 0xC0C0-0xC0C7 */
	0x6a80,0x6a94,0x6a84,0x6aa2,0x6a9c,0x6adb,0x6aa3,0x6a7e, /* 0xC0C8-0xC0CF */
	0x6a97,0x6a90,0x6aa0,0x6b5c,0x6bae,0x6bda,0x6c08,0x6fd8, /* 0xC0D0-0xC0D7 */
	0x6ff1,0x6fdf,0x6fe0,0x6fdb,0x6fe4,0x6feb,0x6fef,0x6f80, /* 0xC0D8-0xC0DF */
	0x6fec,0x6fe1,0x6fe9,0x6fd5,0x6fee,0x6ff0,0x71e7,0x71df, /* 0xC0E0-0xC0E7 */
	0x71ee,0x71e6,0x71e5,0x71ed,0x71ec,0x71f4,0x71e0,0x7235, /* 0xC0E8-0xC0EF */
	0x7246,0x7370,0x7372,0x74a9,0x74b0,0x74a6,0x74a8,0x7646, /* 0xC0F0-0xC0F7 */
	0x7642,0x764c,0x76ea,0x77b3,0x77aa,0x77b0,0x77ac,0x0000, /* 0xC0F8-0xC0FF */
	/* codebase=0xc140 rawbase=0x3080 */
	0x77a7,0x77ad,0x77ef,0x78f7,0x78fa,0x78f4,0x78ef,0x7901, /* 0xC140-0xC147 */
	0x79a7,0x79aa,0x7a57,0x7abf,0x7c07,0x7c0d,0x7bfe,0x7bf7, /* 0xC148-0xC14F */
	0x7c0c,0x7be0,0x7ce0,0x7cdc,0x7cde,0x7ce2,0x7cdf,0x7cd9, /* 0xC150-0xC157 */
	0x7cdd,0x7e2e,0x7e3e,0x7e46,0x7e37,0x7e32,0x7e43,0x7e2b, /* 0xC158-0xC15F */
	0x7e3d,0x7e31,0x7e45,0x7e41,0x7e34,0x7e39,0x7e48,0x7e35, /* 0xC160-0xC167 */
	0x7e3f,0x7e2f,0x7f44,0x7ff3,0x7ffc,0x8071,0x8072,0x8070, /* 0xC168-0xC16F */
	0x806f,0x8073,0x81c6,0x81c3,0x81ba,0x81c2,0x81c0,0x81bf, /* 0xC170-0xC177 */
	0x81bd,0x81c9,0x81be,0x81e8,0x8209,0x8271,0x85aa,0x0000, /* 0xC178-0xC17F */
	/* codebase=0xc180 rawbase=0x30c0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC180-0xC187 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC188-0xC18F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC190-0xC197 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC198-0xC19F */
	0x0000,0x8584,0x857e,0x859c,0x8591,0x8594,0x85af,0x859b, /* 0xC1A0-0xC1A7 */
	0x8587,0x85a8,0x858a,0x8667,0x87c0,0x87d1,0x87b3,0x87d2, /* 0xC1A8-0xC1AF */
	0x87c6,0x87ab,0x87bb,0x87ba,0x87c8,0x87cb,0x893b,0x8936, /* 0xC1B0-0xC1B7 */
	0x8944,0x8938,0x893d,0x89ac,0x8b0e,0x8b17,0x8b19,0x8b1b, /* 0xC1B8-0xC1BF */
	/* codebase=0xc1c0 rawbase=0x3100 */
	0x8b0a,0x8b20,0x8b1d,0x8b04,0x8b10,0x8c41,0x8c3f,0x8c73, /* 0xC1C0-0xC1C7 */
	0x8cfa,0x8cfd,0x8cfc,0x8cf8,0x8cfb,0x8da8,0x8e49,0x8e4b, /* 0xC1C8-0xC1CF */
	0x8e48,0x8e4a,0x8f44,0x8f3e,0x8f42,0x8f45,0x8f3f,0x907f, /* 0xC1D0-0xC1D7 */
	0x907d,0x9084,0x9081,0x9082,0x9080,0x9139,0x91a3,0x919e, /* 0xC1D8-0xC1DF */
	0x919c,0x934d,0x9382,0x9328,0x9375,0x934a,0x9365,0x934b, /* 0xC1E0-0xC1E7 */
	0x9318,0x937e,0x936c,0x935b,0x9370,0x935a,0x9354,0x95ca, /* 0xC1E8-0xC1EF */
	0x95cb,0x95cc,0x95c8,0x95c6,0x96b1,0x96b8,0x96d6,0x971c, /* 0xC1F0-0xC1F7 */
	0x971e,0x97a0,0x97d3,0x9846,0x98b6,0x9935,0x9a01,0x0000, /* 0xC1F8-0xC1FF */
	/* codebase=0xc240 rawbase=0x3140 */
	0x99ff,0x9bae,0x9bab,0x9baa,0x9bad,0x9d3b,0x9d3f,0x9e8b, /* 0xC240-0xC247 */
	0x9ecf,0x9ede,0x9edc,0x9edd,0x9edb,0x9f3e,0x9f4b,0x53e2, /* 0xC248-0xC24F */
	0x5695,0x56ae,0x58d9,0x58d8,0x5b38,0x5f5e,0x61e3,0x6233, /* 0xC250-0xC257 */
	0x64f4,0x64f2,0x64fe,0x6506,0x64fa,0x64fb,0x64f7,0x65b7, /* 0xC258-0xC25F */
	0x66dc,0x6726,0x6ab3,0x6aac,0x6ac3,0x6abb,0x6ab8,0x6ac2, /* 0xC260-0xC267 */
	0x6aae,0x6aaf,0x6b5f,0x6b78,0x6baf,0x7009,0x700b,0x6ffe, /* 0xC268-0xC26F */
	0x7006,0x6ffa,0x7011,0x700f,0x71fb,0x71fc,0x71fe,0x71f8, /* 0xC270-0xC277 */
	0x7377,0x7375,0x74a7,0x74bf,0x7515,0x7656,0x7658,0x0000, /* 0xC278-0xC27F */
	/* codebase=0xc280 rawbase=0x3180 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC280-0xC287 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC288-0xC28F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC290-0xC297 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC298-0xC29F */
	0x0000,0x7652,0x77bd,0x77bf,0x77bb,0x77bc,0x790e,0x79ae, /* 0xC2A0-0xC2A7 */
	0x7a61,0x7a62,0x7a60,0x7ac4,0x7ac5,0x7c2b,0x7c27,0x7c2a, /* 0xC2A8-0xC2AF */
	0x7c1e,0x7c23,0x7c21,0x7ce7,0x7e54,0x7e55,0x7e5e,0x7e5a, /* 0xC2B0-0xC2B7 */
	0x7e61,0x7e52,0x7e59,0x7f48,0x7ff9,0x7ffb,0x8077,0x8076, /* 0xC2B8-0xC2BF */
	/* codebase=0xc2c0 rawbase=0x31c0 */
	0x81cd,0x81cf,0x820a,0x85cf,0x85a9,0x85cd,0x85d0,0x85c9, /* 0xC2C0-0xC2C7 */
	0x85b0,0x85ba,0x85b9,0x85a6,0x87ef,0x87ec,0x87f2,0x87e0, /* 0xC2C8-0xC2CF */
	0x8986,0x89b2,0x89f4,0x8b28,0x8b39,0x8b2c,0x8b2b,0x8c50, /* 0xC2D0-0xC2D7 */
	0x8d05,0x8e59,0x8e63,0x8e66,0x8e64,0x8e5f,0x8e55,0x8ec0, /* 0xC2D8-0xC2DF */
	0x8f49,0x8f4d,0x9087,0x9083,0x9088,0x91ab,0x91ac,0x91d0, /* 0xC2E0-0xC2E7 */
	0x9394,0x938a,0x9396,0x93a2,0x93b3,0x93ae,0x93ac,0x93b0, /* 0xC2E8-0xC2EF */
	0x9398,0x939a,0x9397,0x95d4,0x95d6,0x95d0,0x95d5,0x96e2, /* 0xC2F0-0xC2F7 */
	0x96dc,0x96d9,0x96db,0x96de,0x9724,0x97a3,0x97a6,0x0000, /* 0xC2F8-0xC2FF */
	/* codebase=0xc340 rawbase=0x3200 */
	0x97ad,0x97f9,0x984d,0x984f,0x984c,0x984e,0x9853,0x98ba, /* 0xC340-0xC347 */
	0x993e,0x993f,0x993d,0x992e,0x99a5,0x9a0e,0x9ac1,0x9b03, /* 0xC348-0xC34F */
	0x9b06,0x9b4f,0x9b4e,0x9b4d,0x9bca,0x9bc9,0x9bfd,0x9bc8, /* 0xC350-0xC357 */
	0x9bc0,0x9d51,0x9d5d,0x9d60,0x9ee0,0x9f15,0x9f2c,0x5133, /* 0xC358-0xC35F */
	0x56a5,0x58de,0x58df,0x58e2,0x5bf5,0x9f90,0x5eec,0x61f2, /* 0xC360-0xC367 */
	0x61f7,0x61f6,0x61f5,0x6500,0x650f,0x66e0,0x66dd,0x6ae5, /* 0xC368-0xC36F */
	0x6add,0x6ada,0x6ad3,0x701b,0x701f,0x7028,0x701a,0x701d, /* 0xC370-0xC377 */
	0x7015,0x7018,0x7206,0x720d,0x7258,0x72a2,0x7378,0x0000, /* 0xC378-0xC37F */
	/* codebase=0xc380 rawbase=0x3240 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC380-0xC387 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC388-0xC38F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC390-0xC397 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC398-0xC39F */
	0x0000,0x737a,0x74bd,0x74ca,0x74e3,0x7587,0x7586,0x765f, /* 0xC3A0-0xC3A7 */
	0x7661,0x77c7,0x7919,0x79b1,0x7a6b,0x7a69,0x7c3e,0x7c3f, /* 0xC3A8-0xC3AF */
	0x7c38,0x7c3d,0x7c37,0x7c40,0x7e6b,0x7e6d,0x7e79,0x7e69, /* 0xC3B0-0xC3B7 */
	0x7e6a,0x7f85,0x7e73,0x7fb6,0x7fb9,0x7fb8,0x81d8,0x85e9, /* 0xC3B8-0xC3BF */
	/* codebase=0xc3c0 rawbase=0x3280 */
	0x85dd,0x85ea,0x85d5,0x85e4,0x85e5,0x85f7,0x87fb,0x8805, /* 0xC3C0-0xC3C7 */
	0x880d,0x87f9,0x87fe,0x8960,0x895f,0x8956,0x895e,0x8b41, /* 0xC3C8-0xC3CF */
	0x8b5c,0x8b58,0x8b49,0x8b5a,0x8b4e,0x8b4f,0x8b46,0x8b59, /* 0xC3D0-0xC3D7 */
	0x8d08,0x8d0a,0x8e7c,0x8e72,0x8e87,0x8e76,0x8e6c,0x8e7a, /* 0xC3D8-0xC3DF */
	0x8e74,0x8f54,0x8f4e,0x8fad,0x908a,0x908b,0x91b1,0x91ae, /* 0xC3E0-0xC3E7 */
	0x93e1,0x93d1,0x93df,0x93c3,0x93c8,0x93dc,0x93dd,0x93d6, /* 0xC3E8-0xC3EF */
	0x93e2,0x93cd,0x93d8,0x93e4,0x93d7,0x93e8,0x95dc,0x96b4, /* 0xC3F0-0xC3F7 */
	0x96e3,0x972a,0x9727,0x9761,0x97dc,0x97fb,0x985e,0x0000, /* 0xC3F8-0xC3FF */
	/* codebase=0xc440 rawbase=0x32c0 */
	0x9858,0x985b,0x98bc,0x9945,0x9949,0x9a16,0x9a19,0x9b0d, /* 0xC440-0xC447 */
	0x9be8,0x9be7,0x9bd6,0x9bdb,0x9d89,0x9d61,0x9d72,0x9d6a, /* 0xC448-0xC44F */
	0x9d6c,0x9e92,0x9e97,0x9e93,0x9eb4,0x52f8,0x56a8,0x56b7, /* 0xC450-0xC457 */
	0x56b6,0x56b4,0x56bc,0x58e4,0x5b40,0x5b43,0x5b7d,0x5bf6, /* 0xC458-0xC45F */
	0x5dc9,0x61f8,0x61fa,0x6518,0x6514,0x6519,0x66e6,0x6727, /* 0xC460-0xC467 */
	0x6aec,0x703e,0x7030,0x7032,0x7210,0x737b,0x74cf,0x7662, /* 0xC468-0xC46F */
	0x7665,0x7926,0x792a,0x792c,0x792b,0x7ac7,0x7af6,0x7c4c, /* 0xC470-0xC477 */
	0x7c43,0x7c4d,0x7cef,0x7cf0,0x8fae,0x7e7d,0x7e7c,0x0000, /* 0xC478-0xC47F */
	/* codebase=0xc480 rawbase=0x3300 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC480-0xC487 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC488-0xC48F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC490-0xC497 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC498-0xC49F */
	0x0000,0x7e82,0x7f4c,0x8000,0x81da,0x8266,0x85fb,0x85f9, /* 0xC4A0-0xC4A7 */
	0x8611,0x85fa,0x8606,0x860b,0x8607,0x860a,0x8814,0x8815, /* 0xC4A8-0xC4AF */
	0x8964,0x89ba,0x89f8,0x8b70,0x8b6c,0x8b66,0x8b6f,0x8b5f, /* 0xC4B0-0xC4B7 */
	0x8b6b,0x8d0f,0x8d0d,0x8e89,0x8e81,0x8e85,0x8e82,0x91b4, /* 0xC4B8-0xC4BF */
	/* codebase=0xc4c0 rawbase=0x3340 */
	0x91cb,0x9418,0x9403,0x93fd,0x95e1,0x9730,0x98c4,0x9952, /* 0xC4C0-0xC4C7 */
	0x9951,0x99a8,0x9a2b,0x9a30,0x9a37,0x9a35,0x9c13,0x9c0d, /* 0xC4C8-0xC4CF */
	0x9e79,0x9eb5,0x9ee8,0x9f2f,0x9f5f,0x9f63,0x9f61,0x5137, /* 0xC4D0-0xC4D7 */
	0x5138,0x56c1,0x56c0,0x56c2,0x5914,0x5c6c,0x5dcd,0x61fc, /* 0xC4D8-0xC4DF */
	0x61fe,0x651d,0x651c,0x6595,0x66e9,0x6afb,0x6b04,0x6afa, /* 0xC4E0-0xC4E7 */
	0x6bb2,0x704c,0x721b,0x72a7,0x74d6,0x74d4,0x7669,0x77d3, /* 0xC4E8-0xC4EF */
	0x7c50,0x7e8f,0x7e8c,0x7fbc,0x8617,0x862d,0x861a,0x8823, /* 0xC4F0-0xC4F7 */
	0x8822,0x8821,0x881f,0x896a,0x896c,0x89bd,0x8b74,0x0000, /* 0xC4F8-0xC4FF */
	/* codebase=0xc540 rawbase=0x3380 */
	0x8b77,0x8b7d,0x8d13,0x8e8a,0x8e8d,0x8e8b,0x8f5f,0x8faf, /* 0xC540-0xC547 */
	0x91ba,0x942e,0x9433,0x9435,0x943a,0x9438,0x9432,0x942b, /* 0xC548-0xC54F */
	0x95e2,0x9738,0x9739,0x9732,0x97ff,0x9867,0x9865,0x9957, /* 0xC550-0xC557 */
	0x9a45,0x9a43,0x9a40,0x9a3e,0x9acf,0x9b54,0x9b51,0x9c2d, /* 0xC558-0xC55F */
	0x9c25,0x9daf,0x9db4,0x9dc2,0x9db8,0x9e9d,0x9eef,0x9f19, /* 0xC560-0xC567 */
	0x9f5c,0x9f66,0x9f67,0x513c,0x513b,0x56c8,0x56ca,0x56c9, /* 0xC568-0xC56F */
	0x5b7f,0x5dd4,0x5dd2,0x5f4e,0x61ff,0x6524,0x6b0a,0x6b61, /* 0xC570-0xC577 */
	0x7051,0x7058,0x7380,0x74e4,0x758a,0x766e,0x766c,0x0000, /* 0xC578-0xC57F */
	/* codebase=0xc580 rawbase=0x33c0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC580-0xC587 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC588-0xC58F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC590-0xC597 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC598-0xC59F */
	0x0000,0x79b3,0x7c60,0x7c5f,0x807e,0x807d,0x81df,0x8972, /* 0xC5A0-0xC5A7 */
	0x896f,0x89fc,0x8b80,0x8d16,0x8d17,0x8e91,0x8e93,0x8f61, /* 0xC5A8-0xC5AF */
	0x9148,0x9444,0x9451,0x9452,0x973d,0x973e,0x97c3,0x97c1, /* 0xC5B0-0xC5B7 */
	0x986b,0x9955,0x9a55,0x9a4d,0x9ad2,0x9b1a,0x9c49,0x9c31, /* 0xC5B8-0xC5BF */
	/* codebase=0xc5c0 rawbase=0x3400 */
	0x9c3e,0x9c3b,0x9dd3,0x9dd7,0x9f34,0x9f6c,0x9f6a,0x9f94, /* 0xC5C0-0xC5C7 */
	0x56cc,0x5dd6,0x6200,0x6523,0x652b,0x652a,0x66ec,0x6b10, /* 0xC5C8-0xC5CF */
	0x74da,0x7aca,0x7c64,0x7c63,0x7c65,0x7e93,0x7e96,0x7e94, /* 0xC5D0-0xC5D7 */
	0x81e2,0x8638,0x863f,0x8831,0x8b8a,0x9090,0x908f,0x9463, /* 0xC5D8-0xC5DF */
	0x9460,0x9464,0x9768,0x986f,0x995c,0x9a5a,0x9a5b,0x9a57, /* 0xC5E0-0xC5E7 */
	0x9ad3,0x9ad4,0x9ad1,0x9c54,0x9c57,0x9c56,0x9de5,0x9e9f, /* 0xC5E8-0xC5EF */
	0x9ef4,0x56d1,0x58e9,0x652c,0x705e,0x7671,0x7672,0x77d7, /* 0xC5F0-0xC5F7 */
	0x7f50,0x7f88,0x8836,0x8839,0x8862,0x8b93,0x8b92,0x0000, /* 0xC5F8-0xC5FF */
	/* codebase=0xc640 rawbase=0x3440 */
	0x8b96,0x8277,0x8d1b,0x91c0,0x946a,0x9742,0x9748,0x9744, /* 0xC640-0xC647 */
	0x97c6,0x9870,0x9a5f,0x9b22,0x9b58,0x9c5f,0x9df9,0x9dfa, /* 0xC648-0xC64F */
	0x9e7c,0x9e7d,0x9f07,0x9f77,0x9f72,0x5ef3,0x6b16,0x7063, /* 0xC650-0xC657 */
	0x7c6c,0x7c6e,0x883b,0x89c0,0x8ea1,0x91c1,0x9472,0x9470, /* 0xC658-0xC65F */
	0x9871,0x995e,0x9ad6,0x9b23,0x9ecc,0x7064,0x77da,0x8b9a, /* 0xC660-0xC667 */
	0x9477,0x97c9,0x9a62,0x9a65,0x7e9c,0x8b9c,0x8eaa,0x91c5, /* 0xC668-0xC66F */
	0x947d,0x947e,0x947c,0x9c77,0x9c78,0x9ef7,0x8c54,0x947f, /* 0xC670-0xC677 */
	0x9e1a,0x7228,0x9a6a,0x9b31,0x9e1b,0x9e1e,0x7c72,0x0000, /* 0xC678-0xC67F */
	/* codebase=0xc680 rawbase=0x3480 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC680-0xC687 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC688-0xC68F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC690-0xC697 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC698-0xC69F */
	0x0000,0x2460,0x2461,0x2462,0x2463,0x2464,0x2465,0x2466, /* 0xC6A0-0xC6A7 */
	0x2467,0x2468,0x2469,0x2474,0x2475,0x2476,0x2477,0x2478, /* 0xC6A8-0xC6AF */
	0x2479,0x247a,0x247b,0x247c,0x247d,0x2170,0x2171,0x2172, /* 0xC6B0-0xC6B7 */
	0x2173,0x2174,0x2175,0x2176,0x2177,0x2178,0x2179,0x2f02, /* 0xC6B8-0xC6BF */
	/* codebase=0xc6c0 rawbase=0x34c0 */
	0x2f03,0x2f05,0x2f07,0x2f0c,0x2f0d,0x2f0e,0x2f13,0x2f16, /* 0xC6C0-0xC6C7 */
	0x2f19,0x2f1b,0x2f22,0x2f27,0x2f2e,0x2f33,0x2f34,0x2f35, /* 0xC6C8-0xC6CF */
	0x2f39,0x2f3a,0x2f41,0x2f46,0x2f67,0x2f68,0x2fa1,0x2faa, /* 0xC6D0-0xC6D7 */
	0x00a8,0xff3e,0x30fd,0x30fe,0x309d,0x309e,0xf6ee,0xf6ef, /* 0xC6D8-0xC6DF */
	0x3005,0x3006,0x3007,0x30fc,0xff3b,0xff3d,0x273d,0x3041, /* 0xC6E0-0xC6E7 */
	0x3042,0x3043,0x3044,0x3045,0x3046,0x3047,0x3048,0x3049, /* 0xC6E8-0xC6EF */
	0x304a,0x304b,0x304c,0x304d,0x304e,0x304f,0x3050,0x3051, /* 0xC6F0-0xC6F7 */
	0x3052,0x3053,0x3054,0x3055,0x3056,0x3057,0x3058,0x0000, /* 0xC6F8-0xC6FF */
	/* codebase=0xc740 rawbase=0x3500 */
	0x3059,0x305a,0x305b,0x305c,0x305d,0x305e,0x305f,0x3060, /* 0xC740-0xC747 */
	0x3061,0x3062,0x3063,0x3064,0x3065,0x3066,0x3067,0x3068, /* 0xC748-0xC74F */
	0x3069,0x306a,0x306b,0x306c,0x306d,0x306e,0x306f,0x3070, /* 0xC750-0xC757 */
	0x3071,0x3072,0x3073,0x3074,0x3075,0x3076,0x3077,0x3078, /* 0xC758-0xC75F */
	0x3079,0x307a,0x307b,0x307c,0x307d,0x307e,0x307f,0x3080, /* 0xC760-0xC767 */
	0x3081,0x3082,0x3083,0x3084,0x3085,0x3086,0x3087,0x3088, /* 0xC768-0xC76F */
	0x3089,0x308a,0x308b,0x308c,0x308d,0x308e,0x308f,0x3090, /* 0xC770-0xC777 */
	0x3091,0x3092,0x3093,0x30a1,0x30a2,0x30a3,0x30a4,0x0000, /* 0xC778-0xC77F */
	/* codebase=0xc780 rawbase=0x3540 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC780-0xC787 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC788-0xC78F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC790-0xC797 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC798-0xC79F */
	0x0000,0x30a5,0x30a6,0x30a7,0x30a8,0x30a9,0x30aa,0x30ab, /* 0xC7A0-0xC7A7 */
	0x30ac,0x30ad,0x30ae,0x30af,0x30b0,0x30b1,0x30b2,0x30b3, /* 0xC7A8-0xC7AF */
	0x30b4,0x30b5,0x30b6,0x30b7,0x30b8,0x30b9,0x30ba,0x30bb, /* 0xC7B0-0xC7B7 */
	0x30bc,0x30bd,0x30be,0x30bf,0x30c0,0x30c1,0x30c2,0x30c3, /* 0xC7B8-0xC7BF */
	/* codebase=0xc7c0 rawbase=0x3580 */
	0x30c4,0x30c5,0x30c6,0x30c7,0x30c8,0x30c9,0x30ca,0x30cb, /* 0xC7C0-0xC7C7 */
	0x30cc,0x30cd,0x30ce,0x30cf,0x30d0,0x30d1,0x30d2,0x30d3, /* 0xC7C8-0xC7CF */
	0x30d4,0x30d5,0x30d6,0x30d7,0x30d8,0x30d9,0x30da,0x30db, /* 0xC7D0-0xC7D7 */
	0x30dc,0x30dd,0x30de,0x30df,0x30e0,0x30e1,0x30e2,0x30e3, /* 0xC7D8-0xC7DF */
	0x30e4,0x30e5,0x30e6,0x30e7,0x30e8,0x30e9,0x30ea,0x30eb, /* 0xC7E0-0xC7E7 */
	0x30ec,0x30ed,0x30ee,0x30ef,0x30f0,0x30f1,0x30f2,0x30f3, /* 0xC7E8-0xC7EF */
	0x30f4,0x30f5,0x30f6,0x0410,0x0411,0x0412,0x0413,0x0414, /* 0xC7F0-0xC7F7 */
	0x0415,0x0401,0x0416,0x0417,0x0418,0x0419,0x041a,0x0000, /* 0xC7F8-0xC7FF */
	/* codebase=0xc840 rawbase=0x35c0 */
	0x041b,0x041c,0x041d,0x041e,0x041f,0x0420,0x0421,0x0422, /* 0xC840-0xC847 */
	0x0423,0x0424,0x0425,0x0426,0x0427,0x0428,0x0429,0x042a, /* 0xC848-0xC84F */
	0x042b,0x042c,0x042d,0x042e,0x042f,0x0430,0x0431,0x0432, /* 0xC850-0xC857 */
	0x0433,0x0434,0x0435,0x0451,0x0436,0x0437,0x0438,0x0439, /* 0xC858-0xC85F */
	0x043a,0x043b,0x043c,0x043d,0x043e,0x043f,0x0440,0x0441, /* 0xC860-0xC867 */
	0x0442,0x0443,0x0444,0x0445,0x0446,0x0447,0x0448,0x0449, /* 0xC868-0xC86F */
	0x044a,0x044b,0x044c,0x044d,0x044e,0x044f,0x21e7,0x21b8, /* 0xC870-0xC877 */
	0x21b9,0xf7e5,0xf7e6,0xf7e7,0xf7e8,0xf7e9,0xf7ea,0x0000, /* 0xC878-0xC87F */
	/* codebase=0xc880 rawbase=0x3600 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC880-0xC887 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC888-0xC88F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC890-0xC897 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC898-0xC89F */
	0x0000,0xf7eb,0xf7ec,0xf7ed,0xf7ee,0xf7ef,0xf7f0,0xf7f1, /* 0xC8A0-0xC8A7 */
	0xf7f2,0xf7f3,0xf7f4,0xf7f5,0xf7f6,0xf7f7,0xf7f8,0xf7f9, /* 0xC8A8-0xC8AF */
	0xf7fa,0xf7fb,0xf7fc,0xf7fd,0xf7fe,0xf7ff,0xf800,0xf801, /* 0xC8B0-0xC8B7 */
	0xf802,0xf803,0xf804,0xf805,0xf806,0xf807,0xf808,0xf809, /* 0xC8B8-0xC8BF */
	/* codebase=0xc8c0 rawbase=0x3640 */
	0xf80a,0xf80b,0xf80c,0xf80d,0xf80e,0xf80f,0xf810,0xf811, /* 0xC8C0-0xC8C7 */
	0xf812,0xf813,0xf814,0xf815,0xf816,0xf817,0xf818,0xf819, /* 0xC8C8-0xC8CF */
	0xf81a,0xf81b,0xf81c,0xf81d,0xf81e,0xf81f,0xf820,0xf821, /* 0xC8D0-0xC8D7 */
	0xf822,0xf823,0xf824,0xf825,0xf826,0xf827,0xf828,0xf829, /* 0xC8D8-0xC8DF */
	0xf82a,0xf82b,0xf82c,0xf82d,0xf82e,0xf82f,0xf830,0xf831, /* 0xC8E0-0xC8E7 */
	0xf832,0xf833,0xf834,0xf835,0xf836,0xf837,0xf838,0xf839, /* 0xC8E8-0xC8EF */
	0xf83a,0xf83b,0xf83c,0xf83d,0xf83e,0xf83f,0xf840,0xf841, /* 0xC8F0-0xC8F7 */
	0xf842,0xf843,0xf844,0xf845,0xf846,0xf847,0xf848,0x0000, /* 0xC8F8-0xC8FF */
	/* codebase=0xc940 rawbase=0x3680 */
	0x4e42,0x4e5c,0x51f5,0x531a,0x5382,0x4e07,0x4e0c,0x4e47, /* 0xC940-0xC947 */
	0x4e8d,0x56d7,0xfa0c,0x5c6e,0x5f73,0x4e0f,0x5187,0x4e0e, /* 0xC948-0xC94F */
	0x4e2e,0x4e93,0x4ec2,0x4ec9,0x4ec8,0x5198,0x52fc,0x536c, /* 0xC950-0xC957 */
	0x53b9,0x5720,0x5903,0x592c,0x5c10,0x5dff,0x65e1,0x6bb3, /* 0xC958-0xC95F */
	0x6bcc,0x6c14,0x723f,0x4e31,0x4e3c,0x4ee8,0x4edc,0x4ee9, /* 0xC960-0xC967 */
	0x4ee1,0x4edd,0x4eda,0x520c,0x531c,0x534c,0x5722,0x5723, /* 0xC968-0xC96F */
	0x5917,0x592f,0x5b81,0x5b84,0x5c12,0x5c3b,0x5c74,0x5c73, /* 0xC970-0xC977 */
	0x5e04,0x5e80,0x5e82,0x5fc9,0x6209,0x6250,0x6c15,0x0000, /* 0xC978-0xC97F */
	/* codebase=0xc980 rawbase=0x36c0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC980-0xC987 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC988-0xC98F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC990-0xC997 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC998-0xC99F */
	0x0000,0x6c36,0x6c43,0x6c3f,0x6c3b,0x72ae,0x72b0,0x738a, /* 0xC9A0-0xC9A7 */
	0x79b8,0x808a,0x961e,0x4f0e,0x4f18,0x4f2c,0x4ef5,0x4f14, /* 0xC9A8-0xC9AF */
	0x4ef1,0x4f00,0x4ef7,0x4f08,0x4f1d,0x4f02,0x4f05,0x4f22, /* 0xC9B0-0xC9B7 */
	0x4f13,0x4f04,0x4ef4,0x4f12,0x51b1,0x5213,0x5209,0x5210, /* 0xC9B8-0xC9BF */
	/* codebase=0xc9c0 rawbase=0x3700 */
	0x52a6,0x5322,0x531f,0x534d,0x538a,0x5407,0x56e1,0x56df, /* 0xC9C0-0xC9C7 */
	0x572e,0x572a,0x5734,0x593c,0x5980,0x597c,0x5985,0x597b, /* 0xC9C8-0xC9CF */
	0x597e,0x5977,0x597f,0x5b56,0x5c15,0x5c25,0x5c7c,0x5c7a, /* 0xC9D0-0xC9D7 */
	0x5c7b,0x5c7e,0x5ddf,0x5e75,0x5e84,0x5f02,0x5f1a,0x5f74, /* 0xC9D8-0xC9DF */
	0x5fd5,0x5fd4,0x5fcf,0x625c,0x625e,0x6264,0x6261,0x6266, /* 0xC9E0-0xC9E7 */
	0x6262,0x6259,0x6260,0x625a,0x6265,0x65ef,0x65ee,0x673e, /* 0xC9E8-0xC9EF */
	0x6739,0x6738,0x673b,0x673a,0x673f,0x673c,0x6733,0x6c18, /* 0xC9F0-0xC9F7 */
	0x6c46,0x6c52,0x6c5c,0x6c4f,0x6c4a,0x6c54,0x6c4b,0x0000, /* 0xC9F8-0xC9FF */
	/* codebase=0xca40 rawbase=0x3740 */
	0x6c4c,0x7071,0x725e,0x72b4,0x72b5,0x738e,0x752a,0x767f, /* 0xCA40-0xCA47 */
	0x7a75,0x7f51,0x8278,0x827c,0x8280,0x827d,0x827f,0x864d, /* 0xCA48-0xCA4F */
	0x897e,0x9099,0x9097,0x9098,0x909b,0x9094,0x9622,0x9624, /* 0xCA50-0xCA57 */
	0x9620,0x9623,0x4f56,0x4f3b,0x4f62,0x4f49,0x4f53,0x4f64, /* 0xCA58-0xCA5F */
	0x4f3e,0x4f67,0x4f52,0x4f5f,0x4f41,0x4f58,0x4f2d,0x4f33, /* 0xCA60-0xCA67 */
	0x4f3f,0x4f61,0x518f,0x51b9,0x521c,0x521e,0x5221,0x52ad, /* 0xCA68-0xCA6F */
	0x52ae,0x5309,0x5363,0x5372,0x538e,0x538f,0x5430,0x5437, /* 0xCA70-0xCA77 */
	0x542a,0x5454,0x5445,0x5419,0x541c,0x5425,0x5418,0x0000, /* 0xCA78-0xCA7F */
	/* codebase=0xca80 rawbase=0x3780 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xCA80-0xCA87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xCA88-0xCA8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xCA90-0xCA97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xCA98-0xCA9F */
	0x0000,0x543d,0x544f,0x5441,0x5428,0x5424,0x5447,0x56ee, /* 0xCAA0-0xCAA7 */
	0x56e7,0x56e5,0x5741,0x5745,0x574c,0x5749,0x574b,0x5752, /* 0xCAA8-0xCAAF */
	0x5906,0x5940,0x59a6,0x5998,0x59a0,0x5997,0x598e,0x59a2, /* 0xCAB0-0xCAB7 */
	0x5990,0x598f,0x59a7,0x59a1,0x5b8e,0x5b92,0x5c28,0x5c2a, /* 0xCAB8-0xCABF */
	/* codebase=0xcac0 rawbase=0x37c0 */
	0x5c8d,0x5c8f,0x5c88,0x5c8b,0x5c89,0x5c92,0x5c8a,0x5c86, /* 0xCAC0-0xCAC7 */
	0x5c93,0x5c95,0x5de0,0x5e0a,0x5e0e,0x5e8b,0x5e89,0x5e8c, /* 0xCAC8-0xCACF */
	0x5e88,0x5e8d,0x5f05,0x5f1d,0x5f78,0x5f76,0x5fd2,0x5fd1, /* 0xCAD0-0xCAD7 */
	0x5fd0,0x5fed,0x5fe8,0x5fee,0x5ff3,0x5fe1,0x5fe4,0x5fe3, /* 0xCAD8-0xCADF */
	0x5ffa,0x5fef,0x5ff7,0x5ffb,0x6000,0x5ff4,0x623a,0x6283, /* 0xCAE0-0xCAE7 */
	0x628c,0x628e,0x628f,0x6294,0x6287,0x6271,0x627b,0x627a, /* 0xCAE8-0xCAEF */
	0x6270,0x6281,0x6288,0x6277,0x627d,0x6272,0x6274,0x6537, /* 0xCAF0-0xCAF7 */
	0x65f0,0x65f4,0x65f3,0x65f2,0x65f5,0x6745,0x6747,0x0000, /* 0xCAF8-0xCAFF */
	/* codebase=0xcb40 rawbase=0x3800 */
	0x6759,0x6755,0x674c,0x6748,0x675d,0x674d,0x675a,0x674b, /* 0xCB40-0xCB47 */
	0x6bd0,0x6c19,0x6c1a,0x6c78,0x6c67,0x6c6b,0x6c84,0x6c8b, /* 0xCB48-0xCB4F */
	0x6c8f,0x6c71,0x6c6f,0x6c69,0x6c9a,0x6c6d,0x6c87,0x6c95, /* 0xCB50-0xCB57 */
	0x6c9c,0x6c66,0x6c73,0x6c65,0x6c7b,0x6c8e,0x7074,0x707a, /* 0xCB58-0xCB5F */
	0x7263,0x72bf,0x72bd,0x72c3,0x72c6,0x72c1,0x72ba,0x72c5, /* 0xCB60-0xCB67 */
	0x7395,0x7397,0x7393,0x7394,0x7392,0x753a,0x7539,0x7594, /* 0xCB68-0xCB6F */
	0x7595,0x7681,0x793d,0x8034,0x8095,0x8099,0x8090,0x8092, /* 0xCB70-0xCB77 */
	0x809c,0x8290,0x828f,0x8285,0x828e,0x8291,0x8293,0x0000, /* 0xCB78-0xCB7F */
	/* codebase=0xcb80 rawbase=0x3840 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xCB80-0xCB87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xCB88-0xCB8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xCB90-0xCB97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xCB98-0xCB9F */
	0x0000,0x828a,0x8283,0x8284,0x8c78,0x8fc9,0x8fbf,0x909f, /* 0xCBA0-0xCBA7 */
	0x90a1,0x90a5,0x909e,0x90a7,0x90a0,0x9630,0x9628,0x962f, /* 0xCBA8-0xCBAF */
	0x962d,0x4e33,0x4f98,0x4f7c,0x4f85,0x4f7d,0x4f80,0x4f87, /* 0xCBB0-0xCBB7 */
	0x4f76,0x4f74,0x4f89,0x4f84,0x4f77,0x4f4c,0x4f97,0x4f6a, /* 0xCBB8-0xCBBF */
	/* codebase=0xcbc0 rawbase=0x3880 */
	0x4f9a,0x4f79,0x4f81,0x4f78,0x4f90,0x4f9c,0x4f94,0x4f9e, /* 0xCBC0-0xCBC7 */
	0x4f92,0x4f82,0x4f95,0x4f6b,0x4f6e,0x519e,0x51bc,0x51be, /* 0xCBC8-0xCBCF */
	0x5235,0x5232,0x5233,0x5246,0x5231,0x52bc,0x530a,0x530b, /* 0xCBD0-0xCBD7 */
	0x533c,0x5392,0x5394,0x5487,0x547f,0x5481,0x5491,0x5482, /* 0xCBD8-0xCBDF */
	0x5488,0x546b,0x547a,0x547e,0x5465,0x546c,0x5474,0x5466, /* 0xCBE0-0xCBE7 */
	0x548d,0x546f,0x5461,0x5460,0x5498,0x5463,0x5467,0x5464, /* 0xCBE8-0xCBEF */
	0x56f7,0x56f9,0x576f,0x5772,0x576d,0x576b,0x5771,0x5770, /* 0xCBF0-0xCBF7 */
	0x5776,0x5780,0x5775,0x577b,0x5773,0x5774,0x5762,0x0000, /* 0xCBF8-0xCBFF */
	/* codebase=0xcc40 rawbase=0x38c0 */
	0x5768,0x577d,0x590c,0x5945,0x59b5,0x59ba,0x59cf,0x59ce, /* 0xCC40-0xCC47 */
	0x59b2,0x59cc,0x59c1,0x59b6,0x59bc,0x59c3,0x59d6,0x59b1, /* 0xCC48-0xCC4F */
	0x59bd,0x59c0,0x59c8,0x59b4,0x59c7,0x5b62,0x5b65,0x5b93, /* 0xCC50-0xCC57 */
	0x5b95,0x5c44,0x5c47,0x5cae,0x5ca4,0x5ca0,0x5cb5,0x5caf, /* 0xCC58-0xCC5F */
	0x5ca8,0x5cac,0x5c9f,0x5ca3,0x5cad,0x5ca2,0x5caa,0x5ca7, /* 0xCC60-0xCC67 */
	0x5c9d,0x5ca5,0x5cb6,0x5cb0,0x5ca6,0x5e17,0x5e14,0x5e19, /* 0xCC68-0xCC6F */
	0x5f28,0x5f22,0x5f23,0x5f24,0x5f54,0x5f82,0x5f7e,0x5f7d, /* 0xCC70-0xCC77 */
	0x5fde,0x5fe5,0x602d,0x6026,0x6019,0x6032,0x600b,0x0000, /* 0xCC78-0xCC7F */
	/* codebase=0xcc80 rawbase=0x3900 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xCC80-0xCC87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xCC88-0xCC8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xCC90-0xCC97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xCC98-0xCC9F */
	0x0000,0x6034,0x600a,0x6017,0x6033,0x601a,0x601e,0x602c, /* 0xCCA0-0xCCA7 */
	0x6022,0x600d,0x6010,0x602e,0x6013,0x6011,0x600c,0x6009, /* 0xCCA8-0xCCAF */
	0x601c,0x6214,0x623d,0x62ad,0x62b4,0x62d1,0x62be,0x62aa, /* 0xCCB0-0xCCB7 */
	0x62b6,0x62ca,0x62ae,0x62b3,0x62af,0x62bb,0x62a9,0x62b0, /* 0xCCB8-0xCCBF */
	/* codebase=0xccc0 rawbase=0x3940 */
	0x62b8,0x653d,0x65a8,0x65bb,0x6609,0x65fc,0x6604,0x6612, /* 0xCCC0-0xCCC7 */
	0x6608,0x65fb,0x6603,0x660b,0x660d,0x6605,0x65fd,0x6611, /* 0xCCC8-0xCCCF */
	0x6610,0x66f6,0x670a,0x6785,0x676c,0x678e,0x6792,0x6776, /* 0xCCD0-0xCCD7 */
	0x677b,0x6798,0x6786,0x6784,0x6774,0x678d,0x678c,0x677a, /* 0xCCD8-0xCCDF */
	0x679f,0x6791,0x6799,0x6783,0x677d,0x6781,0x6778,0x6779, /* 0xCCE0-0xCCE7 */
	0x6794,0x6b25,0x6b80,0x6b7e,0x6bde,0x6c1d,0x6c93,0x6cec, /* 0xCCE8-0xCCEF */
	0x6ceb,0x6cee,0x6cd9,0x6cb6,0x6cd4,0x6cad,0x6ce7,0x6cb7, /* 0xCCF0-0xCCF7 */
	0x6cd0,0x6cc2,0x6cba,0x6cc3,0x6cc6,0x6ced,0x6cf2,0x0000, /* 0xCCF8-0xCCFF */
	/* codebase=0xcd40 rawbase=0x3980 */
	0x6cd2,0x6cdd,0x6cb4,0x6c8a,0x6c9d,0x6c80,0x6cde,0x6cc0, /* 0xCD40-0xCD47 */
	0x6d30,0x6ccd,0x6cc7,0x6cb0,0x6cf9,0x6ccf,0x6ce9,0x6cd1, /* 0xCD48-0xCD4F */
	0x7094,0x7098,0x7085,0x7093,0x7086,0x7084,0x7091,0x7096, /* 0xCD50-0xCD57 */
	0x7082,0x709a,0x7083,0x726a,0x72d6,0x72cb,0x72d8,0x72c9, /* 0xCD58-0xCD5F */
	0x72dc,0x72d2,0x72d4,0x72da,0x72cc,0x72d1,0x73a4,0x73a1, /* 0xCD60-0xCD67 */
	0x73ad,0x73a6,0x73a2,0x73a0,0x73ac,0x739d,0x74dd,0x74e8, /* 0xCD68-0xCD6F */
	0x753f,0x7540,0x753e,0x758c,0x7598,0x76af,0x76f3,0x76f1, /* 0xCD70-0xCD77 */
	0x76f0,0x76f5,0x77f8,0x77fc,0x77f9,0x77fb,0x77fa,0x0000, /* 0xCD78-0xCD7F */
	/* codebase=0xcd80 rawbase=0x39c0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xCD80-0xCD87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xCD88-0xCD8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xCD90-0xCD97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xCD98-0xCD9F */
	0x0000,0x77f7,0x7942,0x793f,0x79c5,0x7a78,0x7a7b,0x7afb, /* 0xCDA0-0xCDA7 */
	0x7c75,0x7cfd,0x8035,0x808f,0x80ae,0x80a3,0x80b8,0x80b5, /* 0xCDA8-0xCDAF */
	0x80ad,0x8220,0x82a0,0x82c0,0x82ab,0x829a,0x8298,0x829b, /* 0xCDB0-0xCDB7 */
	0x82b5,0x82a7,0x82ae,0x82bc,0x829e,0x82ba,0x82b4,0x82a8, /* 0xCDB8-0xCDBF */
	/* codebase=0xcdc0 rawbase=0x3a00 */
	0x82a1,0x82a9,0x82c2,0x82a4,0x82c3,0x82b6,0x82a2,0x8670, /* 0xCDC0-0xCDC7 */
	0x866f,0x866d,0x866e,0x8c56,0x8fd2,0x8fcb,0x8fd3,0x8fcd, /* 0xCDC8-0xCDCF */
	0x8fd6,0x8fd5,0x8fd7,0x90b2,0x90b4,0x90af,0x90b3,0x90b0, /* 0xCDD0-0xCDD7 */
	0x9639,0x963d,0x963c,0x963a,0x9643,0x4fcd,0x4fc5,0x4fd3, /* 0xCDD8-0xCDDF */
	0x4fb2,0x4fc9,0x4fcb,0x4fc1,0x4fd4,0x4fdc,0x4fd9,0x4fbb, /* 0xCDE0-0xCDE7 */
	0x4fb3,0x4fdb,0x4fc7,0x4fd6,0x4fba,0x4fc0,0x4fb9,0x4fec, /* 0xCDE8-0xCDEF */
	0x5244,0x5249,0x52c0,0x52c2,0x533d,0x537c,0x5397,0x5396, /* 0xCDF0-0xCDF7 */
	0x5399,0x5398,0x54ba,0x54a1,0x54ad,0x54a5,0x54cf,0x0000, /* 0xCDF8-0xCDFF */
	/* codebase=0xce40 rawbase=0x3a40 */
	0x54c3,0x830d,0x54b7,0x54ae,0x54d6,0x54b6,0x54c5,0x54c6, /* 0xCE40-0xCE47 */
	0x54a0,0x5470,0x54bc,0x54a2,0x54be,0x5472,0x54de,0x54b0, /* 0xCE48-0xCE4F */
	0x57b5,0x579e,0x579f,0x57a4,0x578c,0x5797,0x579d,0x579b, /* 0xCE50-0xCE57 */
	0x5794,0x5798,0x578f,0x5799,0x57a5,0x579a,0x5795,0x58f4, /* 0xCE58-0xCE5F */
	0x590d,0x5953,0x59e1,0x59de,0x59ee,0x5a00,0x59f1,0x59dd, /* 0xCE60-0xCE67 */
	0x59fa,0x59fd,0x59fc,0x59f6,0x59e4,0x59f2,0x59f7,0x59db, /* 0xCE68-0xCE6F */
	0x59e9,0x59f3,0x59f5,0x59e0,0x59fe,0x59f4,0x59ed,0x5ba8, /* 0xCE70-0xCE77 */
	0x5c4c,0x5cd0,0x5cd8,0x5ccc,0x5cd7,0x5ccb,0x5cdb,0x0000, /* 0xCE78-0xCE7F */
	/* codebase=0xce80 rawbase=0x3a80 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xCE80-0xCE87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xCE88-0xCE8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xCE90-0xCE97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xCE98-0xCE9F */
	0x0000,0x5cde,0x5cda,0x5cc9,0x5cc7,0x5cca,0x5cd6,0x5cd3, /* 0xCEA0-0xCEA7 */
	0x5cd4,0x5ccf,0x5cc8,0x5cc6,0x5cce,0x5cdf,0x5cf8,0x5df9, /* 0xCEA8-0xCEAF */
	0x5e21,0x5e22,0x5e23,0x5e20,0x5e24,0x5eb0,0x5ea4,0x5ea2, /* 0xCEB0-0xCEB7 */
	0x5e9b,0x5ea3,0x5ea5,0x5f07,0x5f2e,0x5f56,0x5f86,0x6037, /* 0xCEB8-0xCEBF */
	/* codebase=0xcec0 rawbase=0x3ac0 */
	0x6039,0x6054,0x6072,0x605e,0x6045,0x6053,0x6047,0x6049, /* 0xCEC0-0xCEC7 */
	0x605b,0x604c,0x6040,0x6042,0x605f,0x6024,0x6044,0x6058, /* 0xCEC8-0xCECF */
	0x6066,0x606e,0x6242,0x6243,0x62cf,0x630d,0x630b,0x62f5, /* 0xCED0-0xCED7 */
	0x630e,0x6303,0x62eb,0x62f9,0x630f,0x630c,0x62f8,0x62f6, /* 0xCED8-0xCEDF */
	0x6300,0x6313,0x6314,0x62fa,0x6315,0x62fb,0x62f0,0x6541, /* 0xCEE0-0xCEE7 */
	0x6543,0x65aa,0x65bf,0x6636,0x6621,0x6632,0x6635,0x661c, /* 0xCEE8-0xCEEF */
	0x6626,0x6622,0x6633,0x662b,0x663a,0x661d,0x6634,0x6639, /* 0xCEF0-0xCEF7 */
	0x662e,0x670f,0x6710,0x67c1,0x67f2,0x67c8,0x67ba,0x0000, /* 0xCEF8-0xCEFF */
	/* codebase=0xcf40 rawbase=0x3b00 */
	0x67dc,0x67bb,0x67f8,0x67d8,0x67c0,0x67b7,0x67c5,0x67eb, /* 0xCF40-0xCF47 */
	0x67e4,0x67df,0x67b5,0x67cd,0x67b3,0x67f7,0x67f6,0x67ee, /* 0xCF48-0xCF4F */
	0x67e3,0x67c2,0x67b9,0x67ce,0x67e7,0x67f0,0x67b2,0x67fc, /* 0xCF50-0xCF57 */
	0x67c6,0x67ed,0x67cc,0x67ae,0x67e6,0x67db,0x67fa,0x67c9, /* 0xCF58-0xCF5F */
	0x67ca,0x67c3,0x67ea,0x67cb,0x6b28,0x6b82,0x6b84,0x6bb6, /* 0xCF60-0xCF67 */
	0x6bd6,0x6bd8,0x6be0,0x6c20,0x6c21,0x6d28,0x6d34,0x6d2d, /* 0xCF68-0xCF6F */
	0x6d1f,0x6d3c,0x6d3f,0x6d12,0x6d0a,0x6cda,0x6d33,0x6d04, /* 0xCF70-0xCF77 */
	0x6d19,0x6d3a,0x6d1a,0x6d11,0x6d00,0x6d1d,0x6d42,0x0000, /* 0xCF78-0xCF7F */
	/* codebase=0xcf80 rawbase=0x3b40 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xCF80-0xCF87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xCF88-0xCF8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xCF90-0xCF97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xCF98-0xCF9F */
	0x0000,0x6d01,0x6d18,0x6d37,0x6d03,0x6d0f,0x6d40,0x6d07, /* 0xCFA0-0xCFA7 */
	0x6d20,0x6d2c,0x6d08,0x6d22,0x6d09,0x6d10,0x70b7,0x709f, /* 0xCFA8-0xCFAF */
	0x70be,0x70b1,0x70b0,0x70a1,0x70b4,0x70b5,0x70a9,0x7241, /* 0xCFB0-0xCFB7 */
	0x7249,0x724a,0x726c,0x7270,0x7273,0x726e,0x72ca,0x72e4, /* 0xCFB8-0xCFBF */
	/* codebase=0xcfc0 rawbase=0x3b80 */
	0x72e8,0x72eb,0x72df,0x72ea,0x72e6,0x72e3,0x7385,0x73cc, /* 0xCFC0-0xCFC7 */
	0x73c2,0x73c8,0x73c5,0x73b9,0x73b6,0x73b5,0x73b4,0x73eb, /* 0xCFC8-0xCFCF */
	0x73bf,0x73c7,0x73be,0x73c3,0x73c6,0x73b8,0x73cb,0x74ec, /* 0xCFD0-0xCFD7 */
	0x74ee,0x752e,0x7547,0x7548,0x75a7,0x75aa,0x7679,0x76c4, /* 0xCFD8-0xCFDF */
	0x7708,0x7703,0x7704,0x7705,0x770a,0x76f7,0x76fb,0x76fa, /* 0xCFE0-0xCFE7 */
	0x77e7,0x77e8,0x7806,0x7811,0x7812,0x7805,0x7810,0x780f, /* 0xCFE8-0xCFEF */
	0x780e,0x7809,0x7803,0x7813,0x794a,0x794c,0x794b,0x7945, /* 0xCFF0-0xCFF7 */
	0x7944,0x79d5,0x79cd,0x79cf,0x79d6,0x79ce,0x7a80,0x0000, /* 0xCFF8-0xCFFF */
	/* codebase=0xd040 rawbase=0x3bc0 */
	0x7a7e,0x7ad1,0x7b00,0x7b01,0x7c7a,0x7c78,0x7c79,0x7c7f, /* 0xD040-0xD047 */
	0x7c80,0x7c81,0x7d03,0x7d08,0x7d01,0x7f58,0x7f91,0x7f8d, /* 0xD048-0xD04F */
	0x7fbe,0x8007,0x800e,0x800f,0x8014,0x8037,0x80d8,0x80c7, /* 0xD050-0xD057 */
	0x80e0,0x80d1,0x80c8,0x80c2,0x80d0,0x80c5,0x80e3,0x80d9, /* 0xD058-0xD05F */
	0x80dc,0x80ca,0x80d5,0x80c9,0x80cf,0x80d7,0x80e6,0x80cd, /* 0xD060-0xD067 */
	0x81ff,0x8221,0x8294,0x82d9,0x82fe,0x82f9,0x8307,0x82e8, /* 0xD068-0xD06F */
	0x8300,0x82d5,0x833a,0x82eb,0x82d6,0x82f4,0x82ec,0x82e1, /* 0xD070-0xD077 */
	0x82f2,0x82f5,0x830c,0x82fb,0x82f6,0x82f0,0x82ea,0x0000, /* 0xD078-0xD07F */
	/* codebase=0xd080 rawbase=0x3c00 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD080-0xD087 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD088-0xD08F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD090-0xD097 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD098-0xD09F */
	0x0000,0x82e4,0x82e0,0x82fa,0x82f3,0x82ed,0x8677,0x8674, /* 0xD0A0-0xD0A7 */
	0x867c,0x8673,0x8841,0x884e,0x8867,0x886a,0x8869,0x89d3, /* 0xD0A8-0xD0AF */
	0x8a04,0x8a07,0x8d72,0x8fe3,0x8fe1,0x8fee,0x8fe0,0x90f1, /* 0xD0B0-0xD0B7 */
	0x90bd,0x90bf,0x90d5,0x90c5,0x90be,0x90c7,0x90cb,0x90c8, /* 0xD0B8-0xD0BF */
	/* codebase=0xd0c0 rawbase=0x3c40 */
	0x91d4,0x91d3,0x9654,0x964f,0x9651,0x9653,0x964a,0x964e, /* 0xD0C0-0xD0C7 */
	0x501e,0x5005,0x5007,0x5013,0x5022,0x5030,0x501b,0x4ff5, /* 0xD0C8-0xD0CF */
	0x4ff4,0x5033,0x5037,0x502c,0x4ff6,0x4ff7,0x5017,0x501c, /* 0xD0D0-0xD0D7 */
	0x5020,0x5027,0x5035,0x502f,0x5031,0x500e,0x515a,0x5194, /* 0xD0D8-0xD0DF */
	0x5193,0x51ca,0x51c4,0x51c5,0x51c8,0x51ce,0x5261,0x525a, /* 0xD0E0-0xD0E7 */
	0x5252,0x525e,0x525f,0x5255,0x5262,0x52cd,0x530e,0x539e, /* 0xD0E8-0xD0EF */
	0x5526,0x54e2,0x5517,0x5512,0x54e7,0x54f3,0x54e4,0x551a, /* 0xD0F0-0xD0F7 */
	0x54ff,0x5504,0x5508,0x54eb,0x5511,0x5505,0x54f1,0x0000, /* 0xD0F8-0xD0FF */
	/* codebase=0xd140 rawbase=0x3c80 */
	0x550a,0x54fb,0x54f7,0x54f8,0x54e0,0x550e,0x5503,0x550b, /* 0xD140-0xD147 */
	0x5701,0x5702,0x57cc,0x5832,0x57d5,0x57d2,0x57ba,0x57c6, /* 0xD148-0xD14F */
	0x57bd,0x57bc,0x57b8,0x57b6,0x57bf,0x57c7,0x57d0,0x57b9, /* 0xD150-0xD157 */
	0x57c1,0x590e,0x594a,0x5a19,0x5a16,0x5a2d,0x5a2e,0x5a15, /* 0xD158-0xD15F */
	0x5a0f,0x5a17,0x5a0a,0x5a1e,0x5a33,0x5b6c,0x5ba7,0x5bad, /* 0xD160-0xD167 */
	0x5bac,0x5c03,0x5c56,0x5c54,0x5cec,0x5cff,0x5cee,0x5cf1, /* 0xD168-0xD16F */
	0x5cf7,0x5d00,0x5cf9,0x5e29,0x5e28,0x5ea8,0x5eae,0x5eaa, /* 0xD170-0xD177 */
	0x5eac,0x5f33,0x5f30,0x5f67,0x605d,0x605a,0x6067,0x0000, /* 0xD178-0xD17F */
	/* codebase=0xd180 rawbase=0x3cc0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD180-0xD187 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD188-0xD18F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD190-0xD197 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD198-0xD19F */
	0x0000,0x6041,0x60a2,0x6088,0x6080,0x6092,0x6081,0x609d, /* 0xD1A0-0xD1A7 */
	0x6083,0x6095,0x609b,0x6097,0x6087,0x609c,0x608e,0x6219, /* 0xD1A8-0xD1AF */
	0x6246,0x62f2,0x6310,0x6356,0x632c,0x6344,0x6345,0x6336, /* 0xD1B0-0xD1B7 */
	0x6343,0x63e4,0x6339,0x634b,0x634a,0x633c,0x6329,0x6341, /* 0xD1B8-0xD1BF */
	/* codebase=0xd1c0 rawbase=0x3d00 */
	0x6334,0x6358,0x6354,0x6359,0x632d,0x6347,0x6333,0x635a, /* 0xD1C0-0xD1C7 */
	0x6351,0x6338,0x6357,0x6340,0x6348,0x654a,0x6546,0x65c6, /* 0xD1C8-0xD1CF */
	0x65c3,0x65c4,0x65c2,0x664a,0x665f,0x6647,0x6651,0x6712, /* 0xD1D0-0xD1D7 */
	0x6713,0x681f,0x681a,0x6849,0x6832,0x6833,0x683b,0x684b, /* 0xD1D8-0xD1DF */
	0x684f,0x6816,0x6831,0x681c,0x6835,0x682b,0x682d,0x682f, /* 0xD1E0-0xD1E7 */
	0x684e,0x6844,0x6834,0x681d,0x6812,0x6814,0x6826,0x6828, /* 0xD1E8-0xD1EF */
	0x682e,0x684d,0x683a,0x6825,0x6820,0x6b2c,0x6b2f,0x6b2d, /* 0xD1F0-0xD1F7 */
	0x6b31,0x6b34,0x6b6d,0x8082,0x6b88,0x6be6,0x6be4,0x0000, /* 0xD1F8-0xD1FF */
	/* codebase=0xd240 rawbase=0x3d40 */
	0x6be8,0x6be3,0x6be2,0x6be7,0x6c25,0x6d7a,0x6d63,0x6d64, /* 0xD240-0xD247 */
	0x6d76,0x6d0d,0x6d61,0x6d92,0x6d58,0x6d62,0x6d6d,0x6d6f, /* 0xD248-0xD24F */
	0x6d91,0x6d8d,0x6def,0x6d7f,0x6d86,0x6d5e,0x6d67,0x6d60, /* 0xD250-0xD257 */
	0x6d97,0x6d70,0x6d7c,0x6d5f,0x6d82,0x6d98,0x6d2f,0x6d68, /* 0xD258-0xD25F */
	0x6d8b,0x6d7e,0x6d80,0x6d84,0x6d16,0x6d83,0x6d7b,0x6d7d, /* 0xD260-0xD267 */
	0x6d75,0x6d90,0x70dc,0x70d3,0x70d1,0x70dd,0x70cb,0x7f39, /* 0xD268-0xD26F */
	0x70e2,0x70d7,0x70d2,0x70de,0x70e0,0x70d4,0x70cd,0x70c5, /* 0xD270-0xD277 */
	0x70c6,0x70c7,0x70da,0x70ce,0x70e1,0x7242,0x7278,0x0000, /* 0xD278-0xD27F */
	/* codebase=0xd280 rawbase=0x3d80 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD280-0xD287 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD288-0xD28F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD290-0xD297 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD298-0xD29F */
	0x0000,0x7277,0x7276,0x7300,0x72fa,0x72f4,0x72fe,0x72f6, /* 0xD2A0-0xD2A7 */
	0x72f3,0x72fb,0x7301,0x73d3,0x73d9,0x73e5,0x73d6,0x73bc, /* 0xD2A8-0xD2AF */
	0x73e7,0x73e3,0x73e9,0x73dc,0x73d2,0x73db,0x73d4,0x73dd, /* 0xD2B0-0xD2B7 */
	0x73da,0x73d7,0x73d8,0x73e8,0x74de,0x74df,0x74f4,0x74f5, /* 0xD2B8-0xD2BF */
	/* codebase=0xd2c0 rawbase=0x3dc0 */
	0x7521,0x755b,0x755f,0x75b0,0x75c1,0x75bb,0x75c4,0x75c0, /* 0xD2C0-0xD2C7 */
	0x75bf,0x75b6,0x75ba,0x768a,0x76c9,0x771d,0x771b,0x7710, /* 0xD2C8-0xD2CF */
	0x7713,0x7712,0x7723,0x7711,0x7715,0x7719,0x771a,0x7722, /* 0xD2D0-0xD2D7 */
	0x7727,0x7823,0x782c,0x7822,0x7835,0x782f,0x7828,0x782e, /* 0xD2D8-0xD2DF */
	0x782b,0x7821,0x7829,0x7833,0x782a,0x7831,0x7954,0x795b, /* 0xD2E0-0xD2E7 */
	0x794f,0x795c,0x7953,0x7952,0x7951,0x79eb,0x79ec,0x79e0, /* 0xD2E8-0xD2EF */
	0x79ee,0x79ed,0x79ea,0x79dc,0x79de,0x79dd,0x7a86,0x7a89, /* 0xD2F0-0xD2F7 */
	0x7a85,0x7a8b,0x7a8c,0x7a8a,0x7a87,0x7ad8,0x7b10,0x0000, /* 0xD2F8-0xD2FF */
	/* codebase=0xd340 rawbase=0x3e00 */
	0x7b04,0x7b13,0x7b05,0x7b0f,0x7b08,0x7b0a,0x7b0e,0x7b09, /* 0xD340-0xD347 */
	0x7b12,0x7c84,0x7c91,0x7c8a,0x7c8c,0x7c88,0x7c8d,0x7c85, /* 0xD348-0xD34F */
	0x7d1e,0x7d1d,0x7d11,0x7d0e,0x7d18,0x7d16,0x7d13,0x7d1f, /* 0xD350-0xD357 */
	0x7d12,0x7d0f,0x7d0c,0x7f5c,0x7f61,0x7f5e,0x7f60,0x7f5d, /* 0xD358-0xD35F */
	0x7f5b,0x7f96,0x7f92,0x7fc3,0x7fc2,0x7fc0,0x8016,0x803e, /* 0xD360-0xD367 */
	0x8039,0x80fa,0x80f2,0x80f9,0x80f5,0x8101,0x80fb,0x8100, /* 0xD368-0xD36F */
	0x8201,0x822f,0x8225,0x8333,0x832d,0x8344,0x8319,0x8351, /* 0xD370-0xD377 */
	0x8325,0x8356,0x833f,0x8341,0x8326,0x831c,0x8322,0x0000, /* 0xD378-0xD37F */
	/* codebase=0xd380 rawbase=0x3e40 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD380-0xD387 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD388-0xD38F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD390-0xD397 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD398-0xD39F */
	0x0000,0x8342,0x834e,0x831b,0x832a,0x8308,0x833c,0x834d, /* 0xD3A0-0xD3A7 */
	0x8316,0x8324,0x8320,0x8337,0x832f,0x8329,0x8347,0x8345, /* 0xD3A8-0xD3AF */
	0x834c,0x8353,0x831e,0x832c,0x834b,0x8327,0x8348,0x8653, /* 0xD3B0-0xD3B7 */
	0x8652,0x86a2,0x86a8,0x8696,0x868d,0x8691,0x869e,0x8687, /* 0xD3B8-0xD3BF */
	/* codebase=0xd3c0 rawbase=0x3e80 */
	0x8697,0x8686,0x868b,0x869a,0x8685,0x86a5,0x8699,0x86a1, /* 0xD3C0-0xD3C7 */
	0x86a7,0x8695,0x8698,0x868e,0x869d,0x8690,0x8694,0x8843, /* 0xD3C8-0xD3CF */
	0x8844,0x886d,0x8875,0x8876,0x8872,0x8880,0x8871,0x887f, /* 0xD3D0-0xD3D7 */
	0x886f,0x8883,0x887e,0x8874,0x887c,0x8a12,0x8c47,0x8c57, /* 0xD3D8-0xD3DF */
	0x8c7b,0x8ca4,0x8ca3,0x8d76,0x8d78,0x8db5,0x8db7,0x8db6, /* 0xD3E0-0xD3E7 */
	0x8ed1,0x8ed3,0x8ffe,0x8ff5,0x9002,0x8fff,0x8ffb,0x9004, /* 0xD3E8-0xD3EF */
	0x8ffc,0x8ff6,0x90d6,0x90e0,0x90d9,0x90da,0x90e3,0x90df, /* 0xD3F0-0xD3F7 */
	0x90e5,0x90d8,0x90db,0x90d7,0x90dc,0x90e4,0x9150,0x0000, /* 0xD3F8-0xD3FF */
	/* codebase=0xd440 rawbase=0x3ec0 */
	0x914e,0x914f,0x91d5,0x91e2,0x91da,0x965c,0x965f,0x96bc, /* 0xD440-0xD447 */
	0x98e3,0x9adf,0x9b2f,0x4e7f,0x5070,0x506a,0x5061,0x505e, /* 0xD448-0xD44F */
	0x5060,0x5053,0x504b,0x505d,0x5072,0x5048,0x504d,0x5041, /* 0xD450-0xD457 */
	0x505b,0x504a,0x5062,0x5015,0x5045,0x505f,0x5069,0x506b, /* 0xD458-0xD45F */
	0x5063,0x5064,0x5046,0x5040,0x506e,0x5073,0x5057,0x5051, /* 0xD460-0xD467 */
	0x51d0,0x526b,0x526d,0x526c,0x526e,0x52d6,0x52d3,0x532d, /* 0xD468-0xD46F */
	0x539c,0x5575,0x5576,0x553c,0x554d,0x5550,0x5534,0x552a, /* 0xD470-0xD477 */
	0x5551,0x5562,0x5536,0x5535,0x5530,0x5552,0x5545,0x0000, /* 0xD478-0xD47F */
	/* codebase=0xd480 rawbase=0x3f00 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD480-0xD487 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD488-0xD48F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD490-0xD497 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD498-0xD49F */
	0x0000,0x550c,0x5532,0x5565,0x554e,0x5539,0x5548,0x552d, /* 0xD4A0-0xD4A7 */
	0x553b,0x5540,0x554b,0x570a,0x5707,0x57fb,0x5814,0x57e2, /* 0xD4A8-0xD4AF */
	0x57f6,0x57dc,0x57f4,0x5800,0x57ed,0x57fd,0x5808,0x57f8, /* 0xD4B0-0xD4B7 */
	0x580b,0x57f3,0x57cf,0x5807,0x57ee,0x57e3,0x57f2,0x57e5, /* 0xD4B8-0xD4BF */
	/* codebase=0xd4c0 rawbase=0x3f40 */
	0x57ec,0x57e1,0x580e,0x57fc,0x5810,0x57e7,0x5801,0x580c, /* 0xD4C0-0xD4C7 */
	0x57f1,0x57e9,0x57f0,0x580d,0x5804,0x595c,0x5a60,0x5a58, /* 0xD4C8-0xD4CF */
	0x5a55,0x5a67,0x5a5e,0x5a38,0x5a35,0x5a6d,0x5a50,0x5a5f, /* 0xD4D0-0xD4D7 */
	0x5a65,0x5a6c,0x5a53,0x5a64,0x5a57,0x5a43,0x5a5d,0x5a52, /* 0xD4D8-0xD4DF */
	0x5a44,0x5a5b,0x5a48,0x5a8e,0x5a3e,0x5a4d,0x5a39,0x5a4c, /* 0xD4E0-0xD4E7 */
	0x5a70,0x5a69,0x5a47,0x5a51,0x5a56,0x5a42,0x5a5c,0x5b72, /* 0xD4E8-0xD4EF */
	0x5b6e,0x5bc1,0x5bc0,0x5c59,0x5d1e,0x5d0b,0x5d1d,0x5d1a, /* 0xD4F0-0xD4F7 */
	0x5d20,0x5d0c,0x5d28,0x5d0d,0x5d26,0x5d25,0x5d0f,0x0000, /* 0xD4F8-0xD4FF */
	/* codebase=0xd540 rawbase=0x3f80 */
	0x5d30,0x5d12,0x5d23,0x5d1f,0x5d2e,0x5e3e,0x5e34,0x5eb1, /* 0xD540-0xD547 */
	0x5eb4,0x5eb9,0x5eb2,0x5eb3,0x5f36,0x5f38,0x5f9b,0x5f96, /* 0xD548-0xD54F */
	0x5f9f,0x608a,0x6090,0x6086,0x60be,0x60b0,0x60ba,0x60d3, /* 0xD550-0xD557 */
	0x60d4,0x60cf,0x60e4,0x60d9,0x60dd,0x60c8,0x60b1,0x60db, /* 0xD558-0xD55F */
	0x60b7,0x60ca,0x60bf,0x60c3,0x60cd,0x60c0,0x6332,0x6365, /* 0xD560-0xD567 */
	0x638a,0x6382,0x637d,0x63bd,0x639e,0x63ad,0x639d,0x6397, /* 0xD568-0xD56F */
	0x63ab,0x638e,0x636f,0x6387,0x6390,0x636e,0x63af,0x6375, /* 0xD570-0xD577 */
	0x639c,0x636d,0x63ae,0x637c,0x63a4,0x633b,0x639f,0x0000, /* 0xD578-0xD57F */
	/* codebase=0xd580 rawbase=0x3fc0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD580-0xD587 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD588-0xD58F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD590-0xD597 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD598-0xD59F */
	0x0000,0x6378,0x6385,0x6381,0x6391,0x638d,0x6370,0x6553, /* 0xD5A0-0xD5A7 */
	0x65cd,0x6665,0x6661,0x665b,0x6659,0x665c,0x6662,0x6718, /* 0xD5A8-0xD5AF */
	0x6879,0x6887,0x6890,0x689c,0x686d,0x686e,0x68ae,0x68ab, /* 0xD5B0-0xD5B7 */
	0x6956,0x686f,0x68a3,0x68ac,0x68a9,0x6875,0x6874,0x68b2, /* 0xD5B8-0xD5BF */
	/* codebase=0xd5c0 rawbase=0x4000 */
	0x688f,0x6877,0x6892,0x687c,0x686b,0x6872,0x68aa,0x6880, /* 0xD5C0-0xD5C7 */
	0x6871,0x687e,0x689b,0x6896,0x688b,0x68a0,0x6889,0x68a4, /* 0xD5C8-0xD5CF */
	0x6878,0x687b,0x6891,0x688c,0x688a,0x687d,0x6b36,0x6b33, /* 0xD5D0-0xD5D7 */
	0x6b37,0x6b38,0x6b91,0x6b8f,0x6b8d,0x6b8e,0x6b8c,0x6c2a, /* 0xD5D8-0xD5DF */
	0x6dc0,0x6dab,0x6db4,0x6db3,0x6e74,0x6dac,0x6de9,0x6de2, /* 0xD5E0-0xD5E7 */
	0x6db7,0x6df6,0x6dd4,0x6e00,0x6dc8,0x6de0,0x6ddf,0x6dd6, /* 0xD5E8-0xD5EF */
	0x6dbe,0x6de5,0x6ddc,0x6ddd,0x6ddb,0x6df4,0x6dca,0x6dbd, /* 0xD5F0-0xD5F7 */
	0x6ded,0x6df0,0x6dba,0x6dd5,0x6dc2,0x6dcf,0x6dc9,0x0000, /* 0xD5F8-0xD5FF */
	/* codebase=0xd640 rawbase=0x4040 */
	0x6dd0,0x6df2,0x6dd3,0x6dfd,0x6dd7,0x6dcd,0x6de3,0x6dbb, /* 0xD640-0xD647 */
	0x70fa,0x710d,0x70f7,0x7117,0x70f4,0x710c,0x70f0,0x7104, /* 0xD648-0xD64F */
	0x70f3,0x7110,0x70fc,0x70ff,0x7106,0x7113,0x7100,0x70f8, /* 0xD650-0xD657 */
	0x70f6,0x710b,0x7102,0x710e,0x727e,0x727b,0x727c,0x727f, /* 0xD658-0xD65F */
	0x731d,0x7317,0x7307,0x7311,0x7318,0x730a,0x7308,0x72ff, /* 0xD660-0xD667 */
	0x730f,0x731e,0x7388,0x73f6,0x73f8,0x73f5,0x7404,0x7401, /* 0xD668-0xD66F */
	0x73fd,0x7407,0x7400,0x73fa,0x73fc,0x73ff,0x740c,0x740b, /* 0xD670-0xD677 */
	0x73f4,0x7408,0x7564,0x7563,0x75ce,0x75d2,0x75cf,0x0000, /* 0xD678-0xD67F */
	/* codebase=0xd680 rawbase=0x4080 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD680-0xD687 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD688-0xD68F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD690-0xD697 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD698-0xD69F */
	0x0000,0x75cb,0x75cc,0x75d1,0x75d0,0x768f,0x7689,0x76d3, /* 0xD6A0-0xD6A7 */
	0x7739,0x772f,0x772d,0x7731,0x7732,0x7734,0x7733,0x773d, /* 0xD6A8-0xD6AF */
	0x7725,0x773b,0x7735,0x7848,0x7852,0x7849,0x784d,0x784a, /* 0xD6B0-0xD6B7 */
	0x784c,0x7826,0x7845,0x7850,0x7964,0x7967,0x7969,0x796a, /* 0xD6B8-0xD6BF */
	/* codebase=0xd6c0 rawbase=0x40c0 */
	0x7963,0x796b,0x7961,0x79bb,0x79fa,0x79f8,0x79f6,0x79f7, /* 0xD6C0-0xD6C7 */
	0x7a8f,0x7a94,0x7a90,0x7b35,0x7b47,0x7b34,0x7b25,0x7b30, /* 0xD6C8-0xD6CF */
	0x7b22,0x7b24,0x7b33,0x7b18,0x7b2a,0x7b1d,0x7b31,0x7b2b, /* 0xD6D0-0xD6D7 */
	0x7b2d,0x7b2f,0x7b32,0x7b38,0x7b1a,0x7b23,0x7c94,0x7c98, /* 0xD6D8-0xD6DF */
	0x7c96,0x7ca3,0x7d35,0x7d3d,0x7d38,0x7d36,0x7d3a,0x7d45, /* 0xD6E0-0xD6E7 */
	0x7d2c,0x7d29,0x7d41,0x7d47,0x7d3e,0x7d3f,0x7d4a,0x7d3b, /* 0xD6E8-0xD6EF */
	0x7d28,0x7f63,0x7f95,0x7f9c,0x7f9d,0x7f9b,0x7fca,0x7fcb, /* 0xD6F0-0xD6F7 */
	0x7fcd,0x7fd0,0x7fd1,0x7fc7,0x7fcf,0x7fc9,0x801f,0x0000, /* 0xD6F8-0xD6FF */
	/* codebase=0xd740 rawbase=0x4100 */
	0x801e,0x801b,0x8047,0x8043,0x8048,0x8118,0x8125,0x8119, /* 0xD740-0xD747 */
	0x811b,0x812d,0x811f,0x812c,0x811e,0x8121,0x8115,0x8127, /* 0xD748-0xD74F */
	0x811d,0x8122,0x8211,0x8238,0x8233,0x823a,0x8234,0x8232, /* 0xD750-0xD757 */
	0x8274,0x8390,0x83a3,0x83a8,0x838d,0x837a,0x8373,0x83a4, /* 0xD758-0xD75F */
	0x8374,0x838f,0x8381,0x8395,0x8399,0x8375,0x8394,0x83a9, /* 0xD760-0xD767 */
	0x837d,0x8383,0x838c,0x839d,0x839b,0x83aa,0x838b,0x837e, /* 0xD768-0xD76F */
	0x83a5,0x83af,0x8388,0x8397,0x83b0,0x837f,0x83a6,0x8387, /* 0xD770-0xD777 */
	0x83ae,0x8376,0x839a,0x8659,0x8656,0x86bf,0x86b7,0x0000, /* 0xD778-0xD77F */
	/* codebase=0xd780 rawbase=0x4140 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD780-0xD787 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD788-0xD78F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD790-0xD797 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD798-0xD79F */
	0x0000,0x86c2,0x86c1,0x86c5,0x86ba,0x86b0,0x86c8,0x86b9, /* 0xD7A0-0xD7A7 */
	0x86b3,0x86b8,0x86cc,0x86b4,0x86bb,0x86bc,0x86c3,0x86bd, /* 0xD7A8-0xD7AF */
	0x86be,0x8852,0x8889,0x8895,0x88a8,0x88a2,0x88aa,0x889a, /* 0xD7B0-0xD7B7 */
	0x8891,0x88a1,0x889f,0x8898,0x88a7,0x8899,0x889b,0x8897, /* 0xD7B8-0xD7BF */
	/* codebase=0xd7c0 rawbase=0x4180 */
	0x88a4,0x88ac,0x888c,0x8893,0x888e,0x8982,0x89d6,0x89d9, /* 0xD7C0-0xD7C7 */
	0x89d5,0x8a30,0x8a27,0x8a2c,0x8a1e,0x8c39,0x8c3b,0x8c5c, /* 0xD7C8-0xD7CF */
	0x8c5d,0x8c7d,0x8ca5,0x8d7d,0x8d7b,0x8d79,0x8dbc,0x8dc2, /* 0xD7D0-0xD7D7 */
	0x8db9,0x8dbf,0x8dc1,0x8ed8,0x8ede,0x8edd,0x8edc,0x8ed7, /* 0xD7D8-0xD7DF */
	0x8ee0,0x8ee1,0x9024,0x900b,0x9011,0x901c,0x900c,0x9021, /* 0xD7E0-0xD7E7 */
	0x90ef,0x90ea,0x90f0,0x90f4,0x90f2,0x90f3,0x90d4,0x90eb, /* 0xD7E8-0xD7EF */
	0x90ec,0x90e9,0x9156,0x9158,0x915a,0x9153,0x9155,0x91ec, /* 0xD7F0-0xD7F7 */
	0x91f4,0x91f1,0x91f3,0x91f8,0x91e4,0x91f9,0x91ea,0x0000, /* 0xD7F8-0xD7FF */
	/* codebase=0xd840 rawbase=0x41c0 */
	0x91eb,0x91f7,0x91e8,0x91ee,0x957a,0x9586,0x9588,0x967c, /* 0xD840-0xD847 */
	0x966d,0x966b,0x9671,0x966f,0x96bf,0x976a,0x9804,0x98e5, /* 0xD848-0xD84F */
	0x9997,0x509b,0x5095,0x5094,0x509e,0x508b,0x50a3,0x5083, /* 0xD850-0xD857 */
	0x508c,0x508e,0x509d,0x5068,0x509c,0x5092,0x5082,0x5087, /* 0xD858-0xD85F */
	0x515f,0x51d4,0x5312,0x5311,0x53a4,0x53a7,0x5591,0x55a8, /* 0xD860-0xD867 */
	0x55a5,0x55ad,0x5577,0x5645,0x55a2,0x5593,0x5588,0x558f, /* 0xD868-0xD86F */
	0x55b5,0x5581,0x55a3,0x5592,0x55a4,0x557d,0x558c,0x55a6, /* 0xD870-0xD877 */
	0x557f,0x5595,0x55a1,0x558e,0x570c,0x5829,0x5837,0x0000, /* 0xD878-0xD87F */
	/* codebase=0xd880 rawbase=0x4200 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD880-0xD887 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD888-0xD88F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD890-0xD897 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD898-0xD89F */
	0x0000,0x5819,0x581e,0x5827,0x5823,0x5828,0x57f5,0x5848, /* 0xD8A0-0xD8A7 */
	0x5825,0x581c,0x581b,0x5833,0x583f,0x5836,0x582e,0x5839, /* 0xD8A8-0xD8AF */
	0x5838,0x582d,0x582c,0x583b,0x5961,0x5aaf,0x5a94,0x5a9f, /* 0xD8B0-0xD8B7 */
	0x5a7a,0x5aa2,0x5a9e,0x5a78,0x5aa6,0x5a7c,0x5aa5,0x5aac, /* 0xD8B8-0xD8BF */
	/* codebase=0xd8c0 rawbase=0x4240 */
	0x5a95,0x5aae,0x5a37,0x5a84,0x5a8a,0x5a97,0x5a83,0x5a8b, /* 0xD8C0-0xD8C7 */
	0x5aa9,0x5a7b,0x5a7d,0x5a8c,0x5a9c,0x5a8f,0x5a93,0x5a9d, /* 0xD8C8-0xD8CF */
	0x5bea,0x5bcd,0x5bcb,0x5bd4,0x5bd1,0x5bca,0x5bce,0x5c0c, /* 0xD8D0-0xD8D7 */
	0x5c30,0x5d37,0x5d43,0x5d6b,0x5d41,0x5d4b,0x5d3f,0x5d35, /* 0xD8D8-0xD8DF */
	0x5d51,0x5d4e,0x5d55,0x5d33,0x5d3a,0x5d52,0x5d3d,0x5d31, /* 0xD8E0-0xD8E7 */
	0x5d59,0x5d42,0x5d39,0x5d49,0x5d38,0x5d3c,0x5d32,0x5d36, /* 0xD8E8-0xD8EF */
	0x5d40,0x5d45,0x5e44,0x5e41,0x5f58,0x5fa6,0x5fa5,0x5fab, /* 0xD8F0-0xD8F7 */
	0x60c9,0x60b9,0x60cc,0x60e2,0x60ce,0x60c4,0x6114,0x0000, /* 0xD8F8-0xD8FF */
	/* codebase=0xd940 rawbase=0x4280 */
	0x60f2,0x610a,0x6116,0x6105,0x60f5,0x6113,0x60f8,0x60fc, /* 0xD940-0xD947 */
	0x60fe,0x60c1,0x6103,0x6118,0x611d,0x6110,0x60ff,0x6104, /* 0xD948-0xD94F */
	0x610b,0x624a,0x6394,0x63b1,0x63b0,0x63ce,0x63e5,0x63e8, /* 0xD950-0xD957 */
	0x63ef,0x63c3,0x649d,0x63f3,0x63ca,0x63e0,0x63f6,0x63d5, /* 0xD958-0xD95F */
	0x63f2,0x63f5,0x6461,0x63df,0x63be,0x63dd,0x63dc,0x63c4, /* 0xD960-0xD967 */
	0x63d8,0x63d3,0x63c2,0x63c7,0x63cc,0x63cb,0x63c8,0x63f0, /* 0xD968-0xD96F */
	0x63d7,0x63d9,0x6532,0x6567,0x656a,0x6564,0x655c,0x6568, /* 0xD970-0xD977 */
	0x6565,0x658c,0x659d,0x659e,0x65ae,0x65d0,0x65d2,0x0000, /* 0xD978-0xD97F */
	/* codebase=0xd980 rawbase=0x42c0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD980-0xD987 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD988-0xD98F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD990-0xD997 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD998-0xD99F */
	0x0000,0x667c,0x666c,0x667b,0x6680,0x6671,0x6679,0x666a, /* 0xD9A0-0xD9A7 */
	0x6672,0x6701,0x690c,0x68d3,0x6904,0x68dc,0x692a,0x68ec, /* 0xD9A8-0xD9AF */
	0x68ea,0x68f1,0x690f,0x68d6,0x68f7,0x68eb,0x68e4,0x68f6, /* 0xD9B0-0xD9B7 */
	0x6913,0x6910,0x68f3,0x68e1,0x6907,0x68cc,0x6908,0x6970, /* 0xD9B8-0xD9BF */
	/* codebase=0xd9c0 rawbase=0x4300 */
	0x68b4,0x6911,0x68ef,0x68c6,0x6914,0x68f8,0x68d0,0x68fd, /* 0xD9C0-0xD9C7 */
	0x68fc,0x68e8,0x690b,0x690a,0x6917,0x68ce,0x68c8,0x68dd, /* 0xD9C8-0xD9CF */
	0x68de,0x68e6,0x68f4,0x68d1,0x6906,0x68d4,0x68e9,0x6915, /* 0xD9D0-0xD9D7 */
	0x6925,0x68c7,0x6b39,0x6b3b,0x6b3f,0x6b3c,0x6b94,0x6b97, /* 0xD9D8-0xD9DF */
	0x6b99,0x6b95,0x6bbd,0x6bf0,0x6bf2,0x6bf3,0x6c30,0x6dfc, /* 0xD9E0-0xD9E7 */
	0x6e46,0x6e47,0x6e1f,0x6e49,0x6e88,0x6e3c,0x6e3d,0x6e45, /* 0xD9E8-0xD9EF */
	0x6e62,0x6e2b,0x6e3f,0x6e41,0x6e5d,0x6e73,0x6e1c,0x6e33, /* 0xD9F0-0xD9F7 */
	0x6e4b,0x6e40,0x6e51,0x6e3b,0x6e03,0x6e2e,0x6e5e,0x0000, /* 0xD9F8-0xD9FF */
	/* codebase=0xda40 rawbase=0x4340 */
	0x6e68,0x6e5c,0x6e61,0x6e31,0x6e28,0x6e60,0x6e71,0x6e6b, /* 0xDA40-0xDA47 */
	0x6e39,0x6e22,0x6e30,0x6e53,0x6e65,0x6e27,0x6e78,0x6e64, /* 0xDA48-0xDA4F */
	0x6e77,0x6e55,0x6e79,0x6e52,0x6e66,0x6e35,0x6e36,0x6e5a, /* 0xDA50-0xDA57 */
	0x7120,0x711e,0x712f,0x70fb,0x712e,0x7131,0x7123,0x7125, /* 0xDA58-0xDA5F */
	0x7122,0x7132,0x711f,0x7128,0x713a,0x711b,0x724b,0x725a, /* 0xDA60-0xDA67 */
	0x7288,0x7289,0x7286,0x7285,0x728b,0x7312,0x730b,0x7330, /* 0xDA68-0xDA6F */
	0x7322,0x7331,0x7333,0x7327,0x7332,0x732d,0x7326,0x7323, /* 0xDA70-0xDA77 */
	0x7335,0x730c,0x742e,0x742c,0x7430,0x742b,0x7416,0x0000, /* 0xDA78-0xDA7F */
	/* codebase=0xda80 rawbase=0x4380 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xDA80-0xDA87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xDA88-0xDA8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xDA90-0xDA97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xDA98-0xDA9F */
	0x0000,0x741a,0x7421,0x742d,0x7431,0x7424,0x7423,0x741d, /* 0xDAA0-0xDAA7 */
	0x7429,0x7420,0x7432,0x74fb,0x752f,0x756f,0x756c,0x75e7, /* 0xDAA8-0xDAAF */
	0x75da,0x75e1,0x75e6,0x75dd,0x75df,0x75e4,0x75d7,0x7695, /* 0xDAB0-0xDAB7 */
	0x7692,0x76da,0x7746,0x7747,0x7744,0x774d,0x7745,0x774a, /* 0xDAB8-0xDABF */
	/* codebase=0xdac0 rawbase=0x43c0 */
	0x774e,0x774b,0x774c,0x77de,0x77ec,0x7860,0x7864,0x7865, /* 0xDAC0-0xDAC7 */
	0x785c,0x786d,0x7871,0x786a,0x786e,0x7870,0x7869,0x7868, /* 0xDAC8-0xDACF */
	0x785e,0x7862,0x7974,0x7973,0x7972,0x7970,0x7a02,0x7a0a, /* 0xDAD0-0xDAD7 */
	0x7a03,0x7a0c,0x7a04,0x7a99,0x7ae6,0x7ae4,0x7b4a,0x7b3b, /* 0xDAD8-0xDADF */
	0x7b44,0x7b48,0x7b4c,0x7b4e,0x7b40,0x7b58,0x7b45,0x7ca2, /* 0xDAE0-0xDAE7 */
	0x7c9e,0x7ca8,0x7ca1,0x7d58,0x7d6f,0x7d63,0x7d53,0x7d56, /* 0xDAE8-0xDAEF */
	0x7d67,0x7d6a,0x7d4f,0x7d6d,0x7d5c,0x7d6b,0x7d52,0x7d54, /* 0xDAF0-0xDAF7 */
	0x7d69,0x7d51,0x7d5f,0x7d4e,0x7f3e,0x7f3f,0x7f65,0x0000, /* 0xDAF8-0xDAFF */
	/* codebase=0xdb40 rawbase=0x4400 */
	0x7f66,0x7fa2,0x7fa0,0x7fa1,0x7fd7,0x8051,0x804f,0x8050, /* 0xDB40-0xDB47 */
	0x80fe,0x80d4,0x8143,0x814a,0x8152,0x814f,0x8147,0x813d, /* 0xDB48-0xDB4F */
	0x814d,0x813a,0x81e6,0x81ee,0x81f7,0x81f8,0x81f9,0x8204, /* 0xDB50-0xDB57 */
	0x823c,0x823d,0x823f,0x8275,0x833b,0x83cf,0x83f9,0x8423, /* 0xDB58-0xDB5F */
	0x83c0,0x83e8,0x8412,0x83e7,0x83e4,0x83fc,0x83f6,0x8410, /* 0xDB60-0xDB67 */
	0x83c6,0x83c8,0x83eb,0x83e3,0x83bf,0x8401,0x83dd,0x83e5, /* 0xDB68-0xDB6F */
	0x83d8,0x83ff,0x83e1,0x83cb,0x83ce,0x83d6,0x83f5,0x83c9, /* 0xDB70-0xDB77 */
	0x8409,0x840f,0x83de,0x8411,0x8406,0x83c2,0x83f3,0x0000, /* 0xDB78-0xDB7F */
	/* codebase=0xdb80 rawbase=0x4440 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xDB80-0xDB87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xDB88-0xDB8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xDB90-0xDB97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xDB98-0xDB9F */
	0x0000,0x83d5,0x83fa,0x83c7,0x83d1,0x83ea,0x8413,0x83c3, /* 0xDBA0-0xDBA7 */
	0x83ec,0x83ee,0x83c4,0x83fb,0x83d7,0x83e2,0x841b,0x83db, /* 0xDBA8-0xDBAF */
	0x83fe,0x86d8,0x86e2,0x86e6,0x86d3,0x86e3,0x86da,0x86ea, /* 0xDBB0-0xDBB7 */
	0x86dd,0x86eb,0x86dc,0x86ec,0x86e9,0x86d7,0x86e8,0x86d1, /* 0xDBB8-0xDBBF */
	/* codebase=0xdbc0 rawbase=0x4480 */
	0x8848,0x8856,0x8855,0x88ba,0x88d7,0x88b9,0x88b8,0x88c0, /* 0xDBC0-0xDBC7 */
	0x88be,0x88b6,0x88bc,0x88b7,0x88bd,0x88b2,0x8901,0x88c9, /* 0xDBC8-0xDBCF */
	0x8995,0x8998,0x8997,0x89dd,0x89da,0x89db,0x8a4e,0x8a4d, /* 0xDBD0-0xDBD7 */
	0x8a39,0x8a59,0x8a40,0x8a57,0x8a58,0x8a44,0x8a45,0x8a52, /* 0xDBD8-0xDBDF */
	0x8a48,0x8a51,0x8a4a,0x8a4c,0x8a4f,0x8c5f,0x8c81,0x8c80, /* 0xDBE0-0xDBE7 */
	0x8cba,0x8cbe,0x8cb0,0x8cb9,0x8cb5,0x8d84,0x8d80,0x8d89, /* 0xDBE8-0xDBEF */
	0x8dd8,0x8dd3,0x8dcd,0x8dc7,0x8dd6,0x8ddc,0x8dcf,0x8dd5, /* 0xDBF0-0xDBF7 */
	0x8dd9,0x8dc8,0x8dd7,0x8dc5,0x8eef,0x8ef7,0x8efa,0x0000, /* 0xDBF8-0xDBFF */
	/* codebase=0xdc40 rawbase=0x44c0 */
	0x8ef9,0x8ee6,0x8eee,0x8ee5,0x8ef5,0x8ee7,0x8ee8,0x8ef6, /* 0xDC40-0xDC47 */
	0x8eeb,0x8ef1,0x8eec,0x8ef4,0x8ee9,0x902d,0x9034,0x902f, /* 0xDC48-0xDC4F */
	0x9106,0x912c,0x9104,0x90ff,0x90fc,0x9108,0x90f9,0x90fb, /* 0xDC50-0xDC57 */
	0x9101,0x9100,0x9107,0x9105,0x9103,0x9161,0x9164,0x915f, /* 0xDC58-0xDC5F */
	0x9162,0x9160,0x9201,0x920a,0x9225,0x9203,0x921a,0x9226, /* 0xDC60-0xDC67 */
	0x920f,0x920c,0x9200,0x9212,0x91ff,0x91fd,0x9206,0x9204, /* 0xDC68-0xDC6F */
	0x9227,0x9202,0x921c,0x9224,0x9219,0x9217,0x9205,0x9216, /* 0xDC70-0xDC77 */
	0x957b,0x958d,0x958c,0x9590,0x9687,0x967e,0x9688,0x0000, /* 0xDC78-0xDC7F */
	/* codebase=0xdc80 rawbase=0x4500 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xDC80-0xDC87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xDC88-0xDC8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xDC90-0xDC97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xDC98-0xDC9F */
	0x0000,0x9689,0x9683,0x9680,0x96c2,0x96c8,0x96c3,0x96f1, /* 0xDCA0-0xDCA7 */
	0x96f0,0x976c,0x9770,0x976e,0x9807,0x98a9,0x98eb,0x9ce6, /* 0xDCA8-0xDCAF */
	0x9ef9,0x4e83,0x4e84,0x4eb6,0x50bd,0x50bf,0x50c6,0x50ae, /* 0xDCB0-0xDCB7 */
	0x50c4,0x50ca,0x50b4,0x50c8,0x50c2,0x50b0,0x50c1,0x50ba, /* 0xDCB8-0xDCBF */
	/* codebase=0xdcc0 rawbase=0x4540 */
	0x50b1,0x50cb,0x50c9,0x50b6,0x50b8,0x51d7,0x527a,0x5278, /* 0xDCC0-0xDCC7 */
	0x527b,0x527c,0x55c3,0x55db,0x55cc,0x55d0,0x55cb,0x55ca, /* 0xDCC8-0xDCCF */
	0x55dd,0x55c0,0x55d4,0x55c4,0x55e9,0x55bf,0x55d2,0x558d, /* 0xDCD0-0xDCD7 */
	0x55cf,0x55d5,0x55e2,0x55d6,0x55c8,0x55f2,0x55cd,0x55d9, /* 0xDCD8-0xDCDF */
	0x55c2,0x5714,0x5853,0x5868,0x5864,0x584f,0x584d,0x5849, /* 0xDCE0-0xDCE7 */
	0x586f,0x5855,0x584e,0x585d,0x5859,0x5865,0x585b,0x583d, /* 0xDCE8-0xDCEF */
	0x5863,0x5871,0x58fc,0x5ac7,0x5ac4,0x5acb,0x5aba,0x5ab8, /* 0xDCF0-0xDCF7 */
	0x5ab1,0x5ab5,0x5ab0,0x5abf,0x5ac8,0x5abb,0x5ac6,0x0000, /* 0xDCF8-0xDCFF */
	/* codebase=0xdd40 rawbase=0x4580 */
	0x5ab7,0x5ac0,0x5aca,0x5ab4,0x5ab6,0x5acd,0x5ab9,0x5a90, /* 0xDD40-0xDD47 */
	0x5bd6,0x5bd8,0x5bd9,0x5c1f,0x5c33,0x5d71,0x5d63,0x5d4a, /* 0xDD48-0xDD4F */
	0x5d65,0x5d72,0x5d6c,0x5d5e,0x5d68,0x5d67,0x5d62,0x5df0, /* 0xDD50-0xDD57 */
	0x5e4f,0x5e4e,0x5e4a,0x5e4d,0x5e4b,0x5ec5,0x5ecc,0x5ec6, /* 0xDD58-0xDD5F */
	0x5ecb,0x5ec7,0x5f40,0x5faf,0x5fad,0x60f7,0x6149,0x614a, /* 0xDD60-0xDD67 */
	0x612b,0x6145,0x6136,0x6132,0x612e,0x6146,0x612f,0x614f, /* 0xDD68-0xDD6F */
	0x6129,0x6140,0x6220,0x9168,0x6223,0x6225,0x6224,0x63c5, /* 0xDD70-0xDD77 */
	0x63f1,0x63eb,0x6410,0x6412,0x6409,0x6420,0x6424,0x0000, /* 0xDD78-0xDD7F */
	/* codebase=0xdd80 rawbase=0x45c0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xDD80-0xDD87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xDD88-0xDD8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xDD90-0xDD97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xDD98-0xDD9F */
	0x0000,0x6433,0x6443,0x641f,0x6415,0x6418,0x6439,0x6437, /* 0xDDA0-0xDDA7 */
	0x6422,0x6423,0x640c,0x6426,0x6430,0x6428,0x6441,0x6435, /* 0xDDA8-0xDDAF */
	0x642f,0x640a,0x641a,0x6440,0x6425,0x6427,0x640b,0x63e7, /* 0xDDB0-0xDDB7 */
	0x641b,0x642e,0x6421,0x640e,0x656f,0x6592,0x65d3,0x6686, /* 0xDDB8-0xDDBF */
	/* codebase=0xddc0 rawbase=0x4600 */
	0x668c,0x6695,0x6690,0x668b,0x668a,0x6699,0x6694,0x6678, /* 0xDDC0-0xDDC7 */
	0x6720,0x6966,0x695f,0x6938,0x694e,0x6962,0x6971,0x693f, /* 0xDDC8-0xDDCF */
	0x6945,0x696a,0x6939,0x6942,0x6957,0x6959,0x697a,0x6948, /* 0xDDD0-0xDDD7 */
	0x6949,0x6935,0x696c,0x6933,0x693d,0x6965,0x68f0,0x6978, /* 0xDDD8-0xDDDF */
	0x6934,0x6969,0x6940,0x696f,0x6944,0x6976,0x6958,0x6941, /* 0xDDE0-0xDDE7 */
	0x6974,0x694c,0x693b,0x694b,0x6937,0x695c,0x694f,0x6951, /* 0xDDE8-0xDDEF */
	0x6932,0x6952,0x692f,0x697b,0x693c,0x6b46,0x6b45,0x6b43, /* 0xDDF0-0xDDF7 */
	0x6b42,0x6b48,0x6b41,0x6b9b,0xfa0d,0x6bfb,0x6bfc,0x0000, /* 0xDDF8-0xDDFF */
	/* codebase=0xde40 rawbase=0x4640 */
	0x6bf9,0x6bf7,0x6bf8,0x6e9b,0x6ed6,0x6ec8,0x6e8f,0x6ec0, /* 0xDE40-0xDE47 */
	0x6e9f,0x6e93,0x6e94,0x6ea0,0x6eb1,0x6eb9,0x6ec6,0x6ed2, /* 0xDE48-0xDE4F */
	0x6ebd,0x6ec1,0x6e9e,0x6ec9,0x6eb7,0x6eb0,0x6ecd,0x6ea6, /* 0xDE50-0xDE57 */
	0x6ecf,0x6eb2,0x6ebe,0x6ec3,0x6edc,0x6ed8,0x6e99,0x6e92, /* 0xDE58-0xDE5F */
	0x6e8e,0x6e8d,0x6ea4,0x6ea1,0x6ebf,0x6eb3,0x6ed0,0x6eca, /* 0xDE60-0xDE67 */
	0x6e97,0x6eae,0x6ea3,0x7147,0x7154,0x7152,0x7163,0x7160, /* 0xDE68-0xDE6F */
	0x7141,0x715d,0x7162,0x7172,0x7178,0x716a,0x7161,0x7142, /* 0xDE70-0xDE77 */
	0x7158,0x7143,0x714b,0x7170,0x715f,0x7150,0x7153,0x0000, /* 0xDE78-0xDE7F */
	/* codebase=0xde80 rawbase=0x4680 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xDE80-0xDE87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xDE88-0xDE8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xDE90-0xDE97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xDE98-0xDE9F */
	0x0000,0x7144,0x714d,0x715a,0x724f,0x728d,0x728c,0x7291, /* 0xDEA0-0xDEA7 */
	0x7290,0x728e,0x733c,0x7342,0x733b,0x733a,0x7340,0x734a, /* 0xDEA8-0xDEAF */
	0x7349,0x7444,0x744a,0x744b,0x7452,0x7451,0x7457,0x7440, /* 0xDEB0-0xDEB7 */
	0x744f,0x7450,0x744e,0x7442,0x7446,0x744d,0x7454,0x74e1, /* 0xDEB8-0xDEBF */
	/* codebase=0xdec0 rawbase=0x46c0 */
	0x74ff,0x74fe,0x74fd,0x751d,0x7579,0x7577,0x6983,0x75ef, /* 0xDEC0-0xDEC7 */
	0x760f,0x7603,0x75f7,0x75fe,0x75fc,0x75f9,0x75f8,0x7610, /* 0xDEC8-0xDECF */
	0x75fb,0x75f6,0x75ed,0x75f5,0x75fd,0x7699,0x76b5,0x76dd, /* 0xDED0-0xDED7 */
	0x7755,0x775f,0x7760,0x7752,0x7756,0x775a,0x7769,0x7767, /* 0xDED8-0xDEDF */
	0x7754,0x7759,0x776d,0x77e0,0x7887,0x789a,0x7894,0x788f, /* 0xDEE0-0xDEE7 */
	0x7884,0x7895,0x7885,0x7886,0x78a1,0x7883,0x7879,0x7899, /* 0xDEE8-0xDEEF */
	0x7880,0x7896,0x787b,0x797c,0x7982,0x797d,0x7979,0x7a11, /* 0xDEF0-0xDEF7 */
	0x7a18,0x7a19,0x7a12,0x7a17,0x7a15,0x7a22,0x7a13,0x0000, /* 0xDEF8-0xDEFF */
	/* codebase=0xdf40 rawbase=0x4700 */
	0x7a1b,0x7a10,0x7aa3,0x7aa2,0x7a9e,0x7aeb,0x7b66,0x7b64, /* 0xDF40-0xDF47 */
	0x7b6d,0x7b74,0x7b69,0x7b72,0x7b65,0x7b73,0x7b71,0x7b70, /* 0xDF48-0xDF4F */
	0x7b61,0x7b78,0x7b76,0x7b63,0x7cb2,0x7cb4,0x7caf,0x7d88, /* 0xDF50-0xDF57 */
	0x7d86,0x7d80,0x7d8d,0x7d7f,0x7d85,0x7d7a,0x7d8e,0x7d7b, /* 0xDF58-0xDF5F */
	0x7d83,0x7d7c,0x7d8c,0x7d94,0x7d84,0x7d7d,0x7d92,0x7f6d, /* 0xDF60-0xDF67 */
	0x7f6b,0x7f67,0x7f68,0x7f6c,0x7fa6,0x7fa5,0x7fa7,0x7fdb, /* 0xDF68-0xDF6F */
	0x7fdc,0x8021,0x8164,0x8160,0x8177,0x815c,0x8169,0x815b, /* 0xDF70-0xDF77 */
	0x8162,0x8172,0x6721,0x815e,0x8176,0x8167,0x816f,0x0000, /* 0xDF78-0xDF7F */
	/* codebase=0xdf80 rawbase=0x4740 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xDF80-0xDF87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xDF88-0xDF8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xDF90-0xDF97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xDF98-0xDF9F */
	0x0000,0x8144,0x8161,0x821d,0x8249,0x8244,0x8240,0x8242, /* 0xDFA0-0xDFA7 */
	0x8245,0x84f1,0x843f,0x8456,0x8476,0x8479,0x848f,0x848d, /* 0xDFA8-0xDFAF */
	0x8465,0x8451,0x8440,0x8486,0x8467,0x8430,0x844d,0x847d, /* 0xDFB0-0xDFB7 */
	0x845a,0x8459,0x8474,0x8473,0x845d,0x8507,0x845e,0x8437, /* 0xDFB8-0xDFBF */
	/* codebase=0xdfc0 rawbase=0x4780 */
	0x843a,0x8434,0x847a,0x8443,0x8478,0x8432,0x8445,0x8429, /* 0xDFC0-0xDFC7 */
	0x83d9,0x844b,0x842f,0x8442,0x842d,0x845f,0x8470,0x8439, /* 0xDFC8-0xDFCF */
	0x844e,0x844c,0x8452,0x846f,0x84c5,0x848e,0x843b,0x8447, /* 0xDFD0-0xDFD7 */
	0x8436,0x8433,0x8468,0x847e,0x8444,0x842b,0x8460,0x8454, /* 0xDFD8-0xDFDF */
	0x846e,0x8450,0x870b,0x8704,0x86f7,0x870c,0x86fa,0x86d6, /* 0xDFE0-0xDFE7 */
	0x86f5,0x874d,0x86f8,0x870e,0x8709,0x8701,0x86f6,0x870d, /* 0xDFE8-0xDFEF */
	0x8705,0x88d6,0x88cb,0x88cd,0x88ce,0x88de,0x88db,0x88da, /* 0xDFF0-0xDFF7 */
	0x88cc,0x88d0,0x8985,0x899b,0x89df,0x89e5,0x89e4,0x0000, /* 0xDFF8-0xDFFF */
	/* codebase=0xe040 rawbase=0x47c0 */
	0x89e1,0x89e0,0x89e2,0x89dc,0x89e6,0x8a76,0x8a86,0x8a7f, /* 0xE040-0xE047 */
	0x8a61,0x8a3f,0x8a77,0x8a82,0x8a84,0x8a75,0x8a83,0x8a81, /* 0xE048-0xE04F */
	0x8a74,0x8a7a,0x8c3c,0x8c4b,0x8c4a,0x8c65,0x8c64,0x8c66, /* 0xE050-0xE057 */
	0x8c86,0x8c84,0x8c85,0x8ccc,0x8d68,0x8d69,0x8d91,0x8d8c, /* 0xE058-0xE05F */
	0x8d8e,0x8d8f,0x8d8d,0x8d93,0x8d94,0x8d90,0x8d92,0x8df0, /* 0xE060-0xE067 */
	0x8de0,0x8dec,0x8df1,0x8dee,0x8dd0,0x8de9,0x8de3,0x8de2, /* 0xE068-0xE06F */
	0x8de7,0x8df2,0x8deb,0x8df4,0x8f06,0x8eff,0x8f01,0x8f00, /* 0xE070-0xE077 */
	0x8f05,0x8f07,0x8f08,0x8f02,0x8f0b,0x9052,0x903f,0x0000, /* 0xE078-0xE07F */
	/* codebase=0xe080 rawbase=0x4800 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE080-0xE087 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE088-0xE08F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE090-0xE097 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE098-0xE09F */
	0x0000,0x9044,0x9049,0x903d,0x9110,0x910d,0x910f,0x9111, /* 0xE0A0-0xE0A7 */
	0x9116,0x9114,0x910b,0x910e,0x916e,0x916f,0x9248,0x9252, /* 0xE0A8-0xE0AF */
	0x9230,0x923a,0x9266,0x9233,0x9265,0x925e,0x9283,0x922e, /* 0xE0B0-0xE0B7 */
	0x924a,0x9246,0x926d,0x926c,0x924f,0x9260,0x9267,0x926f, /* 0xE0B8-0xE0BF */
	/* codebase=0xe0c0 rawbase=0x4840 */
	0x9236,0x9261,0x9270,0x9231,0x9254,0x9263,0x9250,0x9272, /* 0xE0C0-0xE0C7 */
	0x924e,0x9253,0x924c,0x9256,0x9232,0x959f,0x959c,0x959e, /* 0xE0C8-0xE0CF */
	0x959b,0x9692,0x9693,0x9691,0x9697,0x96ce,0x96fa,0x96fd, /* 0xE0D0-0xE0D7 */
	0x96f8,0x96f5,0x9773,0x9777,0x9778,0x9772,0x980f,0x980d, /* 0xE0D8-0xE0DF */
	0x980e,0x98ac,0x98f6,0x98f9,0x99af,0x99b2,0x99b0,0x99b5, /* 0xE0E0-0xE0E7 */
	0x9aad,0x9aab,0x9b5b,0x9cea,0x9ced,0x9ce7,0x9e80,0x9efd, /* 0xE0E8-0xE0EF */
	0x50e6,0x50d4,0x50d7,0x50e8,0x50f3,0x50db,0x50ea,0x50dd, /* 0xE0F0-0xE0F7 */
	0x50e4,0x50d3,0x50ec,0x50f0,0x50ef,0x50e3,0x50e0,0x0000, /* 0xE0F8-0xE0FF */
	/* codebase=0xe140 rawbase=0x4880 */
	0x51d8,0x5280,0x5281,0x52e9,0x52eb,0x5330,0x53ac,0x5627, /* 0xE140-0xE147 */
	0x5615,0x560c,0x5612,0x55fc,0x560f,0x561c,0x5601,0x5613, /* 0xE148-0xE14F */
	0x5602,0x55fa,0x561d,0x5604,0x55ff,0x55f9,0x5889,0x587c, /* 0xE150-0xE157 */
	0x5890,0x5898,0x5886,0x5881,0x587f,0x5874,0x588b,0x587a, /* 0xE158-0xE15F */
	0x5887,0x5891,0x588e,0x5876,0x5882,0x5888,0x587b,0x5894, /* 0xE160-0xE167 */
	0x588f,0x58fe,0x596b,0x5adc,0x5aee,0x5ae5,0x5ad5,0x5aea, /* 0xE168-0xE16F */
	0x5ada,0x5aed,0x5aeb,0x5af3,0x5ae2,0x5ae0,0x5adb,0x5aec, /* 0xE170-0xE177 */
	0x5ade,0x5add,0x5ad9,0x5ae8,0x5adf,0x5b77,0x5be0,0x0000, /* 0xE178-0xE17F */
	/* codebase=0xe180 rawbase=0x48c0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE180-0xE187 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE188-0xE18F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE190-0xE197 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE198-0xE19F */
	0x0000,0x5be3,0x5c63,0x5d82,0x5d80,0x5d7d,0x5d86,0x5d7a, /* 0xE1A0-0xE1A7 */
	0x5d81,0x5d77,0x5d8a,0x5d89,0x5d88,0x5d7e,0x5d7c,0x5d8d, /* 0xE1A8-0xE1AF */
	0x5d79,0x5d7f,0x5e58,0x5e59,0x5e53,0x5ed8,0x5ed1,0x5ed7, /* 0xE1B0-0xE1B7 */
	0x5ece,0x5edc,0x5ed5,0x5ed9,0x5ed2,0x5ed4,0x5f44,0x5f43, /* 0xE1B8-0xE1BF */
	/* codebase=0xe1c0 rawbase=0x4900 */
	0x5f6f,0x5fb6,0x612c,0x6128,0x6141,0x615e,0x6171,0x6173, /* 0xE1C0-0xE1C7 */
	0x6152,0x6153,0x6172,0x616c,0x6180,0x6174,0x6154,0x617a, /* 0xE1C8-0xE1CF */
	0x615b,0x6165,0x613b,0x616a,0x6161,0x6156,0x6229,0x6227, /* 0xE1D0-0xE1D7 */
	0x622b,0x642b,0x644d,0x645b,0x645d,0x6474,0x6476,0x6472, /* 0xE1D8-0xE1DF */
	0x6473,0x647d,0x6475,0x6466,0x64a6,0x644e,0x6482,0x645e, /* 0xE1E0-0xE1E7 */
	0x645c,0x644b,0x6453,0x6460,0x6450,0x647f,0x643f,0x646c, /* 0xE1E8-0xE1EF */
	0x646b,0x6459,0x6465,0x6477,0x6573,0x65a0,0x66a1,0x66a0, /* 0xE1F0-0xE1F7 */
	0x669f,0x6705,0x6704,0x6722,0x69b1,0x69b6,0x69c9,0x0000, /* 0xE1F8-0xE1FF */
	/* codebase=0xe240 rawbase=0x4940 */
	0x69a0,0x69ce,0x6996,0x69b0,0x69ac,0x69bc,0x6991,0x6999, /* 0xE240-0xE247 */
	0x698e,0x69a7,0x698d,0x69a9,0x69be,0x69af,0x69bf,0x69c4, /* 0xE248-0xE24F */
	0x69bd,0x69a4,0x69d4,0x69b9,0x69ca,0x699a,0x69cf,0x69b3, /* 0xE250-0xE257 */
	0x6993,0x69aa,0x69a1,0x699e,0x69d9,0x6997,0x6990,0x69c2, /* 0xE258-0xE25F */
	0x69b5,0x69a5,0x69c6,0x6b4a,0x6b4d,0x6b4b,0x6b9e,0x6b9f, /* 0xE260-0xE267 */
	0x6ba0,0x6bc3,0x6bc4,0x6bfe,0x6ece,0x6ef5,0x6ef1,0x6f03, /* 0xE268-0xE26F */
	0x6f25,0x6ef8,0x6f37,0x6efb,0x6f2e,0x6f09,0x6f4e,0x6f19, /* 0xE270-0xE277 */
	0x6f1a,0x6f27,0x6f18,0x6f3b,0x6f12,0x6eed,0x6f0a,0x0000, /* 0xE278-0xE27F */
	/* codebase=0xe280 rawbase=0x4980 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE280-0xE287 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE288-0xE28F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE290-0xE297 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE298-0xE29F */
	0x0000,0x6f36,0x6f73,0x6ef9,0x6eee,0x6f2d,0x6f40,0x6f30, /* 0xE2A0-0xE2A7 */
	0x6f3c,0x6f35,0x6eeb,0x6f07,0x6f0e,0x6f43,0x6f05,0x6efd, /* 0xE2A8-0xE2AF */
	0x6ef6,0x6f39,0x6f1c,0x6efc,0x6f3a,0x6f1f,0x6f0d,0x6f1e, /* 0xE2B0-0xE2B7 */
	0x6f08,0x6f21,0x7187,0x7190,0x7189,0x7180,0x7185,0x7182, /* 0xE2B8-0xE2BF */
	/* codebase=0xe2c0 rawbase=0x49c0 */
	0x718f,0x717b,0x7186,0x7181,0x7197,0x7244,0x7253,0x7297, /* 0xE2C0-0xE2C7 */
	0x7295,0x7293,0x7343,0x734d,0x7351,0x734c,0x7462,0x7473, /* 0xE2C8-0xE2CF */
	0x7471,0x7475,0x7472,0x7467,0x746e,0x7500,0x7502,0x7503, /* 0xE2D0-0xE2D7 */
	0x757d,0x7590,0x7616,0x7608,0x760c,0x7615,0x7611,0x760a, /* 0xE2D8-0xE2DF */
	0x7614,0x76b8,0x7781,0x777c,0x7785,0x7782,0x776e,0x7780, /* 0xE2E0-0xE2E7 */
	0x776f,0x777e,0x7783,0x78b2,0x78aa,0x78b4,0x78ad,0x78a8, /* 0xE2E8-0xE2EF */
	0x787e,0x78ab,0x789e,0x78a5,0x78a0,0x78ac,0x78a2,0x78a4, /* 0xE2F0-0xE2F7 */
	0x7998,0x798a,0x798b,0x7996,0x7995,0x7994,0x7993,0x0000, /* 0xE2F8-0xE2FF */
	/* codebase=0xe340 rawbase=0x4a00 */
	0x7997,0x7988,0x7992,0x7990,0x7a2b,0x7a4a,0x7a30,0x7a2f, /* 0xE340-0xE347 */
	0x7a28,0x7a26,0x7aa8,0x7aab,0x7aac,0x7aee,0x7b88,0x7b9c, /* 0xE348-0xE34F */
	0x7b8a,0x7b91,0x7b90,0x7b96,0x7b8d,0x7b8c,0x7b9b,0x7b8e, /* 0xE350-0xE357 */
	0x7b85,0x7b98,0x5284,0x7b99,0x7ba4,0x7b82,0x7cbb,0x7cbf, /* 0xE358-0xE35F */
	0x7cbc,0x7cba,0x7da7,0x7db7,0x7dc2,0x7da3,0x7daa,0x7dc1, /* 0xE360-0xE367 */
	0x7dc0,0x7dc5,0x7d9d,0x7dce,0x7dc4,0x7dc6,0x7dcb,0x7dcc, /* 0xE368-0xE36F */
	0x7daf,0x7db9,0x7d96,0x7dbc,0x7d9f,0x7da6,0x7dae,0x7da9, /* 0xE370-0xE377 */
	0x7da1,0x7dc9,0x7f73,0x7fe2,0x7fe3,0x7fe5,0x7fde,0x0000, /* 0xE378-0xE37F */
	/* codebase=0xe380 rawbase=0x4a40 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE380-0xE387 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE388-0xE38F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE390-0xE397 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE398-0xE39F */
	0x0000,0x8024,0x805d,0x805c,0x8189,0x8186,0x8183,0x8187, /* 0xE3A0-0xE3A7 */
	0x818d,0x818c,0x818b,0x8215,0x8497,0x84a4,0x84a1,0x849f, /* 0xE3A8-0xE3AF */
	0x84ba,0x84ce,0x84c2,0x84ac,0x84ae,0x84ab,0x84b9,0x84b4, /* 0xE3B0-0xE3B7 */
	0x84c1,0x84cd,0x84aa,0x849a,0x84b1,0x84d0,0x849d,0x84a7, /* 0xE3B8-0xE3BF */
	/* codebase=0xe3c0 rawbase=0x4a80 */
	0x84bb,0x84a2,0x8494,0x84c7,0x84cc,0x849b,0x84a9,0x84af, /* 0xE3C0-0xE3C7 */
	0x84a8,0x84d6,0x8498,0x84b6,0x84cf,0x84a0,0x84d7,0x84d4, /* 0xE3C8-0xE3CF */
	0x84d2,0x84db,0x84b0,0x8491,0x8661,0x8733,0x8723,0x8728, /* 0xE3D0-0xE3D7 */
	0x876b,0x8740,0x872e,0x871e,0x8721,0x8719,0x871b,0x8743, /* 0xE3D8-0xE3DF */
	0x872c,0x8741,0x873e,0x8746,0x8720,0x8732,0x872a,0x872d, /* 0xE3E0-0xE3E7 */
	0x873c,0x8712,0x873a,0x8731,0x8735,0x8742,0x8726,0x8727, /* 0xE3E8-0xE3EF */
	0x8738,0x8724,0x871a,0x8730,0x8711,0x88f7,0x88e7,0x88f1, /* 0xE3F0-0xE3F7 */
	0x88f2,0x88fa,0x88fe,0x88ee,0x88fc,0x88f6,0x88fb,0x0000, /* 0xE3F8-0xE3FF */
	/* codebase=0xe440 rawbase=0x4ac0 */
	0x88f0,0x88ec,0x88eb,0x899d,0x89a1,0x899f,0x899e,0x89e9, /* 0xE440-0xE447 */
	0x89eb,0x89e8,0x8aab,0x8a99,0x8a8b,0x8a92,0x8a8f,0x8a96, /* 0xE448-0xE44F */
	0x8c3d,0x8c68,0x8c69,0x8cd5,0x8ccf,0x8cd7,0x8d96,0x8e09, /* 0xE450-0xE457 */
	0x8e02,0x8dff,0x8e0d,0x8dfd,0x8e0a,0x8e03,0x8e07,0x8e06, /* 0xE458-0xE45F */
	0x8e05,0x8dfe,0x8e00,0x8e04,0x8f10,0x8f11,0x8f0e,0x8f0d, /* 0xE460-0xE467 */
	0x9123,0x911c,0x9120,0x9122,0x911f,0x911d,0x911a,0x9124, /* 0xE468-0xE46F */
	0x9121,0x911b,0x917a,0x9172,0x9179,0x9173,0x92a5,0x92a4, /* 0xE470-0xE477 */
	0x9276,0x929b,0x927a,0x92a0,0x9294,0x92aa,0x928d,0x0000, /* 0xE478-0xE47F */
	/* codebase=0xe480 rawbase=0x4b00 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE480-0xE487 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE488-0xE48F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE490-0xE497 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE498-0xE49F */
	0x0000,0x92a6,0x929a,0x92ab,0x9279,0x9297,0x927f,0x92a3, /* 0xE4A0-0xE4A7 */
	0x92ee,0x928e,0x9282,0x9295,0x92a2,0x927d,0x9288,0x92a1, /* 0xE4A8-0xE4AF */
	0x928a,0x9286,0x928c,0x9299,0x92a7,0x927e,0x9287,0x92a9, /* 0xE4B0-0xE4B7 */
	0x929d,0x928b,0x922d,0x969e,0x96a1,0x96ff,0x9758,0x977d, /* 0xE4B8-0xE4BF */
	/* codebase=0xe4c0 rawbase=0x4b40 */
	0x977a,0x977e,0x9783,0x9780,0x9782,0x977b,0x9784,0x9781, /* 0xE4C0-0xE4C7 */
	0x977f,0x97ce,0x97cd,0x9816,0x98ad,0x98ae,0x9902,0x9900, /* 0xE4C8-0xE4CF */
	0x9907,0x999d,0x999c,0x99c3,0x99b9,0x99bb,0x99ba,0x99c2, /* 0xE4D0-0xE4D7 */
	0x99bd,0x99c7,0x9ab1,0x9ae3,0x9ae7,0x9b3e,0x9b3f,0x9b60, /* 0xE4D8-0xE4DF */
	0x9b61,0x9b5f,0x9cf1,0x9cf2,0x9cf5,0x9ea7,0x50ff,0x5103, /* 0xE4E0-0xE4E7 */
	0x5130,0x50f8,0x5106,0x5107,0x50f6,0x50fe,0x510b,0x510c, /* 0xE4E8-0xE4EF */
	0x50fd,0x510a,0x528b,0x528c,0x52f1,0x52ef,0x5648,0x5642, /* 0xE4F0-0xE4F7 */
	0x564c,0x5635,0x5641,0x564a,0x5649,0x5646,0x5658,0x0000, /* 0xE4F8-0xE4FF */
	/* codebase=0xe540 rawbase=0x4b80 */
	0x565a,0x5640,0x5633,0x563d,0x562c,0x563e,0x5638,0x562a, /* 0xE540-0xE547 */
	0x563a,0x571a,0x58ab,0x589d,0x58b1,0x58a0,0x58a3,0x58af, /* 0xE548-0xE54F */
	0x58ac,0x58a5,0x58a1,0x58ff,0x5aff,0x5af4,0x5afd,0x5af7, /* 0xE550-0xE557 */
	0x5af6,0x5b03,0x5af8,0x5b02,0x5af9,0x5b01,0x5b07,0x5b05, /* 0xE558-0xE55F */
	0x5b0f,0x5c67,0x5d99,0x5d97,0x5d9f,0x5d92,0x5da2,0x5d93, /* 0xE560-0xE567 */
	0x5d95,0x5da0,0x5d9c,0x5da1,0x5d9a,0x5d9e,0x5e69,0x5e5d, /* 0xE568-0xE56F */
	0x5e60,0x5e5c,0x7df3,0x5edb,0x5ede,0x5ee1,0x5f49,0x5fb2, /* 0xE570-0xE577 */
	0x618b,0x6183,0x6179,0x61b1,0x61b0,0x61a2,0x6189,0x0000, /* 0xE578-0xE57F */
	/* codebase=0xe580 rawbase=0x4bc0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE580-0xE587 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE588-0xE58F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE590-0xE597 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE598-0xE59F */
	0x0000,0x619b,0x6193,0x61af,0x61ad,0x619f,0x6192,0x61aa, /* 0xE5A0-0xE5A7 */
	0x61a1,0x618d,0x6166,0x61b3,0x622d,0x646e,0x6470,0x6496, /* 0xE5A8-0xE5AF */
	0x64a0,0x6485,0x6497,0x649c,0x648f,0x648b,0x648a,0x648c, /* 0xE5B0-0xE5B7 */
	0x64a3,0x649f,0x6468,0x64b1,0x6498,0x6576,0x657a,0x6579, /* 0xE5B8-0xE5BF */
	/* codebase=0xe5c0 rawbase=0x4c00 */
	0x657b,0x65b2,0x65b3,0x66b5,0x66b0,0x66a9,0x66b2,0x66b7, /* 0xE5C0-0xE5C7 */
	0x66aa,0x66af,0x6a00,0x6a06,0x6a17,0x69e5,0x69f8,0x6a15, /* 0xE5C8-0xE5CF */
	0x69f1,0x69e4,0x6a20,0x69ff,0x69ec,0x69e2,0x6a1b,0x6a1d, /* 0xE5D0-0xE5D7 */
	0x69fe,0x6a27,0x69f2,0x69ee,0x6a14,0x69f7,0x69e7,0x6a40, /* 0xE5D8-0xE5DF */
	0x6a08,0x69e6,0x69fb,0x6a0d,0x69fc,0x69eb,0x6a09,0x6a04, /* 0xE5E0-0xE5E7 */
	0x6a18,0x6a25,0x6a0f,0x69f6,0x6a26,0x6a07,0x69f4,0x6a16, /* 0xE5E8-0xE5EF */
	0x6b51,0x6ba5,0x6ba3,0x6ba2,0x6ba6,0x6c01,0x6c00,0x6bff, /* 0xE5F0-0xE5F7 */
	0x6c02,0x6f41,0x6f26,0x6f7e,0x6f87,0x6fc6,0x6f92,0x0000, /* 0xE5F8-0xE5FF */
	/* codebase=0xe640 rawbase=0x4c40 */
	0x6f8d,0x6f89,0x6f8c,0x6f62,0x6f4f,0x6f85,0x6f5a,0x6f96, /* 0xE640-0xE647 */
	0x6f76,0x6f6c,0x6f82,0x6f55,0x6f72,0x6f52,0x6f50,0x6f57, /* 0xE648-0xE64F */
	0x6f94,0x6f93,0x6f5d,0x6f00,0x6f61,0x6f6b,0x6f7d,0x6f67, /* 0xE650-0xE657 */
	0x6f90,0x6f53,0x6f8b,0x6f69,0x6f7f,0x6f95,0x6f63,0x6f77, /* 0xE658-0xE65F */
	0x6f6a,0x6f7b,0x71b2,0x71af,0x719b,0x71b0,0x71a0,0x719a, /* 0xE660-0xE667 */
	0x71a9,0x71b5,0x719d,0x71a5,0x719e,0x71a4,0x71a1,0x71aa, /* 0xE668-0xE66F */
	0x719c,0x71a7,0x71b3,0x7298,0x729a,0x7358,0x7352,0x735e, /* 0xE670-0xE677 */
	0x735f,0x7360,0x735d,0x735b,0x7361,0x735a,0x7359,0x0000, /* 0xE678-0xE67F */
	/* codebase=0xe680 rawbase=0x4c80 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE680-0xE687 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE688-0xE68F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE690-0xE697 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE698-0xE69F */
	0x0000,0x7362,0x7487,0x7489,0x748a,0x7486,0x7481,0x747d, /* 0xE6A0-0xE6A7 */
	0x7485,0x7488,0x747c,0x7479,0x7508,0x7507,0x757e,0x7625, /* 0xE6A8-0xE6AF */
	0x761e,0x7619,0x761d,0x761c,0x7623,0x761a,0x7628,0x761b, /* 0xE6B0-0xE6B7 */
	0x769c,0x769d,0x769e,0x769b,0x778d,0x778f,0x7789,0x7788, /* 0xE6B8-0xE6BF */
	/* codebase=0xe6c0 rawbase=0x4cc0 */
	0x78cd,0x78bb,0x78cf,0x78cc,0x78d1,0x78ce,0x78d4,0x78c8, /* 0xE6C0-0xE6C7 */
	0x78c3,0x78c4,0x78c9,0x799a,0x79a1,0x79a0,0x799c,0x79a2, /* 0xE6C8-0xE6CF */
	0x799b,0x6b76,0x7a39,0x7ab2,0x7ab4,0x7ab3,0x7bb7,0x7bcb, /* 0xE6D0-0xE6D7 */
	0x7bbe,0x7bac,0x7bce,0x7baf,0x7bb9,0x7bca,0x7bb5,0x7cc5, /* 0xE6D8-0xE6DF */
	0x7cc8,0x7ccc,0x7ccb,0x7df7,0x7ddb,0x7dea,0x7de7,0x7dd7, /* 0xE6E0-0xE6E7 */
	0x7de1,0x7e03,0x7dfa,0x7de6,0x7df6,0x7df1,0x7df0,0x7dee, /* 0xE6E8-0xE6EF */
	0x7ddf,0x7f76,0x7fac,0x7fb0,0x7fad,0x7fed,0x7feb,0x7fea, /* 0xE6F0-0xE6F7 */
	0x7fec,0x7fe6,0x7fe8,0x8064,0x8067,0x81a3,0x819f,0x0000, /* 0xE6F8-0xE6FF */
	/* codebase=0xe740 rawbase=0x4d00 */
	0x819e,0x8195,0x81a2,0x8199,0x8197,0x8216,0x824f,0x8253, /* 0xE740-0xE747 */
	0x8252,0x8250,0x824e,0x8251,0x8524,0x853b,0x850f,0x8500, /* 0xE748-0xE74F */
	0x8529,0x850e,0x8509,0x850d,0x851f,0x850a,0x8527,0x851c, /* 0xE750-0xE757 */
	0x84fb,0x852b,0x84fa,0x8508,0x850c,0x84f4,0x852a,0x84f2, /* 0xE758-0xE75F */
	0x8515,0x84f7,0x84eb,0x84f3,0x84fc,0x8512,0x84ea,0x84e9, /* 0xE760-0xE767 */
	0x8516,0x84fe,0x8528,0x851d,0x852e,0x8502,0x84fd,0x851e, /* 0xE768-0xE76F */
	0x84f6,0x8531,0x8526,0x84e7,0x84e8,0x84f0,0x84ef,0x84f9, /* 0xE770-0xE777 */
	0x8518,0x8520,0x8530,0x850b,0x8519,0x852f,0x8662,0x0000, /* 0xE778-0xE77F */
	/* codebase=0xe780 rawbase=0x4d40 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE780-0xE787 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE788-0xE78F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE790-0xE797 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE798-0xE79F */
	0x0000,0x8756,0x8763,0x8764,0x8777,0x87e1,0x8773,0x8758, /* 0xE7A0-0xE7A7 */
	0x8754,0x875b,0x8752,0x8761,0x875a,0x8751,0x875e,0x876d, /* 0xE7A8-0xE7AF */
	0x876a,0x8750,0x874e,0x875f,0x875d,0x876f,0x876c,0x877a, /* 0xE7B0-0xE7B7 */
	0x876e,0x875c,0x8765,0x874f,0x877b,0x8775,0x8762,0x8767, /* 0xE7B8-0xE7BF */
	/* codebase=0xe7c0 rawbase=0x4d80 */
	0x8769,0x885a,0x8905,0x890c,0x8914,0x890b,0x8917,0x8918, /* 0xE7C0-0xE7C7 */
	0x8919,0x8906,0x8916,0x8911,0x890e,0x8909,0x89a2,0x89a4, /* 0xE7C8-0xE7CF */
	0x89a3,0x89ed,0x89f0,0x89ec,0x8acf,0x8ac6,0x8ab8,0x8ad3, /* 0xE7D0-0xE7D7 */
	0x8ad1,0x8ad4,0x8ad5,0x8abb,0x8ad7,0x8abe,0x8ac0,0x8ac5, /* 0xE7D8-0xE7DF */
	0x8ad8,0x8ac3,0x8aba,0x8abd,0x8ad9,0x8c3e,0x8c4d,0x8c8f, /* 0xE7E0-0xE7E7 */
	0x8ce5,0x8cdf,0x8cd9,0x8ce8,0x8cda,0x8cdd,0x8ce7,0x8da0, /* 0xE7E8-0xE7EF */
	0x8d9c,0x8da1,0x8d9b,0x8e20,0x8e23,0x8e25,0x8e24,0x8e2e, /* 0xE7F0-0xE7F7 */
	0x8e15,0x8e1b,0x8e16,0x8e11,0x8e19,0x8e26,0x8e27,0x0000, /* 0xE7F8-0xE7FF */
	/* codebase=0xe840 rawbase=0x4dc0 */
	0x8e14,0x8e12,0x8e18,0x8e13,0x8e1c,0x8e17,0x8e1a,0x8f2c, /* 0xE840-0xE847 */
	0x8f24,0x8f18,0x8f1a,0x8f20,0x8f23,0x8f16,0x8f17,0x9073, /* 0xE848-0xE84F */
	0x9070,0x906f,0x9067,0x906b,0x912f,0x912b,0x9129,0x912a, /* 0xE850-0xE857 */
	0x9132,0x9126,0x912e,0x9185,0x9186,0x918a,0x9181,0x9182, /* 0xE858-0xE85F */
	0x9184,0x9180,0x92d0,0x92c3,0x92c4,0x92c0,0x92d9,0x92b6, /* 0xE860-0xE867 */
	0x92cf,0x92f1,0x92df,0x92d8,0x92e9,0x92d7,0x92dd,0x92cc, /* 0xE868-0xE86F */
	0x92ef,0x92c2,0x92e8,0x92ca,0x92c8,0x92ce,0x92e6,0x92cd, /* 0xE870-0xE877 */
	0x92d5,0x92c9,0x92e0,0x92de,0x92e7,0x92d1,0x92d3,0x0000, /* 0xE878-0xE87F */
	/* codebase=0xe880 rawbase=0x4e00 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE880-0xE887 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE888-0xE88F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE890-0xE897 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE898-0xE89F */
	0x0000,0x92b5,0x92e1,0x92c6,0x92b4,0x957c,0x95ac,0x95ab, /* 0xE8A0-0xE8A7 */
	0x95ae,0x95b0,0x96a4,0x96a2,0x96d3,0x9705,0x9708,0x9702, /* 0xE8A8-0xE8AF */
	0x975a,0x978a,0x978e,0x9788,0x97d0,0x97cf,0x981e,0x981d, /* 0xE8B0-0xE8B7 */
	0x9826,0x9829,0x9828,0x9820,0x981b,0x9827,0x98b2,0x9908, /* 0xE8B8-0xE8BF */
	/* codebase=0xe8c0 rawbase=0x4e40 */
	0x98fa,0x9911,0x9914,0x9916,0x9917,0x9915,0x99dc,0x99cd, /* 0xE8C0-0xE8C7 */
	0x99cf,0x99d3,0x99d4,0x99ce,0x99c9,0x99d6,0x99d8,0x99cb, /* 0xE8C8-0xE8CF */
	0x99d7,0x99cc,0x9ab3,0x9aec,0x9aeb,0x9af3,0x9af2,0x9af1, /* 0xE8D0-0xE8D7 */
	0x9b46,0x9b43,0x9b67,0x9b74,0x9b71,0x9b66,0x9b76,0x9b75, /* 0xE8D8-0xE8DF */
	0x9b70,0x9b68,0x9b64,0x9b6c,0x9cfc,0x9cfa,0x9cfd,0x9cff, /* 0xE8E0-0xE8E7 */
	0x9cf7,0x9d07,0x9d00,0x9cf9,0x9cfb,0x9d08,0x9d05,0x9d04, /* 0xE8E8-0xE8EF */
	0x9e83,0x9ed3,0x9f0f,0x9f10,0x511c,0x5113,0x5117,0x511a, /* 0xE8F0-0xE8F7 */
	0x5111,0x51de,0x5334,0x53e1,0x5670,0x5660,0x566e,0x0000, /* 0xE8F8-0xE8FF */
	/* codebase=0xe940 rawbase=0x4e80 */
	0x5673,0x5666,0x5663,0x566d,0x5672,0x565e,0x5677,0x571c, /* 0xE940-0xE947 */
	0x571b,0x58c8,0x58bd,0x58c9,0x58bf,0x58ba,0x58c2,0x58bc, /* 0xE948-0xE94F */
	0x58c6,0x5b17,0x5b19,0x5b1b,0x5b21,0x5b14,0x5b13,0x5b10, /* 0xE950-0xE957 */
	0x5b16,0x5b28,0x5b1a,0x5b20,0x5b1e,0x5bef,0x5dac,0x5db1, /* 0xE958-0xE95F */
	0x5da9,0x5da7,0x5db5,0x5db0,0x5dae,0x5daa,0x5da8,0x5db2, /* 0xE960-0xE967 */
	0x5dad,0x5daf,0x5db4,0x5e67,0x5e68,0x5e66,0x5e6f,0x5ee9, /* 0xE968-0xE96F */
	0x5ee7,0x5ee6,0x5ee8,0x5ee5,0x5f4b,0x5fbc,0x619d,0x61a8, /* 0xE970-0xE977 */
	0x6196,0x61c5,0x61b4,0x61c6,0x61c1,0x61cc,0x61ba,0x0000, /* 0xE978-0xE97F */
	/* codebase=0xe980 rawbase=0x4ec0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE980-0xE987 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE988-0xE98F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE990-0xE997 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE998-0xE99F */
	0x0000,0x61bf,0x61b8,0x618c,0x64d7,0x64d6,0x64d0,0x64cf, /* 0xE9A0-0xE9A7 */
	0x64c9,0x64bd,0x6489,0x64c3,0x64db,0x64f3,0x64d9,0x6533, /* 0xE9A8-0xE9AF */
	0x657f,0x657c,0x65a2,0x66c8,0x66be,0x66c0,0x66ca,0x66cb, /* 0xE9B0-0xE9B7 */
	0x66cf,0x66bd,0x66bb,0x66ba,0x66cc,0x6723,0x6a34,0x6a66, /* 0xE9B8-0xE9BF */
	/* codebase=0xe9c0 rawbase=0x4f00 */
	0x6a49,0x6a67,0x6a32,0x6a68,0x6a3e,0x6a5d,0x6a6d,0x6a76, /* 0xE9C0-0xE9C7 */
	0x6a5b,0x6a51,0x6a28,0x6a5a,0x6a3b,0x6a3f,0x6a41,0x6a6a, /* 0xE9C8-0xE9CF */
	0x6a64,0x6a50,0x6a4f,0x6a54,0x6a6f,0x6a69,0x6a60,0x6a3c, /* 0xE9D0-0xE9D7 */
	0x6a5e,0x6a56,0x6a55,0x6a4d,0x6a4e,0x6a46,0x6b55,0x6b54, /* 0xE9D8-0xE9DF */
	0x6b56,0x6ba7,0x6baa,0x6bab,0x6bc8,0x6bc7,0x6c04,0x6c03, /* 0xE9E0-0xE9E7 */
	0x6c06,0x6fad,0x6fcb,0x6fa3,0x6fc7,0x6fbc,0x6fce,0x6fc8, /* 0xE9E8-0xE9EF */
	0x6f5e,0x6fc4,0x6fbd,0x6f9e,0x6fca,0x6fa8,0x7004,0x6fa5, /* 0xE9F0-0xE9F7 */
	0x6fae,0x6fba,0x6fac,0x6faa,0x6fcf,0x6fbf,0x6fb8,0x0000, /* 0xE9F8-0xE9FF */
	/* codebase=0xea40 rawbase=0x4f40 */
	0x6fa2,0x6fc9,0x6fab,0x6fcd,0x6faf,0x6fb2,0x6fb0,0x71c5, /* 0xEA40-0xEA47 */
	0x71c2,0x71bf,0x71b8,0x71d6,0x71c0,0x71c1,0x71cb,0x71d4, /* 0xEA48-0xEA4F */
	0x71ca,0x71c7,0x71cf,0x71bd,0x71d8,0x71bc,0x71c6,0x71da, /* 0xEA50-0xEA57 */
	0x71db,0x729d,0x729e,0x7369,0x7366,0x7367,0x736c,0x7365, /* 0xEA58-0xEA5F */
	0x736b,0x736a,0x747f,0x749a,0x74a0,0x7494,0x7492,0x7495, /* 0xEA60-0xEA67 */
	0x74a1,0x750b,0x7580,0x762f,0x762d,0x7631,0x763d,0x7633, /* 0xEA68-0xEA6F */
	0x763c,0x7635,0x7632,0x7630,0x76bb,0x76e6,0x779a,0x779d, /* 0xEA70-0xEA77 */
	0x77a1,0x779c,0x779b,0x77a2,0x77a3,0x7795,0x7799,0x0000, /* 0xEA78-0xEA7F */
	/* codebase=0xea80 rawbase=0x4f80 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xEA80-0xEA87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xEA88-0xEA8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xEA90-0xEA97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xEA98-0xEA9F */
	0x0000,0x7797,0x78dd,0x78e9,0x78e5,0x78ea,0x78de,0x78e3, /* 0xEAA0-0xEAA7 */
	0x78db,0x78e1,0x78e2,0x78ed,0x78df,0x78e0,0x79a4,0x7a44, /* 0xEAA8-0xEAAF */
	0x7a48,0x7a47,0x7ab6,0x7ab8,0x7ab5,0x7ab1,0x7ab7,0x7bde, /* 0xEAB0-0xEAB7 */
	0x7be3,0x7be7,0x7bdd,0x7bd5,0x7be5,0x7bda,0x7be8,0x7bf9, /* 0xEAB8-0xEABF */
	/* codebase=0xeac0 rawbase=0x4fc0 */
	0x7bd4,0x7bea,0x7be2,0x7bdc,0x7beb,0x7bd8,0x7bdf,0x7cd2, /* 0xEAC0-0xEAC7 */
	0x7cd4,0x7cd7,0x7cd0,0x7cd1,0x7e12,0x7e21,0x7e17,0x7e0c, /* 0xEAC8-0xEACF */
	0x7e1f,0x7e20,0x7e13,0x7e0e,0x7e1c,0x7e15,0x7e1a,0x7e22, /* 0xEAD0-0xEAD7 */
	0x7e0b,0x7e0f,0x7e16,0x7e0d,0x7e14,0x7e25,0x7e24,0x7f43, /* 0xEAD8-0xEADF */
	0x7f7b,0x7f7c,0x7f7a,0x7fb1,0x7fef,0x802a,0x8029,0x806c, /* 0xEAE0-0xEAE7 */
	0x81b1,0x81a6,0x81ae,0x81b9,0x81b5,0x81ab,0x81b0,0x81ac, /* 0xEAE8-0xEAEF */
	0x81b4,0x81b2,0x81b7,0x81a7,0x81f2,0x8255,0x8256,0x8257, /* 0xEAF0-0xEAF7 */
	0x8556,0x8545,0x856b,0x854d,0x8553,0x8561,0x8558,0x0000, /* 0xEAF8-0xEAFF */
	/* codebase=0xeb40 rawbase=0x5000 */
	0x8540,0x8546,0x8564,0x8541,0x8562,0x8544,0x8551,0x8547, /* 0xEB40-0xEB47 */
	0x8563,0x853e,0x855b,0x8571,0x854e,0x856e,0x8575,0x8555, /* 0xEB48-0xEB4F */
	0x8567,0x8560,0x858c,0x8566,0x855d,0x8554,0x8565,0x856c, /* 0xEB50-0xEB57 */
	0x8663,0x8665,0x8664,0x879b,0x878f,0x8797,0x8793,0x8792, /* 0xEB58-0xEB5F */
	0x8788,0x8781,0x8796,0x8798,0x8779,0x8787,0x87a3,0x8785, /* 0xEB60-0xEB67 */
	0x8790,0x8791,0x879d,0x8784,0x8794,0x879c,0x879a,0x8789, /* 0xEB68-0xEB6F */
	0x891e,0x8926,0x8930,0x892d,0x892e,0x8927,0x8931,0x8922, /* 0xEB70-0xEB77 */
	0x8929,0x8923,0x892f,0x892c,0x891f,0x89f1,0x8ae0,0x0000, /* 0xEB78-0xEB7F */
	/* codebase=0xeb80 rawbase=0x5040 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xEB80-0xEB87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xEB88-0xEB8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xEB90-0xEB97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xEB98-0xEB9F */
	0x0000,0x8ae2,0x8af2,0x8af4,0x8af5,0x8add,0x8b14,0x8ae4, /* 0xEBA0-0xEBA7 */
	0x8adf,0x8af0,0x8ac8,0x8ade,0x8ae1,0x8ae8,0x8aff,0x8aef, /* 0xEBA8-0xEBAF */
	0x8afb,0x8c91,0x8c92,0x8c90,0x8cf5,0x8cee,0x8cf1,0x8cf0, /* 0xEBB0-0xEBB7 */
	0x8cf3,0x8d6c,0x8d6e,0x8da5,0x8da7,0x8e33,0x8e3e,0x8e38, /* 0xEBB8-0xEBBF */
	/* codebase=0xebc0 rawbase=0x5080 */
	0x8e40,0x8e45,0x8e36,0x8e3c,0x8e3d,0x8e41,0x8e30,0x8e3f, /* 0xEBC0-0xEBC7 */
	0x8ebd,0x8f36,0x8f2e,0x8f35,0x8f32,0x8f39,0x8f37,0x8f34, /* 0xEBC8-0xEBCF */
	0x9076,0x9079,0x907b,0x9086,0x90fa,0x9133,0x9135,0x9136, /* 0xEBD0-0xEBD7 */
	0x9193,0x9190,0x9191,0x918d,0x918f,0x9327,0x931e,0x9308, /* 0xEBD8-0xEBDF */
	0x931f,0x9306,0x930f,0x937a,0x9338,0x933c,0x931b,0x9323, /* 0xEBE0-0xEBE7 */
	0x9312,0x9301,0x9346,0x932d,0x930e,0x930d,0x92cb,0x931d, /* 0xEBE8-0xEBEF */
	0x92fa,0x9325,0x9313,0x92f9,0x92f7,0x9334,0x9302,0x9324, /* 0xEBF0-0xEBF7 */
	0x92ff,0x9329,0x9339,0x9335,0x932a,0x9314,0x930c,0x0000, /* 0xEBF8-0xEBFF */
	/* codebase=0xec40 rawbase=0x50c0 */
	0x930b,0x92fe,0x9309,0x9300,0x92fb,0x9316,0x95bc,0x95cd, /* 0xEC40-0xEC47 */
	0x95be,0x95b9,0x95ba,0x95b6,0x95bf,0x95b5,0x95bd,0x96a9, /* 0xEC48-0xEC4F */
	0x96d4,0x970b,0x9712,0x9710,0x9799,0x9797,0x9794,0x97f0, /* 0xEC50-0xEC57 */
	0x97f8,0x9835,0x982f,0x9832,0x9924,0x991f,0x9927,0x9929, /* 0xEC58-0xEC5F */
	0x999e,0x99ee,0x99ec,0x99e5,0x99e4,0x99f0,0x99e3,0x99ea, /* 0xEC60-0xEC67 */
	0x99e9,0x99e7,0x9ab9,0x9abf,0x9ab4,0x9abb,0x9af6,0x9afa, /* 0xEC68-0xEC6F */
	0x9af9,0x9af7,0x9b33,0x9b80,0x9b85,0x9b87,0x9b7c,0x9b7e, /* 0xEC70-0xEC77 */
	0x9b7b,0x9b82,0x9b93,0x9b92,0x9b90,0x9b7a,0x9b95,0x0000, /* 0xEC78-0xEC7F */
	/* codebase=0xec80 rawbase=0x5100 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xEC80-0xEC87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xEC88-0xEC8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xEC90-0xEC97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xEC98-0xEC9F */
	0x0000,0x9b7d,0x9b88,0x9d25,0x9d17,0x9d20,0x9d1e,0x9d14, /* 0xECA0-0xECA7 */
	0x9d29,0x9d1d,0x9d18,0x9d22,0x9d10,0x9d19,0x9d1f,0x9e88, /* 0xECA8-0xECAF */
	0x9e86,0x9e87,0x9eae,0x9ead,0x9ed5,0x9ed6,0x9efa,0x9f12, /* 0xECB0-0xECB7 */
	0x9f3d,0x5126,0x5125,0x5122,0x5124,0x5120,0x5129,0x52f4, /* 0xECB8-0xECBF */
	/* codebase=0xecc0 rawbase=0x5140 */
	0x5693,0x568c,0x568d,0x5686,0x5684,0x5683,0x567e,0x5682, /* 0xECC0-0xECC7 */
	0x567f,0x5681,0x58d6,0x58d4,0x58cf,0x58d2,0x5b2d,0x5b25, /* 0xECC8-0xECCF */
	0x5b32,0x5b23,0x5b2c,0x5b27,0x5b26,0x5b2f,0x5b2e,0x5b7b, /* 0xECD0-0xECD7 */
	0x5bf1,0x5bf2,0x5db7,0x5e6c,0x5e6a,0x5fbe,0x5fbb,0x61c3, /* 0xECD8-0xECDF */
	0x61b5,0x61bc,0x61e7,0x61e0,0x61e5,0x61e4,0x61e8,0x61de, /* 0xECE0-0xECE7 */
	0x64ef,0x64e9,0x64e3,0x64eb,0x64e4,0x64e8,0x6581,0x6580, /* 0xECE8-0xECEF */
	0x65b6,0x65da,0x66d2,0x6a8d,0x6a96,0x6a81,0x6aa5,0x6a89, /* 0xECF0-0xECF7 */
	0x6a9f,0x6a9b,0x6aa1,0x6a9e,0x6a87,0x6a93,0x6a8e,0x0000, /* 0xECF8-0xECFF */
	/* codebase=0xed40 rawbase=0x5180 */
	0x6a95,0x6a83,0x6aa8,0x6aa4,0x6a91,0x6a7f,0x6aa6,0x6a9a, /* 0xED40-0xED47 */
	0x6a85,0x6a8c,0x6a92,0x6b5b,0x6bad,0x6c09,0x6fcc,0x6fa9, /* 0xED48-0xED4F */
	0x6ff4,0x6fd4,0x6fe3,0x6fdc,0x6fed,0x6fe7,0x6fe6,0x6fde, /* 0xED50-0xED57 */
	0x6ff2,0x6fdd,0x6fe2,0x6fe8,0x71e1,0x71f1,0x71e8,0x71f2, /* 0xED58-0xED5F */
	0x71e4,0x71f0,0x71e2,0x7373,0x736e,0x736f,0x7497,0x74b2, /* 0xED60-0xED67 */
	0x74ab,0x7490,0x74aa,0x74ad,0x74b1,0x74a5,0x74af,0x7510, /* 0xED68-0xED6F */
	0x7511,0x7512,0x750f,0x7584,0x7643,0x7648,0x7649,0x7647, /* 0xED70-0xED77 */
	0x76a4,0x76e9,0x77b5,0x77ab,0x77b2,0x77b7,0x77b6,0x0000, /* 0xED78-0xED7F */
	/* codebase=0xed80 rawbase=0x51c0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xED80-0xED87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xED88-0xED8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xED90-0xED97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xED98-0xED9F */
	0x0000,0x77b4,0x77b1,0x77a8,0x77f0,0x78f3,0x78fd,0x7902, /* 0xEDA0-0xEDA7 */
	0x78fb,0x78fc,0x78f2,0x7905,0x78f9,0x78fe,0x7904,0x79ab, /* 0xEDA8-0xEDAF */
	0x79a8,0x7a5c,0x7a5b,0x7a56,0x7a58,0x7a54,0x7a5a,0x7abe, /* 0xEDB0-0xEDB7 */
	0x7ac0,0x7ac1,0x7c05,0x7c0f,0x7bf2,0x7c00,0x7bff,0x7bfb, /* 0xEDB8-0xEDBF */
	/* codebase=0xedc0 rawbase=0x5200 */
	0x7c0e,0x7bf4,0x7c0b,0x7bf3,0x7c02,0x7c09,0x7c03,0x7c01, /* 0xEDC0-0xEDC7 */
	0x7bf8,0x7bfd,0x7c06,0x7bf0,0x7bf1,0x7c10,0x7c0a,0x7ce8, /* 0xEDC8-0xEDCF */
	0x7e2d,0x7e3c,0x7e42,0x7e33,0x9848,0x7e38,0x7e2a,0x7e49, /* 0xEDD0-0xEDD7 */
	0x7e40,0x7e47,0x7e29,0x7e4c,0x7e30,0x7e3b,0x7e36,0x7e44, /* 0xEDD8-0xEDDF */
	0x7e3a,0x7f45,0x7f7f,0x7f7e,0x7f7d,0x7ff4,0x7ff2,0x802c, /* 0xEDE0-0xEDE7 */
	0x81bb,0x81c4,0x81cc,0x81ca,0x81c5,0x81c7,0x81bc,0x81e9, /* 0xEDE8-0xEDEF */
	0x825b,0x825a,0x825c,0x8583,0x8580,0x858f,0x85a7,0x8595, /* 0xEDF0-0xEDF7 */
	0x85a0,0x858b,0x85a3,0x857b,0x85a4,0x859a,0x859e,0x0000, /* 0xEDF8-0xEDFF */
	/* codebase=0xee40 rawbase=0x5240 */
	0x8577,0x857c,0x8589,0x85a1,0x857a,0x8578,0x8557,0x858e, /* 0xEE40-0xEE47 */
	0x8596,0x8586,0x858d,0x8599,0x859d,0x8581,0x85a2,0x8582, /* 0xEE48-0xEE4F */
	0x8588,0x8585,0x8579,0x8576,0x8598,0x8590,0x859f,0x8668, /* 0xEE50-0xEE57 */
	0x87be,0x87aa,0x87ad,0x87c5,0x87b0,0x87ac,0x87b9,0x87b5, /* 0xEE58-0xEE5F */
	0x87bc,0x87ae,0x87c9,0x87c3,0x87c2,0x87cc,0x87b7,0x87af, /* 0xEE60-0xEE67 */
	0x87c4,0x87ca,0x87b4,0x87b6,0x87bf,0x87b8,0x87bd,0x87de, /* 0xEE68-0xEE6F */
	0x87b2,0x8935,0x8933,0x893c,0x893e,0x8941,0x8952,0x8937, /* 0xEE70-0xEE77 */
	0x8942,0x89ad,0x89af,0x89ae,0x89f2,0x89f3,0x8b1e,0x0000, /* 0xEE78-0xEE7F */
	/* codebase=0xee80 rawbase=0x5280 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xEE80-0xEE87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xEE88-0xEE8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xEE90-0xEE97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xEE98-0xEE9F */
	0x0000,0x8b18,0x8b16,0x8b11,0x8b05,0x8b0b,0x8b22,0x8b0f, /* 0xEEA0-0xEEA7 */
	0x8b12,0x8b15,0x8b07,0x8b0d,0x8b08,0x8b06,0x8b1c,0x8b13, /* 0xEEA8-0xEEAF */
	0x8b1a,0x8c4f,0x8c70,0x8c72,0x8c71,0x8c6f,0x8c95,0x8c94, /* 0xEEB0-0xEEB7 */
	0x8cf9,0x8d6f,0x8e4e,0x8e4d,0x8e53,0x8e50,0x8e4c,0x8e47, /* 0xEEB8-0xEEBF */
	/* codebase=0xeec0 rawbase=0x52c0 */
	0x8f43,0x8f40,0x9085,0x907e,0x9138,0x919a,0x91a2,0x919b, /* 0xEEC0-0xEEC7 */
	0x9199,0x919f,0x91a1,0x919d,0x91a0,0x93a1,0x9383,0x93af, /* 0xEEC8-0xEECF */
	0x9364,0x9356,0x9347,0x937c,0x9358,0x935c,0x9376,0x9349, /* 0xEED0-0xEED7 */
	0x9350,0x9351,0x9360,0x936d,0x938f,0x934c,0x936a,0x9379, /* 0xEED8-0xEEDF */
	0x9357,0x9355,0x9352,0x934f,0x9371,0x9377,0x937b,0x9361, /* 0xEEE0-0xEEE7 */
	0x935e,0x9363,0x9367,0x9380,0x934e,0x9359,0x95c7,0x95c0, /* 0xEEE8-0xEEEF */
	0x95c9,0x95c3,0x95c5,0x95b7,0x96ae,0x96b0,0x96ac,0x9720, /* 0xEEF0-0xEEF7 */
	0x971f,0x9718,0x971d,0x9719,0x979a,0x97a1,0x979c,0x0000, /* 0xEEF8-0xEEFF */
	/* codebase=0xef40 rawbase=0x5300 */
	0x979e,0x979d,0x97d5,0x97d4,0x97f1,0x9841,0x9844,0x984a, /* 0xEF40-0xEF47 */
	0x9849,0x9845,0x9843,0x9925,0x992b,0x992c,0x992a,0x9933, /* 0xEF48-0xEF4F */
	0x9932,0x992f,0x992d,0x9931,0x9930,0x9998,0x99a3,0x99a1, /* 0xEF50-0xEF57 */
	0x9a02,0x99fa,0x99f4,0x99f7,0x99f9,0x99f8,0x99f6,0x99fb, /* 0xEF58-0xEF5F */
	0x99fd,0x99fe,0x99fc,0x9a03,0x9abe,0x9afe,0x9afd,0x9b01, /* 0xEF60-0xEF67 */
	0x9afc,0x9b48,0x9b9a,0x9ba8,0x9b9e,0x9b9b,0x9ba6,0x9ba1, /* 0xEF68-0xEF6F */
	0x9ba5,0x9ba4,0x9b86,0x9ba2,0x9ba0,0x9baf,0x9d33,0x9d41, /* 0xEF70-0xEF77 */
	0x9d67,0x9d36,0x9d2e,0x9d2f,0x9d31,0x9d38,0x9d30,0x0000, /* 0xEF78-0xEF7F */
	/* codebase=0xef80 rawbase=0x5340 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xEF80-0xEF87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xEF88-0xEF8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xEF90-0xEF97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xEF98-0xEF9F */
	0x0000,0x9d45,0x9d42,0x9d43,0x9d3e,0x9d37,0x9d40,0x9d3d, /* 0xEFA0-0xEFA7 */
	0x7ff5,0x9d2d,0x9e8a,0x9e89,0x9e8d,0x9eb0,0x9ec8,0x9eda, /* 0xEFA8-0xEFAF */
	0x9efb,0x9eff,0x9f24,0x9f23,0x9f22,0x9f54,0x9fa0,0x5131, /* 0xEFB0-0xEFB7 */
	0x512d,0x512e,0x5698,0x569c,0x5697,0x569a,0x569d,0x5699, /* 0xEFB8-0xEFBF */
	/* codebase=0xefc0 rawbase=0x5380 */
	0x5970,0x5b3c,0x5c69,0x5c6a,0x5dc0,0x5e6d,0x5e6e,0x61d8, /* 0xEFC0-0xEFC7 */
	0x61df,0x61ed,0x61ee,0x61f1,0x61ea,0x61f0,0x61eb,0x61d6, /* 0xEFC8-0xEFCF */
	0x61e9,0x64ff,0x6504,0x64fd,0x64f8,0x6501,0x6503,0x64fc, /* 0xEFD0-0xEFD7 */
	0x6594,0x65db,0x66da,0x66db,0x66d8,0x6ac5,0x6ab9,0x6abd, /* 0xEFD8-0xEFDF */
	0x6ae1,0x6ac6,0x6aba,0x6ab6,0x6ab7,0x6ac7,0x6ab4,0x6aad, /* 0xEFE0-0xEFE7 */
	0x6b5e,0x6bc9,0x6c0b,0x7007,0x700c,0x700d,0x7001,0x7005, /* 0xEFE8-0xEFEF */
	0x7014,0x700e,0x6fff,0x7000,0x6ffb,0x7026,0x6ffc,0x6ff7, /* 0xEFF0-0xEFF7 */
	0x700a,0x7201,0x71ff,0x71f9,0x7203,0x71fd,0x7376,0x0000, /* 0xEFF8-0xEFFF */
	/* codebase=0xf040 rawbase=0x53c0 */
	0x74b8,0x74c0,0x74b5,0x74c1,0x74be,0x74b6,0x74bb,0x74c2, /* 0xF040-0xF047 */
	0x7514,0x7513,0x765c,0x7664,0x7659,0x7650,0x7653,0x7657, /* 0xF048-0xF04F */
	0x765a,0x76a6,0x76bd,0x76ec,0x77c2,0x77ba,0x78ff,0x790c, /* 0xF050-0xF057 */
	0x7913,0x7914,0x7909,0x7910,0x7912,0x7911,0x79ad,0x79ac, /* 0xF058-0xF05F */
	0x7a5f,0x7c1c,0x7c29,0x7c19,0x7c20,0x7c1f,0x7c2d,0x7c1d, /* 0xF060-0xF067 */
	0x7c26,0x7c28,0x7c22,0x7c25,0x7c30,0x7e5c,0x7e50,0x7e56, /* 0xF068-0xF06F */
	0x7e63,0x7e58,0x7e62,0x7e5f,0x7e51,0x7e60,0x7e57,0x7e53, /* 0xF070-0xF077 */
	0x7fb5,0x7fb3,0x7ff7,0x7ff8,0x8075,0x81d1,0x81d2,0x0000, /* 0xF078-0xF07F */
	/* codebase=0xf080 rawbase=0x5400 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF080-0xF087 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF088-0xF08F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF090-0xF097 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF098-0xF09F */
	0x0000,0x81d0,0x825f,0x825e,0x85b4,0x85c6,0x85c0,0x85c3, /* 0xF0A0-0xF0A7 */
	0x85c2,0x85b3,0x85b5,0x85bd,0x85c7,0x85c4,0x85bf,0x85cb, /* 0xF0A8-0xF0AF */
	0x85ce,0x85c8,0x85c5,0x85b1,0x85b6,0x85d2,0x8624,0x85b8, /* 0xF0B0-0xF0B7 */
	0x85b7,0x85be,0x8669,0x87e7,0x87e6,0x87e2,0x87db,0x87eb, /* 0xF0B8-0xF0BF */
	/* codebase=0xf0c0 rawbase=0x5440 */
	0x87ea,0x87e5,0x87df,0x87f3,0x87e4,0x87d4,0x87dc,0x87d3, /* 0xF0C0-0xF0C7 */
	0x87ed,0x87d8,0x87e3,0x87a4,0x87d7,0x87d9,0x8801,0x87f4, /* 0xF0C8-0xF0CF */
	0x87e8,0x87dd,0x8953,0x894b,0x894f,0x894c,0x8946,0x8950, /* 0xF0D0-0xF0D7 */
	0x8951,0x8949,0x8b2a,0x8b27,0x8b23,0x8b33,0x8b30,0x8b35, /* 0xF0D8-0xF0DF */
	0x8b47,0x8b2f,0x8b3c,0x8b3e,0x8b31,0x8b25,0x8b37,0x8b26, /* 0xF0E0-0xF0E7 */
	0x8b36,0x8b2e,0x8b24,0x8b3b,0x8b3d,0x8b3a,0x8c42,0x8c75, /* 0xF0E8-0xF0EF */
	0x8c99,0x8c98,0x8c97,0x8cfe,0x8d04,0x8d02,0x8d00,0x8e5c, /* 0xF0F0-0xF0F7 */
	0x8e62,0x8e60,0x8e57,0x8e56,0x8e5e,0x8e65,0x8e67,0x0000, /* 0xF0F8-0xF0FF */
	/* codebase=0xf140 rawbase=0x5480 */
	0x8e5b,0x8e5a,0x8e61,0x8e5d,0x8e69,0x8e54,0x8f46,0x8f47, /* 0xF140-0xF147 */
	0x8f48,0x8f4b,0x9128,0x913a,0x913b,0x913e,0x91a8,0x91a5, /* 0xF148-0xF14F */
	0x91a7,0x91af,0x91aa,0x93b5,0x938c,0x9392,0x93b7,0x939b, /* 0xF150-0xF157 */
	0x939d,0x9389,0x93a7,0x938e,0x93aa,0x939e,0x93a6,0x9395, /* 0xF158-0xF15F */
	0x9388,0x9399,0x939f,0x938d,0x93b1,0x9391,0x93b2,0x93a4, /* 0xF160-0xF167 */
	0x93a8,0x93b4,0x93a3,0x93a5,0x95d2,0x95d3,0x95d1,0x96b3, /* 0xF168-0xF16F */
	0x96d7,0x96da,0x5dc2,0x96df,0x96d8,0x96dd,0x9723,0x9722, /* 0xF170-0xF177 */
	0x9725,0x97ac,0x97ae,0x97a8,0x97ab,0x97a4,0x97aa,0x0000, /* 0xF178-0xF17F */
	/* codebase=0xf180 rawbase=0x54c0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF180-0xF187 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF188-0xF18F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF190-0xF197 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF198-0xF19F */
	0x0000,0x97a2,0x97a5,0x97d7,0x97d9,0x97d6,0x97d8,0x97fa, /* 0xF1A0-0xF1A7 */
	0x9850,0x9851,0x9852,0x98b8,0x9941,0x993c,0x993a,0x9a0f, /* 0xF1A8-0xF1AF */
	0x9a0b,0x9a09,0x9a0d,0x9a04,0x9a11,0x9a0a,0x9a05,0x9a07, /* 0xF1B0-0xF1B7 */
	0x9a06,0x9ac0,0x9adc,0x9b08,0x9b04,0x9b05,0x9b29,0x9b35, /* 0xF1B8-0xF1BF */
	/* codebase=0xf1c0 rawbase=0x5500 */
	0x9b4a,0x9b4c,0x9b4b,0x9bc7,0x9bc6,0x9bc3,0x9bbf,0x9bc1, /* 0xF1C0-0xF1C7 */
	0x9bb5,0x9bb8,0x9bd3,0x9bb6,0x9bc4,0x9bb9,0x9bbd,0x9d5c, /* 0xF1C8-0xF1CF */
	0x9d53,0x9d4f,0x9d4a,0x9d5b,0x9d4b,0x9d59,0x9d56,0x9d4c, /* 0xF1D0-0xF1D7 */
	0x9d57,0x9d52,0x9d54,0x9d5f,0x9d58,0x9d5a,0x9e8e,0x9e8c, /* 0xF1D8-0xF1DF */
	0x9edf,0x9f01,0x9f00,0x9f16,0x9f25,0x9f2b,0x9f2a,0x9f29, /* 0xF1E0-0xF1E7 */
	0x9f28,0x9f4c,0x9f55,0x5134,0x5135,0x5296,0x52f7,0x53b4, /* 0xF1E8-0xF1EF */
	0x56ab,0x56ad,0x56a6,0x56a7,0x56aa,0x56ac,0x58da,0x58dd, /* 0xF1F0-0xF1F7 */
	0x58db,0x5912,0x5b3d,0x5b3e,0x5b3f,0x5dc3,0x5e70,0x0000, /* 0xF1F8-0xF1FF */
	/* codebase=0xf240 rawbase=0x5540 */
	0x5fbf,0x61fb,0x6507,0x6510,0x650d,0x6509,0x650c,0x650e, /* 0xF240-0xF247 */
	0x6584,0x65de,0x65dd,0x66de,0x6ae7,0x6ae0,0x6acc,0x6ad1, /* 0xF248-0xF24F */
	0x6ad9,0x6acb,0x6adf,0x6adc,0x6ad0,0x6aeb,0x6acf,0x6acd, /* 0xF250-0xF257 */
	0x6ade,0x6b60,0x6bb0,0x6c0c,0x7019,0x7027,0x7020,0x7016, /* 0xF258-0xF25F */
	0x702b,0x7021,0x7022,0x7023,0x7029,0x7017,0x7024,0x701c, /* 0xF260-0xF267 */
	0x702a,0x720c,0x720a,0x7207,0x7202,0x7205,0x72a5,0x72a6, /* 0xF268-0xF26F */
	0x72a4,0x72a3,0x72a1,0x74cb,0x74c5,0x74b7,0x74c3,0x7516, /* 0xF270-0xF277 */
	0x7660,0x77c9,0x77ca,0x77c4,0x77f1,0x791d,0x791b,0x0000, /* 0xF278-0xF27F */
	/* codebase=0xf280 rawbase=0x5580 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF280-0xF287 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF288-0xF28F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF290-0xF297 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF298-0xF29F */
	0x0000,0x7921,0x791c,0x7917,0x791e,0x79b0,0x7a67,0x7a68, /* 0xF2A0-0xF2A7 */
	0x7c33,0x7c3c,0x7c39,0x7c2c,0x7c3b,0x7cec,0x7cea,0x7e76, /* 0xF2A8-0xF2AF */
	0x7e75,0x7e78,0x7e70,0x7e77,0x7e6f,0x7e7a,0x7e72,0x7e74, /* 0xF2B0-0xF2B7 */
	0x7e68,0x7f4b,0x7f4a,0x7f83,0x7f86,0x7fb7,0x7ffd,0x7ffe, /* 0xF2B8-0xF2BF */
	/* codebase=0xf2c0 rawbase=0x55c0 */
	0x8078,0x81d7,0x81d5,0x8264,0x8261,0x8263,0x85eb,0x85f1, /* 0xF2C0-0xF2C7 */
	0x85ed,0x85d9,0x85e1,0x85e8,0x85da,0x85d7,0x85ec,0x85f2, /* 0xF2C8-0xF2CF */
	0x85f8,0x85d8,0x85df,0x85e3,0x85dc,0x85d1,0x85f0,0x85e6, /* 0xF2D0-0xF2D7 */
	0x85ef,0x85de,0x85e2,0x8800,0x87fa,0x8803,0x87f6,0x87f7, /* 0xF2D8-0xF2DF */
	0x8809,0x880c,0x880b,0x8806,0x87fc,0x8808,0x87ff,0x880a, /* 0xF2E0-0xF2E7 */
	0x8802,0x8962,0x895a,0x895b,0x8957,0x8961,0x895c,0x8958, /* 0xF2E8-0xF2EF */
	0x895d,0x8959,0x8988,0x89b7,0x89b6,0x89f6,0x8b50,0x8b48, /* 0xF2F0-0xF2F7 */
	0x8b4a,0x8b40,0x8b53,0x8b56,0x8b54,0x8b4b,0x8b55,0x0000, /* 0xF2F8-0xF2FF */
	/* codebase=0xf340 rawbase=0x5600 */
	0x8b51,0x8b42,0x8b52,0x8b57,0x8c43,0x8c77,0x8c76,0x8c9a, /* 0xF340-0xF347 */
	0x8d06,0x8d07,0x8d09,0x8dac,0x8daa,0x8dad,0x8dab,0x8e6d, /* 0xF348-0xF34F */
	0x8e78,0x8e73,0x8e6a,0x8e6f,0x8e7b,0x8ec2,0x8f52,0x8f51, /* 0xF350-0xF357 */
	0x8f4f,0x8f50,0x8f53,0x8fb4,0x9140,0x913f,0x91b0,0x91ad, /* 0xF358-0xF35F */
	0x93de,0x93c7,0x93cf,0x93c2,0x93da,0x93d0,0x93f9,0x93ec, /* 0xF360-0xF367 */
	0x93cc,0x93d9,0x93a9,0x93e6,0x93ca,0x93d4,0x93ee,0x93e3, /* 0xF368-0xF36F */
	0x93d5,0x93c4,0x93ce,0x93c0,0x93d2,0x93e7,0x957d,0x95da, /* 0xF370-0xF377 */
	0x95db,0x96e1,0x9729,0x972b,0x972c,0x9728,0x9726,0x0000, /* 0xF378-0xF37F */
	/* codebase=0xf380 rawbase=0x5640 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF380-0xF387 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF388-0xF38F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF390-0xF397 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF398-0xF39F */
	0x0000,0x97b3,0x97b7,0x97b6,0x97dd,0x97de,0x97df,0x985c, /* 0xF3A0-0xF3A7 */
	0x9859,0x985d,0x9857,0x98bf,0x98bd,0x98bb,0x98be,0x9948, /* 0xF3A8-0xF3AF */
	0x9947,0x9943,0x99a6,0x99a7,0x9a1a,0x9a15,0x9a25,0x9a1d, /* 0xF3B0-0xF3B7 */
	0x9a24,0x9a1b,0x9a22,0x9a20,0x9a27,0x9a23,0x9a1e,0x9a1c, /* 0xF3B8-0xF3BF */
	/* codebase=0xf3c0 rawbase=0x5680 */
	0x9a14,0x9ac2,0x9b0b,0x9b0a,0x9b0e,0x9b0c,0x9b37,0x9bea, /* 0xF3C0-0xF3C7 */
	0x9beb,0x9be0,0x9bde,0x9be4,0x9be6,0x9be2,0x9bf0,0x9bd4, /* 0xF3C8-0xF3CF */
	0x9bd7,0x9bec,0x9bdc,0x9bd9,0x9be5,0x9bd5,0x9be1,0x9bda, /* 0xF3D0-0xF3D7 */
	0x9d77,0x9d81,0x9d8a,0x9d84,0x9d88,0x9d71,0x9d80,0x9d78, /* 0xF3D8-0xF3DF */
	0x9d86,0x9d8b,0x9d8c,0x9d7d,0x9d6b,0x9d74,0x9d75,0x9d70, /* 0xF3E0-0xF3E7 */
	0x9d69,0x9d85,0x9d73,0x9d7b,0x9d82,0x9d6f,0x9d79,0x9d7f, /* 0xF3E8-0xF3EF */
	0x9d87,0x9d68,0x9e94,0x9e91,0x9ec0,0x9efc,0x9f2d,0x9f40, /* 0xF3F0-0xF3F7 */
	0x9f41,0x9f4d,0x9f56,0x9f57,0x9f58,0x5337,0x56b2,0x0000, /* 0xF3F8-0xF3FF */
	/* codebase=0xf440 rawbase=0x56c0 */
	0x56b5,0x56b3,0x58e3,0x5b45,0x5dc6,0x5dc7,0x5eee,0x5eef, /* 0xF440-0xF447 */
	0x5fc0,0x5fc1,0x61f9,0x6517,0x6516,0x6515,0x6513,0x65df, /* 0xF448-0xF44F */
	0x66e8,0x66e3,0x66e4,0x6af3,0x6af0,0x6aea,0x6ae8,0x6af9, /* 0xF450-0xF457 */
	0x6af1,0x6aee,0x6aef,0x703c,0x7035,0x702f,0x7037,0x7034, /* 0xF458-0xF45F */
	0x7031,0x7042,0x7038,0x703f,0x703a,0x7039,0x7040,0x703b, /* 0xF460-0xF467 */
	0x7033,0x7041,0x7213,0x7214,0x72a8,0x737d,0x737c,0x74ba, /* 0xF468-0xF46F */
	0x76ab,0x76aa,0x76be,0x76ed,0x77cc,0x77ce,0x77cf,0x77cd, /* 0xF470-0xF477 */
	0x77f2,0x7925,0x7923,0x7927,0x7928,0x7924,0x7929,0x0000, /* 0xF478-0xF47F */
	/* codebase=0xf480 rawbase=0x5700 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF480-0xF487 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF488-0xF48F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF490-0xF497 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF498-0xF49F */
	0x0000,0x79b2,0x7a6e,0x7a6c,0x7a6d,0x7af7,0x7c49,0x7c48, /* 0xF4A0-0xF4A7 */
	0x7c4a,0x7c47,0x7c45,0x7cee,0x7e7b,0x7e7e,0x7e81,0x7e80, /* 0xF4A8-0xF4AF */
	0x7fba,0x7fff,0x8079,0x81db,0x81d9,0x820b,0x8268,0x8269, /* 0xF4B0-0xF4B7 */
	0x8622,0x85ff,0x8601,0x85fe,0x861b,0x8600,0x85f6,0x8604, /* 0xF4B8-0xF4BF */
	/* codebase=0xf4c0 rawbase=0x5740 */
	0x8609,0x8605,0x860c,0x85fd,0x8819,0x8810,0x8811,0x8817, /* 0xF4C0-0xF4C7 */
	0x8813,0x8816,0x8963,0x8966,0x89b9,0x89f7,0x8b60,0x8b6a, /* 0xF4C8-0xF4CF */
	0x8b5d,0x8b68,0x8b63,0x8b65,0x8b67,0x8b6d,0x8dae,0x8e86, /* 0xF4D0-0xF4D7 */
	0x8e88,0x8e84,0x8f59,0x8f56,0x8f57,0x8f55,0x8f58,0x8f5a, /* 0xF4D8-0xF4DF */
	0x908d,0x9143,0x9141,0x91b7,0x91b5,0x91b2,0x91b3,0x940b, /* 0xF4E0-0xF4E7 */
	0x9413,0x93fb,0x9420,0x940f,0x9414,0x93fe,0x9415,0x9410, /* 0xF4E8-0xF4EF */
	0x9428,0x9419,0x940d,0x93f5,0x9400,0x93f7,0x9407,0x940e, /* 0xF4F0-0xF4F7 */
	0x9416,0x9412,0x93fa,0x9409,0x93f8,0x940a,0x93ff,0x0000, /* 0xF4F8-0xF4FF */
	/* codebase=0xf540 rawbase=0x5780 */
	0x93fc,0x940c,0x93f6,0x9411,0x9406,0x95de,0x95e0,0x95df, /* 0xF540-0xF547 */
	0x972e,0x972f,0x97b9,0x97bb,0x97fd,0x97fe,0x9860,0x9862, /* 0xF548-0xF54F */
	0x9863,0x985f,0x98c1,0x98c2,0x9950,0x994e,0x9959,0x994c, /* 0xF550-0xF557 */
	0x994b,0x9953,0x9a32,0x9a34,0x9a31,0x9a2c,0x9a2a,0x9a36, /* 0xF558-0xF55F */
	0x9a29,0x9a2e,0x9a38,0x9a2d,0x9ac7,0x9aca,0x9ac6,0x9b10, /* 0xF560-0xF567 */
	0x9b12,0x9b11,0x9c0b,0x9c08,0x9bf7,0x9c05,0x9c12,0x9bf8, /* 0xF568-0xF56F */
	0x9c40,0x9c07,0x9c0e,0x9c06,0x9c17,0x9c14,0x9c09,0x9d9f, /* 0xF570-0xF577 */
	0x9d99,0x9da4,0x9d9d,0x9d92,0x9d98,0x9d90,0x9d9b,0x0000, /* 0xF578-0xF57F */
	/* codebase=0xf580 rawbase=0x57c0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF580-0xF587 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF588-0xF58F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF590-0xF597 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF598-0xF59F */
	0x0000,0x9da0,0x9d94,0x9d9c,0x9daa,0x9d97,0x9da1,0x9d9a, /* 0xF5A0-0xF5A7 */
	0x9da2,0x9da8,0x9d9e,0x9da3,0x9dbf,0x9da9,0x9d96,0x9da6, /* 0xF5A8-0xF5AF */
	0x9da7,0x9e99,0x9e9b,0x9e9a,0x9ee5,0x9ee4,0x9ee7,0x9ee6, /* 0xF5B0-0xF5B7 */
	0x9f30,0x9f2e,0x9f5b,0x9f60,0x9f5e,0x9f5d,0x9f59,0x9f91, /* 0xF5B8-0xF5BF */
	/* codebase=0xf5c0 rawbase=0x5800 */
	0x513a,0x5139,0x5298,0x5297,0x56c3,0x56bd,0x56be,0x5b48, /* 0xF5C0-0xF5C7 */
	0x5b47,0x5dcb,0x5dcf,0x5ef1,0x61fd,0x651b,0x6b02,0x6afc, /* 0xF5C8-0xF5CF */
	0x6b03,0x6af8,0x6b00,0x7043,0x7044,0x704a,0x7048,0x7049, /* 0xF5D0-0xF5D7 */
	0x7045,0x7046,0x721d,0x721a,0x7219,0x737e,0x7517,0x766a, /* 0xF5D8-0xF5DF */
	0x77d0,0x792d,0x7931,0x792f,0x7c54,0x7c53,0x7cf2,0x7e8a, /* 0xF5E0-0xF5E7 */
	0x7e87,0x7e88,0x7e8b,0x7e86,0x7e8d,0x7f4d,0x7fbb,0x8030, /* 0xF5E8-0xF5EF */
	0x81dd,0x8618,0x862a,0x8626,0x861f,0x8623,0x861c,0x8619, /* 0xF5F0-0xF5F7 */
	0x8627,0x862e,0x8621,0x8620,0x8629,0x861e,0x8625,0x0000, /* 0xF5F8-0xF5FF */
	/* codebase=0xf640 rawbase=0x5840 */
	0x8829,0x881d,0x881b,0x8820,0x8824,0x881c,0x882b,0x884a, /* 0xF640-0xF647 */
	0x896d,0x8969,0x896e,0x896b,0x89fa,0x8b79,0x8b78,0x8b45, /* 0xF648-0xF64F */
	0x8b7a,0x8b7b,0x8d10,0x8d14,0x8daf,0x8e8e,0x8e8c,0x8f5e, /* 0xF650-0xF657 */
	0x8f5b,0x8f5d,0x9146,0x9144,0x9145,0x91b9,0x943f,0x943b, /* 0xF658-0xF65F */
	0x9436,0x9429,0x943d,0x943c,0x9430,0x9439,0x942a,0x9437, /* 0xF660-0xF667 */
	0x942c,0x9440,0x9431,0x95e5,0x95e4,0x95e3,0x9735,0x973a, /* 0xF668-0xF66F */
	0x97bf,0x97e1,0x9864,0x98c9,0x98c6,0x98c0,0x9958,0x9956, /* 0xF670-0xF677 */
	0x9a39,0x9a3d,0x9a46,0x9a44,0x9a42,0x9a41,0x9a3a,0x0000, /* 0xF678-0xF67F */
	/* codebase=0xf680 rawbase=0x5880 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF680-0xF687 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF688-0xF68F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF690-0xF697 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF698-0xF69F */
	0x0000,0x9a3f,0x9acd,0x9b15,0x9b17,0x9b18,0x9b16,0x9b3a, /* 0xF6A0-0xF6A7 */
	0x9b52,0x9c2b,0x9c1d,0x9c1c,0x9c2c,0x9c23,0x9c28,0x9c29, /* 0xF6A8-0xF6AF */
	0x9c24,0x9c21,0x9db7,0x9db6,0x9dbc,0x9dc1,0x9dc7,0x9dca, /* 0xF6B0-0xF6B7 */
	0x9dcf,0x9dbe,0x9dc5,0x9dc3,0x9dbb,0x9db5,0x9dce,0x9db9, /* 0xF6B8-0xF6BF */
	/* codebase=0xf6c0 rawbase=0x58c0 */
	0x9dba,0x9dac,0x9dc8,0x9db1,0x9dad,0x9dcc,0x9db3,0x9dcd, /* 0xF6C0-0xF6C7 */
	0x9db2,0x9e7a,0x9e9c,0x9eeb,0x9eee,0x9eed,0x9f1b,0x9f18, /* 0xF6C8-0xF6CF */
	0x9f1a,0x9f31,0x9f4e,0x9f65,0x9f64,0x9f92,0x4eb9,0x56c6, /* 0xF6D0-0xF6D7 */
	0x56c5,0x56cb,0x5971,0x5b4b,0x5b4c,0x5dd5,0x5dd1,0x5ef2, /* 0xF6D8-0xF6DF */
	0x6521,0x6520,0x6526,0x6522,0x6b0b,0x6b08,0x6b09,0x6c0d, /* 0xF6E0-0xF6E7 */
	0x7055,0x7056,0x7057,0x7052,0x721e,0x721f,0x72a9,0x737f, /* 0xF6E8-0xF6EF */
	0x74d8,0x74d5,0x74d9,0x74d7,0x766d,0x76ad,0x7935,0x79b4, /* 0xF6F0-0xF6F7 */
	0x7a70,0x7a71,0x7c57,0x7c5c,0x7c59,0x7c5b,0x7c5a,0x0000, /* 0xF6F8-0xF6FF */
	/* codebase=0xf740 rawbase=0x5900 */
	0x7cf4,0x7cf1,0x7e91,0x7f4f,0x7f87,0x81de,0x826b,0x8634, /* 0xF740-0xF747 */
	0x8635,0x8633,0x862c,0x8632,0x8636,0x882c,0x8828,0x8826, /* 0xF748-0xF74F */
	0x882a,0x8825,0x8971,0x89bf,0x89be,0x89fb,0x8b7e,0x8b84, /* 0xF750-0xF757 */
	0x8b82,0x8b86,0x8b85,0x8b7f,0x8d15,0x8e95,0x8e94,0x8e9a, /* 0xF758-0xF75F */
	0x8e92,0x8e90,0x8e96,0x8e97,0x8f60,0x8f62,0x9147,0x944c, /* 0xF760-0xF767 */
	0x9450,0x944a,0x944b,0x944f,0x9447,0x9445,0x9448,0x9449, /* 0xF768-0xF76F */
	0x9446,0x973f,0x97e3,0x986a,0x9869,0x98cb,0x9954,0x995b, /* 0xF770-0xF777 */
	0x9a4e,0x9a53,0x9a54,0x9a4c,0x9a4f,0x9a48,0x9a4a,0x0000, /* 0xF778-0xF77F */
	/* codebase=0xf780 rawbase=0x5940 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF780-0xF787 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF788-0xF78F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF790-0xF797 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF798-0xF79F */
	0x0000,0x9a49,0x9a52,0x9a50,0x9ad0,0x9b19,0x9b2b,0x9b3b, /* 0xF7A0-0xF7A7 */
	0x9b56,0x9b55,0x9c46,0x9c48,0x9c3f,0x9c44,0x9c39,0x9c33, /* 0xF7A8-0xF7AF */
	0x9c41,0x9c3c,0x9c37,0x9c34,0x9c32,0x9c3d,0x9c36,0x9ddb, /* 0xF7B0-0xF7B7 */
	0x9dd2,0x9dde,0x9dda,0x9dcb,0x9dd0,0x9ddc,0x9dd1,0x9ddf, /* 0xF7B8-0xF7BF */
	/* codebase=0xf7c0 rawbase=0x5980 */
	0x9de9,0x9dd9,0x9dd8,0x9dd6,0x9df5,0x9dd5,0x9ddd,0x9eb6, /* 0xF7C0-0xF7C7 */
	0x9ef0,0x9f35,0x9f33,0x9f32,0x9f42,0x9f6b,0x9f95,0x9fa2, /* 0xF7C8-0xF7CF */
	0x513d,0x5299,0x58e8,0x58e7,0x5972,0x5b4d,0x5dd8,0x882f, /* 0xF7D0-0xF7D7 */
	0x5f4f,0x6201,0x6203,0x6204,0x6529,0x6525,0x6596,0x66eb, /* 0xF7D8-0xF7DF */
	0x6b11,0x6b12,0x6b0f,0x6bca,0x705b,0x705a,0x7222,0x7382, /* 0xF7E0-0xF7E7 */
	0x7381,0x7383,0x7670,0x77d4,0x7c67,0x7c66,0x7e95,0x826c, /* 0xF7E8-0xF7EF */
	0x863a,0x8640,0x8639,0x863c,0x8631,0x863b,0x863e,0x8830, /* 0xF7F0-0xF7F7 */
	0x8832,0x882e,0x8833,0x8976,0x8974,0x8973,0x89fe,0x0000, /* 0xF7F8-0xF7FF */
	/* codebase=0xf840 rawbase=0x59c0 */
	0x8b8c,0x8b8e,0x8b8b,0x8b88,0x8c45,0x8d19,0x8e98,0x8f64, /* 0xF840-0xF847 */
	0x8f63,0x91bc,0x9462,0x9455,0x945d,0x9457,0x945e,0x97c4, /* 0xF848-0xF84F */
	0x97c5,0x9800,0x9a56,0x9a59,0x9b1e,0x9b1f,0x9b20,0x9c52, /* 0xF850-0xF857 */
	0x9c58,0x9c50,0x9c4a,0x9c4d,0x9c4b,0x9c55,0x9c59,0x9c4c, /* 0xF858-0xF85F */
	0x9c4e,0x9dfb,0x9df7,0x9def,0x9de3,0x9deb,0x9df8,0x9de4, /* 0xF860-0xF867 */
	0x9df6,0x9de1,0x9dee,0x9de6,0x9df2,0x9df0,0x9de2,0x9dec, /* 0xF868-0xF86F */
	0x9df4,0x9df3,0x9de8,0x9ded,0x9ec2,0x9ed0,0x9ef2,0x9ef3, /* 0xF870-0xF877 */
	0x9f06,0x9f1c,0x9f38,0x9f37,0x9f36,0x9f43,0x9f4f,0x0000, /* 0xF878-0xF87F */
	/* codebase=0xf880 rawbase=0x5a00 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF880-0xF887 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF888-0xF88F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF890-0xF897 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF898-0xF89F */
	0x0000,0x9f71,0x9f70,0x9f6e,0x9f6f,0x56d3,0x56cd,0x5b4e, /* 0xF8A0-0xF8A7 */
	0x5c6d,0x652d,0x66ed,0x66ee,0x6b13,0x705f,0x7061,0x705d, /* 0xF8A8-0xF8AF */
	0x7060,0x7223,0x74db,0x74e5,0x77d5,0x7938,0x79b7,0x79b6, /* 0xF8B0-0xF8B7 */
	0x7c6a,0x7e97,0x7f89,0x826d,0x8643,0x8838,0x8837,0x8835, /* 0xF8B8-0xF8BF */
	/* codebase=0xf8c0 rawbase=0x5a40 */
	0x884b,0x8b94,0x8b95,0x8e9e,0x8e9f,0x8ea0,0x8e9d,0x91be, /* 0xF8C0-0xF8C7 */
	0x91bd,0x91c2,0x946b,0x9468,0x9469,0x96e5,0x9746,0x9743, /* 0xF8C8-0xF8CF */
	0x9747,0x97c7,0x97e5,0x9a5e,0x9ad5,0x9b59,0x9c63,0x9c67, /* 0xF8D0-0xF8D7 */
	0x9c66,0x9c62,0x9c5e,0x9c60,0x9e02,0x9dfe,0x9e07,0x9e03, /* 0xF8D8-0xF8DF */
	0x9e06,0x9e05,0x9e00,0x9e01,0x9e09,0x9dff,0x9dfd,0x9e04, /* 0xF8E0-0xF8E7 */
	0x9ea0,0x9f1e,0x9f46,0x9f74,0x9f75,0x9f76,0x56d4,0x652e, /* 0xF8E8-0xF8EF */
	0x65b8,0x6b18,0x6b19,0x6b17,0x6b1a,0x7062,0x7226,0x72aa, /* 0xF8F0-0xF8F7 */
	0x77d8,0x77d9,0x7939,0x7c69,0x7c6b,0x7cf6,0x7e9a,0x0000, /* 0xF8F8-0xF8FF */
	/* codebase=0xf940 rawbase=0x5a80 */
	0x7e98,0x7e9b,0x7e99,0x81e0,0x81e1,0x8646,0x8647,0x8648, /* 0xF940-0xF947 */
	0x8979,0x897a,0x897c,0x897b,0x89ff,0x8b98,0x8b99,0x8ea5, /* 0xF948-0xF94F */
	0x8ea4,0x8ea3,0x946e,0x946d,0x946f,0x9471,0x9473,0x9749, /* 0xF950-0xF957 */
	0x9872,0x995f,0x9c68,0x9c6e,0x9c6d,0x9e0b,0x9e0d,0x9e10, /* 0xF958-0xF95F */
	0x9e0f,0x9e12,0x9e11,0x9ea1,0x9ef5,0x9f09,0x9f47,0x9f78, /* 0xF960-0xF967 */
	0x9f7b,0x9f7a,0x9f79,0x571e,0x7066,0x7c6f,0x883c,0x8db2, /* 0xF968-0xF96F */
	0x8ea6,0x91c3,0x9474,0x9478,0x9476,0x9475,0x9a60,0x9c74, /* 0xF970-0xF977 */
	0x9c73,0x9c71,0x9c75,0x9e14,0x9e13,0x9ef6,0x9f0a,0x0000, /* 0xF978-0xF97F */
	/* codebase=0xf980 rawbase=0x5ac0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF980-0xF987 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF988-0xF98F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF990-0xF997 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF998-0xF99F */
	0x0000,0x9fa4,0x7068,0x7065,0x7cf7,0x866a,0x883e,0x883d, /* 0xF9A0-0xF9A7 */
	0x883f,0x8b9e,0x8c9c,0x8ea9,0x8ec9,0x974b,0x9873,0x9874, /* 0xF9A8-0xF9AF */
	0x98cc,0x9961,0x99ab,0x9a64,0x9a66,0x9a67,0x9b24,0x9e15, /* 0xF9B0-0xF9B7 */
	0x9e17,0x9f48,0x6207,0x6b1e,0x7227,0x864c,0x8ea8,0x9482, /* 0xF9B8-0xF9BF */
	/* codebase=0xf9c0 rawbase=0x5b00 */
	0x9480,0x9481,0x9a69,0x9a68,0x9b2e,0x9e19,0x7229,0x864b, /* 0xF9C0-0xF9C7 */
	0x8b9f,0x9483,0x9c79,0x9eb7,0x7675,0x9a6b,0x9c7a,0x9e1d, /* 0xF9C8-0xF9CF */
	0x7069,0x706a,0x9ea4,0x9f7e,0x9f49,0x9f98,0x7881,0x92b9, /* 0xF9D0-0xF9D7 */
	0x88cf,0x58bb,0x6052,0x7ca7,0x5afa,0x2554,0x2566,0x2557, /* 0xF9D8-0xF9DF */
	0x2560,0x256c,0x2563,0x255a,0x2569,0x255d,0x2552,0x2564, /* 0xF9E0-0xF9E7 */
	0x2555,0x255e,0x256a,0x2561,0x2558,0x2567,0x255b,0x2553, /* 0xF9E8-0xF9EF */
	0x2565,0x2556,0x255f,0x256b,0x2562,0x2559,0x2568,0x255c, /* 0xF9F0-0xF9F7 */
	0x2551,0x2550,0x2554,0x2557,0x255a,0x255d,0x2593,0x0000, /* 0xF9F8-0xF9FF */
	/* codebase=0xfa40 rawbase=0x5b40 */
	0xe000,0xe001,0xe002,0xe003,0xe004,0xe005,0xe006,0xe007, /* 0xFA40-0xFA47 */
	0xe008,0xe009,0xe00a,0xe00b,0xe00c,0xe00d,0xe00e,0xe00f, /* 0xFA48-0xFA4F */
	0xe010,0xe011,0xe012,0xe013,0xe014,0xe015,0xe016,0xe017, /* 0xFA50-0xFA57 */
	0xe018,0xe019,0xe01a,0xe01b,0xe01c,0xe01d,0xe01e,0xe01f, /* 0xFA58-0xFA5F */
	0xe020,0xe021,0xe022,0xe023,0xe024,0xe025,0xe026,0xe027, /* 0xFA60-0xFA67 */
	0xe028,0xe029,0xe02a,0xe02b,0xe02c,0xe02d,0xe02e,0xe02f, /* 0xFA68-0xFA6F */
	0xe030,0xe031,0xe032,0xe033,0xe034,0xe035,0xe036,0xe037, /* 0xFA70-0xFA77 */
	0xe038,0xe039,0xe03a,0xe03b,0xe03c,0xe03d,0xe03e,0x0000, /* 0xFA78-0xFA7F */
	/* codebase=0xfa80 rawbase=0x5b80 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFA80-0xFA87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFA88-0xFA8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFA90-0xFA97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFA98-0xFA9F */
	0x0000,0xe03f,0xe040,0xe041,0xe042,0xe043,0xe044,0xe045, /* 0xFAA0-0xFAA7 */
	0xe046,0xe047,0xe048,0xe049,0xe04a,0xe04b,0xe04c,0xe04d, /* 0xFAA8-0xFAAF */
	0xe04e,0xe04f,0xe050,0xe051,0xe052,0xe053,0xe054,0xe055, /* 0xFAB0-0xFAB7 */
	0xe056,0xe057,0xe058,0xe059,0xe05a,0xe05b,0xe05c,0xe05d, /* 0xFAB8-0xFABF */
	/* codebase=0xfac0 rawbase=0x5bc0 */
	0xe05e,0xe05f,0xe060,0xe061,0xe062,0xe063,0xe064,0xe065, /* 0xFAC0-0xFAC7 */
	0xe066,0xe067,0xe068,0xe069,0xe06a,0xe06b,0xe06c,0xe06d, /* 0xFAC8-0xFACF */
	0xe06e,0xe06f,0xe070,0xe071,0xe072,0xe073,0xe074,0xe075, /* 0xFAD0-0xFAD7 */
	0xe076,0xe077,0xe078,0xe079,0xe07a,0xe07b,0xe07c,0xe07d, /* 0xFAD8-0xFADF */
	0xe07e,0xe07f,0xe080,0xe081,0xe082,0xe083,0xe084,0xe085, /* 0xFAE0-0xFAE7 */
	0xe086,0xe087,0xe088,0xe089,0xe08a,0xe08b,0xe08c,0xe08d, /* 0xFAE8-0xFAEF */
	0xe08e,0xe08f,0xe090,0xe091,0xe092,0xe093,0xe094,0xe095, /* 0xFAF0-0xFAF7 */
	0xe096,0xe097,0xe098,0xe099,0xe09a,0xe09b,0xe09c,0x0000, /* 0xFAF8-0xFAFF */
	/* codebase=0xfb40 rawbase=0x5c00 */
	0xe09d,0xe09e,0xe09f,0xe0a0,0xe0a1,0xe0a2,0xe0a3,0xe0a4, /* 0xFB40-0xFB47 */
	0xe0a5,0xe0a6,0xe0a7,0xe0a8,0xe0a9,0xe0aa,0xe0ab,0xe0ac, /* 0xFB48-0xFB4F */
	0xe0ad,0xe0ae,0xe0af,0xe0b0,0xe0b1,0xe0b2,0xe0b3,0xe0b4, /* 0xFB50-0xFB57 */
	0xe0b5,0xe0b6,0xe0b7,0xe0b8,0xe0b9,0xe0ba,0xe0bb,0xe0bc, /* 0xFB58-0xFB5F */
	0xe0bd,0xe0be,0xe0bf,0xe0c0,0xe0c1,0xe0c2,0xe0c3,0xe0c4, /* 0xFB60-0xFB67 */
	0xe0c5,0xe0c6,0xe0c7,0xe0c8,0xe0c9,0xe0ca,0xe0cb,0xe0cc, /* 0xFB68-0xFB6F */
	0xe0cd,0xe0ce,0xe0cf,0xe0d0,0xe0d1,0xe0d2,0xe0d3,0xe0d4, /* 0xFB70-0xFB77 */
	0xe0d5,0xe0d6,0xe0d7,0xe0d8,0xe0d9,0xe0da,0xe0db,0x0000, /* 0xFB78-0xFB7F */
	/* codebase=0xfb80 rawbase=0x5c40 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFB80-0xFB87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFB88-0xFB8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFB90-0xFB97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFB98-0xFB9F */
	0x0000,0xe0dc,0xe0dd,0xe0de,0xe0df,0xe0e0,0xe0e1,0xe0e2, /* 0xFBA0-0xFBA7 */
	0xe0e3,0xe0e4,0xe0e5,0xe0e6,0xe0e7,0xe0e8,0xe0e9,0xe0ea, /* 0xFBA8-0xFBAF */
	0xe0eb,0xe0ec,0xe0ed,0xe0ee,0xe0ef,0xe0f0,0xe0f1,0xe0f2, /* 0xFBB0-0xFBB7 */
	0xe0f3,0xe0f4,0xe0f5,0xe0f6,0xe0f7,0xe0f8,0xe0f9,0xe0fa, /* 0xFBB8-0xFBBF */
	/* codebase=0xfbc0 rawbase=0x5c80 */
	0xe0fb,0xe0fc,0xe0fd,0xe0fe,0xe0ff,0xe100,0xe101,0xe102, /* 0xFBC0-0xFBC7 */
	0xe103,0xe104,0xe105,0xe106,0xe107,0xe108,0xe109,0xe10a, /* 0xFBC8-0xFBCF */
	0xe10b,0xe10c,0xe10d,0xe10e,0xe10f,0xe110,0xe111,0xe112, /* 0xFBD0-0xFBD7 */
	0xe113,0xe114,0xe115,0xe116,0xe117,0xe118,0xe119,0xe11a, /* 0xFBD8-0xFBDF */
	0xe11b,0xe11c,0xe11d,0xe11e,0xe11f,0xe120,0xe121,0xe122, /* 0xFBE0-0xFBE7 */
	0xe123,0xe124,0xe125,0xe126,0xe127,0xe128,0xe129,0xe12a, /* 0xFBE8-0xFBEF */
	0xe12b,0xe12c,0xe12d,0xe12e,0xe12f,0xe130,0xe131,0xe132, /* 0xFBF0-0xFBF7 */
	0xe133,0xe134,0xe135,0xe136,0xe137,0xe138,0xe139,0x0000, /* 0xFBF8-0xFBFF */
	/* codebase=0xfc40 rawbase=0x5cc0 */
	0xe13a,0xe13b,0xe13c,0xe13d,0xe13e,0xe13f,0xe140,0xe141, /* 0xFC40-0xFC47 */
	0xe142,0xe143,0xe144,0xe145,0xe146,0xe147,0xe148,0xe149, /* 0xFC48-0xFC4F */
	0xe14a,0xe14b,0xe14c,0xe14d,0xe14e,0xe14f,0xe150,0xe151, /* 0xFC50-0xFC57 */
	0xe152,0xe153,0xe154,0xe155,0xe156,0xe157,0xe158,0xe159, /* 0xFC58-0xFC5F */
	0xe15a,0xe15b,0xe15c,0xe15d,0xe15e,0xe15f,0xe160,0xe161, /* 0xFC60-0xFC67 */
	0xe162,0xe163,0xe164,0xe165,0xe166,0xe167,0xe168,0xe169, /* 0xFC68-0xFC6F */
	0xe16a,0xe16b,0xe16c,0xe16d,0xe16e,0xe16f,0xe170,0xe171, /* 0xFC70-0xFC77 */
	0xe172,0xe173,0xe174,0xe175,0xe176,0xe177,0xe178,0x0000, /* 0xFC78-0xFC7F */
	/* codebase=0xfc80 rawbase=0x5d00 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFC80-0xFC87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFC88-0xFC8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFC90-0xFC97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFC98-0xFC9F */
	0x0000,0xe179,0xe17a,0xe17b,0xe17c,0xe17d,0xe17e,0xe17f, /* 0xFCA0-0xFCA7 */
	0xe180,0xe181,0xe182,0xe183,0xe184,0xe185,0xe186,0xe187, /* 0xFCA8-0xFCAF */
	0xe188,0xe189,0xe18a,0xe18b,0xe18c,0xe18d,0xe18e,0xe18f, /* 0xFCB0-0xFCB7 */
	0xe190,0xe191,0xe192,0xe193,0xe194,0xe195,0xe196,0xe197, /* 0xFCB8-0xFCBF */
	/* codebase=0xfcc0 rawbase=0x5d40 */
	0xe198,0xe199,0xe19a,0xe19b,0xe19c,0xe19d,0xe19e,0xe19f, /* 0xFCC0-0xFCC7 */
	0xe1a0,0xe1a1,0xe1a2,0xe1a3,0xe1a4,0xe1a5,0xe1a6,0xe1a7, /* 0xFCC8-0xFCCF */
	0xe1a8,0xe1a9,0xe1aa,0xe1ab,0xe1ac,0xe1ad,0xe1ae,0xe1af, /* 0xFCD0-0xFCD7 */
	0xe1b0,0xe1b1,0xe1b2,0xe1b3,0xe1b4,0xe1b5,0xe1b6,0xe1b7, /* 0xFCD8-0xFCDF */
	0xe1b8,0xe1b9,0xe1ba,0xe1bb,0xe1bc,0xe1bd,0xe1be,0xe1bf, /* 0xFCE0-0xFCE7 */
	0xe1c0,0xe1c1,0xe1c2,0xe1c3,0xe1c4,0xe1c5,0xe1c6,0xe1c7, /* 0xFCE8-0xFCEF */
	0xe1c8,0xe1c9,0xe1ca,0xe1cb,0xe1cc,0xe1cd,0xe1ce,0xe1cf, /* 0xFCF0-0xFCF7 */
	0xe1d0,0xe1d1,0xe1d2,0xe1d3,0xe1d4,0xe1d5,0xe1d6,0x0000, /* 0xFCF8-0xFCFF */
	/* codebase=0xfd40 rawbase=0x5d80 */
	0xe1d7,0xe1d8,0xe1d9,0xe1da,0xe1db,0xe1dc,0xe1dd,0xe1de, /* 0xFD40-0xFD47 */
	0xe1df,0xe1e0,0xe1e1,0xe1e2,0xe1e3,0xe1e4,0xe1e5,0xe1e6, /* 0xFD48-0xFD4F */
	0xe1e7,0xe1e8,0xe1e9,0xe1ea,0xe1eb,0xe1ec,0xe1ed,0xe1ee, /* 0xFD50-0xFD57 */
	0xe1ef,0xe1f0,0xe1f1,0xe1f2,0xe1f3,0xe1f4,0xe1f5,0xe1f6, /* 0xFD58-0xFD5F */
	0xe1f7,0xe1f8,0xe1f9,0xe1fa,0xe1fb,0xe1fc,0xe1fd,0xe1fe, /* 0xFD60-0xFD67 */
	0xe1ff,0xe200,0xe201,0xe202,0xe203,0xe204,0xe205,0xe206, /* 0xFD68-0xFD6F */
	0xe207,0xe208,0xe209,0xe20a,0xe20b,0xe20c,0xe20d,0xe20e, /* 0xFD70-0xFD77 */
	0xe20f,0xe210,0xe211,0xe212,0xe213,0xe214,0xe215,0x0000, /* 0xFD78-0xFD7F */
	/* codebase=0xfd80 rawbase=0x5dc0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFD80-0xFD87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFD88-0xFD8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFD90-0xFD97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFD98-0xFD9F */
	0x0000,0xe216,0xe217,0xe218,0xe219,0xe21a,0xe21b,0xe21c, /* 0xFDA0-0xFDA7 */
	0xe21d,0xe21e,0xe21f,0xe220,0xe221,0xe222,0xe223,0xe224, /* 0xFDA8-0xFDAF */
	0xe225,0xe226,0xe227,0xe228,0xe229,0xe22a,0xe22b,0xe22c, /* 0xFDB0-0xFDB7 */
	0xe22d,0xe22e,0xe22f,0xe230,0xe231,0xe232,0xe233,0xe234, /* 0xFDB8-0xFDBF */
	/* codebase=0xfdc0 rawbase=0x5e00 */
	0xe235,0xe236,0xe237,0xe238,0xe239,0xe23a,0xe23b,0xe23c, /* 0xFDC0-0xFDC7 */
	0xe23d,0xe23e,0xe23f,0xe240,0xe241,0xe242,0xe243,0xe244, /* 0xFDC8-0xFDCF */
	0xe245,0xe246,0xe247,0xe248,0xe249,0xe24a,0xe24b,0xe24c, /* 0xFDD0-0xFDD7 */
	0xe24d,0xe24e,0xe24f,0xe250,0xe251,0xe252,0xe253,0xe254, /* 0xFDD8-0xFDDF */
	0xe255,0xe256,0xe257,0xe258,0xe259,0xe25a,0xe25b,0xe25c, /* 0xFDE0-0xFDE7 */
	0xe25d,0xe25e,0xe25f,0xe260,0xe261,0xe262,0xe263,0xe264, /* 0xFDE8-0xFDEF */
	0xe265,0xe266,0xe267,0xe268,0xe269,0xe26a,0xe26b,0xe26c, /* 0xFDF0-0xFDF7 */
	0xe26d,0xe26e,0xe26f,0xe270,0xe271,0xe272,0xe273,0x0000, /* 0xFDF8-0xFDFF */
	/* codebase=0xfe40 rawbase=0x5e40 */
	0xe274,0xe275,0xe276,0xe277,0xe278,0xe279,0xe27a,0xe27b, /* 0xFE40-0xFE47 */
	0xe27c,0xe27d,0xe27e,0xe27f,0xe280,0xe281,0xe282,0xe283, /* 0xFE48-0xFE4F */
	0xe284,0xe285,0xe286,0xe287,0xe288,0xe289,0xe28a,0xe28b, /* 0xFE50-0xFE57 */
	0xe28c,0xe28d,0xe28e,0xe28f,0xe290,0xe291,0xe292,0xe293, /* 0xFE58-0xFE5F */
	0xe294,0xe295,0xe296,0xe297,0xe298,0xe299,0xe29a,0xe29b, /* 0xFE60-0xFE67 */
	0xe29c,0xe29d,0xe29e,0xe29f,0xe2a0,0xe2a1,0xe2a2,0xe2a3, /* 0xFE68-0xFE6F */
	0xe2a4,0xe2a5,0xe2a6,0xe2a7,0xe2a8,0xe2a9,0xe2aa,0xe2ab, /* 0xFE70-0xFE77 */
	0xe2ac,0xe2ad,0xe2ae,0xe2af,0xe2b0,0xe2b1,0xe2b2,0x0000, /* 0xFE78-0xFE7F */
	/* codebase=0xfe80 rawbase=0x5e80 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFE80-0xFE87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFE88-0xFE8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFE90-0xFE97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFE98-0xFE9F */
	0x0000,0xe2b3,0xe2b4,0xe2b5,0xe2b6,0xe2b7,0xe2b8,0xe2b9, /* 0xFEA0-0xFEA7 */
	0xe2ba,0xe2bb,0xe2bc,0xe2bd,0xe2be,0xe2bf,0xe2c0,0xe2c1, /* 0xFEA8-0xFEAF */
	0xe2c2,0xe2c3,0xe2c4,0xe2c5,0xe2c6,0xe2c7,0xe2c8,0xe2c9, /* 0xFEB0-0xFEB7 */
	0xe2ca,0xe2cb,0xe2cc,0xe2cd,0xe2ce,0xe2cf,0xe2d0,0xe2d1, /* 0xFEB8-0xFEBF */
	/* codebase=0xfec0 rawbase=0x5ec0 */
	0xe2d2,0xe2d3,0xe2d4,0xe2d5,0xe2d6,0xe2d7,0xe2d8,0xe2d9, /* 0xFEC0-0xFEC7 */
	0xe2da,0xe2db,0xe2dc,0xe2dd,0xe2de,0xe2df,0xe2e0,0xe2e1, /* 0xFEC8-0xFECF */
	0xe2e2,0xe2e3,0xe2e4,0xe2e5,0xe2e6,0xe2e7,0xe2e8,0xe2e9, /* 0xFED0-0xFED7 */
	0xe2ea,0xe2eb,0xe2ec,0xe2ed,0xe2ee,0xe2ef,0xe2f0,0xe2f1, /* 0xFED8-0xFEDF */
	0xe2f2,0xe2f3,0xe2f4,0xe2f5,0xe2f6,0xe2f7,0xe2f8,0xe2f9, /* 0xFEE0-0xFEE7 */
	0xe2fa,0xe2fb,0xe2fc,0xe2fd,0xe2fe,0xe2ff,0xe300,0xe301, /* 0xFEE8-0xFEEF */
	0xe302,0xe303,0xe304,0xe305,0xe306,0xe307,0xe308,0xe309, /* 0xFEF0-0xFEF7 */
	0xe30a,0xe30b,0xe30c,0xe30d,0xe30e,0xe30f,0xe310,0x0000, /* 0xFEF8-0xFEFF */
};
bool madecp950 = false;
uint16_t cp950_to_unicode_raw[16704];
void makestdcp950table() {
    if (madecp950) return;
    for (int i=0; i<64*2; i++)
        cp950_to_unicode_raw[i] = cp950ext_to_unicode_raw[i];
    for (int i=64*2; i<64*114; i++)
        cp950_to_unicode_raw[i] = cp950ext_to_unicode_raw[i+64*96];
    for (int i=64*114; i<64*261; i++)
        cp950_to_unicode_raw[i] = cp950ext_to_unicode_raw[i+64*104];
    for (int i=64*10; i<64*10+33; i++) cp950_to_unicode_raw[i] = 0;
    cp950_to_unicode_raw[64*2+22] = 0x2013;
    cp950_to_unicode_raw[64*4+2] = 0x00af;
    cp950_to_unicode_raw[64*6+36] = 0x2550;
    cp950_to_unicode_raw[64*6+37] = 0x255e;
    cp950_to_unicode_raw[64*6+38] = 0x256a;
    cp950_to_unicode_raw[64*6+39] = 0x2561;
    cp950_to_unicode_raw[64*7+12] = 0x0000; /* 0x5341 is duplicate mapping so replace it with 0x0000 */
    cp950_to_unicode_raw[64*7+13] = 0x5344;
    cp950_to_unicode_raw[64*7+14] = 0x0000; /* 0x5345 is duplicate mapping so replace it with 0x0000 */
    cp950_to_unicode_raw[64*101+21] = 0x5f5d;
    cp950_to_unicode_raw[64*260+58] = 0x256d;
    cp950_to_unicode_raw[64*260+59] = 0x256e;
    cp950_to_unicode_raw[64*260+60] = 0x2570;
    cp950_to_unicode_raw[64*260+61] = 0x256f;
    madecp950 = true;
};
const uint16_t cp950_to_unicode_hitbl[1024] = {
	0x0000, /* 0x0000-0x003F */
	0x0040, /* 0x0040-0x007F */
	0xffff, /* 0x0080-0x00BF NOT PRESENT */
	0xffff, /* 0x00c0-0x00FF NOT PRESENT */
	0xffff, /* 0x0100-0x013F NOT PRESENT */
	0xffff, /* 0x0140-0x017F NOT PRESENT */
	0xffff, /* 0x0180-0x01BF NOT PRESENT */
	0xffff, /* 0x01c0-0x01FF NOT PRESENT */
	0xffff, /* 0x0200-0x023F NOT PRESENT */
	0xffff, /* 0x0240-0x027F NOT PRESENT */
	0xffff, /* 0x0280-0x02BF NOT PRESENT */
	0xffff, /* 0x02c0-0x02FF NOT PRESENT */
	0xffff, /* 0x0300-0x033F NOT PRESENT */
	0xffff, /* 0x0340-0x037F NOT PRESENT */
	0xffff, /* 0x0380-0x03BF NOT PRESENT */
	0xffff, /* 0x03c0-0x03FF NOT PRESENT */
	0xffff, /* 0x0400-0x043F NOT PRESENT */
	0xffff, /* 0x0440-0x047F NOT PRESENT */
	0xffff, /* 0x0480-0x04BF NOT PRESENT */
	0xffff, /* 0x04c0-0x04FF NOT PRESENT */
	0xffff, /* 0x0500-0x053F NOT PRESENT */
	0xffff, /* 0x0540-0x057F NOT PRESENT */
	0xffff, /* 0x0580-0x05BF NOT PRESENT */
	0xffff, /* 0x05c0-0x05FF NOT PRESENT */
	0xffff, /* 0x0600-0x063F NOT PRESENT */
	0xffff, /* 0x0640-0x067F NOT PRESENT */
	0xffff, /* 0x0680-0x06BF NOT PRESENT */
	0xffff, /* 0x06c0-0x06FF NOT PRESENT */
	0xffff, /* 0x0700-0x073F NOT PRESENT */
	0xffff, /* 0x0740-0x077F NOT PRESENT */
	0xffff, /* 0x0780-0x07BF NOT PRESENT */
	0xffff, /* 0x07c0-0x07FF NOT PRESENT */
	0xffff, /* 0x0800-0x083F NOT PRESENT */
	0xffff, /* 0x0840-0x087F NOT PRESENT */
	0xffff, /* 0x0880-0x08BF NOT PRESENT */
	0xffff, /* 0x08c0-0x08FF NOT PRESENT */
	0xffff, /* 0x0900-0x093F NOT PRESENT */
	0xffff, /* 0x0940-0x097F NOT PRESENT */
	0xffff, /* 0x0980-0x09BF NOT PRESENT */
	0xffff, /* 0x09c0-0x09FF NOT PRESENT */
	0xffff, /* 0x0a00-0x0A3F NOT PRESENT */
	0xffff, /* 0x0a40-0x0A7F NOT PRESENT */
	0xffff, /* 0x0a80-0x0ABF NOT PRESENT */
	0xffff, /* 0x0ac0-0x0AFF NOT PRESENT */
	0xffff, /* 0x0b00-0x0B3F NOT PRESENT */
	0xffff, /* 0x0b40-0x0B7F NOT PRESENT */
	0xffff, /* 0x0b80-0x0BBF NOT PRESENT */
	0xffff, /* 0x0bc0-0x0BFF NOT PRESENT */
	0xffff, /* 0x0c00-0x0C3F NOT PRESENT */
	0xffff, /* 0x0c40-0x0C7F NOT PRESENT */
	0xffff, /* 0x0c80-0x0CBF NOT PRESENT */
	0xffff, /* 0x0cc0-0x0CFF NOT PRESENT */
	0xffff, /* 0x0d00-0x0D3F NOT PRESENT */
	0xffff, /* 0x0d40-0x0D7F NOT PRESENT */
	0xffff, /* 0x0d80-0x0DBF NOT PRESENT */
	0xffff, /* 0x0dc0-0x0DFF NOT PRESENT */
	0xffff, /* 0x0e00-0x0E3F NOT PRESENT */
	0xffff, /* 0x0e40-0x0E7F NOT PRESENT */
	0xffff, /* 0x0e80-0x0EBF NOT PRESENT */
	0xffff, /* 0x0ec0-0x0EFF NOT PRESENT */
	0xffff, /* 0x0f00-0x0F3F NOT PRESENT */
	0xffff, /* 0x0f40-0x0F7F NOT PRESENT */
	0xffff, /* 0x0f80-0x0FBF NOT PRESENT */
	0xffff, /* 0x0fc0-0x0FFF NOT PRESENT */
	0xffff, /* 0x1000-0x103F NOT PRESENT */
	0xffff, /* 0x1040-0x107F NOT PRESENT */
	0xffff, /* 0x1080-0x10BF NOT PRESENT */
	0xffff, /* 0x10c0-0x10FF NOT PRESENT */
	0xffff, /* 0x1100-0x113F NOT PRESENT */
	0xffff, /* 0x1140-0x117F NOT PRESENT */
	0xffff, /* 0x1180-0x11BF NOT PRESENT */
	0xffff, /* 0x11c0-0x11FF NOT PRESENT */
	0xffff, /* 0x1200-0x123F NOT PRESENT */
	0xffff, /* 0x1240-0x127F NOT PRESENT */
	0xffff, /* 0x1280-0x12BF NOT PRESENT */
	0xffff, /* 0x12c0-0x12FF NOT PRESENT */
	0xffff, /* 0x1300-0x133F NOT PRESENT */
	0xffff, /* 0x1340-0x137F NOT PRESENT */
	0xffff, /* 0x1380-0x13BF NOT PRESENT */
	0xffff, /* 0x13c0-0x13FF NOT PRESENT */
	0xffff, /* 0x1400-0x143F NOT PRESENT */
	0xffff, /* 0x1440-0x147F NOT PRESENT */
	0xffff, /* 0x1480-0x14BF NOT PRESENT */
	0xffff, /* 0x14c0-0x14FF NOT PRESENT */
	0xffff, /* 0x1500-0x153F NOT PRESENT */
	0xffff, /* 0x1540-0x157F NOT PRESENT */
	0xffff, /* 0x1580-0x15BF NOT PRESENT */
	0xffff, /* 0x15c0-0x15FF NOT PRESENT */
	0xffff, /* 0x1600-0x163F NOT PRESENT */
	0xffff, /* 0x1640-0x167F NOT PRESENT */
	0xffff, /* 0x1680-0x16BF NOT PRESENT */
	0xffff, /* 0x16c0-0x16FF NOT PRESENT */
	0xffff, /* 0x1700-0x173F NOT PRESENT */
	0xffff, /* 0x1740-0x177F NOT PRESENT */
	0xffff, /* 0x1780-0x17BF NOT PRESENT */
	0xffff, /* 0x17c0-0x17FF NOT PRESENT */
	0xffff, /* 0x1800-0x183F NOT PRESENT */
	0xffff, /* 0x1840-0x187F NOT PRESENT */
	0xffff, /* 0x1880-0x18BF NOT PRESENT */
	0xffff, /* 0x18c0-0x18FF NOT PRESENT */
	0xffff, /* 0x1900-0x193F NOT PRESENT */
	0xffff, /* 0x1940-0x197F NOT PRESENT */
	0xffff, /* 0x1980-0x19BF NOT PRESENT */
	0xffff, /* 0x19c0-0x19FF NOT PRESENT */
	0xffff, /* 0x1a00-0x1A3F NOT PRESENT */
	0xffff, /* 0x1a40-0x1A7F NOT PRESENT */
	0xffff, /* 0x1a80-0x1ABF NOT PRESENT */
	0xffff, /* 0x1ac0-0x1AFF NOT PRESENT */
	0xffff, /* 0x1b00-0x1B3F NOT PRESENT */
	0xffff, /* 0x1b40-0x1B7F NOT PRESENT */
	0xffff, /* 0x1b80-0x1BBF NOT PRESENT */
	0xffff, /* 0x1bc0-0x1BFF NOT PRESENT */
	0xffff, /* 0x1c00-0x1C3F NOT PRESENT */
	0xffff, /* 0x1c40-0x1C7F NOT PRESENT */
	0xffff, /* 0x1c80-0x1CBF NOT PRESENT */
	0xffff, /* 0x1cc0-0x1CFF NOT PRESENT */
	0xffff, /* 0x1d00-0x1D3F NOT PRESENT */
	0xffff, /* 0x1d40-0x1D7F NOT PRESENT */
	0xffff, /* 0x1d80-0x1DBF NOT PRESENT */
	0xffff, /* 0x1dc0-0x1DFF NOT PRESENT */
	0xffff, /* 0x1e00-0x1E3F NOT PRESENT */
	0xffff, /* 0x1e40-0x1E7F NOT PRESENT */
	0xffff, /* 0x1e80-0x1EBF NOT PRESENT */
	0xffff, /* 0x1ec0-0x1EFF NOT PRESENT */
	0xffff, /* 0x1f00-0x1F3F NOT PRESENT */
	0xffff, /* 0x1f40-0x1F7F NOT PRESENT */
	0xffff, /* 0x1f80-0x1FBF NOT PRESENT */
	0xffff, /* 0x1fc0-0x1FFF NOT PRESENT */
	0xffff, /* 0x2000-0x203F NOT PRESENT */
	0xffff, /* 0x2040-0x207F NOT PRESENT */
	0xffff, /* 0x2080-0x20BF NOT PRESENT */
	0xffff, /* 0x20c0-0x20FF NOT PRESENT */
	0xffff, /* 0x2100-0x213F NOT PRESENT */
	0xffff, /* 0x2140-0x217F NOT PRESENT */
	0xffff, /* 0x2180-0x21BF NOT PRESENT */
	0xffff, /* 0x21c0-0x21FF NOT PRESENT */
	0xffff, /* 0x2200-0x223F NOT PRESENT */
	0xffff, /* 0x2240-0x227F NOT PRESENT */
	0xffff, /* 0x2280-0x22BF NOT PRESENT */
	0xffff, /* 0x22c0-0x22FF NOT PRESENT */
	0xffff, /* 0x2300-0x233F NOT PRESENT */
	0xffff, /* 0x2340-0x237F NOT PRESENT */
	0xffff, /* 0x2380-0x23BF NOT PRESENT */
	0xffff, /* 0x23c0-0x23FF NOT PRESENT */
	0xffff, /* 0x2400-0x243F NOT PRESENT */
	0xffff, /* 0x2440-0x247F NOT PRESENT */
	0xffff, /* 0x2480-0x24BF NOT PRESENT */
	0xffff, /* 0x24c0-0x24FF NOT PRESENT */
	0xffff, /* 0x2500-0x253F NOT PRESENT */
	0xffff, /* 0x2540-0x257F NOT PRESENT */
	0xffff, /* 0x2580-0x25BF NOT PRESENT */
	0xffff, /* 0x25c0-0x25FF NOT PRESENT */
	0xffff, /* 0x2600-0x263F NOT PRESENT */
	0xffff, /* 0x2640-0x267F NOT PRESENT */
	0xffff, /* 0x2680-0x26BF NOT PRESENT */
	0xffff, /* 0x26c0-0x26FF NOT PRESENT */
	0xffff, /* 0x2700-0x273F NOT PRESENT */
	0xffff, /* 0x2740-0x277F NOT PRESENT */
	0xffff, /* 0x2780-0x27BF NOT PRESENT */
	0xffff, /* 0x27c0-0x27FF NOT PRESENT */
	0xffff, /* 0x2800-0x283F NOT PRESENT */
	0xffff, /* 0x2840-0x287F NOT PRESENT */
	0xffff, /* 0x2880-0x28BF NOT PRESENT */
	0xffff, /* 0x28c0-0x28FF NOT PRESENT */
	0xffff, /* 0x2900-0x293F NOT PRESENT */
	0xffff, /* 0x2940-0x297F NOT PRESENT */
	0xffff, /* 0x2980-0x29BF NOT PRESENT */
	0xffff, /* 0x29c0-0x29FF NOT PRESENT */
	0xffff, /* 0x2a00-0x2A3F NOT PRESENT */
	0xffff, /* 0x2a40-0x2A7F NOT PRESENT */
	0xffff, /* 0x2a80-0x2ABF NOT PRESENT */
	0xffff, /* 0x2ac0-0x2AFF NOT PRESENT */
	0xffff, /* 0x2b00-0x2B3F NOT PRESENT */
	0xffff, /* 0x2b40-0x2B7F NOT PRESENT */
	0xffff, /* 0x2b80-0x2BBF NOT PRESENT */
	0xffff, /* 0x2bc0-0x2BFF NOT PRESENT */
	0xffff, /* 0x2c00-0x2C3F NOT PRESENT */
	0xffff, /* 0x2c40-0x2C7F NOT PRESENT */
	0xffff, /* 0x2c80-0x2CBF NOT PRESENT */
	0xffff, /* 0x2cc0-0x2CFF NOT PRESENT */
	0xffff, /* 0x2d00-0x2D3F NOT PRESENT */
	0xffff, /* 0x2d40-0x2D7F NOT PRESENT */
	0xffff, /* 0x2d80-0x2DBF NOT PRESENT */
	0xffff, /* 0x2dc0-0x2DFF NOT PRESENT */
	0xffff, /* 0x2e00-0x2E3F NOT PRESENT */
	0xffff, /* 0x2e40-0x2E7F NOT PRESENT */
	0xffff, /* 0x2e80-0x2EBF NOT PRESENT */
	0xffff, /* 0x2ec0-0x2EFF NOT PRESENT */
	0xffff, /* 0x2f00-0x2F3F NOT PRESENT */
	0xffff, /* 0x2f40-0x2F7F NOT PRESENT */
	0xffff, /* 0x2f80-0x2FBF NOT PRESENT */
	0xffff, /* 0x2fc0-0x2FFF NOT PRESENT */
	0xffff, /* 0x3000-0x303F NOT PRESENT */
	0xffff, /* 0x3040-0x307F NOT PRESENT */
	0xffff, /* 0x3080-0x30BF NOT PRESENT */
	0xffff, /* 0x30c0-0x30FF NOT PRESENT */
	0xffff, /* 0x3100-0x313F NOT PRESENT */
	0xffff, /* 0x3140-0x317F NOT PRESENT */
	0xffff, /* 0x3180-0x31BF NOT PRESENT */
	0xffff, /* 0x31c0-0x31FF NOT PRESENT */
	0xffff, /* 0x3200-0x323F NOT PRESENT */
	0xffff, /* 0x3240-0x327F NOT PRESENT */
	0xffff, /* 0x3280-0x32BF NOT PRESENT */
	0xffff, /* 0x32c0-0x32FF NOT PRESENT */
	0xffff, /* 0x3300-0x333F NOT PRESENT */
	0xffff, /* 0x3340-0x337F NOT PRESENT */
	0xffff, /* 0x3380-0x33BF NOT PRESENT */
	0xffff, /* 0x33c0-0x33FF NOT PRESENT */
	0xffff, /* 0x3400-0x343F NOT PRESENT */
	0xffff, /* 0x3440-0x347F NOT PRESENT */
	0xffff, /* 0x3480-0x34BF NOT PRESENT */
	0xffff, /* 0x34c0-0x34FF NOT PRESENT */
	0xffff, /* 0x3500-0x353F NOT PRESENT */
	0xffff, /* 0x3540-0x357F NOT PRESENT */
	0xffff, /* 0x3580-0x35BF NOT PRESENT */
	0xffff, /* 0x35c0-0x35FF NOT PRESENT */
	0xffff, /* 0x3600-0x363F NOT PRESENT */
	0xffff, /* 0x3640-0x367F NOT PRESENT */
	0xffff, /* 0x3680-0x36BF NOT PRESENT */
	0xffff, /* 0x36c0-0x36FF NOT PRESENT */
	0xffff, /* 0x3700-0x373F NOT PRESENT */
	0xffff, /* 0x3740-0x377F NOT PRESENT */
	0xffff, /* 0x3780-0x37BF NOT PRESENT */
	0xffff, /* 0x37c0-0x37FF NOT PRESENT */
	0xffff, /* 0x3800-0x383F NOT PRESENT */
	0xffff, /* 0x3840-0x387F NOT PRESENT */
	0xffff, /* 0x3880-0x38BF NOT PRESENT */
	0xffff, /* 0x38c0-0x38FF NOT PRESENT */
	0xffff, /* 0x3900-0x393F NOT PRESENT */
	0xffff, /* 0x3940-0x397F NOT PRESENT */
	0xffff, /* 0x3980-0x39BF NOT PRESENT */
	0xffff, /* 0x39c0-0x39FF NOT PRESENT */
	0xffff, /* 0x3a00-0x3A3F NOT PRESENT */
	0xffff, /* 0x3a40-0x3A7F NOT PRESENT */
	0xffff, /* 0x3a80-0x3ABF NOT PRESENT */
	0xffff, /* 0x3ac0-0x3AFF NOT PRESENT */
	0xffff, /* 0x3b00-0x3B3F NOT PRESENT */
	0xffff, /* 0x3b40-0x3B7F NOT PRESENT */
	0xffff, /* 0x3b80-0x3BBF NOT PRESENT */
	0xffff, /* 0x3bc0-0x3BFF NOT PRESENT */
	0xffff, /* 0x3c00-0x3C3F NOT PRESENT */
	0xffff, /* 0x3c40-0x3C7F NOT PRESENT */
	0xffff, /* 0x3c80-0x3CBF NOT PRESENT */
	0xffff, /* 0x3cc0-0x3CFF NOT PRESENT */
	0xffff, /* 0x3d00-0x3D3F NOT PRESENT */
	0xffff, /* 0x3d40-0x3D7F NOT PRESENT */
	0xffff, /* 0x3d80-0x3DBF NOT PRESENT */
	0xffff, /* 0x3dc0-0x3DFF NOT PRESENT */
	0xffff, /* 0x3e00-0x3E3F NOT PRESENT */
	0xffff, /* 0x3e40-0x3E7F NOT PRESENT */
	0xffff, /* 0x3e80-0x3EBF NOT PRESENT */
	0xffff, /* 0x3ec0-0x3EFF NOT PRESENT */
	0xffff, /* 0x3f00-0x3F3F NOT PRESENT */
	0xffff, /* 0x3f40-0x3F7F NOT PRESENT */
	0xffff, /* 0x3f80-0x3FBF NOT PRESENT */
	0xffff, /* 0x3fc0-0x3FFF NOT PRESENT */
	0xffff, /* 0x4000-0x403F NOT PRESENT */
	0xffff, /* 0x4040-0x407F NOT PRESENT */
	0xffff, /* 0x4080-0x40BF NOT PRESENT */
	0xffff, /* 0x40c0-0x40FF NOT PRESENT */
	0xffff, /* 0x4100-0x413F NOT PRESENT */
	0xffff, /* 0x4140-0x417F NOT PRESENT */
	0xffff, /* 0x4180-0x41BF NOT PRESENT */
	0xffff, /* 0x41c0-0x41FF NOT PRESENT */
	0xffff, /* 0x4200-0x423F NOT PRESENT */
	0xffff, /* 0x4240-0x427F NOT PRESENT */
	0xffff, /* 0x4280-0x42BF NOT PRESENT */
	0xffff, /* 0x42c0-0x42FF NOT PRESENT */
	0xffff, /* 0x4300-0x433F NOT PRESENT */
	0xffff, /* 0x4340-0x437F NOT PRESENT */
	0xffff, /* 0x4380-0x43BF NOT PRESENT */
	0xffff, /* 0x43c0-0x43FF NOT PRESENT */
	0xffff, /* 0x4400-0x443F NOT PRESENT */
	0xffff, /* 0x4440-0x447F NOT PRESENT */
	0xffff, /* 0x4480-0x44BF NOT PRESENT */
	0xffff, /* 0x44c0-0x44FF NOT PRESENT */
	0xffff, /* 0x4500-0x453F NOT PRESENT */
	0xffff, /* 0x4540-0x457F NOT PRESENT */
	0xffff, /* 0x4580-0x45BF NOT PRESENT */
	0xffff, /* 0x45c0-0x45FF NOT PRESENT */
	0xffff, /* 0x4600-0x463F NOT PRESENT */
	0xffff, /* 0x4640-0x467F NOT PRESENT */
	0xffff, /* 0x4680-0x46BF NOT PRESENT */
	0xffff, /* 0x46c0-0x46FF NOT PRESENT */
	0xffff, /* 0x4700-0x473F NOT PRESENT */
	0xffff, /* 0x4740-0x477F NOT PRESENT */
	0xffff, /* 0x4780-0x47BF NOT PRESENT */
	0xffff, /* 0x47c0-0x47FF NOT PRESENT */
	0xffff, /* 0x4800-0x483F NOT PRESENT */
	0xffff, /* 0x4840-0x487F NOT PRESENT */
	0xffff, /* 0x4880-0x48BF NOT PRESENT */
	0xffff, /* 0x48c0-0x48FF NOT PRESENT */
	0xffff, /* 0x4900-0x493F NOT PRESENT */
	0xffff, /* 0x4940-0x497F NOT PRESENT */
	0xffff, /* 0x4980-0x49BF NOT PRESENT */
	0xffff, /* 0x49c0-0x49FF NOT PRESENT */
	0xffff, /* 0x4a00-0x4A3F NOT PRESENT */
	0xffff, /* 0x4a40-0x4A7F NOT PRESENT */
	0xffff, /* 0x4a80-0x4ABF NOT PRESENT */
	0xffff, /* 0x4ac0-0x4AFF NOT PRESENT */
	0xffff, /* 0x4b00-0x4B3F NOT PRESENT */
	0xffff, /* 0x4b40-0x4B7F NOT PRESENT */
	0xffff, /* 0x4b80-0x4BBF NOT PRESENT */
	0xffff, /* 0x4bc0-0x4BFF NOT PRESENT */
	0xffff, /* 0x4c00-0x4C3F NOT PRESENT */
	0xffff, /* 0x4c40-0x4C7F NOT PRESENT */
	0xffff, /* 0x4c80-0x4CBF NOT PRESENT */
	0xffff, /* 0x4cc0-0x4CFF NOT PRESENT */
	0xffff, /* 0x4d00-0x4D3F NOT PRESENT */
	0xffff, /* 0x4d40-0x4D7F NOT PRESENT */
	0xffff, /* 0x4d80-0x4DBF NOT PRESENT */
	0xffff, /* 0x4dc0-0x4DFF NOT PRESENT */
	0xffff, /* 0x4e00-0x4E3F NOT PRESENT */
	0xffff, /* 0x4e40-0x4E7F NOT PRESENT */
	0xffff, /* 0x4e80-0x4EBF NOT PRESENT */
	0xffff, /* 0x4ec0-0x4EFF NOT PRESENT */
	0xffff, /* 0x4f00-0x4F3F NOT PRESENT */
	0xffff, /* 0x4f40-0x4F7F NOT PRESENT */
	0xffff, /* 0x4f80-0x4FBF NOT PRESENT */
	0xffff, /* 0x4fc0-0x4FFF NOT PRESENT */
	0xffff, /* 0x5000-0x503F NOT PRESENT */
	0xffff, /* 0x5040-0x507F NOT PRESENT */
	0xffff, /* 0x5080-0x50BF NOT PRESENT */
	0xffff, /* 0x50c0-0x50FF NOT PRESENT */
	0xffff, /* 0x5100-0x513F NOT PRESENT */
	0xffff, /* 0x5140-0x517F NOT PRESENT */
	0xffff, /* 0x5180-0x51BF NOT PRESENT */
	0xffff, /* 0x51c0-0x51FF NOT PRESENT */
	0xffff, /* 0x5200-0x523F NOT PRESENT */
	0xffff, /* 0x5240-0x527F NOT PRESENT */
	0xffff, /* 0x5280-0x52BF NOT PRESENT */
	0xffff, /* 0x52c0-0x52FF NOT PRESENT */
	0xffff, /* 0x5300-0x533F NOT PRESENT */
	0xffff, /* 0x5340-0x537F NOT PRESENT */
	0xffff, /* 0x5380-0x53BF NOT PRESENT */
	0xffff, /* 0x53c0-0x53FF NOT PRESENT */
	0xffff, /* 0x5400-0x543F NOT PRESENT */
	0xffff, /* 0x5440-0x547F NOT PRESENT */
	0xffff, /* 0x5480-0x54BF NOT PRESENT */
	0xffff, /* 0x54c0-0x54FF NOT PRESENT */
	0xffff, /* 0x5500-0x553F NOT PRESENT */
	0xffff, /* 0x5540-0x557F NOT PRESENT */
	0xffff, /* 0x5580-0x55BF NOT PRESENT */
	0xffff, /* 0x55c0-0x55FF NOT PRESENT */
	0xffff, /* 0x5600-0x563F NOT PRESENT */
	0xffff, /* 0x5640-0x567F NOT PRESENT */
	0xffff, /* 0x5680-0x56BF NOT PRESENT */
	0xffff, /* 0x56c0-0x56FF NOT PRESENT */
	0xffff, /* 0x5700-0x573F NOT PRESENT */
	0xffff, /* 0x5740-0x577F NOT PRESENT */
	0xffff, /* 0x5780-0x57BF NOT PRESENT */
	0xffff, /* 0x57c0-0x57FF NOT PRESENT */
	0xffff, /* 0x5800-0x583F NOT PRESENT */
	0xffff, /* 0x5840-0x587F NOT PRESENT */
	0xffff, /* 0x5880-0x58BF NOT PRESENT */
	0xffff, /* 0x58c0-0x58FF NOT PRESENT */
	0xffff, /* 0x5900-0x593F NOT PRESENT */
	0xffff, /* 0x5940-0x597F NOT PRESENT */
	0xffff, /* 0x5980-0x59BF NOT PRESENT */
	0xffff, /* 0x59c0-0x59FF NOT PRESENT */
	0xffff, /* 0x5a00-0x5A3F NOT PRESENT */
	0xffff, /* 0x5a40-0x5A7F NOT PRESENT */
	0xffff, /* 0x5a80-0x5ABF NOT PRESENT */
	0xffff, /* 0x5ac0-0x5AFF NOT PRESENT */
	0xffff, /* 0x5b00-0x5B3F NOT PRESENT */
	0xffff, /* 0x5b40-0x5B7F NOT PRESENT */
	0xffff, /* 0x5b80-0x5BBF NOT PRESENT */
	0xffff, /* 0x5bc0-0x5BFF NOT PRESENT */
	0xffff, /* 0x5c00-0x5C3F NOT PRESENT */
	0xffff, /* 0x5c40-0x5C7F NOT PRESENT */
	0xffff, /* 0x5c80-0x5CBF NOT PRESENT */
	0xffff, /* 0x5cc0-0x5CFF NOT PRESENT */
	0xffff, /* 0x5d00-0x5D3F NOT PRESENT */
	0xffff, /* 0x5d40-0x5D7F NOT PRESENT */
	0xffff, /* 0x5d80-0x5DBF NOT PRESENT */
	0xffff, /* 0x5dc0-0x5DFF NOT PRESENT */
	0xffff, /* 0x5e00-0x5E3F NOT PRESENT */
	0xffff, /* 0x5e40-0x5E7F NOT PRESENT */
	0xffff, /* 0x5e80-0x5EBF NOT PRESENT */
	0xffff, /* 0x5ec0-0x5EFF NOT PRESENT */
	0xffff, /* 0x5f00-0x5F3F NOT PRESENT */
	0xffff, /* 0x5f40-0x5F7F NOT PRESENT */
	0xffff, /* 0x5f80-0x5FBF NOT PRESENT */
	0xffff, /* 0x5fc0-0x5FFF NOT PRESENT */
	0xffff, /* 0x6000-0x603F NOT PRESENT */
	0xffff, /* 0x6040-0x607F NOT PRESENT */
	0xffff, /* 0x6080-0x60BF NOT PRESENT */
	0xffff, /* 0x60c0-0x60FF NOT PRESENT */
	0xffff, /* 0x6100-0x613F NOT PRESENT */
	0xffff, /* 0x6140-0x617F NOT PRESENT */
	0xffff, /* 0x6180-0x61BF NOT PRESENT */
	0xffff, /* 0x61c0-0x61FF NOT PRESENT */
	0xffff, /* 0x6200-0x623F NOT PRESENT */
	0xffff, /* 0x6240-0x627F NOT PRESENT */
	0xffff, /* 0x6280-0x62BF NOT PRESENT */
	0xffff, /* 0x62c0-0x62FF NOT PRESENT */
	0xffff, /* 0x6300-0x633F NOT PRESENT */
	0xffff, /* 0x6340-0x637F NOT PRESENT */
	0xffff, /* 0x6380-0x63BF NOT PRESENT */
	0xffff, /* 0x63c0-0x63FF NOT PRESENT */
	0xffff, /* 0x6400-0x643F NOT PRESENT */
	0xffff, /* 0x6440-0x647F NOT PRESENT */
	0xffff, /* 0x6480-0x64BF NOT PRESENT */
	0xffff, /* 0x64c0-0x64FF NOT PRESENT */
	0xffff, /* 0x6500-0x653F NOT PRESENT */
	0xffff, /* 0x6540-0x657F NOT PRESENT */
	0xffff, /* 0x6580-0x65BF NOT PRESENT */
	0xffff, /* 0x65c0-0x65FF NOT PRESENT */
	0xffff, /* 0x6600-0x663F NOT PRESENT */
	0xffff, /* 0x6640-0x667F NOT PRESENT */
	0xffff, /* 0x6680-0x66BF NOT PRESENT */
	0xffff, /* 0x66c0-0x66FF NOT PRESENT */
	0xffff, /* 0x6700-0x673F NOT PRESENT */
	0xffff, /* 0x6740-0x677F NOT PRESENT */
	0xffff, /* 0x6780-0x67BF NOT PRESENT */
	0xffff, /* 0x67c0-0x67FF NOT PRESENT */
	0xffff, /* 0x6800-0x683F NOT PRESENT */
	0xffff, /* 0x6840-0x687F NOT PRESENT */
	0xffff, /* 0x6880-0x68BF NOT PRESENT */
	0xffff, /* 0x68c0-0x68FF NOT PRESENT */
	0xffff, /* 0x6900-0x693F NOT PRESENT */
	0xffff, /* 0x6940-0x697F NOT PRESENT */
	0xffff, /* 0x6980-0x69BF NOT PRESENT */
	0xffff, /* 0x69c0-0x69FF NOT PRESENT */
	0xffff, /* 0x6a00-0x6A3F NOT PRESENT */
	0xffff, /* 0x6a40-0x6A7F NOT PRESENT */
	0xffff, /* 0x6a80-0x6ABF NOT PRESENT */
	0xffff, /* 0x6ac0-0x6AFF NOT PRESENT */
	0xffff, /* 0x6b00-0x6B3F NOT PRESENT */
	0xffff, /* 0x6b40-0x6B7F NOT PRESENT */
	0xffff, /* 0x6b80-0x6BBF NOT PRESENT */
	0xffff, /* 0x6bc0-0x6BFF NOT PRESENT */
	0xffff, /* 0x6c00-0x6C3F NOT PRESENT */
	0xffff, /* 0x6c40-0x6C7F NOT PRESENT */
	0xffff, /* 0x6c80-0x6CBF NOT PRESENT */
	0xffff, /* 0x6cc0-0x6CFF NOT PRESENT */
	0xffff, /* 0x6d00-0x6D3F NOT PRESENT */
	0xffff, /* 0x6d40-0x6D7F NOT PRESENT */
	0xffff, /* 0x6d80-0x6DBF NOT PRESENT */
	0xffff, /* 0x6dc0-0x6DFF NOT PRESENT */
	0xffff, /* 0x6e00-0x6E3F NOT PRESENT */
	0xffff, /* 0x6e40-0x6E7F NOT PRESENT */
	0xffff, /* 0x6e80-0x6EBF NOT PRESENT */
	0xffff, /* 0x6ec0-0x6EFF NOT PRESENT */
	0xffff, /* 0x6f00-0x6F3F NOT PRESENT */
	0xffff, /* 0x6f40-0x6F7F NOT PRESENT */
	0xffff, /* 0x6f80-0x6FBF NOT PRESENT */
	0xffff, /* 0x6fc0-0x6FFF NOT PRESENT */
	0xffff, /* 0x7000-0x703F NOT PRESENT */
	0xffff, /* 0x7040-0x707F NOT PRESENT */
	0xffff, /* 0x7080-0x70BF NOT PRESENT */
	0xffff, /* 0x70c0-0x70FF NOT PRESENT */
	0xffff, /* 0x7100-0x713F NOT PRESENT */
	0xffff, /* 0x7140-0x717F NOT PRESENT */
	0xffff, /* 0x7180-0x71BF NOT PRESENT */
	0xffff, /* 0x71c0-0x71FF NOT PRESENT */
	0xffff, /* 0x7200-0x723F NOT PRESENT */
	0xffff, /* 0x7240-0x727F NOT PRESENT */
	0xffff, /* 0x7280-0x72BF NOT PRESENT */
	0xffff, /* 0x72c0-0x72FF NOT PRESENT */
	0xffff, /* 0x7300-0x733F NOT PRESENT */
	0xffff, /* 0x7340-0x737F NOT PRESENT */
	0xffff, /* 0x7380-0x73BF NOT PRESENT */
	0xffff, /* 0x73c0-0x73FF NOT PRESENT */
	0xffff, /* 0x7400-0x743F NOT PRESENT */
	0xffff, /* 0x7440-0x747F NOT PRESENT */
	0xffff, /* 0x7480-0x74BF NOT PRESENT */
	0xffff, /* 0x74c0-0x74FF NOT PRESENT */
	0xffff, /* 0x7500-0x753F NOT PRESENT */
	0xffff, /* 0x7540-0x757F NOT PRESENT */
	0xffff, /* 0x7580-0x75BF NOT PRESENT */
	0xffff, /* 0x75c0-0x75FF NOT PRESENT */
	0xffff, /* 0x7600-0x763F NOT PRESENT */
	0xffff, /* 0x7640-0x767F NOT PRESENT */
	0xffff, /* 0x7680-0x76BF NOT PRESENT */
	0xffff, /* 0x76c0-0x76FF NOT PRESENT */
	0xffff, /* 0x7700-0x773F NOT PRESENT */
	0xffff, /* 0x7740-0x777F NOT PRESENT */
	0xffff, /* 0x7780-0x77BF NOT PRESENT */
	0xffff, /* 0x77c0-0x77FF NOT PRESENT */
	0xffff, /* 0x7800-0x783F NOT PRESENT */
	0xffff, /* 0x7840-0x787F NOT PRESENT */
	0xffff, /* 0x7880-0x78BF NOT PRESENT */
	0xffff, /* 0x78c0-0x78FF NOT PRESENT */
	0xffff, /* 0x7900-0x793F NOT PRESENT */
	0xffff, /* 0x7940-0x797F NOT PRESENT */
	0xffff, /* 0x7980-0x79BF NOT PRESENT */
	0xffff, /* 0x79c0-0x79FF NOT PRESENT */
	0xffff, /* 0x7a00-0x7A3F NOT PRESENT */
	0xffff, /* 0x7a40-0x7A7F NOT PRESENT */
	0xffff, /* 0x7a80-0x7ABF NOT PRESENT */
	0xffff, /* 0x7ac0-0x7AFF NOT PRESENT */
	0xffff, /* 0x7b00-0x7B3F NOT PRESENT */
	0xffff, /* 0x7b40-0x7B7F NOT PRESENT */
	0xffff, /* 0x7b80-0x7BBF NOT PRESENT */
	0xffff, /* 0x7bc0-0x7BFF NOT PRESENT */
	0xffff, /* 0x7c00-0x7C3F NOT PRESENT */
	0xffff, /* 0x7c40-0x7C7F NOT PRESENT */
	0xffff, /* 0x7c80-0x7CBF NOT PRESENT */
	0xffff, /* 0x7cc0-0x7CFF NOT PRESENT */
	0xffff, /* 0x7d00-0x7D3F NOT PRESENT */
	0xffff, /* 0x7d40-0x7D7F NOT PRESENT */
	0xffff, /* 0x7d80-0x7DBF NOT PRESENT */
	0xffff, /* 0x7dc0-0x7DFF NOT PRESENT */
	0xffff, /* 0x7e00-0x7E3F NOT PRESENT */
	0xffff, /* 0x7e40-0x7E7F NOT PRESENT */
	0xffff, /* 0x7e80-0x7EBF NOT PRESENT */
	0xffff, /* 0x7ec0-0x7EFF NOT PRESENT */
	0xffff, /* 0x7f00-0x7F3F NOT PRESENT */
	0xffff, /* 0x7f40-0x7F7F NOT PRESENT */
	0xffff, /* 0x7f80-0x7FBF NOT PRESENT */
	0xffff, /* 0x7fc0-0x7FFF NOT PRESENT */
	0xffff, /* 0x8000-0x803F NOT PRESENT */
	0xffff, /* 0x8040-0x807F NOT PRESENT */
	0xffff, /* 0x8080-0x80BF NOT PRESENT */
	0xffff, /* 0x80c0-0x80FF NOT PRESENT */
	0xffff, /* 0x8100-0x813F NOT PRESENT */
	0xffff, /* 0x8140-0x817F NOT PRESENT */
	0xffff, /* 0x8180-0x81BF NOT PRESENT */
	0xffff, /* 0x81c0-0x81FF NOT PRESENT */
	0xffff, /* 0x8200-0x823F NOT PRESENT */
	0xffff, /* 0x8240-0x827F NOT PRESENT */
	0xffff, /* 0x8280-0x82BF NOT PRESENT */
	0xffff, /* 0x82c0-0x82FF NOT PRESENT */
	0xffff, /* 0x8300-0x833F NOT PRESENT */
	0xffff, /* 0x8340-0x837F NOT PRESENT */
	0xffff, /* 0x8380-0x83BF NOT PRESENT */
	0xffff, /* 0x83c0-0x83FF NOT PRESENT */
	0xffff, /* 0x8400-0x843F NOT PRESENT */
	0xffff, /* 0x8440-0x847F NOT PRESENT */
	0xffff, /* 0x8480-0x84BF NOT PRESENT */
	0xffff, /* 0x84c0-0x84FF NOT PRESENT */
	0xffff, /* 0x8500-0x853F NOT PRESENT */
	0xffff, /* 0x8540-0x857F NOT PRESENT */
	0xffff, /* 0x8580-0x85BF NOT PRESENT */
	0xffff, /* 0x85c0-0x85FF NOT PRESENT */
	0xffff, /* 0x8600-0x863F NOT PRESENT */
	0xffff, /* 0x8640-0x867F NOT PRESENT */
	0xffff, /* 0x8680-0x86BF NOT PRESENT */
	0xffff, /* 0x86c0-0x86FF NOT PRESENT */
	0xffff, /* 0x8700-0x873F NOT PRESENT */
	0xffff, /* 0x8740-0x877F NOT PRESENT */
	0xffff, /* 0x8780-0x87BF NOT PRESENT */
	0xffff, /* 0x87c0-0x87FF NOT PRESENT */
	0xffff, /* 0x8800-0x883F NOT PRESENT */
	0xffff, /* 0x8840-0x887F NOT PRESENT */
	0xffff, /* 0x8880-0x88BF NOT PRESENT */
	0xffff, /* 0x88c0-0x88FF NOT PRESENT */
	0xffff, /* 0x8900-0x893F NOT PRESENT */
	0xffff, /* 0x8940-0x897F NOT PRESENT */
	0xffff, /* 0x8980-0x89BF NOT PRESENT */
	0xffff, /* 0x89c0-0x89FF NOT PRESENT */
	0xffff, /* 0x8a00-0x8A3F NOT PRESENT */
	0xffff, /* 0x8a40-0x8A7F NOT PRESENT */
	0xffff, /* 0x8a80-0x8ABF NOT PRESENT */
	0xffff, /* 0x8ac0-0x8AFF NOT PRESENT */
	0xffff, /* 0x8b00-0x8B3F NOT PRESENT */
	0xffff, /* 0x8b40-0x8B7F NOT PRESENT */
	0xffff, /* 0x8b80-0x8BBF NOT PRESENT */
	0xffff, /* 0x8bc0-0x8BFF NOT PRESENT */
	0xffff, /* 0x8c00-0x8C3F NOT PRESENT */
	0xffff, /* 0x8c40-0x8C7F NOT PRESENT */
	0xffff, /* 0x8c80-0x8CBF NOT PRESENT */
	0xffff, /* 0x8cc0-0x8CFF NOT PRESENT */
	0xffff, /* 0x8d00-0x8D3F NOT PRESENT */
	0xffff, /* 0x8d40-0x8D7F NOT PRESENT */
	0xffff, /* 0x8d80-0x8DBF NOT PRESENT */
	0xffff, /* 0x8dc0-0x8DFF NOT PRESENT */
	0xffff, /* 0x8e00-0x8E3F NOT PRESENT */
	0xffff, /* 0x8e40-0x8E7F NOT PRESENT */
	0xffff, /* 0x8e80-0x8EBF NOT PRESENT */
	0xffff, /* 0x8ec0-0x8EFF NOT PRESENT */
	0xffff, /* 0x8f00-0x8F3F NOT PRESENT */
	0xffff, /* 0x8f40-0x8F7F NOT PRESENT */
	0xffff, /* 0x8f80-0x8FBF NOT PRESENT */
	0xffff, /* 0x8fc0-0x8FFF NOT PRESENT */
	0xffff, /* 0x9000-0x903F NOT PRESENT */
	0xffff, /* 0x9040-0x907F NOT PRESENT */
	0xffff, /* 0x9080-0x90BF NOT PRESENT */
	0xffff, /* 0x90c0-0x90FF NOT PRESENT */
	0xffff, /* 0x9100-0x913F NOT PRESENT */
	0xffff, /* 0x9140-0x917F NOT PRESENT */
	0xffff, /* 0x9180-0x91BF NOT PRESENT */
	0xffff, /* 0x91c0-0x91FF NOT PRESENT */
	0xffff, /* 0x9200-0x923F NOT PRESENT */
	0xffff, /* 0x9240-0x927F NOT PRESENT */
	0xffff, /* 0x9280-0x92BF NOT PRESENT */
	0xffff, /* 0x92c0-0x92FF NOT PRESENT */
	0xffff, /* 0x9300-0x933F NOT PRESENT */
	0xffff, /* 0x9340-0x937F NOT PRESENT */
	0xffff, /* 0x9380-0x93BF NOT PRESENT */
	0xffff, /* 0x93c0-0x93FF NOT PRESENT */
	0xffff, /* 0x9400-0x943F NOT PRESENT */
	0xffff, /* 0x9440-0x947F NOT PRESENT */
	0xffff, /* 0x9480-0x94BF NOT PRESENT */
	0xffff, /* 0x94c0-0x94FF NOT PRESENT */
	0xffff, /* 0x9500-0x953F NOT PRESENT */
	0xffff, /* 0x9540-0x957F NOT PRESENT */
	0xffff, /* 0x9580-0x95BF NOT PRESENT */
	0xffff, /* 0x95c0-0x95FF NOT PRESENT */
	0xffff, /* 0x9600-0x963F NOT PRESENT */
	0xffff, /* 0x9640-0x967F NOT PRESENT */
	0xffff, /* 0x9680-0x96BF NOT PRESENT */
	0xffff, /* 0x96c0-0x96FF NOT PRESENT */
	0xffff, /* 0x9700-0x973F NOT PRESENT */
	0xffff, /* 0x9740-0x977F NOT PRESENT */
	0xffff, /* 0x9780-0x97BF NOT PRESENT */
	0xffff, /* 0x97c0-0x97FF NOT PRESENT */
	0xffff, /* 0x9800-0x983F NOT PRESENT */
	0xffff, /* 0x9840-0x987F NOT PRESENT */
	0xffff, /* 0x9880-0x98BF NOT PRESENT */
	0xffff, /* 0x98c0-0x98FF NOT PRESENT */
	0xffff, /* 0x9900-0x993F NOT PRESENT */
	0xffff, /* 0x9940-0x997F NOT PRESENT */
	0xffff, /* 0x9980-0x99BF NOT PRESENT */
	0xffff, /* 0x99c0-0x99FF NOT PRESENT */
	0xffff, /* 0x9a00-0x9A3F NOT PRESENT */
	0xffff, /* 0x9a40-0x9A7F NOT PRESENT */
	0xffff, /* 0x9a80-0x9ABF NOT PRESENT */
	0xffff, /* 0x9ac0-0x9AFF NOT PRESENT */
	0xffff, /* 0x9b00-0x9B3F NOT PRESENT */
	0xffff, /* 0x9b40-0x9B7F NOT PRESENT */
	0xffff, /* 0x9b80-0x9BBF NOT PRESENT */
	0xffff, /* 0x9bc0-0x9BFF NOT PRESENT */
	0xffff, /* 0x9c00-0x9C3F NOT PRESENT */
	0xffff, /* 0x9c40-0x9C7F NOT PRESENT */
	0xffff, /* 0x9c80-0x9CBF NOT PRESENT */
	0xffff, /* 0x9cc0-0x9CFF NOT PRESENT */
	0xffff, /* 0x9d00-0x9D3F NOT PRESENT */
	0xffff, /* 0x9d40-0x9D7F NOT PRESENT */
	0xffff, /* 0x9d80-0x9DBF NOT PRESENT */
	0xffff, /* 0x9dc0-0x9DFF NOT PRESENT */
	0xffff, /* 0x9e00-0x9E3F NOT PRESENT */
	0xffff, /* 0x9e40-0x9E7F NOT PRESENT */
	0xffff, /* 0x9e80-0x9EBF NOT PRESENT */
	0xffff, /* 0x9ec0-0x9EFF NOT PRESENT */
	0xffff, /* 0x9f00-0x9F3F NOT PRESENT */
	0xffff, /* 0x9f40-0x9F7F NOT PRESENT */
	0xffff, /* 0x9f80-0x9FBF NOT PRESENT */
	0xffff, /* 0x9fc0-0x9FFF NOT PRESENT */
	0xffff, /* 0xa000-0xA03F NOT PRESENT */
	0xffff, /* 0xa040-0xA07F NOT PRESENT */
	0xffff, /* 0xa080-0xA0BF NOT PRESENT */
	0xffff, /* 0xa0c0-0xA0FF NOT PRESENT */
	0xffff, /* 0xa100-0xA13F NOT PRESENT */
	0x0080, /* 0xa140-0xA17F */
	0x00c0, /* 0xa180-0xA1BF */
	0x0100, /* 0xa1c0-0xA1FF */
	0xffff, /* 0xa200-0xA23F NOT PRESENT */
	0x0140, /* 0xa240-0xA27F */
	0x0180, /* 0xa280-0xA2BF */
	0x01c0, /* 0xa2c0-0xA2FF */
	0xffff, /* 0xa300-0xA33F NOT PRESENT */
	0x0200, /* 0xa340-0xA37F */
	0x0240, /* 0xa380-0xA3BF */
	0x0280, /* 0xa3c0-0xA3FF */
	0xffff, /* 0xa400-0xA43F NOT PRESENT */
	0x02c0, /* 0xa440-0xA47F */
	0x0300, /* 0xa480-0xA4BF */
	0x0340, /* 0xa4c0-0xA4FF */
	0xffff, /* 0xa500-0xA53F NOT PRESENT */
	0x0380, /* 0xa540-0xA57F */
	0x03c0, /* 0xa580-0xA5BF */
	0x0400, /* 0xa5c0-0xA5FF */
	0xffff, /* 0xa600-0xA63F NOT PRESENT */
	0x0440, /* 0xa640-0xA67F */
	0x0480, /* 0xa680-0xA6BF */
	0x04c0, /* 0xa6c0-0xA6FF */
	0xffff, /* 0xa700-0xA73F NOT PRESENT */
	0x0500, /* 0xa740-0xA77F */
	0x0540, /* 0xa780-0xA7BF */
	0x0580, /* 0xa7c0-0xA7FF */
	0xffff, /* 0xa800-0xA83F NOT PRESENT */
	0x05c0, /* 0xa840-0xA87F */
	0x0600, /* 0xa880-0xA8BF */
	0x0640, /* 0xa8c0-0xA8FF */
	0xffff, /* 0xa900-0xA93F NOT PRESENT */
	0x0680, /* 0xa940-0xA97F */
	0x06c0, /* 0xa980-0xA9BF */
	0x0700, /* 0xa9c0-0xA9FF */
	0xffff, /* 0xaa00-0xAA3F NOT PRESENT */
	0x0740, /* 0xaa40-0xAA7F */
	0x0780, /* 0xaa80-0xAABF */
	0x07c0, /* 0xaac0-0xAAFF */
	0xffff, /* 0xab00-0xAB3F NOT PRESENT */
	0x0800, /* 0xab40-0xAB7F */
	0x0840, /* 0xab80-0xABBF */
	0x0880, /* 0xabc0-0xABFF */
	0xffff, /* 0xac00-0xAC3F NOT PRESENT */
	0x08c0, /* 0xac40-0xAC7F */
	0x0900, /* 0xac80-0xACBF */
	0x0940, /* 0xacc0-0xACFF */
	0xffff, /* 0xad00-0xAD3F NOT PRESENT */
	0x0980, /* 0xad40-0xAD7F */
	0x09c0, /* 0xad80-0xADBF */
	0x0a00, /* 0xadc0-0xADFF */
	0xffff, /* 0xae00-0xAE3F NOT PRESENT */
	0x0a40, /* 0xae40-0xAE7F */
	0x0a80, /* 0xae80-0xAEBF */
	0x0ac0, /* 0xaec0-0xAEFF */
	0xffff, /* 0xaf00-0xAF3F NOT PRESENT */
	0x0b00, /* 0xaf40-0xAF7F */
	0x0b40, /* 0xaf80-0xAFBF */
	0x0b80, /* 0xafc0-0xAFFF */
	0xffff, /* 0xb000-0xB03F NOT PRESENT */
	0x0bc0, /* 0xb040-0xB07F */
	0x0c00, /* 0xb080-0xB0BF */
	0x0c40, /* 0xb0c0-0xB0FF */
	0xffff, /* 0xb100-0xB13F NOT PRESENT */
	0x0c80, /* 0xb140-0xB17F */
	0x0cc0, /* 0xb180-0xB1BF */
	0x0d00, /* 0xb1c0-0xB1FF */
	0xffff, /* 0xb200-0xB23F NOT PRESENT */
	0x0d40, /* 0xb240-0xB27F */
	0x0d80, /* 0xb280-0xB2BF */
	0x0dc0, /* 0xb2c0-0xB2FF */
	0xffff, /* 0xb300-0xB33F NOT PRESENT */
	0x0e00, /* 0xb340-0xB37F */
	0x0e40, /* 0xb380-0xB3BF */
	0x0e80, /* 0xb3c0-0xB3FF */
	0xffff, /* 0xb400-0xB43F NOT PRESENT */
	0x0ec0, /* 0xb440-0xB47F */
	0x0f00, /* 0xb480-0xB4BF */
	0x0f40, /* 0xb4c0-0xB4FF */
	0xffff, /* 0xb500-0xB53F NOT PRESENT */
	0x0f80, /* 0xb540-0xB57F */
	0x0fc0, /* 0xb580-0xB5BF */
	0x1000, /* 0xb5c0-0xB5FF */
	0xffff, /* 0xb600-0xB63F NOT PRESENT */
	0x1040, /* 0xb640-0xB67F */
	0x1080, /* 0xb680-0xB6BF */
	0x10c0, /* 0xb6c0-0xB6FF */
	0xffff, /* 0xb700-0xB73F NOT PRESENT */
	0x1100, /* 0xb740-0xB77F */
	0x1140, /* 0xb780-0xB7BF */
	0x1180, /* 0xb7c0-0xB7FF */
	0xffff, /* 0xb800-0xB83F NOT PRESENT */
	0x11c0, /* 0xb840-0xB87F */
	0x1200, /* 0xb880-0xB8BF */
	0x1240, /* 0xb8c0-0xB8FF */
	0xffff, /* 0xb900-0xB93F NOT PRESENT */
	0x1280, /* 0xb940-0xB97F */
	0x12c0, /* 0xb980-0xB9BF */
	0x1300, /* 0xb9c0-0xB9FF */
	0xffff, /* 0xba00-0xBA3F NOT PRESENT */
	0x1340, /* 0xba40-0xBA7F */
	0x1380, /* 0xba80-0xBABF */
	0x13c0, /* 0xbac0-0xBAFF */
	0xffff, /* 0xbb00-0xBB3F NOT PRESENT */
	0x1400, /* 0xbb40-0xBB7F */
	0x1440, /* 0xbb80-0xBBBF */
	0x1480, /* 0xbbc0-0xBBFF */
	0xffff, /* 0xbc00-0xBC3F NOT PRESENT */
	0x14c0, /* 0xbc40-0xBC7F */
	0x1500, /* 0xbc80-0xBCBF */
	0x1540, /* 0xbcc0-0xBCFF */
	0xffff, /* 0xbd00-0xBD3F NOT PRESENT */
	0x1580, /* 0xbd40-0xBD7F */
	0x15c0, /* 0xbd80-0xBDBF */
	0x1600, /* 0xbdc0-0xBDFF */
	0xffff, /* 0xbe00-0xBE3F NOT PRESENT */
	0x1640, /* 0xbe40-0xBE7F */
	0x1680, /* 0xbe80-0xBEBF */
	0x16c0, /* 0xbec0-0xBEFF */
	0xffff, /* 0xbf00-0xBF3F NOT PRESENT */
	0x1700, /* 0xbf40-0xBF7F */
	0x1740, /* 0xbf80-0xBFBF */
	0x1780, /* 0xbfc0-0xBFFF */
	0xffff, /* 0xc000-0xC03F NOT PRESENT */
	0x17c0, /* 0xc040-0xC07F */
	0x1800, /* 0xc080-0xC0BF */
	0x1840, /* 0xc0c0-0xC0FF */
	0xffff, /* 0xc100-0xC13F NOT PRESENT */
	0x1880, /* 0xc140-0xC17F */
	0x18c0, /* 0xc180-0xC1BF */
	0x1900, /* 0xc1c0-0xC1FF */
	0xffff, /* 0xc200-0xC23F NOT PRESENT */
	0x1940, /* 0xc240-0xC27F */
	0x1980, /* 0xc280-0xC2BF */
	0x19c0, /* 0xc2c0-0xC2FF */
	0xffff, /* 0xc300-0xC33F NOT PRESENT */
	0x1a00, /* 0xc340-0xC37F */
	0x1a40, /* 0xc380-0xC3BF */
	0x1a80, /* 0xc3c0-0xC3FF */
	0xffff, /* 0xc400-0xC43F NOT PRESENT */
	0x1ac0, /* 0xc440-0xC47F */
	0x1b00, /* 0xc480-0xC4BF */
	0x1b40, /* 0xc4c0-0xC4FF */
	0xffff, /* 0xc500-0xC53F NOT PRESENT */
	0x1b80, /* 0xc540-0xC57F */
	0x1bc0, /* 0xc580-0xC5BF */
	0x1c00, /* 0xc5c0-0xC5FF */
	0xffff, /* 0xc600-0xC63F NOT PRESENT */
	0x1c40, /* 0xc640-0xC67F */
	0xffff, /* 0xc680-0xC6BF NOT PRESENT */
	0xffff, /* 0xc6c0-0xC6FF NOT PRESENT */
	0xffff, /* 0xc700-0xC73F NOT PRESENT */
	0xffff, /* 0xc740-0xC77F NOT PRESENT */
	0xffff, /* 0xc780-0xC7BF NOT PRESENT */
	0xffff, /* 0xc7c0-0xC7FF NOT PRESENT */
	0xffff, /* 0xc800-0xC83F NOT PRESENT */
	0xffff, /* 0xc840-0xC87F NOT PRESENT */
	0xffff, /* 0xc880-0xC8BF NOT PRESENT */
	0xffff, /* 0xc8c0-0xC8FF NOT PRESENT */
	0xffff, /* 0xc900-0xC93F NOT PRESENT */
	0x1c80, /* 0xc940-0xC97F */
	0x1cc0, /* 0xc980-0xC9BF */
	0x1d00, /* 0xc9c0-0xC9FF */
	0xffff, /* 0xca00-0xCA3F NOT PRESENT */
	0x1d40, /* 0xca40-0xCA7F */
	0x1d80, /* 0xca80-0xCABF */
	0x1dc0, /* 0xcac0-0xCAFF */
	0xffff, /* 0xcb00-0xCB3F NOT PRESENT */
	0x1e00, /* 0xcb40-0xCB7F */
	0x1e40, /* 0xcb80-0xCBBF */
	0x1e80, /* 0xcbc0-0xCBFF */
	0xffff, /* 0xcc00-0xCC3F NOT PRESENT */
	0x1ec0, /* 0xcc40-0xCC7F */
	0x1f00, /* 0xcc80-0xCCBF */
	0x1f40, /* 0xccc0-0xCCFF */
	0xffff, /* 0xcd00-0xCD3F NOT PRESENT */
	0x1f80, /* 0xcd40-0xCD7F */
	0x1fc0, /* 0xcd80-0xCDBF */
	0x2000, /* 0xcdc0-0xCDFF */
	0xffff, /* 0xce00-0xCE3F NOT PRESENT */
	0x2040, /* 0xce40-0xCE7F */
	0x2080, /* 0xce80-0xCEBF */
	0x20c0, /* 0xcec0-0xCEFF */
	0xffff, /* 0xcf00-0xCF3F NOT PRESENT */
	0x2100, /* 0xcf40-0xCF7F */
	0x2140, /* 0xcf80-0xCFBF */
	0x2180, /* 0xcfc0-0xCFFF */
	0xffff, /* 0xd000-0xD03F NOT PRESENT */
	0x21c0, /* 0xd040-0xD07F */
	0x2200, /* 0xd080-0xD0BF */
	0x2240, /* 0xd0c0-0xD0FF */
	0xffff, /* 0xd100-0xD13F NOT PRESENT */
	0x2280, /* 0xd140-0xD17F */
	0x22c0, /* 0xd180-0xD1BF */
	0x2300, /* 0xd1c0-0xD1FF */
	0xffff, /* 0xd200-0xD23F NOT PRESENT */
	0x2340, /* 0xd240-0xD27F */
	0x2380, /* 0xd280-0xD2BF */
	0x23c0, /* 0xd2c0-0xD2FF */
	0xffff, /* 0xd300-0xD33F NOT PRESENT */
	0x2400, /* 0xd340-0xD37F */
	0x2440, /* 0xd380-0xD3BF */
	0x2480, /* 0xd3c0-0xD3FF */
	0xffff, /* 0xd400-0xD43F NOT PRESENT */
	0x24c0, /* 0xd440-0xD47F */
	0x2500, /* 0xd480-0xD4BF */
	0x2540, /* 0xd4c0-0xD4FF */
	0xffff, /* 0xd500-0xD53F NOT PRESENT */
	0x2580, /* 0xd540-0xD57F */
	0x25c0, /* 0xd580-0xD5BF */
	0x2600, /* 0xd5c0-0xD5FF */
	0xffff, /* 0xd600-0xD63F NOT PRESENT */
	0x2640, /* 0xd640-0xD67F */
	0x2680, /* 0xd680-0xD6BF */
	0x26c0, /* 0xd6c0-0xD6FF */
	0xffff, /* 0xd700-0xD73F NOT PRESENT */
	0x2700, /* 0xd740-0xD77F */
	0x2740, /* 0xd780-0xD7BF */
	0x2780, /* 0xd7c0-0xD7FF */
	0xffff, /* 0xd800-0xD83F NOT PRESENT */
	0x27c0, /* 0xd840-0xD87F */
	0x2800, /* 0xd880-0xD8BF */
	0x2840, /* 0xd8c0-0xD8FF */
	0xffff, /* 0xd900-0xD93F NOT PRESENT */
	0x2880, /* 0xd940-0xD97F */
	0x28c0, /* 0xd980-0xD9BF */
	0x2900, /* 0xd9c0-0xD9FF */
	0xffff, /* 0xda00-0xDA3F NOT PRESENT */
	0x2940, /* 0xda40-0xDA7F */
	0x2980, /* 0xda80-0xDABF */
	0x29c0, /* 0xdac0-0xDAFF */
	0xffff, /* 0xdb00-0xDB3F NOT PRESENT */
	0x2a00, /* 0xdb40-0xDB7F */
	0x2a40, /* 0xdb80-0xDBBF */
	0x2a80, /* 0xdbc0-0xDBFF */
	0xffff, /* 0xdc00-0xDC3F NOT PRESENT */
	0x2ac0, /* 0xdc40-0xDC7F */
	0x2b00, /* 0xdc80-0xDCBF */
	0x2b40, /* 0xdcc0-0xDCFF */
	0xffff, /* 0xdd00-0xDD3F NOT PRESENT */
	0x2b80, /* 0xdd40-0xDD7F */
	0x2bc0, /* 0xdd80-0xDDBF */
	0x2c00, /* 0xddc0-0xDDFF */
	0xffff, /* 0xde00-0xDE3F NOT PRESENT */
	0x2c40, /* 0xde40-0xDE7F */
	0x2c80, /* 0xde80-0xDEBF */
	0x2cc0, /* 0xdec0-0xDEFF */
	0xffff, /* 0xdf00-0xDF3F NOT PRESENT */
	0x2d00, /* 0xdf40-0xDF7F */
	0x2d40, /* 0xdf80-0xDFBF */
	0x2d80, /* 0xdfc0-0xDFFF */
	0xffff, /* 0xe000-0xE03F NOT PRESENT */
	0x2dc0, /* 0xe040-0xE07F */
	0x2e00, /* 0xe080-0xE0BF */
	0x2e40, /* 0xe0c0-0xE0FF */
	0xffff, /* 0xe100-0xE13F NOT PRESENT */
	0x2e80, /* 0xe140-0xE17F */
	0x2ec0, /* 0xe180-0xE1BF */
	0x2f00, /* 0xe1c0-0xE1FF */
	0xffff, /* 0xe200-0xE23F NOT PRESENT */
	0x2f40, /* 0xe240-0xE27F */
	0x2f80, /* 0xe280-0xE2BF */
	0x2fc0, /* 0xe2c0-0xE2FF */
	0xffff, /* 0xe300-0xE33F NOT PRESENT */
	0x3000, /* 0xe340-0xE37F */
	0x3040, /* 0xe380-0xE3BF */
	0x3080, /* 0xe3c0-0xE3FF */
	0xffff, /* 0xe400-0xE43F NOT PRESENT */
	0x30c0, /* 0xe440-0xE47F */
	0x3100, /* 0xe480-0xE4BF */
	0x3140, /* 0xe4c0-0xE4FF */
	0xffff, /* 0xe500-0xE53F NOT PRESENT */
	0x3180, /* 0xe540-0xE57F */
	0x31c0, /* 0xe580-0xE5BF */
	0x3200, /* 0xe5c0-0xE5FF */
	0xffff, /* 0xe600-0xE63F NOT PRESENT */
	0x3240, /* 0xe640-0xE67F */
	0x3280, /* 0xe680-0xE6BF */
	0x32c0, /* 0xe6c0-0xE6FF */
	0xffff, /* 0xe700-0xE73F NOT PRESENT */
	0x3300, /* 0xe740-0xE77F */
	0x3340, /* 0xe780-0xE7BF */
	0x3380, /* 0xe7c0-0xE7FF */
	0xffff, /* 0xe800-0xE83F NOT PRESENT */
	0x33c0, /* 0xe840-0xE87F */
	0x3400, /* 0xe880-0xE8BF */
	0x3440, /* 0xe8c0-0xE8FF */
	0xffff, /* 0xe900-0xE93F NOT PRESENT */
	0x3480, /* 0xe940-0xE97F */
	0x34c0, /* 0xe980-0xE9BF */
	0x3500, /* 0xe9c0-0xE9FF */
	0xffff, /* 0xea00-0xEA3F NOT PRESENT */
	0x3540, /* 0xea40-0xEA7F */
	0x3580, /* 0xea80-0xEABF */
	0x35c0, /* 0xeac0-0xEAFF */
	0xffff, /* 0xeb00-0xEB3F NOT PRESENT */
	0x3600, /* 0xeb40-0xEB7F */
	0x3640, /* 0xeb80-0xEBBF */
	0x3680, /* 0xebc0-0xEBFF */
	0xffff, /* 0xec00-0xEC3F NOT PRESENT */
	0x36c0, /* 0xec40-0xEC7F */
	0x3700, /* 0xec80-0xECBF */
	0x3740, /* 0xecc0-0xECFF */
	0xffff, /* 0xed00-0xED3F NOT PRESENT */
	0x3780, /* 0xed40-0xED7F */
	0x37c0, /* 0xed80-0xEDBF */
	0x3800, /* 0xedc0-0xEDFF */
	0xffff, /* 0xee00-0xEE3F NOT PRESENT */
	0x3840, /* 0xee40-0xEE7F */
	0x3880, /* 0xee80-0xEEBF */
	0x38c0, /* 0xeec0-0xEEFF */
	0xffff, /* 0xef00-0xEF3F NOT PRESENT */
	0x3900, /* 0xef40-0xEF7F */
	0x3940, /* 0xef80-0xEFBF */
	0x3980, /* 0xefc0-0xEFFF */
	0xffff, /* 0xf000-0xF03F NOT PRESENT */
	0x39c0, /* 0xf040-0xF07F */
	0x3a00, /* 0xf080-0xF0BF */
	0x3a40, /* 0xf0c0-0xF0FF */
	0xffff, /* 0xf100-0xF13F NOT PRESENT */
	0x3a80, /* 0xf140-0xF17F */
	0x3ac0, /* 0xf180-0xF1BF */
	0x3b00, /* 0xf1c0-0xF1FF */
	0xffff, /* 0xf200-0xF23F NOT PRESENT */
	0x3b40, /* 0xf240-0xF27F */
	0x3b80, /* 0xf280-0xF2BF */
	0x3bc0, /* 0xf2c0-0xF2FF */
	0xffff, /* 0xf300-0xF33F NOT PRESENT */
	0x3c00, /* 0xf340-0xF37F */
	0x3c40, /* 0xf380-0xF3BF */
	0x3c80, /* 0xf3c0-0xF3FF */
	0xffff, /* 0xf400-0xF43F NOT PRESENT */
	0x3cc0, /* 0xf440-0xF47F */
	0x3d00, /* 0xf480-0xF4BF */
	0x3d40, /* 0xf4c0-0xF4FF */
	0xffff, /* 0xf500-0xF53F NOT PRESENT */
	0x3d80, /* 0xf540-0xF57F */
	0x3dc0, /* 0xf580-0xF5BF */
	0x3e00, /* 0xf5c0-0xF5FF */
	0xffff, /* 0xf600-0xF63F NOT PRESENT */
	0x3e40, /* 0xf640-0xF67F */
	0x3e80, /* 0xf680-0xF6BF */
	0x3ec0, /* 0xf6c0-0xF6FF */
	0xffff, /* 0xf700-0xF73F NOT PRESENT */
	0x3f00, /* 0xf740-0xF77F */
	0x3f40, /* 0xf780-0xF7BF */
	0x3f80, /* 0xf7c0-0xF7FF */
	0xffff, /* 0xf800-0xF83F NOT PRESENT */
	0x3fc0, /* 0xf840-0xF87F */
	0x4000, /* 0xf880-0xF8BF */
	0x4040, /* 0xf8c0-0xF8FF */
	0xffff, /* 0xf900-0xF93F NOT PRESENT */
	0x4080, /* 0xf940-0xF97F */
	0x40c0, /* 0xf980-0xF9BF */
	0x4100, /* 0xf9c0-0xF9FF */
	0xffff, /* 0xfa00-0xFA3F NOT PRESENT */
	0xffff, /* 0xfa40-0xFA7F NOT PRESENT */
	0xffff, /* 0xfa80-0xFABF NOT PRESENT */
	0xffff, /* 0xfac0-0xFAFF NOT PRESENT */
	0xffff, /* 0xfb00-0xFB3F NOT PRESENT */
	0xffff, /* 0xfb40-0xFB7F NOT PRESENT */
	0xffff, /* 0xfb80-0xFBBF NOT PRESENT */
	0xffff, /* 0xfbc0-0xFBFF NOT PRESENT */
	0xffff, /* 0xfc00-0xFC3F NOT PRESENT */
	0xffff, /* 0xfc40-0xFC7F NOT PRESENT */
	0xffff, /* 0xfc80-0xFCBF NOT PRESENT */
	0xffff, /* 0xfcc0-0xFCFF NOT PRESENT */
	0xffff, /* 0xfd00-0xFD3F NOT PRESENT */
	0xffff, /* 0xfd40-0xFD7F NOT PRESENT */
	0xffff, /* 0xfd80-0xFDBF NOT PRESENT */
	0xffff, /* 0xfdc0-0xFDFF NOT PRESENT */
	0xffff, /* 0xfe00-0xFE3F NOT PRESENT */
	0xffff, /* 0xfe40-0xFE7F NOT PRESENT */
	0xffff, /* 0xfe80-0xFEBF NOT PRESENT */
	0xffff, /* 0xfec0-0xFEFF NOT PRESENT */
	0xffff, /* 0xff00-0xFF3F NOT PRESENT */
	0xffff, /* 0xff40-0xFF7F NOT PRESENT */
	0xffff, /* 0xff80-0xFFBF NOT PRESENT */
	0xffff  /* 0xffc0-0xFFFF NOT PRESENT */
};
const uint16_t cp950ext_to_unicode_hitbl[1024] = {
	0x0000, /* 0x0000-0x003F */
	0x0040, /* 0x0040-0x007F */
	0xffff, /* 0x0080-0x00BF NOT PRESENT */
	0xffff, /* 0x00c0-0x00FF NOT PRESENT */
	0xffff, /* 0x0100-0x013F NOT PRESENT */
	0xffff, /* 0x0140-0x017F NOT PRESENT */
	0xffff, /* 0x0180-0x01BF NOT PRESENT */
	0xffff, /* 0x01c0-0x01FF NOT PRESENT */
	0xffff, /* 0x0200-0x023F NOT PRESENT */
	0xffff, /* 0x0240-0x027F NOT PRESENT */
	0xffff, /* 0x0280-0x02BF NOT PRESENT */
	0xffff, /* 0x02c0-0x02FF NOT PRESENT */
	0xffff, /* 0x0300-0x033F NOT PRESENT */
	0xffff, /* 0x0340-0x037F NOT PRESENT */
	0xffff, /* 0x0380-0x03BF NOT PRESENT */
	0xffff, /* 0x03c0-0x03FF NOT PRESENT */
	0xffff, /* 0x0400-0x043F NOT PRESENT */
	0xffff, /* 0x0440-0x047F NOT PRESENT */
	0xffff, /* 0x0480-0x04BF NOT PRESENT */
	0xffff, /* 0x04c0-0x04FF NOT PRESENT */
	0xffff, /* 0x0500-0x053F NOT PRESENT */
	0xffff, /* 0x0540-0x057F NOT PRESENT */
	0xffff, /* 0x0580-0x05BF NOT PRESENT */
	0xffff, /* 0x05c0-0x05FF NOT PRESENT */
	0xffff, /* 0x0600-0x063F NOT PRESENT */
	0xffff, /* 0x0640-0x067F NOT PRESENT */
	0xffff, /* 0x0680-0x06BF NOT PRESENT */
	0xffff, /* 0x06c0-0x06FF NOT PRESENT */
	0xffff, /* 0x0700-0x073F NOT PRESENT */
	0xffff, /* 0x0740-0x077F NOT PRESENT */
	0xffff, /* 0x0780-0x07BF NOT PRESENT */
	0xffff, /* 0x07c0-0x07FF NOT PRESENT */
	0xffff, /* 0x0800-0x083F NOT PRESENT */
	0xffff, /* 0x0840-0x087F NOT PRESENT */
	0xffff, /* 0x0880-0x08BF NOT PRESENT */
	0xffff, /* 0x08c0-0x08FF NOT PRESENT */
	0xffff, /* 0x0900-0x093F NOT PRESENT */
	0xffff, /* 0x0940-0x097F NOT PRESENT */
	0xffff, /* 0x0980-0x09BF NOT PRESENT */
	0xffff, /* 0x09c0-0x09FF NOT PRESENT */
	0xffff, /* 0x0a00-0x0A3F NOT PRESENT */
	0xffff, /* 0x0a40-0x0A7F NOT PRESENT */
	0xffff, /* 0x0a80-0x0ABF NOT PRESENT */
	0xffff, /* 0x0ac0-0x0AFF NOT PRESENT */
	0xffff, /* 0x0b00-0x0B3F NOT PRESENT */
	0xffff, /* 0x0b40-0x0B7F NOT PRESENT */
	0xffff, /* 0x0b80-0x0BBF NOT PRESENT */
	0xffff, /* 0x0bc0-0x0BFF NOT PRESENT */
	0xffff, /* 0x0c00-0x0C3F NOT PRESENT */
	0xffff, /* 0x0c40-0x0C7F NOT PRESENT */
	0xffff, /* 0x0c80-0x0CBF NOT PRESENT */
	0xffff, /* 0x0cc0-0x0CFF NOT PRESENT */
	0xffff, /* 0x0d00-0x0D3F NOT PRESENT */
	0xffff, /* 0x0d40-0x0D7F NOT PRESENT */
	0xffff, /* 0x0d80-0x0DBF NOT PRESENT */
	0xffff, /* 0x0dc0-0x0DFF NOT PRESENT */
	0xffff, /* 0x0e00-0x0E3F NOT PRESENT */
	0xffff, /* 0x0e40-0x0E7F NOT PRESENT */
	0xffff, /* 0x0e80-0x0EBF NOT PRESENT */
	0xffff, /* 0x0ec0-0x0EFF NOT PRESENT */
	0xffff, /* 0x0f00-0x0F3F NOT PRESENT */
	0xffff, /* 0x0f40-0x0F7F NOT PRESENT */
	0xffff, /* 0x0f80-0x0FBF NOT PRESENT */
	0xffff, /* 0x0fc0-0x0FFF NOT PRESENT */
	0xffff, /* 0x1000-0x103F NOT PRESENT */
	0xffff, /* 0x1040-0x107F NOT PRESENT */
	0xffff, /* 0x1080-0x10BF NOT PRESENT */
	0xffff, /* 0x10c0-0x10FF NOT PRESENT */
	0xffff, /* 0x1100-0x113F NOT PRESENT */
	0xffff, /* 0x1140-0x117F NOT PRESENT */
	0xffff, /* 0x1180-0x11BF NOT PRESENT */
	0xffff, /* 0x11c0-0x11FF NOT PRESENT */
	0xffff, /* 0x1200-0x123F NOT PRESENT */
	0xffff, /* 0x1240-0x127F NOT PRESENT */
	0xffff, /* 0x1280-0x12BF NOT PRESENT */
	0xffff, /* 0x12c0-0x12FF NOT PRESENT */
	0xffff, /* 0x1300-0x133F NOT PRESENT */
	0xffff, /* 0x1340-0x137F NOT PRESENT */
	0xffff, /* 0x1380-0x13BF NOT PRESENT */
	0xffff, /* 0x13c0-0x13FF NOT PRESENT */
	0xffff, /* 0x1400-0x143F NOT PRESENT */
	0xffff, /* 0x1440-0x147F NOT PRESENT */
	0xffff, /* 0x1480-0x14BF NOT PRESENT */
	0xffff, /* 0x14c0-0x14FF NOT PRESENT */
	0xffff, /* 0x1500-0x153F NOT PRESENT */
	0xffff, /* 0x1540-0x157F NOT PRESENT */
	0xffff, /* 0x1580-0x15BF NOT PRESENT */
	0xffff, /* 0x15c0-0x15FF NOT PRESENT */
	0xffff, /* 0x1600-0x163F NOT PRESENT */
	0xffff, /* 0x1640-0x167F NOT PRESENT */
	0xffff, /* 0x1680-0x16BF NOT PRESENT */
	0xffff, /* 0x16c0-0x16FF NOT PRESENT */
	0xffff, /* 0x1700-0x173F NOT PRESENT */
	0xffff, /* 0x1740-0x177F NOT PRESENT */
	0xffff, /* 0x1780-0x17BF NOT PRESENT */
	0xffff, /* 0x17c0-0x17FF NOT PRESENT */
	0xffff, /* 0x1800-0x183F NOT PRESENT */
	0xffff, /* 0x1840-0x187F NOT PRESENT */
	0xffff, /* 0x1880-0x18BF NOT PRESENT */
	0xffff, /* 0x18c0-0x18FF NOT PRESENT */
	0xffff, /* 0x1900-0x193F NOT PRESENT */
	0xffff, /* 0x1940-0x197F NOT PRESENT */
	0xffff, /* 0x1980-0x19BF NOT PRESENT */
	0xffff, /* 0x19c0-0x19FF NOT PRESENT */
	0xffff, /* 0x1a00-0x1A3F NOT PRESENT */
	0xffff, /* 0x1a40-0x1A7F NOT PRESENT */
	0xffff, /* 0x1a80-0x1ABF NOT PRESENT */
	0xffff, /* 0x1ac0-0x1AFF NOT PRESENT */
	0xffff, /* 0x1b00-0x1B3F NOT PRESENT */
	0xffff, /* 0x1b40-0x1B7F NOT PRESENT */
	0xffff, /* 0x1b80-0x1BBF NOT PRESENT */
	0xffff, /* 0x1bc0-0x1BFF NOT PRESENT */
	0xffff, /* 0x1c00-0x1C3F NOT PRESENT */
	0xffff, /* 0x1c40-0x1C7F NOT PRESENT */
	0xffff, /* 0x1c80-0x1CBF NOT PRESENT */
	0xffff, /* 0x1cc0-0x1CFF NOT PRESENT */
	0xffff, /* 0x1d00-0x1D3F NOT PRESENT */
	0xffff, /* 0x1d40-0x1D7F NOT PRESENT */
	0xffff, /* 0x1d80-0x1DBF NOT PRESENT */
	0xffff, /* 0x1dc0-0x1DFF NOT PRESENT */
	0xffff, /* 0x1e00-0x1E3F NOT PRESENT */
	0xffff, /* 0x1e40-0x1E7F NOT PRESENT */
	0xffff, /* 0x1e80-0x1EBF NOT PRESENT */
	0xffff, /* 0x1ec0-0x1EFF NOT PRESENT */
	0xffff, /* 0x1f00-0x1F3F NOT PRESENT */
	0xffff, /* 0x1f40-0x1F7F NOT PRESENT */
	0xffff, /* 0x1f80-0x1FBF NOT PRESENT */
	0xffff, /* 0x1fc0-0x1FFF NOT PRESENT */
	0xffff, /* 0x2000-0x203F NOT PRESENT */
	0xffff, /* 0x2040-0x207F NOT PRESENT */
	0xffff, /* 0x2080-0x20BF NOT PRESENT */
	0xffff, /* 0x20c0-0x20FF NOT PRESENT */
	0xffff, /* 0x2100-0x213F NOT PRESENT */
	0xffff, /* 0x2140-0x217F NOT PRESENT */
	0xffff, /* 0x2180-0x21BF NOT PRESENT */
	0xffff, /* 0x21c0-0x21FF NOT PRESENT */
	0xffff, /* 0x2200-0x223F NOT PRESENT */
	0xffff, /* 0x2240-0x227F NOT PRESENT */
	0xffff, /* 0x2280-0x22BF NOT PRESENT */
	0xffff, /* 0x22c0-0x22FF NOT PRESENT */
	0xffff, /* 0x2300-0x233F NOT PRESENT */
	0xffff, /* 0x2340-0x237F NOT PRESENT */
	0xffff, /* 0x2380-0x23BF NOT PRESENT */
	0xffff, /* 0x23c0-0x23FF NOT PRESENT */
	0xffff, /* 0x2400-0x243F NOT PRESENT */
	0xffff, /* 0x2440-0x247F NOT PRESENT */
	0xffff, /* 0x2480-0x24BF NOT PRESENT */
	0xffff, /* 0x24c0-0x24FF NOT PRESENT */
	0xffff, /* 0x2500-0x253F NOT PRESENT */
	0xffff, /* 0x2540-0x257F NOT PRESENT */
	0xffff, /* 0x2580-0x25BF NOT PRESENT */
	0xffff, /* 0x25c0-0x25FF NOT PRESENT */
	0xffff, /* 0x2600-0x263F NOT PRESENT */
	0xffff, /* 0x2640-0x267F NOT PRESENT */
	0xffff, /* 0x2680-0x26BF NOT PRESENT */
	0xffff, /* 0x26c0-0x26FF NOT PRESENT */
	0xffff, /* 0x2700-0x273F NOT PRESENT */
	0xffff, /* 0x2740-0x277F NOT PRESENT */
	0xffff, /* 0x2780-0x27BF NOT PRESENT */
	0xffff, /* 0x27c0-0x27FF NOT PRESENT */
	0xffff, /* 0x2800-0x283F NOT PRESENT */
	0xffff, /* 0x2840-0x287F NOT PRESENT */
	0xffff, /* 0x2880-0x28BF NOT PRESENT */
	0xffff, /* 0x28c0-0x28FF NOT PRESENT */
	0xffff, /* 0x2900-0x293F NOT PRESENT */
	0xffff, /* 0x2940-0x297F NOT PRESENT */
	0xffff, /* 0x2980-0x29BF NOT PRESENT */
	0xffff, /* 0x29c0-0x29FF NOT PRESENT */
	0xffff, /* 0x2a00-0x2A3F NOT PRESENT */
	0xffff, /* 0x2a40-0x2A7F NOT PRESENT */
	0xffff, /* 0x2a80-0x2ABF NOT PRESENT */
	0xffff, /* 0x2ac0-0x2AFF NOT PRESENT */
	0xffff, /* 0x2b00-0x2B3F NOT PRESENT */
	0xffff, /* 0x2b40-0x2B7F NOT PRESENT */
	0xffff, /* 0x2b80-0x2BBF NOT PRESENT */
	0xffff, /* 0x2bc0-0x2BFF NOT PRESENT */
	0xffff, /* 0x2c00-0x2C3F NOT PRESENT */
	0xffff, /* 0x2c40-0x2C7F NOT PRESENT */
	0xffff, /* 0x2c80-0x2CBF NOT PRESENT */
	0xffff, /* 0x2cc0-0x2CFF NOT PRESENT */
	0xffff, /* 0x2d00-0x2D3F NOT PRESENT */
	0xffff, /* 0x2d40-0x2D7F NOT PRESENT */
	0xffff, /* 0x2d80-0x2DBF NOT PRESENT */
	0xffff, /* 0x2dc0-0x2DFF NOT PRESENT */
	0xffff, /* 0x2e00-0x2E3F NOT PRESENT */
	0xffff, /* 0x2e40-0x2E7F NOT PRESENT */
	0xffff, /* 0x2e80-0x2EBF NOT PRESENT */
	0xffff, /* 0x2ec0-0x2EFF NOT PRESENT */
	0xffff, /* 0x2f00-0x2F3F NOT PRESENT */
	0xffff, /* 0x2f40-0x2F7F NOT PRESENT */
	0xffff, /* 0x2f80-0x2FBF NOT PRESENT */
	0xffff, /* 0x2fc0-0x2FFF NOT PRESENT */
	0xffff, /* 0x3000-0x303F NOT PRESENT */
	0xffff, /* 0x3040-0x307F NOT PRESENT */
	0xffff, /* 0x3080-0x30BF NOT PRESENT */
	0xffff, /* 0x30c0-0x30FF NOT PRESENT */
	0xffff, /* 0x3100-0x313F NOT PRESENT */
	0xffff, /* 0x3140-0x317F NOT PRESENT */
	0xffff, /* 0x3180-0x31BF NOT PRESENT */
	0xffff, /* 0x31c0-0x31FF NOT PRESENT */
	0xffff, /* 0x3200-0x323F NOT PRESENT */
	0xffff, /* 0x3240-0x327F NOT PRESENT */
	0xffff, /* 0x3280-0x32BF NOT PRESENT */
	0xffff, /* 0x32c0-0x32FF NOT PRESENT */
	0xffff, /* 0x3300-0x333F NOT PRESENT */
	0xffff, /* 0x3340-0x337F NOT PRESENT */
	0xffff, /* 0x3380-0x33BF NOT PRESENT */
	0xffff, /* 0x33c0-0x33FF NOT PRESENT */
	0xffff, /* 0x3400-0x343F NOT PRESENT */
	0xffff, /* 0x3440-0x347F NOT PRESENT */
	0xffff, /* 0x3480-0x34BF NOT PRESENT */
	0xffff, /* 0x34c0-0x34FF NOT PRESENT */
	0xffff, /* 0x3500-0x353F NOT PRESENT */
	0xffff, /* 0x3540-0x357F NOT PRESENT */
	0xffff, /* 0x3580-0x35BF NOT PRESENT */
	0xffff, /* 0x35c0-0x35FF NOT PRESENT */
	0xffff, /* 0x3600-0x363F NOT PRESENT */
	0xffff, /* 0x3640-0x367F NOT PRESENT */
	0xffff, /* 0x3680-0x36BF NOT PRESENT */
	0xffff, /* 0x36c0-0x36FF NOT PRESENT */
	0xffff, /* 0x3700-0x373F NOT PRESENT */
	0xffff, /* 0x3740-0x377F NOT PRESENT */
	0xffff, /* 0x3780-0x37BF NOT PRESENT */
	0xffff, /* 0x37c0-0x37FF NOT PRESENT */
	0xffff, /* 0x3800-0x383F NOT PRESENT */
	0xffff, /* 0x3840-0x387F NOT PRESENT */
	0xffff, /* 0x3880-0x38BF NOT PRESENT */
	0xffff, /* 0x38c0-0x38FF NOT PRESENT */
	0xffff, /* 0x3900-0x393F NOT PRESENT */
	0xffff, /* 0x3940-0x397F NOT PRESENT */
	0xffff, /* 0x3980-0x39BF NOT PRESENT */
	0xffff, /* 0x39c0-0x39FF NOT PRESENT */
	0xffff, /* 0x3a00-0x3A3F NOT PRESENT */
	0xffff, /* 0x3a40-0x3A7F NOT PRESENT */
	0xffff, /* 0x3a80-0x3ABF NOT PRESENT */
	0xffff, /* 0x3ac0-0x3AFF NOT PRESENT */
	0xffff, /* 0x3b00-0x3B3F NOT PRESENT */
	0xffff, /* 0x3b40-0x3B7F NOT PRESENT */
	0xffff, /* 0x3b80-0x3BBF NOT PRESENT */
	0xffff, /* 0x3bc0-0x3BFF NOT PRESENT */
	0xffff, /* 0x3c00-0x3C3F NOT PRESENT */
	0xffff, /* 0x3c40-0x3C7F NOT PRESENT */
	0xffff, /* 0x3c80-0x3CBF NOT PRESENT */
	0xffff, /* 0x3cc0-0x3CFF NOT PRESENT */
	0xffff, /* 0x3d00-0x3D3F NOT PRESENT */
	0xffff, /* 0x3d40-0x3D7F NOT PRESENT */
	0xffff, /* 0x3d80-0x3DBF NOT PRESENT */
	0xffff, /* 0x3dc0-0x3DFF NOT PRESENT */
	0xffff, /* 0x3e00-0x3E3F NOT PRESENT */
	0xffff, /* 0x3e40-0x3E7F NOT PRESENT */
	0xffff, /* 0x3e80-0x3EBF NOT PRESENT */
	0xffff, /* 0x3ec0-0x3EFF NOT PRESENT */
	0xffff, /* 0x3f00-0x3F3F NOT PRESENT */
	0xffff, /* 0x3f40-0x3F7F NOT PRESENT */
	0xffff, /* 0x3f80-0x3FBF NOT PRESENT */
	0xffff, /* 0x3fc0-0x3FFF NOT PRESENT */
	0xffff, /* 0x4000-0x403F NOT PRESENT */
	0xffff, /* 0x4040-0x407F NOT PRESENT */
	0xffff, /* 0x4080-0x40BF NOT PRESENT */
	0xffff, /* 0x40c0-0x40FF NOT PRESENT */
	0xffff, /* 0x4100-0x413F NOT PRESENT */
	0xffff, /* 0x4140-0x417F NOT PRESENT */
	0xffff, /* 0x4180-0x41BF NOT PRESENT */
	0xffff, /* 0x41c0-0x41FF NOT PRESENT */
	0xffff, /* 0x4200-0x423F NOT PRESENT */
	0xffff, /* 0x4240-0x427F NOT PRESENT */
	0xffff, /* 0x4280-0x42BF NOT PRESENT */
	0xffff, /* 0x42c0-0x42FF NOT PRESENT */
	0xffff, /* 0x4300-0x433F NOT PRESENT */
	0xffff, /* 0x4340-0x437F NOT PRESENT */
	0xffff, /* 0x4380-0x43BF NOT PRESENT */
	0xffff, /* 0x43c0-0x43FF NOT PRESENT */
	0xffff, /* 0x4400-0x443F NOT PRESENT */
	0xffff, /* 0x4440-0x447F NOT PRESENT */
	0xffff, /* 0x4480-0x44BF NOT PRESENT */
	0xffff, /* 0x44c0-0x44FF NOT PRESENT */
	0xffff, /* 0x4500-0x453F NOT PRESENT */
	0xffff, /* 0x4540-0x457F NOT PRESENT */
	0xffff, /* 0x4580-0x45BF NOT PRESENT */
	0xffff, /* 0x45c0-0x45FF NOT PRESENT */
	0xffff, /* 0x4600-0x463F NOT PRESENT */
	0xffff, /* 0x4640-0x467F NOT PRESENT */
	0xffff, /* 0x4680-0x46BF NOT PRESENT */
	0xffff, /* 0x46c0-0x46FF NOT PRESENT */
	0xffff, /* 0x4700-0x473F NOT PRESENT */
	0xffff, /* 0x4740-0x477F NOT PRESENT */
	0xffff, /* 0x4780-0x47BF NOT PRESENT */
	0xffff, /* 0x47c0-0x47FF NOT PRESENT */
	0xffff, /* 0x4800-0x483F NOT PRESENT */
	0xffff, /* 0x4840-0x487F NOT PRESENT */
	0xffff, /* 0x4880-0x48BF NOT PRESENT */
	0xffff, /* 0x48c0-0x48FF NOT PRESENT */
	0xffff, /* 0x4900-0x493F NOT PRESENT */
	0xffff, /* 0x4940-0x497F NOT PRESENT */
	0xffff, /* 0x4980-0x49BF NOT PRESENT */
	0xffff, /* 0x49c0-0x49FF NOT PRESENT */
	0xffff, /* 0x4a00-0x4A3F NOT PRESENT */
	0xffff, /* 0x4a40-0x4A7F NOT PRESENT */
	0xffff, /* 0x4a80-0x4ABF NOT PRESENT */
	0xffff, /* 0x4ac0-0x4AFF NOT PRESENT */
	0xffff, /* 0x4b00-0x4B3F NOT PRESENT */
	0xffff, /* 0x4b40-0x4B7F NOT PRESENT */
	0xffff, /* 0x4b80-0x4BBF NOT PRESENT */
	0xffff, /* 0x4bc0-0x4BFF NOT PRESENT */
	0xffff, /* 0x4c00-0x4C3F NOT PRESENT */
	0xffff, /* 0x4c40-0x4C7F NOT PRESENT */
	0xffff, /* 0x4c80-0x4CBF NOT PRESENT */
	0xffff, /* 0x4cc0-0x4CFF NOT PRESENT */
	0xffff, /* 0x4d00-0x4D3F NOT PRESENT */
	0xffff, /* 0x4d40-0x4D7F NOT PRESENT */
	0xffff, /* 0x4d80-0x4DBF NOT PRESENT */
	0xffff, /* 0x4dc0-0x4DFF NOT PRESENT */
	0xffff, /* 0x4e00-0x4E3F NOT PRESENT */
	0xffff, /* 0x4e40-0x4E7F NOT PRESENT */
	0xffff, /* 0x4e80-0x4EBF NOT PRESENT */
	0xffff, /* 0x4ec0-0x4EFF NOT PRESENT */
	0xffff, /* 0x4f00-0x4F3F NOT PRESENT */
	0xffff, /* 0x4f40-0x4F7F NOT PRESENT */
	0xffff, /* 0x4f80-0x4FBF NOT PRESENT */
	0xffff, /* 0x4fc0-0x4FFF NOT PRESENT */
	0xffff, /* 0x5000-0x503F NOT PRESENT */
	0xffff, /* 0x5040-0x507F NOT PRESENT */
	0xffff, /* 0x5080-0x50BF NOT PRESENT */
	0xffff, /* 0x50c0-0x50FF NOT PRESENT */
	0xffff, /* 0x5100-0x513F NOT PRESENT */
	0xffff, /* 0x5140-0x517F NOT PRESENT */
	0xffff, /* 0x5180-0x51BF NOT PRESENT */
	0xffff, /* 0x51c0-0x51FF NOT PRESENT */
	0xffff, /* 0x5200-0x523F NOT PRESENT */
	0xffff, /* 0x5240-0x527F NOT PRESENT */
	0xffff, /* 0x5280-0x52BF NOT PRESENT */
	0xffff, /* 0x52c0-0x52FF NOT PRESENT */
	0xffff, /* 0x5300-0x533F NOT PRESENT */
	0xffff, /* 0x5340-0x537F NOT PRESENT */
	0xffff, /* 0x5380-0x53BF NOT PRESENT */
	0xffff, /* 0x53c0-0x53FF NOT PRESENT */
	0xffff, /* 0x5400-0x543F NOT PRESENT */
	0xffff, /* 0x5440-0x547F NOT PRESENT */
	0xffff, /* 0x5480-0x54BF NOT PRESENT */
	0xffff, /* 0x54c0-0x54FF NOT PRESENT */
	0xffff, /* 0x5500-0x553F NOT PRESENT */
	0xffff, /* 0x5540-0x557F NOT PRESENT */
	0xffff, /* 0x5580-0x55BF NOT PRESENT */
	0xffff, /* 0x55c0-0x55FF NOT PRESENT */
	0xffff, /* 0x5600-0x563F NOT PRESENT */
	0xffff, /* 0x5640-0x567F NOT PRESENT */
	0xffff, /* 0x5680-0x56BF NOT PRESENT */
	0xffff, /* 0x56c0-0x56FF NOT PRESENT */
	0xffff, /* 0x5700-0x573F NOT PRESENT */
	0xffff, /* 0x5740-0x577F NOT PRESENT */
	0xffff, /* 0x5780-0x57BF NOT PRESENT */
	0xffff, /* 0x57c0-0x57FF NOT PRESENT */
	0xffff, /* 0x5800-0x583F NOT PRESENT */
	0xffff, /* 0x5840-0x587F NOT PRESENT */
	0xffff, /* 0x5880-0x58BF NOT PRESENT */
	0xffff, /* 0x58c0-0x58FF NOT PRESENT */
	0xffff, /* 0x5900-0x593F NOT PRESENT */
	0xffff, /* 0x5940-0x597F NOT PRESENT */
	0xffff, /* 0x5980-0x59BF NOT PRESENT */
	0xffff, /* 0x59c0-0x59FF NOT PRESENT */
	0xffff, /* 0x5a00-0x5A3F NOT PRESENT */
	0xffff, /* 0x5a40-0x5A7F NOT PRESENT */
	0xffff, /* 0x5a80-0x5ABF NOT PRESENT */
	0xffff, /* 0x5ac0-0x5AFF NOT PRESENT */
	0xffff, /* 0x5b00-0x5B3F NOT PRESENT */
	0xffff, /* 0x5b40-0x5B7F NOT PRESENT */
	0xffff, /* 0x5b80-0x5BBF NOT PRESENT */
	0xffff, /* 0x5bc0-0x5BFF NOT PRESENT */
	0xffff, /* 0x5c00-0x5C3F NOT PRESENT */
	0xffff, /* 0x5c40-0x5C7F NOT PRESENT */
	0xffff, /* 0x5c80-0x5CBF NOT PRESENT */
	0xffff, /* 0x5cc0-0x5CFF NOT PRESENT */
	0xffff, /* 0x5d00-0x5D3F NOT PRESENT */
	0xffff, /* 0x5d40-0x5D7F NOT PRESENT */
	0xffff, /* 0x5d80-0x5DBF NOT PRESENT */
	0xffff, /* 0x5dc0-0x5DFF NOT PRESENT */
	0xffff, /* 0x5e00-0x5E3F NOT PRESENT */
	0xffff, /* 0x5e40-0x5E7F NOT PRESENT */
	0xffff, /* 0x5e80-0x5EBF NOT PRESENT */
	0xffff, /* 0x5ec0-0x5EFF NOT PRESENT */
	0xffff, /* 0x5f00-0x5F3F NOT PRESENT */
	0xffff, /* 0x5f40-0x5F7F NOT PRESENT */
	0xffff, /* 0x5f80-0x5FBF NOT PRESENT */
	0xffff, /* 0x5fc0-0x5FFF NOT PRESENT */
	0xffff, /* 0x6000-0x603F NOT PRESENT */
	0xffff, /* 0x6040-0x607F NOT PRESENT */
	0xffff, /* 0x6080-0x60BF NOT PRESENT */
	0xffff, /* 0x60c0-0x60FF NOT PRESENT */
	0xffff, /* 0x6100-0x613F NOT PRESENT */
	0xffff, /* 0x6140-0x617F NOT PRESENT */
	0xffff, /* 0x6180-0x61BF NOT PRESENT */
	0xffff, /* 0x61c0-0x61FF NOT PRESENT */
	0xffff, /* 0x6200-0x623F NOT PRESENT */
	0xffff, /* 0x6240-0x627F NOT PRESENT */
	0xffff, /* 0x6280-0x62BF NOT PRESENT */
	0xffff, /* 0x62c0-0x62FF NOT PRESENT */
	0xffff, /* 0x6300-0x633F NOT PRESENT */
	0xffff, /* 0x6340-0x637F NOT PRESENT */
	0xffff, /* 0x6380-0x63BF NOT PRESENT */
	0xffff, /* 0x63c0-0x63FF NOT PRESENT */
	0xffff, /* 0x6400-0x643F NOT PRESENT */
	0xffff, /* 0x6440-0x647F NOT PRESENT */
	0xffff, /* 0x6480-0x64BF NOT PRESENT */
	0xffff, /* 0x64c0-0x64FF NOT PRESENT */
	0xffff, /* 0x6500-0x653F NOT PRESENT */
	0xffff, /* 0x6540-0x657F NOT PRESENT */
	0xffff, /* 0x6580-0x65BF NOT PRESENT */
	0xffff, /* 0x65c0-0x65FF NOT PRESENT */
	0xffff, /* 0x6600-0x663F NOT PRESENT */
	0xffff, /* 0x6640-0x667F NOT PRESENT */
	0xffff, /* 0x6680-0x66BF NOT PRESENT */
	0xffff, /* 0x66c0-0x66FF NOT PRESENT */
	0xffff, /* 0x6700-0x673F NOT PRESENT */
	0xffff, /* 0x6740-0x677F NOT PRESENT */
	0xffff, /* 0x6780-0x67BF NOT PRESENT */
	0xffff, /* 0x67c0-0x67FF NOT PRESENT */
	0xffff, /* 0x6800-0x683F NOT PRESENT */
	0xffff, /* 0x6840-0x687F NOT PRESENT */
	0xffff, /* 0x6880-0x68BF NOT PRESENT */
	0xffff, /* 0x68c0-0x68FF NOT PRESENT */
	0xffff, /* 0x6900-0x693F NOT PRESENT */
	0xffff, /* 0x6940-0x697F NOT PRESENT */
	0xffff, /* 0x6980-0x69BF NOT PRESENT */
	0xffff, /* 0x69c0-0x69FF NOT PRESENT */
	0xffff, /* 0x6a00-0x6A3F NOT PRESENT */
	0xffff, /* 0x6a40-0x6A7F NOT PRESENT */
	0xffff, /* 0x6a80-0x6ABF NOT PRESENT */
	0xffff, /* 0x6ac0-0x6AFF NOT PRESENT */
	0xffff, /* 0x6b00-0x6B3F NOT PRESENT */
	0xffff, /* 0x6b40-0x6B7F NOT PRESENT */
	0xffff, /* 0x6b80-0x6BBF NOT PRESENT */
	0xffff, /* 0x6bc0-0x6BFF NOT PRESENT */
	0xffff, /* 0x6c00-0x6C3F NOT PRESENT */
	0xffff, /* 0x6c40-0x6C7F NOT PRESENT */
	0xffff, /* 0x6c80-0x6CBF NOT PRESENT */
	0xffff, /* 0x6cc0-0x6CFF NOT PRESENT */
	0xffff, /* 0x6d00-0x6D3F NOT PRESENT */
	0xffff, /* 0x6d40-0x6D7F NOT PRESENT */
	0xffff, /* 0x6d80-0x6DBF NOT PRESENT */
	0xffff, /* 0x6dc0-0x6DFF NOT PRESENT */
	0xffff, /* 0x6e00-0x6E3F NOT PRESENT */
	0xffff, /* 0x6e40-0x6E7F NOT PRESENT */
	0xffff, /* 0x6e80-0x6EBF NOT PRESENT */
	0xffff, /* 0x6ec0-0x6EFF NOT PRESENT */
	0xffff, /* 0x6f00-0x6F3F NOT PRESENT */
	0xffff, /* 0x6f40-0x6F7F NOT PRESENT */
	0xffff, /* 0x6f80-0x6FBF NOT PRESENT */
	0xffff, /* 0x6fc0-0x6FFF NOT PRESENT */
	0xffff, /* 0x7000-0x703F NOT PRESENT */
	0xffff, /* 0x7040-0x707F NOT PRESENT */
	0xffff, /* 0x7080-0x70BF NOT PRESENT */
	0xffff, /* 0x70c0-0x70FF NOT PRESENT */
	0xffff, /* 0x7100-0x713F NOT PRESENT */
	0xffff, /* 0x7140-0x717F NOT PRESENT */
	0xffff, /* 0x7180-0x71BF NOT PRESENT */
	0xffff, /* 0x71c0-0x71FF NOT PRESENT */
	0xffff, /* 0x7200-0x723F NOT PRESENT */
	0xffff, /* 0x7240-0x727F NOT PRESENT */
	0xffff, /* 0x7280-0x72BF NOT PRESENT */
	0xffff, /* 0x72c0-0x72FF NOT PRESENT */
	0xffff, /* 0x7300-0x733F NOT PRESENT */
	0xffff, /* 0x7340-0x737F NOT PRESENT */
	0xffff, /* 0x7380-0x73BF NOT PRESENT */
	0xffff, /* 0x73c0-0x73FF NOT PRESENT */
	0xffff, /* 0x7400-0x743F NOT PRESENT */
	0xffff, /* 0x7440-0x747F NOT PRESENT */
	0xffff, /* 0x7480-0x74BF NOT PRESENT */
	0xffff, /* 0x74c0-0x74FF NOT PRESENT */
	0xffff, /* 0x7500-0x753F NOT PRESENT */
	0xffff, /* 0x7540-0x757F NOT PRESENT */
	0xffff, /* 0x7580-0x75BF NOT PRESENT */
	0xffff, /* 0x75c0-0x75FF NOT PRESENT */
	0xffff, /* 0x7600-0x763F NOT PRESENT */
	0xffff, /* 0x7640-0x767F NOT PRESENT */
	0xffff, /* 0x7680-0x76BF NOT PRESENT */
	0xffff, /* 0x76c0-0x76FF NOT PRESENT */
	0xffff, /* 0x7700-0x773F NOT PRESENT */
	0xffff, /* 0x7740-0x777F NOT PRESENT */
	0xffff, /* 0x7780-0x77BF NOT PRESENT */
	0xffff, /* 0x77c0-0x77FF NOT PRESENT */
	0xffff, /* 0x7800-0x783F NOT PRESENT */
	0xffff, /* 0x7840-0x787F NOT PRESENT */
	0xffff, /* 0x7880-0x78BF NOT PRESENT */
	0xffff, /* 0x78c0-0x78FF NOT PRESENT */
	0xffff, /* 0x7900-0x793F NOT PRESENT */
	0xffff, /* 0x7940-0x797F NOT PRESENT */
	0xffff, /* 0x7980-0x79BF NOT PRESENT */
	0xffff, /* 0x79c0-0x79FF NOT PRESENT */
	0xffff, /* 0x7a00-0x7A3F NOT PRESENT */
	0xffff, /* 0x7a40-0x7A7F NOT PRESENT */
	0xffff, /* 0x7a80-0x7ABF NOT PRESENT */
	0xffff, /* 0x7ac0-0x7AFF NOT PRESENT */
	0xffff, /* 0x7b00-0x7B3F NOT PRESENT */
	0xffff, /* 0x7b40-0x7B7F NOT PRESENT */
	0xffff, /* 0x7b80-0x7BBF NOT PRESENT */
	0xffff, /* 0x7bc0-0x7BFF NOT PRESENT */
	0xffff, /* 0x7c00-0x7C3F NOT PRESENT */
	0xffff, /* 0x7c40-0x7C7F NOT PRESENT */
	0xffff, /* 0x7c80-0x7CBF NOT PRESENT */
	0xffff, /* 0x7cc0-0x7CFF NOT PRESENT */
	0xffff, /* 0x7d00-0x7D3F NOT PRESENT */
	0xffff, /* 0x7d40-0x7D7F NOT PRESENT */
	0xffff, /* 0x7d80-0x7DBF NOT PRESENT */
	0xffff, /* 0x7dc0-0x7DFF NOT PRESENT */
	0xffff, /* 0x7e00-0x7E3F NOT PRESENT */
	0xffff, /* 0x7e40-0x7E7F NOT PRESENT */
	0xffff, /* 0x7e80-0x7EBF NOT PRESENT */
	0xffff, /* 0x7ec0-0x7EFF NOT PRESENT */
	0xffff, /* 0x7f00-0x7F3F NOT PRESENT */
	0xffff, /* 0x7f40-0x7F7F NOT PRESENT */
	0xffff, /* 0x7f80-0x7FBF NOT PRESENT */
	0xffff, /* 0x7fc0-0x7FFF NOT PRESENT */
	0xffff, /* 0x8000-0x803F NOT PRESENT */
	0xffff, /* 0x8040-0x807F NOT PRESENT */
	0xffff, /* 0x8080-0x80BF NOT PRESENT */
	0xffff, /* 0x80c0-0x80FF NOT PRESENT */
	0xffff, /* 0x8100-0x813F NOT PRESENT */
	0x0080, /* 0x8140-0x817F */
	0x00c0, /* 0x8180-0x81BF */
	0x0100, /* 0x81c0-0x81FF */
	0xffff, /* 0x8200-0x823F NOT PRESENT */
	0x0140, /* 0x8240-0x827F */
	0x0180, /* 0x8280-0x82BF */
	0x01c0, /* 0x82c0-0x82FF */
	0xffff, /* 0x8300-0x833F NOT PRESENT */
	0x0200, /* 0x8340-0x837F */
	0x0240, /* 0x8380-0x83BF */
	0x0280, /* 0x83c0-0x83FF */
	0xffff, /* 0x8400-0x843F NOT PRESENT */
	0x02c0, /* 0x8440-0x847F */
	0x0300, /* 0x8480-0x84BF */
	0x0340, /* 0x84c0-0x84FF */
	0xffff, /* 0x8500-0x853F NOT PRESENT */
	0x0380, /* 0x8540-0x857F */
	0x03c0, /* 0x8580-0x85BF */
	0x0400, /* 0x85c0-0x85FF */
	0xffff, /* 0x8600-0x863F NOT PRESENT */
	0x0440, /* 0x8640-0x867F */
	0x0480, /* 0x8680-0x86BF */
	0x04c0, /* 0x86c0-0x86FF */
	0xffff, /* 0x8700-0x873F NOT PRESENT */
	0x0500, /* 0x8740-0x877F */
	0x0540, /* 0x8780-0x87BF */
	0x0580, /* 0x87c0-0x87FF */
	0xffff, /* 0x8800-0x883F NOT PRESENT */
	0x05c0, /* 0x8840-0x887F */
	0x0600, /* 0x8880-0x88BF */
	0x0640, /* 0x88c0-0x88FF */
	0xffff, /* 0x8900-0x893F NOT PRESENT */
	0x0680, /* 0x8940-0x897F */
	0x06c0, /* 0x8980-0x89BF */
	0x0700, /* 0x89c0-0x89FF */
	0xffff, /* 0x8a00-0x8A3F NOT PRESENT */
	0x0740, /* 0x8a40-0x8A7F */
	0x0780, /* 0x8a80-0x8ABF */
	0x07c0, /* 0x8ac0-0x8AFF */
	0xffff, /* 0x8b00-0x8B3F NOT PRESENT */
	0x0800, /* 0x8b40-0x8B7F */
	0x0840, /* 0x8b80-0x8BBF */
	0x0880, /* 0x8bc0-0x8BFF */
	0xffff, /* 0x8c00-0x8C3F NOT PRESENT */
	0x08c0, /* 0x8c40-0x8C7F */
	0x0900, /* 0x8c80-0x8CBF */
	0x0940, /* 0x8cc0-0x8CFF */
	0xffff, /* 0x8d00-0x8D3F NOT PRESENT */
	0x0980, /* 0x8d40-0x8D7F */
	0x09c0, /* 0x8d80-0x8DBF */
	0x0a00, /* 0x8dc0-0x8DFF */
	0xffff, /* 0x8e00-0x8E3F NOT PRESENT */
	0x0a40, /* 0x8e40-0x8E7F */
	0x0a80, /* 0x8e80-0x8EBF */
	0x0ac0, /* 0x8ec0-0x8EFF */
	0xffff, /* 0x8f00-0x8F3F NOT PRESENT */
	0x0b00, /* 0x8f40-0x8F7F */
	0x0b40, /* 0x8f80-0x8FBF */
	0x0b80, /* 0x8fc0-0x8FFF */
	0xffff, /* 0x9000-0x903F NOT PRESENT */
	0x0bc0, /* 0x9040-0x907F */
	0x0c00, /* 0x9080-0x90BF */
	0x0c40, /* 0x90c0-0x90FF */
	0xffff, /* 0x9100-0x913F NOT PRESENT */
	0x0c80, /* 0x9140-0x917F */
	0x0cc0, /* 0x9180-0x91BF */
	0x0d00, /* 0x91c0-0x91FF */
	0xffff, /* 0x9200-0x923F NOT PRESENT */
	0x0d40, /* 0x9240-0x927F */
	0x0d80, /* 0x9280-0x92BF */
	0x0dc0, /* 0x92c0-0x92FF */
	0xffff, /* 0x9300-0x933F NOT PRESENT */
	0x0e00, /* 0x9340-0x937F */
	0x0e40, /* 0x9380-0x93BF */
	0x0e80, /* 0x93c0-0x93FF */
	0xffff, /* 0x9400-0x943F NOT PRESENT */
	0x0ec0, /* 0x9440-0x947F */
	0x0f00, /* 0x9480-0x94BF */
	0x0f40, /* 0x94c0-0x94FF */
	0xffff, /* 0x9500-0x953F NOT PRESENT */
	0x0f80, /* 0x9540-0x957F */
	0x0fc0, /* 0x9580-0x95BF */
	0x1000, /* 0x95c0-0x95FF */
	0xffff, /* 0x9600-0x963F NOT PRESENT */
	0x1040, /* 0x9640-0x967F */
	0x1080, /* 0x9680-0x96BF */
	0x10c0, /* 0x96c0-0x96FF */
	0xffff, /* 0x9700-0x973F NOT PRESENT */
	0x1100, /* 0x9740-0x977F */
	0x1140, /* 0x9780-0x97BF */
	0x1180, /* 0x97c0-0x97FF */
	0xffff, /* 0x9800-0x983F NOT PRESENT */
	0x11c0, /* 0x9840-0x987F */
	0x1200, /* 0x9880-0x98BF */
	0x1240, /* 0x98c0-0x98FF */
	0xffff, /* 0x9900-0x993F NOT PRESENT */
	0x1280, /* 0x9940-0x997F */
	0x12c0, /* 0x9980-0x99BF */
	0x1300, /* 0x99c0-0x99FF */
	0xffff, /* 0x9a00-0x9A3F NOT PRESENT */
	0x1340, /* 0x9a40-0x9A7F */
	0x1380, /* 0x9a80-0x9ABF */
	0x13c0, /* 0x9ac0-0x9AFF */
	0xffff, /* 0x9b00-0x9B3F NOT PRESENT */
	0x1400, /* 0x9b40-0x9B7F */
	0x1440, /* 0x9b80-0x9BBF */
	0x1480, /* 0x9bc0-0x9BFF */
	0xffff, /* 0x9c00-0x9C3F NOT PRESENT */
	0x14c0, /* 0x9c40-0x9C7F */
	0x1500, /* 0x9c80-0x9CBF */
	0x1540, /* 0x9cc0-0x9CFF */
	0xffff, /* 0x9d00-0x9D3F NOT PRESENT */
	0x1580, /* 0x9d40-0x9D7F */
	0x15c0, /* 0x9d80-0x9DBF */
	0x1600, /* 0x9dc0-0x9DFF */
	0xffff, /* 0x9e00-0x9E3F NOT PRESENT */
	0x1640, /* 0x9e40-0x9E7F */
	0x1680, /* 0x9e80-0x9EBF */
	0x16c0, /* 0x9ec0-0x9EFF */
	0xffff, /* 0x9f00-0x9F3F NOT PRESENT */
	0x1700, /* 0x9f40-0x9F7F */
	0x1740, /* 0x9f80-0x9FBF */
	0x1780, /* 0x9fc0-0x9FFF */
	0xffff, /* 0xa000-0xA03F NOT PRESENT */
	0x17c0, /* 0xa040-0xA07F */
	0x1800, /* 0xa080-0xA0BF */
	0x1840, /* 0xa0c0-0xA0FF */
	0xffff, /* 0xa100-0xA13F NOT PRESENT */
	0x1880, /* 0xa140-0xA17F */
	0x18c0, /* 0xa180-0xA1BF */
	0x1900, /* 0xa1c0-0xA1FF */
	0xffff, /* 0xa200-0xA23F NOT PRESENT */
	0x1940, /* 0xa240-0xA27F */
	0x1980, /* 0xa280-0xA2BF */
	0x19c0, /* 0xa2c0-0xA2FF */
	0xffff, /* 0xa300-0xA33F NOT PRESENT */
	0x1a00, /* 0xa340-0xA37F */
	0x1a40, /* 0xa380-0xA3BF */
	0x1a80, /* 0xa3c0-0xA3FF */
	0xffff, /* 0xa400-0xA43F NOT PRESENT */
	0x1ac0, /* 0xa440-0xA47F */
	0x1b00, /* 0xa480-0xA4BF */
	0x1b40, /* 0xa4c0-0xA4FF */
	0xffff, /* 0xa500-0xA53F NOT PRESENT */
	0x1b80, /* 0xa540-0xA57F */
	0x1bc0, /* 0xa580-0xA5BF */
	0x1c00, /* 0xa5c0-0xA5FF */
	0xffff, /* 0xa600-0xA63F NOT PRESENT */
	0x1c40, /* 0xa640-0xA67F */
	0x1c80, /* 0xa680-0xA6BF */
	0x1cc0, /* 0xa6c0-0xA6FF */
	0xffff, /* 0xa700-0xA73F NOT PRESENT */
	0x1d00, /* 0xa740-0xA77F */
	0x1d40, /* 0xa780-0xA7BF */
	0x1d80, /* 0xa7c0-0xA7FF */
	0xffff, /* 0xa800-0xA83F NOT PRESENT */
	0x1dc0, /* 0xa840-0xA87F */
	0x1e00, /* 0xa880-0xA8BF */
	0x1e40, /* 0xa8c0-0xA8FF */
	0xffff, /* 0xa900-0xA93F NOT PRESENT */
	0x1e80, /* 0xa940-0xA97F */
	0x1ec0, /* 0xa980-0xA9BF */
	0x1f00, /* 0xa9c0-0xA9FF */
	0xffff, /* 0xaa00-0xAA3F NOT PRESENT */
	0x1f40, /* 0xaa40-0xAA7F */
	0x1f80, /* 0xaa80-0xAABF */
	0x1fc0, /* 0xaac0-0xAAFF */
	0xffff, /* 0xab00-0xAB3F NOT PRESENT */
	0x2000, /* 0xab40-0xAB7F */
	0x2040, /* 0xab80-0xABBF */
	0x2080, /* 0xabc0-0xABFF */
	0xffff, /* 0xac00-0xAC3F NOT PRESENT */
	0x20c0, /* 0xac40-0xAC7F */
	0x2100, /* 0xac80-0xACBF */
	0x2140, /* 0xacc0-0xACFF */
	0xffff, /* 0xad00-0xAD3F NOT PRESENT */
	0x2180, /* 0xad40-0xAD7F */
	0x21c0, /* 0xad80-0xADBF */
	0x2200, /* 0xadc0-0xADFF */
	0xffff, /* 0xae00-0xAE3F NOT PRESENT */
	0x2240, /* 0xae40-0xAE7F */
	0x2280, /* 0xae80-0xAEBF */
	0x22c0, /* 0xaec0-0xAEFF */
	0xffff, /* 0xaf00-0xAF3F NOT PRESENT */
	0x2300, /* 0xaf40-0xAF7F */
	0x2340, /* 0xaf80-0xAFBF */
	0x2380, /* 0xafc0-0xAFFF */
	0xffff, /* 0xb000-0xB03F NOT PRESENT */
	0x23c0, /* 0xb040-0xB07F */
	0x2400, /* 0xb080-0xB0BF */
	0x2440, /* 0xb0c0-0xB0FF */
	0xffff, /* 0xb100-0xB13F NOT PRESENT */
	0x2480, /* 0xb140-0xB17F */
	0x24c0, /* 0xb180-0xB1BF */
	0x2500, /* 0xb1c0-0xB1FF */
	0xffff, /* 0xb200-0xB23F NOT PRESENT */
	0x2540, /* 0xb240-0xB27F */
	0x2580, /* 0xb280-0xB2BF */
	0x25c0, /* 0xb2c0-0xB2FF */
	0xffff, /* 0xb300-0xB33F NOT PRESENT */
	0x2600, /* 0xb340-0xB37F */
	0x2640, /* 0xb380-0xB3BF */
	0x2680, /* 0xb3c0-0xB3FF */
	0xffff, /* 0xb400-0xB43F NOT PRESENT */
	0x26c0, /* 0xb440-0xB47F */
	0x2700, /* 0xb480-0xB4BF */
	0x2740, /* 0xb4c0-0xB4FF */
	0xffff, /* 0xb500-0xB53F NOT PRESENT */
	0x2780, /* 0xb540-0xB57F */
	0x27c0, /* 0xb580-0xB5BF */
	0x2800, /* 0xb5c0-0xB5FF */
	0xffff, /* 0xb600-0xB63F NOT PRESENT */
	0x2840, /* 0xb640-0xB67F */
	0x2880, /* 0xb680-0xB6BF */
	0x28c0, /* 0xb6c0-0xB6FF */
	0xffff, /* 0xb700-0xB73F NOT PRESENT */
	0x2900, /* 0xb740-0xB77F */
	0x2940, /* 0xb780-0xB7BF */
	0x2980, /* 0xb7c0-0xB7FF */
	0xffff, /* 0xb800-0xB83F NOT PRESENT */
	0x29c0, /* 0xb840-0xB87F */
	0x2a00, /* 0xb880-0xB8BF */
	0x2a40, /* 0xb8c0-0xB8FF */
	0xffff, /* 0xb900-0xB93F NOT PRESENT */
	0x2a80, /* 0xb940-0xB97F */
	0x2ac0, /* 0xb980-0xB9BF */
	0x2b00, /* 0xb9c0-0xB9FF */
	0xffff, /* 0xba00-0xBA3F NOT PRESENT */
	0x2b40, /* 0xba40-0xBA7F */
	0x2b80, /* 0xba80-0xBABF */
	0x2bc0, /* 0xbac0-0xBAFF */
	0xffff, /* 0xbb00-0xBB3F NOT PRESENT */
	0x2c00, /* 0xbb40-0xBB7F */
	0x2c40, /* 0xbb80-0xBBBF */
	0x2c80, /* 0xbbc0-0xBBFF */
	0xffff, /* 0xbc00-0xBC3F NOT PRESENT */
	0x2cc0, /* 0xbc40-0xBC7F */
	0x2d00, /* 0xbc80-0xBCBF */
	0x2d40, /* 0xbcc0-0xBCFF */
	0xffff, /* 0xbd00-0xBD3F NOT PRESENT */
	0x2d80, /* 0xbd40-0xBD7F */
	0x2dc0, /* 0xbd80-0xBDBF */
	0x2e00, /* 0xbdc0-0xBDFF */
	0xffff, /* 0xbe00-0xBE3F NOT PRESENT */
	0x2e40, /* 0xbe40-0xBE7F */
	0x2e80, /* 0xbe80-0xBEBF */
	0x2ec0, /* 0xbec0-0xBEFF */
	0xffff, /* 0xbf00-0xBF3F NOT PRESENT */
	0x2f00, /* 0xbf40-0xBF7F */
	0x2f40, /* 0xbf80-0xBFBF */
	0x2f80, /* 0xbfc0-0xBFFF */
	0xffff, /* 0xc000-0xC03F NOT PRESENT */
	0x2fc0, /* 0xc040-0xC07F */
	0x3000, /* 0xc080-0xC0BF */
	0x3040, /* 0xc0c0-0xC0FF */
	0xffff, /* 0xc100-0xC13F NOT PRESENT */
	0x3080, /* 0xc140-0xC17F */
	0x30c0, /* 0xc180-0xC1BF */
	0x3100, /* 0xc1c0-0xC1FF */
	0xffff, /* 0xc200-0xC23F NOT PRESENT */
	0x3140, /* 0xc240-0xC27F */
	0x3180, /* 0xc280-0xC2BF */
	0x31c0, /* 0xc2c0-0xC2FF */
	0xffff, /* 0xc300-0xC33F NOT PRESENT */
	0x3200, /* 0xc340-0xC37F */
	0x3240, /* 0xc380-0xC3BF */
	0x3280, /* 0xc3c0-0xC3FF */
	0xffff, /* 0xc400-0xC43F NOT PRESENT */
	0x32c0, /* 0xc440-0xC47F */
	0x3300, /* 0xc480-0xC4BF */
	0x3340, /* 0xc4c0-0xC4FF */
	0xffff, /* 0xc500-0xC53F NOT PRESENT */
	0x3380, /* 0xc540-0xC57F */
	0x33c0, /* 0xc580-0xC5BF */
	0x3400, /* 0xc5c0-0xC5FF */
	0xffff, /* 0xc600-0xC63F NOT PRESENT */
	0x3440, /* 0xc640-0xC67F */
	0x3480, /* 0xc680-0xC6BF */
	0x34c0, /* 0xc6c0-0xC6FF */
	0xffff, /* 0xc700-0xC73F NOT PRESENT */
	0x3500, /* 0xc740-0xC77F */
	0x3540, /* 0xc780-0xC7BF */
	0x3580, /* 0xc7c0-0xC7FF */
	0xffff, /* 0xc800-0xC83F NOT PRESENT */
	0x35c0, /* 0xc840-0xC87F */
	0x3600, /* 0xc880-0xC8BF */
	0x3640, /* 0xc8c0-0xC8FF */
	0xffff, /* 0xc900-0xC93F NOT PRESENT */
	0x3680, /* 0xc940-0xC97F */
	0x36c0, /* 0xc980-0xC9BF */
	0x3700, /* 0xc9c0-0xC9FF */
	0xffff, /* 0xca00-0xCA3F NOT PRESENT */
	0x3740, /* 0xca40-0xCA7F */
	0x3780, /* 0xca80-0xCABF */
	0x37c0, /* 0xcac0-0xCAFF */
	0xffff, /* 0xcb00-0xCB3F NOT PRESENT */
	0x3800, /* 0xcb40-0xCB7F */
	0x3840, /* 0xcb80-0xCBBF */
	0x3880, /* 0xcbc0-0xCBFF */
	0xffff, /* 0xcc00-0xCC3F NOT PRESENT */
	0x38c0, /* 0xcc40-0xCC7F */
	0x3900, /* 0xcc80-0xCCBF */
	0x3940, /* 0xccc0-0xCCFF */
	0xffff, /* 0xcd00-0xCD3F NOT PRESENT */
	0x3980, /* 0xcd40-0xCD7F */
	0x39c0, /* 0xcd80-0xCDBF */
	0x3a00, /* 0xcdc0-0xCDFF */
	0xffff, /* 0xce00-0xCE3F NOT PRESENT */
	0x3a40, /* 0xce40-0xCE7F */
	0x3a80, /* 0xce80-0xCEBF */
	0x3ac0, /* 0xcec0-0xCEFF */
	0xffff, /* 0xcf00-0xCF3F NOT PRESENT */
	0x3b00, /* 0xcf40-0xCF7F */
	0x3b40, /* 0xcf80-0xCFBF */
	0x3b80, /* 0xcfc0-0xCFFF */
	0xffff, /* 0xd000-0xD03F NOT PRESENT */
	0x3bc0, /* 0xd040-0xD07F */
	0x3c00, /* 0xd080-0xD0BF */
	0x3c40, /* 0xd0c0-0xD0FF */
	0xffff, /* 0xd100-0xD13F NOT PRESENT */
	0x3c80, /* 0xd140-0xD17F */
	0x3cc0, /* 0xd180-0xD1BF */
	0x3d00, /* 0xd1c0-0xD1FF */
	0xffff, /* 0xd200-0xD23F NOT PRESENT */
	0x3d40, /* 0xd240-0xD27F */
	0x3d80, /* 0xd280-0xD2BF */
	0x3dc0, /* 0xd2c0-0xD2FF */
	0xffff, /* 0xd300-0xD33F NOT PRESENT */
	0x3e00, /* 0xd340-0xD37F */
	0x3e40, /* 0xd380-0xD3BF */
	0x3e80, /* 0xd3c0-0xD3FF */
	0xffff, /* 0xd400-0xD43F NOT PRESENT */
	0x3ec0, /* 0xd440-0xD47F */
	0x3f00, /* 0xd480-0xD4BF */
	0x3f40, /* 0xd4c0-0xD4FF */
	0xffff, /* 0xd500-0xD53F NOT PRESENT */
	0x3f80, /* 0xd540-0xD57F */
	0x3fc0, /* 0xd580-0xD5BF */
	0x4000, /* 0xd5c0-0xD5FF */
	0xffff, /* 0xd600-0xD63F NOT PRESENT */
	0x4040, /* 0xd640-0xD67F */
	0x4080, /* 0xd680-0xD6BF */
	0x40c0, /* 0xd6c0-0xD6FF */
	0xffff, /* 0xd700-0xD73F NOT PRESENT */
	0x4100, /* 0xd740-0xD77F */
	0x4140, /* 0xd780-0xD7BF */
	0x4180, /* 0xd7c0-0xD7FF */
	0xffff, /* 0xd800-0xD83F NOT PRESENT */
	0x41c0, /* 0xd840-0xD87F */
	0x4200, /* 0xd880-0xD8BF */
	0x4240, /* 0xd8c0-0xD8FF */
	0xffff, /* 0xd900-0xD93F NOT PRESENT */
	0x4280, /* 0xd940-0xD97F */
	0x42c0, /* 0xd980-0xD9BF */
	0x4300, /* 0xd9c0-0xD9FF */
	0xffff, /* 0xda00-0xDA3F NOT PRESENT */
	0x4340, /* 0xda40-0xDA7F */
	0x4380, /* 0xda80-0xDABF */
	0x43c0, /* 0xdac0-0xDAFF */
	0xffff, /* 0xdb00-0xDB3F NOT PRESENT */
	0x4400, /* 0xdb40-0xDB7F */
	0x4440, /* 0xdb80-0xDBBF */
	0x4480, /* 0xdbc0-0xDBFF */
	0xffff, /* 0xdc00-0xDC3F NOT PRESENT */
	0x44c0, /* 0xdc40-0xDC7F */
	0x4500, /* 0xdc80-0xDCBF */
	0x4540, /* 0xdcc0-0xDCFF */
	0xffff, /* 0xdd00-0xDD3F NOT PRESENT */
	0x4580, /* 0xdd40-0xDD7F */
	0x45c0, /* 0xdd80-0xDDBF */
	0x4600, /* 0xddc0-0xDDFF */
	0xffff, /* 0xde00-0xDE3F NOT PRESENT */
	0x4640, /* 0xde40-0xDE7F */
	0x4680, /* 0xde80-0xDEBF */
	0x46c0, /* 0xdec0-0xDEFF */
	0xffff, /* 0xdf00-0xDF3F NOT PRESENT */
	0x4700, /* 0xdf40-0xDF7F */
	0x4740, /* 0xdf80-0xDFBF */
	0x4780, /* 0xdfc0-0xDFFF */
	0xffff, /* 0xe000-0xE03F NOT PRESENT */
	0x47c0, /* 0xe040-0xE07F */
	0x4800, /* 0xe080-0xE0BF */
	0x4840, /* 0xe0c0-0xE0FF */
	0xffff, /* 0xe100-0xE13F NOT PRESENT */
	0x4880, /* 0xe140-0xE17F */
	0x48c0, /* 0xe180-0xE1BF */
	0x4900, /* 0xe1c0-0xE1FF */
	0xffff, /* 0xe200-0xE23F NOT PRESENT */
	0x4940, /* 0xe240-0xE27F */
	0x4980, /* 0xe280-0xE2BF */
	0x49c0, /* 0xe2c0-0xE2FF */
	0xffff, /* 0xe300-0xE33F NOT PRESENT */
	0x4a00, /* 0xe340-0xE37F */
	0x4a40, /* 0xe380-0xE3BF */
	0x4a80, /* 0xe3c0-0xE3FF */
	0xffff, /* 0xe400-0xE43F NOT PRESENT */
	0x4ac0, /* 0xe440-0xE47F */
	0x4b00, /* 0xe480-0xE4BF */
	0x4b40, /* 0xe4c0-0xE4FF */
	0xffff, /* 0xe500-0xE53F NOT PRESENT */
	0x4b80, /* 0xe540-0xE57F */
	0x4bc0, /* 0xe580-0xE5BF */
	0x4c00, /* 0xe5c0-0xE5FF */
	0xffff, /* 0xe600-0xE63F NOT PRESENT */
	0x4c40, /* 0xe640-0xE67F */
	0x4c80, /* 0xe680-0xE6BF */
	0x4cc0, /* 0xe6c0-0xE6FF */
	0xffff, /* 0xe700-0xE73F NOT PRESENT */
	0x4d00, /* 0xe740-0xE77F */
	0x4d40, /* 0xe780-0xE7BF */
	0x4d80, /* 0xe7c0-0xE7FF */
	0xffff, /* 0xe800-0xE83F NOT PRESENT */
	0x4dc0, /* 0xe840-0xE87F */
	0x4e00, /* 0xe880-0xE8BF */
	0x4e40, /* 0xe8c0-0xE8FF */
	0xffff, /* 0xe900-0xE93F NOT PRESENT */
	0x4e80, /* 0xe940-0xE97F */
	0x4ec0, /* 0xe980-0xE9BF */
	0x4f00, /* 0xe9c0-0xE9FF */
	0xffff, /* 0xea00-0xEA3F NOT PRESENT */
	0x4f40, /* 0xea40-0xEA7F */
	0x4f80, /* 0xea80-0xEABF */
	0x4fc0, /* 0xeac0-0xEAFF */
	0xffff, /* 0xeb00-0xEB3F NOT PRESENT */
	0x5000, /* 0xeb40-0xEB7F */
	0x5040, /* 0xeb80-0xEBBF */
	0x5080, /* 0xebc0-0xEBFF */
	0xffff, /* 0xec00-0xEC3F NOT PRESENT */
	0x50c0, /* 0xec40-0xEC7F */
	0x5100, /* 0xec80-0xECBF */
	0x5140, /* 0xecc0-0xECFF */
	0xffff, /* 0xed00-0xED3F NOT PRESENT */
	0x5180, /* 0xed40-0xED7F */
	0x51c0, /* 0xed80-0xEDBF */
	0x5200, /* 0xedc0-0xEDFF */
	0xffff, /* 0xee00-0xEE3F NOT PRESENT */
	0x5240, /* 0xee40-0xEE7F */
	0x5280, /* 0xee80-0xEEBF */
	0x52c0, /* 0xeec0-0xEEFF */
	0xffff, /* 0xef00-0xEF3F NOT PRESENT */
	0x5300, /* 0xef40-0xEF7F */
	0x5340, /* 0xef80-0xEFBF */
	0x5380, /* 0xefc0-0xEFFF */
	0xffff, /* 0xf000-0xF03F NOT PRESENT */
	0x53c0, /* 0xf040-0xF07F */
	0x5400, /* 0xf080-0xF0BF */
	0x5440, /* 0xf0c0-0xF0FF */
	0xffff, /* 0xf100-0xF13F NOT PRESENT */
	0x5480, /* 0xf140-0xF17F */
	0x54c0, /* 0xf180-0xF1BF */
	0x5500, /* 0xf1c0-0xF1FF */
	0xffff, /* 0xf200-0xF23F NOT PRESENT */
	0x5540, /* 0xf240-0xF27F */
	0x5580, /* 0xf280-0xF2BF */
	0x55c0, /* 0xf2c0-0xF2FF */
	0xffff, /* 0xf300-0xF33F NOT PRESENT */
	0x5600, /* 0xf340-0xF37F */
	0x5640, /* 0xf380-0xF3BF */
	0x5680, /* 0xf3c0-0xF3FF */
	0xffff, /* 0xf400-0xF43F NOT PRESENT */
	0x56c0, /* 0xf440-0xF47F */
	0x5700, /* 0xf480-0xF4BF */
	0x5740, /* 0xf4c0-0xF4FF */
	0xffff, /* 0xf500-0xF53F NOT PRESENT */
	0x5780, /* 0xf540-0xF57F */
	0x57c0, /* 0xf580-0xF5BF */
	0x5800, /* 0xf5c0-0xF5FF */
	0xffff, /* 0xf600-0xF63F NOT PRESENT */
	0x5840, /* 0xf640-0xF67F */
	0x5880, /* 0xf680-0xF6BF */
	0x58c0, /* 0xf6c0-0xF6FF */
	0xffff, /* 0xf700-0xF73F NOT PRESENT */
	0x5900, /* 0xf740-0xF77F */
	0x5940, /* 0xf780-0xF7BF */
	0x5980, /* 0xf7c0-0xF7FF */
	0xffff, /* 0xf800-0xF83F NOT PRESENT */
	0x59c0, /* 0xf840-0xF87F */
	0x5a00, /* 0xf880-0xF8BF */
	0x5a40, /* 0xf8c0-0xF8FF */
	0xffff, /* 0xf900-0xF93F NOT PRESENT */
	0x5a80, /* 0xf940-0xF97F */
	0x5ac0, /* 0xf980-0xF9BF */
	0x5b00, /* 0xf9c0-0xF9FF */
	0xffff, /* 0xfa00-0xFA3F NOT PRESENT */
	0x5b40, /* 0xfa40-0xFA7F */
	0x5b80, /* 0xfa80-0xFABF */
	0x5bc0, /* 0xfac0-0xFAFF */
	0xffff, /* 0xfb00-0xFB3F NOT PRESENT */
	0x5c00, /* 0xfb40-0xFB7F */
	0x5c40, /* 0xfb80-0xFBBF */
	0x5c80, /* 0xfbc0-0xFBFF */
	0xffff, /* 0xfc00-0xFC3F NOT PRESENT */
	0x5cc0, /* 0xfc40-0xFC7F */
	0x5d00, /* 0xfc80-0xFCBF */
	0x5d40, /* 0xfcc0-0xFCFF */
	0xffff, /* 0xfd00-0xFD3F NOT PRESENT */
	0x5d80, /* 0xfd40-0xFD7F */
	0x5dc0, /* 0xfd80-0xFDBF */
	0x5e00, /* 0xfdc0-0xFDFF */
	0xffff, /* 0xfe00-0xFE3F NOT PRESENT */
	0x5e40, /* 0xfe40-0xFE7F */
	0x5e80, /* 0xfe80-0xFEBF */
	0x5ec0, /* 0xfec0-0xFEFF */
	0xffff, /* 0xff00-0xFF3F NOT PRESENT */
	0xffff, /* 0xff40-0xFF7F NOT PRESENT */
	0xffff, /* 0xff80-0xFFBF NOT PRESENT */
	0xffff  /* 0xffc0-0xFFFF NOT PRESENT */
};
