/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.internal.parser.v0;

import org.openjdk.jmc.flightrecorder.internal.InvalidJfrFileException;
import org.openjdk.jmc.flightrecorder.internal.util.DataInputToolkit;

class Offset {
    private int offset;
    private final int offsetLimit;

    Offset(byte[] data, int startOffset) throws InvalidJfrFileException {
        int structSize = DataInputToolkit.readInt(data, startOffset);
        int structEnd = startOffset + structSize;
        if (structSize < 4 || structEnd > data.length) {
            throw new InvalidJfrFileException();
        }
        this.offset = startOffset + 4;
        this.offsetLimit = structEnd;
    }

    void increase(int amount) throws InvalidJfrFileException {
        if (amount < 0) {
            throw new InvalidJfrFileException();
        }
        int newOffset = this.offset + amount;
        if (newOffset > this.offsetLimit) {
            throw new InvalidJfrFileException();
        }
        this.offset = newOffset;
    }

    int get() {
        return this.offset;
    }

    int getAndIncrease(int amount) throws InvalidJfrFileException {
        int current = this.offset;
        this.increase(amount);
        return current;
    }

    int getEnd() {
        return this.offsetLimit;
    }
}

