/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.datatool;

import com.dickimawbooks.texparserlib.CharObject;
import com.dickimawbooks.texparserlib.Comment;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.DataObjectList;
import com.dickimawbooks.texparserlib.FileMapHandler;
import com.dickimawbooks.texparserlib.Ignoreable;
import com.dickimawbooks.texparserlib.SingleToken;
import com.dickimawbooks.texparserlib.Space;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.WhiteSpace;
import com.dickimawbooks.texparserlib.latex.datatool.DataBase;
import com.dickimawbooks.texparserlib.latex.datatool.DataElement;
import com.dickimawbooks.texparserlib.latex.datatool.DataStringElement;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolEntry;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolEntryRow;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolHeader;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolHeaderRow;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolRows;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolSty;
import com.dickimawbooks.texparserlib.latex.datatool.EscapeCharsOption;
import com.dickimawbooks.texparserlib.latex.datatool.IOSettings;
import java.io.EOFException;
import java.io.IOException;
import java.util.Vector;

public class CsvReadHandler
implements FileMapHandler {
    DataBase database;
    IOSettings settings;
    boolean appending = false;
    int rowIdx = 0;
    DataObjectList pendingRow = null;
    TeXObjectList pendingCell = null;
    TeXObjectList currentStack = null;
    Vector<DataToolHeader> headers;
    TeXParser parser;
    DataToolSty sty;

    public CsvReadHandler(DataBase dataBase, boolean bl, IOSettings iOSettings) {
        this.database = dataBase;
        this.appending = bl;
        this.settings = iOSettings;
        this.headers = new Vector();
        this.sty = iOSettings.getSty();
        this.parser = this.sty.getParser();
        this.headers = new Vector();
    }

    @Override
    public void processLine(TeXParser teXParser, TeXObjectList teXObjectList, int n) throws IOException {
        this.parser = teXParser;
        this.currentStack = teXObjectList;
        if (this.rowIdx == 0) {
            DataObjectList dataObjectList;
            if (this.settings.getSkipLines() < n && (dataObjectList = this.splitRow(teXObjectList)) != null) {
                if (this.isRowEmpty(dataObjectList)) {
                    switch (this.settings.getCsvBlankOption()) {
                        case IGNORE: {
                            return;
                        }
                        case END: {
                            throw new EOFException();
                        }
                    }
                }
                if (this.settings.isHeaderIncluded()) {
                    this.parseHeader(dataObjectList);
                    this.rowIdx = 1;
                } else if (this.sty.acceptNewRowRead(this.settings, this.database, dataObjectList)) {
                    this.parseRow(dataObjectList);
                    ++this.rowIdx;
                }
            }
        } else {
            DataObjectList dataObjectList = this.splitRow(teXObjectList);
            if (dataObjectList != null) {
                if (this.isRowEmpty(dataObjectList)) {
                    switch (this.settings.getCsvBlankOption()) {
                        case IGNORE: {
                            return;
                        }
                        case END: {
                            throw new EOFException();
                        }
                    }
                }
                if (this.sty.acceptNewRowRead(this.settings, this.database, dataObjectList)) {
                    this.parseRow(dataObjectList);
                    ++this.rowIdx;
                }
            }
        }
    }

    protected boolean isRowEmpty(DataObjectList dataObjectList) {
        if (dataObjectList.isEmpty()) {
            return true;
        }
        for (TeXObject teXObject : dataObjectList) {
            if (teXObject.isEmpty()) continue;
            return false;
        }
        return true;
    }

    protected void parseHeader(DataObjectList dataObjectList) throws IOException {
        boolean bl = this.settings.isAutoKeysOn();
        DataToolHeaderRow dataToolHeaderRow = this.database.getHeaders();
        if (dataToolHeaderRow == null) {
            dataToolHeaderRow = new DataToolHeaderRow(this.settings.getSty());
            this.database.update(dataToolHeaderRow, this.database.getData());
        }
        for (int i = 0; i < dataObjectList.size(); ++i) {
            DataToolHeader dataToolHeader;
            TeXObject teXObject;
            String string;
            boolean bl2;
            Integer n = i + 1;
            if (bl) {
                bl2 = false;
                string = this.parser.expandToString(this.parser.getListener().getControlSequence("dtldefaultkey"), this.currentStack) + n;
                teXObject = this.parser.getListener().createString(string);
            } else {
                string = this.settings.getColumnKey(n);
                if (string == null) {
                    bl2 = false;
                    teXObject = this.processCell((TeXObject)dataObjectList.get(i));
                    string = teXObject.toString(this.parser);
                } else {
                    bl2 = false;
                    teXObject = this.parser.getListener().createString(string);
                }
                if (string.isEmpty()) {
                    string = this.parser.expandToString(this.parser.getListener().getControlSequence("dtldefaultkey"), this.currentStack) + n;
                }
            }
            TeXObject teXObject2 = this.settings.getColumnHeader(n);
            if (teXObject2 == null) {
                teXObject2 = bl2 ? teXObject : this.processCell((TeXObject)dataObjectList.get(i));
            }
            if (this.appending) {
                dataToolHeader = this.database.getHeader(string);
                if (dataToolHeader == null) {
                    dataToolHeader = new DataToolHeader(this.settings.getSty(), dataToolHeaderRow.size() + 1, string);
                    dataToolHeader.setTitle(teXObject2);
                    dataToolHeaderRow.add(dataToolHeader);
                }
            } else {
                dataToolHeader = new DataToolHeader(this.settings.getSty(), n, string);
                dataToolHeader.setTitle(teXObject2);
                dataToolHeaderRow.add(dataToolHeader);
            }
            this.headers.add(dataToolHeader);
        }
    }

    protected void parseRow(DataObjectList dataObjectList) throws IOException {
        DataToolRows dataToolRows;
        DataToolHeaderRow dataToolHeaderRow = this.database.getHeaders();
        if (dataToolHeaderRow == null) {
            dataToolHeaderRow = new DataToolHeaderRow(this.settings.getSty());
        }
        if ((dataToolRows = this.database.getData()) == null) {
            dataToolRows = new DataToolRows(this.settings.getSty());
        }
        DataToolEntryRow dataToolEntryRow = new DataToolEntryRow(dataToolRows.size() + 1, this.settings.getSty());
        dataToolRows.add(dataToolEntryRow);
        this.database.update(dataToolHeaderRow, dataToolRows);
        for (int i = 0; i < dataObjectList.size(); ++i) {
            Object object;
            TeXObject teXObject = (TeXObject)dataObjectList.get(i);
            if (this.sty.isNull(teXObject)) continue;
            TeXObject teXObject2 = this.processCell(teXObject);
            DataElement dataElement = this.settings.getSty().getElement(teXObject2);
            boolean bl = true;
            if (dataElement == null) {
                bl = false;
                dataElement = new DataStringElement();
            }
            DataToolHeader dataToolHeader = null;
            if (this.headers.size() > i) {
                dataToolHeader = this.headers.get(i);
            } else {
                object = i + 1;
                String string = this.settings.getColumnKey((Integer)object);
                if (string == null) {
                    string = this.parser.expandToString(this.parser.getListener().getControlSequence("dtldefaultkey"), this.currentStack) + object;
                }
                dataToolHeader = new DataToolHeader(this.settings.getSty(), dataToolHeaderRow.size() + 1, string);
                dataToolHeaderRow.add(dataToolHeader);
                this.headers.add(dataToolHeader);
            }
            if (bl) {
                dataToolHeader.updateType(dataElement);
            }
            object = new DataToolEntry(this.settings.getSty(), dataToolHeader.getColumnIndex(), dataElement);
            dataToolEntryRow.add(object);
        }
    }

    protected TeXObject processCell(TeXObject teXObject) throws IOException {
        if (this.settings.isCsvLiteral()) {
            TeXObjectList teXObjectList;
            StringBuilder stringBuilder = new StringBuilder();
            if (this.parser.isStack(teXObject)) {
                teXObjectList = (TeXObjectList)teXObject;
                for (int i = 0; i < teXObjectList.size(); ++i) {
                    this.processLiteralToken((TeXObject)teXObjectList.get(i), stringBuilder);
                }
            } else {
                this.processLiteralToken(teXObject, stringBuilder);
            }
            teXObjectList = this.parser.getListener().createStack();
            this.parser.scan(stringBuilder.toString(), teXObjectList);
            teXObject = teXObjectList;
        }
        switch (this.settings.getExpandOption()) {
            case PROTECTED: {
                teXObject = TeXParserUtils.expandOnce(teXObject, this.parser, this.currentStack);
                break;
            }
            case FULL: {
                teXObject = TeXParserUtils.expandFully(teXObject, this.parser, this.currentStack);
            }
        }
        if (this.settings.isTrimElementOn() && this.parser.isStack(teXObject)) {
            ((TeXObjectList)teXObject).trim();
        }
        return teXObject;
    }

    protected void processLiteralToken(TeXObject teXObject, StringBuilder stringBuilder) {
        if (teXObject instanceof ControlSequence) {
            String string = ((ControlSequence)teXObject).getName();
            if (string.equals("f") || string.equals("n") || string.equals("r")) {
                stringBuilder.append(' ');
            } else if (string.equals("t")) {
                stringBuilder.append('\t');
            } else {
                int n;
                String string2 = teXObject.toString(this.parser);
                for (int i = 0; i < string2.length(); i += Character.charCount(n)) {
                    n = string2.codePointAt(i);
                    this.sty.appendCsvLiteral(n, stringBuilder);
                }
            }
        } else if (teXObject instanceof SingleToken) {
            int n = ((SingleToken)teXObject).getCharCode();
            this.sty.appendCsvLiteral(n, stringBuilder);
        } else {
            int n;
            String string = teXObject.toString(this.parser);
            for (int i = 0; i < string.length(); i += Character.charCount(n)) {
                n = string.codePointAt(i);
                this.sty.appendCsvLiteral(n, stringBuilder);
            }
        }
    }

    protected DataObjectList splitRow(TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject;
        int n = this.settings.getDelimiter();
        int n2 = this.settings.getSeparator();
        boolean bl = false;
        if (this.pendingCell != null) {
            if (this.pendingCell.isEmpty()) {
                this.pendingCell.add(this.parser.getListener().getControlSequence("DTLpar"));
            } else if (!(this.pendingCell.lastElement() instanceof Comment)) {
                this.pendingCell.add(this.parser.getListener().getEol());
            }
            bl = true;
        }
        if (this.pendingRow == null) {
            this.pendingRow = new DataObjectList();
        }
        boolean bl2 = false;
        while (!teXObjectList.isEmpty()) {
            TeXObject teXObject2;
            teXObject = teXObjectList.pop();
            if (teXObject instanceof CharObject) {
                int n3 = ((CharObject)teXObject).getCharCode();
                if (bl) {
                    if (n3 == n) {
                        TeXObject teXObject3 = teXObjectList.peekStack(TeXObjectList.POP_IGNORE_LEADING_SPACE);
                        if (teXObject3 == null) {
                            this.pendingRow.add(this.pendingCell);
                            teXObject2 = this.pendingRow;
                            this.pendingCell = null;
                            this.pendingRow = null;
                            bl = false;
                            return teXObject2;
                        }
                        if (teXObject3 instanceof CharObject && ((CharObject)teXObject3).getCharCode() == n2) {
                            this.pendingRow.add(this.pendingCell);
                            this.pendingCell = null;
                            bl = false;
                            teXObjectList.popStack(this.parser, TeXObjectList.POP_IGNORE_LEADING_SPACE);
                            continue;
                        }
                        teXObject3 = teXObjectList.peekStack();
                        if (teXObject3 instanceof CharObject && ((CharObject)teXObject3).getCharCode() == n && this.settings.getEscapeCharsOption() == EscapeCharsOption.DOUBLE_DELIM) {
                            this.pendingCell.add(teXObject);
                            teXObjectList.popStack(this.parser);
                            continue;
                        }
                        if (this.settings.isCsvStrictQuotes()) {
                            this.pendingRow.add(this.pendingCell);
                            this.pendingCell = null;
                            bl = false;
                            bl2 = true;
                            continue;
                        }
                        this.pendingCell.add(teXObject);
                        continue;
                    }
                    this.pendingCell.add(teXObject);
                    continue;
                }
                if (bl2 && n3 != n2) continue;
                if (n3 == n) {
                    if (this.pendingCell == null) {
                        this.pendingCell = this.parser.getListener().createStack();
                        bl = true;
                        continue;
                    }
                    if (this.pendingCell.isBlank() || this.settings.isCsvStrictQuotes()) {
                        this.pendingCell.clear();
                        bl = true;
                        continue;
                    }
                    this.pendingCell.add(teXObject);
                    continue;
                }
                if (n3 == n2) {
                    bl2 = false;
                    if (this.pendingCell != null) {
                        if (!this.settings.isCsvLiteral()) {
                            this.pendingCell = TeXParserUtils.removeGroup(this.pendingCell);
                        }
                        if (this.settings.isTrimElementOn()) {
                            this.pendingCell.trimTrailing();
                        }
                        this.pendingRow.add(this.pendingCell);
                        this.pendingCell = null;
                        continue;
                    }
                    this.pendingRow.add(this.parser.getListener().createStack());
                    continue;
                }
                if (this.parser.isCatCode(10, n3)) {
                    Space space = this.parser.getListener().getSpace();
                    space.setSpace(n3);
                    if (this.pendingCell == null) {
                        if (this.settings.isTrimElementOn()) continue;
                        this.pendingCell = this.parser.getListener().createStack();
                        this.pendingCell.add(space);
                        continue;
                    }
                    this.pendingCell.add(space);
                    continue;
                }
                if (this.pendingCell == null) {
                    this.pendingCell = this.parser.getListener().createStack();
                }
                this.pendingCell.add(teXObject);
                continue;
            }
            if (teXObject instanceof WhiteSpace || teXObject instanceof Ignoreable) {
                if (this.pendingCell == null) {
                    if (this.settings.isTrimElementOn()) continue;
                    this.pendingCell = this.parser.getListener().createStack();
                    this.pendingCell.add(teXObject);
                    continue;
                }
                this.pendingCell.add(teXObject);
                continue;
            }
            if (teXObject instanceof ControlSequence) {
                if (this.pendingCell == null) {
                    this.pendingCell = this.parser.getListener().createStack();
                }
                if (this.settings.getEscapeCharsOption() == EscapeCharsOption.DOUBLE_DELIM) {
                    String string = ((ControlSequence)teXObject).getName();
                    int n4 = string.codePointAt(0);
                    this.pendingCell.add(teXObject);
                    if (n4 != n || string.length() != Character.charCount(n4) || !((teXObject2 = teXObjectList.peekStack()) instanceof CharObject) || ((CharObject)teXObject2).getCharCode() != n) continue;
                    teXObjectList.popStack(this.parser);
                    continue;
                }
                this.pendingCell.add(this.fromControlSequence((ControlSequence)teXObject));
                continue;
            }
            if (this.pendingCell == null) {
                this.pendingCell = this.parser.getListener().createStack();
            }
            this.pendingCell.add(teXObject);
        }
        if (bl) {
            return null;
        }
        if (this.pendingCell != null) {
            if (!this.settings.isCsvLiteral()) {
                this.pendingCell = TeXParserUtils.removeGroup(this.pendingCell);
            }
            if (this.settings.isTrimElementOn()) {
                this.pendingCell.trimTrailing();
            }
            if (this.pendingRow == null) {
                this.pendingRow = new DataObjectList();
            }
            this.pendingRow.add(this.pendingCell);
            this.pendingCell = null;
        }
        if (this.pendingRow == null) {
            return new DataObjectList();
        }
        teXObject = this.pendingRow;
        this.pendingRow = null;
        return teXObject;
    }

    protected TeXObject fromControlSequence(ControlSequence controlSequence) {
        EscapeCharsOption escapeCharsOption = this.settings.getEscapeCharsOption();
        if (escapeCharsOption == EscapeCharsOption.NONE || escapeCharsOption == EscapeCharsOption.DOUBLE_DELIM) {
            return controlSequence;
        }
        String string = controlSequence.getName();
        int n = string.codePointAt(0);
        int n2 = this.settings.getDelimiter();
        switch (escapeCharsOption) {
            case ESC_DELIM: {
                if (n != n2 || string.length() != Character.charCount(n)) break;
                return this.parser.getListener().getOther(n);
            }
            case ESC_DELIM_BKSL: {
                if (n != n2 && !this.parser.isCatCode(0, n) || string.length() != Character.charCount(n)) break;
                return this.parser.getListener().getOther(n);
            }
        }
        return controlSequence;
    }

    @Override
    public void processCompleted(TeXParser teXParser) throws IOException {
    }
}

