/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInput;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.table.MaxpTable;
import jogamp.graph.font.typecast.ot.table.Table;
import jogamp.graph.font.typecast.ot.table.VheaTable;

class VmtxTable
implements Table {
    private int[] _vMetrics;
    private short[] _topSideBearing;

    protected VmtxTable(DataInput dataInput, VheaTable vheaTable, MaxpTable maxpTable) throws IOException {
        int n;
        this._vMetrics = new int[vheaTable.getNumberOfLongVerMetrics()];
        for (n = 0; n < vheaTable.getNumberOfLongVerMetrics(); ++n) {
            this._vMetrics[n] = dataInput.readUnsignedByte() << 24 | dataInput.readUnsignedByte() << 16 | dataInput.readUnsignedByte() << 8 | dataInput.readUnsignedByte();
        }
        n = maxpTable.getNumGlyphs() - vheaTable.getNumberOfLongVerMetrics();
        this._topSideBearing = new short[n];
        for (int i = 0; i < n; ++i) {
            this._topSideBearing[i] = dataInput.readShort();
        }
    }

    private int getAdvanceHeight(int n) {
        if (this._vMetrics == null) {
            return 0;
        }
        if (n < this._vMetrics.length) {
            return this._vMetrics[n] >> 16;
        }
        return this._vMetrics[this._vMetrics.length - 1] >> 16;
    }

    private short getTopSideBearing(int n) {
        if (this._vMetrics == null) {
            return 0;
        }
        if (n < this._vMetrics.length) {
            return (short)(this._vMetrics[n] & 0xFFFF);
        }
        return this._topSideBearing[n - this._vMetrics.length];
    }

    public String toString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("'vmtx' Table - Vertical Metrics\n-------------------------------\n");
        stringBuilder.append(this._vMetrics.length).append(" entries\n");
        for (n = 0; n < this._vMetrics.length; ++n) {
            stringBuilder.append("        ").append(n).append(". advHeight: ").append(this.getAdvanceHeight(n)).append(", TSdBear: ").append(this.getTopSideBearing(n)).append("\n");
        }
        for (n = 0; n < this._topSideBearing.length; ++n) {
            stringBuilder.append("        TSdBear ").append(n + this._vMetrics.length).append(": ").append(this._topSideBearing[n]).append("\n");
        }
        return stringBuilder.toString();
    }
}

