/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ml;

import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch.ml.UpdateModelGroupResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public final class UpdateModelGroupRequest
extends RequestBase
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, UpdateModelGroupRequest> {
    @Nullable
    private final Boolean addAllBackendRoles;
    @Nonnull
    private final List<String> addBackendRoles;
    @Nonnull
    private final List<String> backendRoles;
    @Nullable
    private final String description;
    @Nullable
    private final String modelAccessName;
    @Nonnull
    private final String modelGroupId;
    @Nullable
    private final String name;
    public static final JsonpDeserializer<UpdateModelGroupRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UpdateModelGroupRequest::setupUpdateModelGroupRequestDeserializer);
    public static final Endpoint<UpdateModelGroupRequest, UpdateModelGroupResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<UpdateModelGroupRequest, UpdateModelGroupResponse>(request -> "PUT", request -> {
        StringBuilder buf = new StringBuilder();
        buf.append("/_plugins/_ml/model_groups/");
        SimpleEndpoint.pathEncode(request.modelGroupId, buf);
        return buf.toString();
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), true, UpdateModelGroupResponse._DESERIALIZER);

    private UpdateModelGroupRequest(Builder builder) {
        super(builder);
        this.addAllBackendRoles = builder.addAllBackendRoles;
        this.addBackendRoles = ApiTypeHelper.unmodifiable(builder.addBackendRoles);
        this.backendRoles = ApiTypeHelper.unmodifiable(builder.backendRoles);
        this.description = builder.description;
        this.modelAccessName = builder.modelAccessName;
        this.modelGroupId = ApiTypeHelper.requireNonNull(builder.modelGroupId, this, "modelGroupId");
        this.name = builder.name;
    }

    public static UpdateModelGroupRequest of(Function<Builder, ObjectBuilder<UpdateModelGroupRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean addAllBackendRoles() {
        return this.addAllBackendRoles;
    }

    @Nonnull
    public final List<String> addBackendRoles() {
        return this.addBackendRoles;
    }

    @Nonnull
    public final List<String> backendRoles() {
        return this.backendRoles;
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    @Nullable
    public final String modelAccessName() {
        return this.modelAccessName;
    }

    @Nonnull
    public final String modelGroupId() {
        return this.modelGroupId;
    }

    @Nullable
    public final String name() {
        return this.name;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.addAllBackendRoles != null) {
            generator.writeKey("add_all_backend_roles");
            generator.write(this.addAllBackendRoles.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.addBackendRoles)) {
            generator.writeKey("add_backend_roles");
            generator.writeStartArray();
            for (String item0 : this.addBackendRoles) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.backendRoles)) {
            generator.writeKey("backend_roles");
            generator.writeStartArray();
            for (String item0 : this.backendRoles) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (this.modelAccessName != null) {
            generator.writeKey("model_access_name");
            generator.write(this.modelAccessName);
        }
        if (this.name != null) {
            generator.writeKey("name");
            generator.write(this.name);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupUpdateModelGroupRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::addAllBackendRoles, JsonpDeserializer.booleanDeserializer(), "add_all_backend_roles");
        op.add(Builder::addBackendRoles, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "add_backend_roles");
        op.add(Builder::backendRoles, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "backend_roles");
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::modelAccessName, JsonpDeserializer.stringDeserializer(), "model_access_name");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.addAllBackendRoles);
        result = 31 * result + Objects.hashCode(this.addBackendRoles);
        result = 31 * result + Objects.hashCode(this.backendRoles);
        result = 31 * result + Objects.hashCode(this.description);
        result = 31 * result + Objects.hashCode(this.modelAccessName);
        result = 31 * result + this.modelGroupId.hashCode();
        result = 31 * result + Objects.hashCode(this.name);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateModelGroupRequest other = (UpdateModelGroupRequest)o;
        return Objects.equals(this.addAllBackendRoles, other.addAllBackendRoles) && Objects.equals(this.addBackendRoles, other.addBackendRoles) && Objects.equals(this.backendRoles, other.backendRoles) && Objects.equals(this.description, other.description) && Objects.equals(this.modelAccessName, other.modelAccessName) && this.modelGroupId.equals(other.modelGroupId) && Objects.equals(this.name, other.name);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, UpdateModelGroupRequest> {
        @Nullable
        private Boolean addAllBackendRoles;
        @Nullable
        private List<String> addBackendRoles;
        @Nullable
        private List<String> backendRoles;
        @Nullable
        private String description;
        @Nullable
        private String modelAccessName;
        private String modelGroupId;
        @Nullable
        private String name;

        public Builder() {
        }

        private Builder(UpdateModelGroupRequest o) {
            super(o);
            this.addAllBackendRoles = o.addAllBackendRoles;
            this.addBackendRoles = Builder._listCopy(o.addBackendRoles);
            this.backendRoles = Builder._listCopy(o.backendRoles);
            this.description = o.description;
            this.modelAccessName = o.modelAccessName;
            this.modelGroupId = o.modelGroupId;
            this.name = o.name;
        }

        private Builder(Builder o) {
            super(o);
            this.addAllBackendRoles = o.addAllBackendRoles;
            this.addBackendRoles = Builder._listCopy(o.addBackendRoles);
            this.backendRoles = Builder._listCopy(o.backendRoles);
            this.description = o.description;
            this.modelAccessName = o.modelAccessName;
            this.modelGroupId = o.modelGroupId;
            this.name = o.name;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder addAllBackendRoles(@Nullable Boolean value) {
            this.addAllBackendRoles = value;
            return this;
        }

        @Nonnull
        public final Builder addBackendRoles(List<String> list) {
            this.addBackendRoles = Builder._listAddAll(this.addBackendRoles, list);
            return this;
        }

        @Nonnull
        public final Builder addBackendRoles(String value, String ... values) {
            this.addBackendRoles = Builder._listAdd(this.addBackendRoles, value, values);
            return this;
        }

        @Nonnull
        public final Builder backendRoles(List<String> list) {
            this.backendRoles = Builder._listAddAll(this.backendRoles, list);
            return this;
        }

        @Nonnull
        public final Builder backendRoles(String value, String ... values) {
            this.backendRoles = Builder._listAdd(this.backendRoles, value, values);
            return this;
        }

        @Nonnull
        public final Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        @Nonnull
        public final Builder modelAccessName(@Nullable String value) {
            this.modelAccessName = value;
            return this;
        }

        @Nonnull
        public final Builder modelGroupId(String value) {
            this.modelGroupId = value;
            return this;
        }

        @Nonnull
        public final Builder name(@Nullable String value) {
            this.name = value;
            return this;
        }

        @Override
        @Nonnull
        public UpdateModelGroupRequest build() {
            this._checkSingleUse();
            return new UpdateModelGroupRequest(this);
        }
    }
}

