/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.openapi.spi;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ServiceLoader;
import org.eclipse.microprofile.openapi.models.Constructible;

public abstract class OASFactoryResolver {
    private static volatile OASFactoryResolver instance = null;

    public abstract <T extends Constructible> T createObject(Class<T> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OASFactoryResolver instance() {
        if (instance != null) return instance;
        Class<OASFactoryResolver> clazz = OASFactoryResolver.class;
        synchronized (OASFactoryResolver.class) {
            OASFactoryResolver newInstance;
            if (instance != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
            ClassLoader cl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
            if (cl == null) {
                cl = OASFactoryResolver.class.getClassLoader();
            }
            if ((newInstance = OASFactoryResolver.loadSpi(cl)) == null) {
                throw new IllegalStateException("No OASFactoryResolver implementation found!");
            }
            instance = newInstance;
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static OASFactoryResolver loadSpi(ClassLoader cl) {
        if (cl == null) {
            return null;
        }
        OASFactoryResolver instance = null;
        ServiceLoader<OASFactoryResolver> sl = ServiceLoader.load(OASFactoryResolver.class, cl);
        for (OASFactoryResolver spi : sl) {
            if (instance != null) {
                throw new IllegalStateException("Multiple OASFactoryResolver implementations found: " + spi.getClass().getName() + " and " + instance.getClass().getName());
            }
            instance = spi;
        }
        return instance;
    }

    public static void setInstance(OASFactoryResolver factory) {
        instance = factory;
    }
}

