/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.config;

import java.io.InputStream;
import java.util.ArrayList;
import org.apache.felix.scr.impl.manager.ScrConfiguration;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.MetaTypeProvider;
import org.osgi.service.metatype.ObjectClassDefinition;

class ScrMetaTypeProvider
implements MetaTypeProvider {
    private final ScrConfiguration configuration;

    public ScrMetaTypeProvider(ScrConfiguration scrConfiguration) {
        this.configuration = scrConfiguration;
    }

    public String[] getLocales() {
        return null;
    }

    public ObjectClassDefinition getObjectClassDefinition(String id, String locale) {
        if (!"org.apache.felix.scr.ScrService".equals(id)) {
            return null;
        }
        final ArrayList<AttributeDefinitionImpl> adList = new ArrayList<AttributeDefinitionImpl>();
        adList.add(new AttributeDefinitionImpl("ds.loglevel", "SCR Log Level", "Allows limiting the amount of logging information sent to the OSGi LogService. Supported values are DEBUG, INFO, WARN, and ERROR. This property is not used if a R7 LogService implementation is available as the log level can be configured through that service. Default is ERROR.", 3, new String[]{String.valueOf((Object)this.configuration.getLogLevel())}, 0, new String[]{"Debug", "Information", "Warnings", "Error"}, new String[]{"4", "3", "2", "1"}));
        adList.add(new AttributeDefinitionImpl("ds.factory.enabled", "Extended Factory Components", "Whether or not to enable the support for creating Factory Component instances based on factory configuration. This is an Apache Felix SCR specific extension, explicitly not supported by the Declarative Services specification. Reliance on this feature prevent the component from being used with other Declarative Services implementations. The default value is false to disable this feature.", this.configuration.isFactoryEnabled()));
        adList.add(new AttributeDefinitionImpl("ds.delayed.keepInstances", "Keep Component Instances", "Whether or not to keep instances of delayed components once they are not referred to any more. The Declarative Services specifications suggests that instances of delayed components are disposed off if there is not used any longer. Setting this flag causes the components to not be disposed off and thus prevent them from being constantly recreated if often used. Examples of such components may be EventHandler services. The default is to dispose of unused components.", this.configuration.keepInstances()));
        adList.add(new AttributeDefinitionImpl("ds.lock.timeout.milliseconds", "Lock timeout milliseconds", "How long a lock is held before releasing due to suspected deadlock", 2, new String[]{String.valueOf(this.configuration.lockTimeout())}, 0, null, null));
        adList.add(new AttributeDefinitionImpl("ds.stop.timeout.milliseconds", "Stop timeout milliseconds", "How long stopping a bundle is waited for before continuing due to suspected deadlock", 2, new String[]{String.valueOf(this.configuration.stopTimeout())}, 0, null, null));
        adList.add(new AttributeDefinitionImpl("ds.global.extender", "Global Extender", "Whether to extend all bundles whether or not visible to this bundle.", false));
        return new ObjectClassDefinition(){
            private final AttributeDefinition[] attrs;
            {
                this.attrs = adList.toArray(new AttributeDefinition[adList.size()]);
            }

            public String getName() {
                return "Apache Felix Declarative Service Implementation";
            }

            public InputStream getIcon(int arg0) {
                return null;
            }

            public String getID() {
                return "org.apache.felix.scr.ScrService";
            }

            public String getDescription() {
                return "Configuration for the Apache Felix Declarative Services Implementation. This configuration overwrites configuration defined in framework properties of the same names.";
            }

            public AttributeDefinition[] getAttributeDefinitions(int filter) {
                return filter == 2 ? null : this.attrs;
            }
        };
    }

    private static class AttributeDefinitionImpl
    implements AttributeDefinition {
        private final String id;
        private final String name;
        private final String description;
        private final int type;
        private final String[] defaultValues;
        private final int cardinality;
        private final String[] optionLabels;
        private final String[] optionValues;

        AttributeDefinitionImpl(String id, String name, String description, boolean defaultValue) {
            this(id, name, description, 11, new String[]{String.valueOf(defaultValue)}, 0, null, null);
        }

        AttributeDefinitionImpl(String id, String name, String description, int type, String[] defaultValues, int cardinality, String[] optionLabels, String[] optionValues) {
            this.id = id;
            this.name = name;
            this.description = description;
            this.type = type;
            this.defaultValues = defaultValues;
            this.cardinality = cardinality;
            this.optionLabels = optionLabels;
            this.optionValues = optionValues;
        }

        public int getCardinality() {
            return this.cardinality;
        }

        public String[] getDefaultValue() {
            return this.defaultValues;
        }

        public String getDescription() {
            return this.description;
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String[] getOptionLabels() {
            return this.optionLabels;
        }

        public String[] getOptionValues() {
            return this.optionValues;
        }

        public int getType() {
            return this.type;
        }

        public String validate(String arg0) {
            return null;
        }
    }
}

