/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.config;

import amazon.fws.clicommando.exceptions.ConfigurationErrorException;
import amazon.fws.clicommando.util.StringUtils;

public class MapKeyConfig {
    private String name;
    private String translation;
    private boolean required;

    public MapKeyConfig(String name, String translation, String requiredString) {
        this.name = name;
        this.translation = translation;
        this.required = StringUtils.toBoolean(requiredString);
        this.isValid();
    }

    private void isValid() {
        if (this.name == null) {
            throw new ConfigurationErrorException("Null name is not allowed for a map key" + this);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getTranslation() {
        return this.translation;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MapKeyConfig other = (MapKeyConfig)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }
}

