#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Warcraft 3
###

script_version=20231017.1

PLAYIT_COMPATIBILITY_LEVEL='2.27'

GAME_ID='warcraft-3'
GAME_NAME='Warcraft Ⅲ: Reign of Chaos'

## This DRM-free archive is no longer available for download,
## as Blizzard would rather have us use their new DRM-infested build.
ARCHIVE_BASE_0_NAME='Installer Tome.mpq'
ARCHIVE_BASE_0_MD5='dd5926d8bb6ed10c47617bbc69b0ce1a'
ARCHIVE_BASE_0_SIZE='780000'
ARCHIVE_BASE_0_VERSION='1.27-blizzard1'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_BIN_PATH='PC'
CONTENT_GAME_BIN_FILES='
redist
blizzard.ax
*.dll
*.exe'
CONTENT_GAME_DATA_PATH='Common'
CONTENT_GAME_DATA_FILES='
Maps
Movies
*.mpq'

USER_PERSISTENT_DIRECTORIES='
Campaigns
Maps
Replay
Save'

APP_MAIN_EXE='Warcraft III.exe'
APP_MAIN_OPTIONS='-opengl'
APP_MAIN_ICON='PC/War3.exe'
APP_MAIN_ICON_WRESTOOL_OPTIONS='--type=14 --name=WAR3.ICO'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID"

# Set the list of requirements to extract the archive contents.

SCRIPT_DEPS="${SCRIPT_DEPS:-} smpq"

## FIXME: This game can get display issues on some resolutions, when run on Wayland without using a virtual desktop.

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Check for the presence of required extra archives

## Check for the presence of the CD key files.
## See notes/warcraft-3 for details on how to get these files.
ARCHIVE_REQUIRED_CDKEY_1_NAME='font.clh'
ARCHIVE_REQUIRED_CDKEY_2_NAME='font.gid'
archive_initialize_required \
	'ARCHIVE_CDKEY_1' \
	'ARCHIVE_REQUIRED_CDKEY_1'
archive_initialize_required \
	'ARCHIVE_CDKEY_2' \
	'ARCHIVE_REQUIRED_CDKEY_2'

# Extract game data

archive_path=$(archive_path $(current_archive))
archive_path_cdkey_1=$(archive_path 'ARCHIVE_CDKEY_1')
archive_path_cdkey_2=$(archive_path 'ARCHIVE_CDKEY_2')
mkdir --parents "${PLAYIT_WORKDIR}/gamedata"
information_archive_data_extraction "$archive_path"
(
	cd "${PLAYIT_WORKDIR}/gamedata"
	smpq --extract "$archive_path"

	## Update .mpq file
	(
		cd 'PC-100'
		smpq --append ../Common/War3.mpq *
	)
	(
		cd 'Files'
		cp --dereference \
			"$archive_path_cdkey_1" \
			"$archive_path_cdkey_2" \
			'font'
		smpq --append ../Common/War3.mpq \
			font/font.ccd \
			font/font.clh \
			font/font.gid
		rm --force --recursive 'font'
	)
)

# Include game data

set_current_package 'PKG_DATA'
icons_inclusion
content_inclusion_default

# Write launchers

set_current_package 'PKG_BIN'
launchers_write

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
