#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2021 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# L'Amerzone
# send your bug reports to contact@dotslashplay.it
###

script_version=20240516.1

PLAYIT_COMPATIBILITY_LEVEL='2.28'

GAME_ID='amerzone'
GAME_NAME='LʼAmerzone'

ARCHIVE_BASE_EN_0_NAME='setup_amerzone_2.0.0.8.exe'
ARCHIVE_BASE_EN_0_MD5='f6be5dbae76289bfdb58eef01913f85e'
ARCHIVE_BASE_EN_0_TYPE='innosetup'
ARCHIVE_BASE_EN_0_SIZE='2000000'
ARCHIVE_BASE_EN_0_VERSION='1.0-gog2.0.0.8'
ARCHIVE_BASE_EN_0_URL='https://www.gog.com/game/amerzone_the_explorer_legacy'

ARCHIVE_BASE_FR_0_NAME='setup_amerzone_french_2.1.0.10.exe'
ARCHIVE_BASE_FR_0_MD5='00458580b95940b6d7257cfa6ba902b2'
ARCHIVE_BASE_FR_0_TYPE='innosetup'
ARCHIVE_BASE_FR_0_SIZE='2000000'
ARCHIVE_BASE_FR_0_VERSION='1.0-gog2.1.0.10'
ARCHIVE_BASE_FR_0_URL='https://www.gog.com/game/amerzone_the_explorer_legacy'

CONTENT_PATH_DEFAULT='app'
CONTENT_GAME_BIN_FILES='
*.dll
*.exe
launch'
CONTENT_GAME_L10N_FILES='
splash
??vr_*/*.ifo
??vr_*/acces_base.vr
??vr_*/avion.vr
??vr_*/bark.vr
??vr_*/carnet.vr
??vr_*/changelevel.vr
??vr_*/chapter?.vr
??vr_*/chklist.vr
??vr_*/coordonnees.vr
??vr_*/credits.vr
??vr_*/disk?.vr
??vr_*/glisseur.vr
??vr_*/grappin.vr
??vr_*/helico.vr
??vr_*/interface.vr
??vr_*/inv_*.vr
??vr_*/inventaire*.vr
??vr_*/lettre*.vr
??vr_*/modes.vr
??vr_*/nocarbu*.vr
??vr_*/oeuf*.vr
??vr_*/options.vr
??vr_*/password.vr
??vr_*/quit.vr
??vr_*/ssmarin.vr
??vr_*/testament.vr
??vr_*/voilier.vr
01vr_phare/sc01_a.smk
01vr_phare/scene01.smk
01vr_phare/scene03.smk
02vr_ile/sc14.smk
02vr_ile/sc15.smk
02vr_ile/sc16.smk
03vr_pueblo/scene23.smk
03vr_pueblo/scene26.smk
03vr_pueblo/scene27.smk
05vr_villagemarais/sc41.smk
01vr_phare/warp214.vr
02vr_ile/warp321.vr
03vr_pueblo/warp404.vr
03vr_pueblo/warp410.vr
04vr_fleuve/warp518a.vr
04vr_fleuve/warp519a.vr
05vr_villagemarais/warp734.vr
01vr_phare/museum.wav
05vr_villagemarais/indian8.wav
05vr_villagemarais/indian9.wav
05vr_villagemarais/indian10.wav'
CONTENT_GAME_DATA_FILES='
*.dat
*.ico
*.pak
*.smk
*.tst
*.vr
??vr_*'
CONTENT_DOC_L10N_FILES='
*.pdf'

USER_PERSISTENT_FILES='
Saved_*.bin'

WINE_VIRTUAL_DESKTOP='auto'

APP_MAIN_EXE='amerzone.exe'

PACKAGES_LIST='
PKG_BIN
PKG_L10N
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_L10N_ID="${GAME_ID}-l10n"
PKG_L10N_ID_EN="${PKG_L10N_ID}-en"
PKG_L10N_ID_FR="${PKG_L10N_ID}-fr"
PKG_L10N_PROVIDES="
$PKG_L10N_ID"
PKG_L10N_DESCRIPTION_EN='English localization'
PKG_L10N_DESCRIPTION_FR='French localization'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID $PKG_L10N_ID"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
