#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# To The Moon
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220720.1

GAME_ID='to-the-moon'
GAME_NAME='To The Moon'

ARCHIVE_BASE_0='ToTheMoon_linux_1389114090.sh'
ARCHIVE_BASE_0_MD5='706a5c9467328438d412370ffb1454de'
ARCHIVE_BASE_0_TYPE='mojosetup'
ARCHIVE_BASE_0_SIZE='93000'
ARCHIVE_BASE_0_VERSION='1.0-humble1'
ARCHIVE_BASE_0_URL='https://www.humblebundle.com/store/to-the-moon'

CONTENT_PATH_DEFAULT='data/noarch'
ARCHIVE_DOC_DATA_FILES='
*.txt'
ARCHIVE_GAME_DATA_FILES='
*'
ARCHIVE_GAME_BIN32_PATH="${CONTENT_PATH_DEFAULT}/../x86"
ARCHIVE_GAME_BIN32_FILES='
*'
ARCHIVE_GAME_BIN64_PATH="${CONTENT_PATH_DEFAULT}/../x86_64"
ARCHIVE_GAME_BIN64_FILES='
*'

APP_MAIN_TYPE='native'
APP_MAIN_PREFIX_TYPE='none'
APP_MAIN_EXE_BIN32='ToTheMoon.bin.x86'
APP_MAIN_EXE_BIN64='ToTheMoon.bin.x86_64'
APP_MAIN_ICON='ToTheMoon.png'

PACKAGES_LIST='PKG_BIN32 PKG_BIN64 PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN32_ARCH='32'
PKG_BIN32_DEPS="$PKG_DATA_ID libGL.so.1 libSDL2-2.0.so.0 freetype alsa"

PKG_BIN64_ARCH='64'
PKG_BIN64_DEPS="$PKG_BIN32_DEPS"

# Load common functions

target_version='2.17'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Include game icon

PKG='PKG_DATA'
icons_inclusion

# Include game data

prepare_package_layout

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

for PKG in 'PKG_BIN32' 'PKG_BIN64'; do
	launchers_write
done

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
