#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2019 BetaRays
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Q.U.B.E. 2
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220710.1

GAME_ID='qube-2'
GAME_NAME='Q.U.B.E. 2'

ARCHIVE_BASE_1='setup_q.u.b.e._2_1.8_(64bit)_(33108).exe'
ARCHIVE_BASE_1_MD5='38e53c42845f1ea44ca2939d2d48571b'
ARCHIVE_BASE_1_TYPE='innosetup'
ARCHIVE_BASE_1_PART1='setup_q.u.b.e._2_1.8_(64bit)_(33108)-1.bin'
ARCHIVE_BASE_1_PART1_MD5='838dbb204cd6eca9488d502ec16f28d0'
ARCHIVE_BASE_1_PART1_TYPE='innosetup'
ARCHIVE_BASE_1_SIZE='3800000'
ARCHIVE_BASE_1_VERSION='1.8-gog33108'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/qube_2'

ARCHIVE_BASE_0='setup_q.u.b.e._2_1.6_with_overlay_(64bit)_(23818).exe'
ARCHIVE_BASE_0_MD5='b62f5e18bff2e9abcb591e1921538989'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1='setup_q.u.b.e._2_1.6_with_overlay_(64bit)_(23818)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='7a397b6e7c20a13c00af2ee964952609'
ARCHIVE_BASE_0_PART1_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='3700000'
ARCHIVE_BASE_0_VERSION='1.6-gog23818'

CONTENT_PATH_DEFAULT='.'
ARCHIVE_GAME_BIN_FILES='
qube/binaries
qube/plugins
engine'
ARCHIVE_GAME_DATA_FILES='
qube/content'

APP_MAIN_TYPE='wine'
APP_MAIN_EXE='qube/binaries/win64/qube-win64-shipping.exe'
APP_MAIN_ICON='qube/binaries/win64/qube-win64-shipping.exe'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID wine libGL.so.1 libopenal.so.1"
PKG_BIN_POSTINST_RUN_GENTOO='
ewarn "You might need to compile wine with the openal or faudio USE flag"'

# Load common functions

target_version='2.16'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

case "$OPTION_PACKAGE" in
	('gentoo'|'egentoo')
		PKG_BIN_POSTINST_RUN="$PKG_BIN_POSTINST_RUN_GENTOO"
	;;
esac

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'
prepare_package_layout

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Include game icon

PKG='PKG_BIN'
icons_get_from_package 'APP_MAIN'
icons_move_to 'PKG_DATA'

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
