#!/bin/sh
set -o errexit

###
# Copyright (c) 2015-2021, Antoine Le Gonidec <vv221@dotslashplay.it>
# Copyright (c) 2016-2021, Mopi
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# 1. Redistributions of source code must retain the above copyright notice,
# this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright notice,
# this list of conditions and the following disclaimer in the documentation
# and/or other materials provided with the distribution.
#
# This software is provided by the copyright holders and contributors "as is"
# and any express or implied warranties, including, but not limited to, the
# implied warranties of merchantability and fitness for a particular purpose
# are disclaimed. In no event shall the copyright holder or contributors be
# liable for any direct, indirect, incidental, special, exemplary, or
# consequential damages (including, but not limited to, procurement of
# substitute goods or services; loss of use, data, or profits; or business
# interruption) however caused and on any theory of liability, whether in
# contract, strict liability, or tort (including negligence or otherwise)
# arising in any way out of the use of this software, even if advised of the
# possibility of such damage.
###

###
# Little Nightmares 1
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20210501.4

# Set game-specific variables

GAME_ID='little-nightmares-1'
GAME_NAME='Little Nightmares 1'

ARCHIVES_LIST='
ARCHIVE_BASE_0'

ARCHIVE_BASE_0='setup_little_nightmares_1.0.43.1_(18471).exe'
ARCHIVE_BASE_0_MD5='6e1ac1107650aeb03abc17cf0e614e4c'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1='setup_little_nightmares_1.0.43.1_(18471)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='0732121bf0da7db6dc6f5e5a3bc8705b'
ARCHIVE_BASE_0_PART1_TYPE='innosetup'
ARCHIVE_BASE_0_VERSION='1.0.43.1-gog18471'
ARCHIVE_BASE_0_SIZE='9500000'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/little_nightmares'

ARCHIVE_GAME_BIN_PATH='.'
ARCHIVE_GAME_BIN_FILES='atlas/binaries engine'

ARCHIVE_GAME_DATA_PATH='.'
ARCHIVE_GAME_DATA_FILES='atlas/content'

APP_MAIN_TYPE='wine'
APP_MAIN_EXE='atlas/binaries/win64/littlenightmares.exe'
APP_MAIN_ICON='atlas/binaries/win64/littlenightmares.exe'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID wine"

# Use persistent storage for user data

CONFIG_DIRS="${CONFIG_DIRS} ./atlas/Saved/Config"
DATA_DIRS="${DATA_DIRS} ./atlas/Saved/SaveGames"

# Load common functions

target_version='2.12'

if [ -z "$PLAYIT_LIB2" ]; then
	for path in \
		"$PWD" \
		"${XDG_DATA_HOME:="$HOME/.local/share"}/play.it" \
		'/usr/local/share/games/play.it' \
		'/usr/local/share/play.it' \
		'/usr/share/games/play.it' \
		'/usr/share/play.it'
	do
		if [ -e "$path/libplayit2.sh" ]; then
			PLAYIT_LIB2="$path/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=play.it-2/lib/libplayit2.sh
. "$PLAYIT_LIB2"

# Enable dxvk patches in the WINE prefix

APP_MAIN_PRERUN="$APP_MAIN_PRERUN"'
# Install dxvk on first launch
if [ ! -e dxvk_installed ]; then
	# Wait a bit to ensure there is no lingering wine process
	sleep 1s

	if \
		command -v dxvk-setup >/dev/null 2>&1 && \
		command -v wine-development >/dev/null 2>&1
	then
		dxvk-setup install --development
		touch dxvk_installed
	elif command -v winetricks >/dev/null 2>&1; then
		winetricks dxvk
		touch dxvk_installed
	else
		message="\\033[1;33mWarning:\\033[0m\\n"
		message="${message}DXVK patches could not be installed in the WINE prefix.\\n"
		message="${message}The game might run with display or performance issues.\\n"
		printf "\\n${message}\\n"
	fi

	# Wait a bit to ensure there is no lingering wine process
	sleep 1s
fi'
case "$OPTION_PACKAGE" in
	('deb')
		# Debian-based distributions should use repositories-provided dxvk
		# winetricks is used as a fallback for branches not having access to dxvk-setup
		extra_dependencies='dxvk-wine64-development | winetricks, dxvk | winetricks'
		if [ -n "$PKG_BIN_DEPS_DEB" ]; then
			PKG_BIN_DEPS_DEB="${PKG_BIN_DEPS_DEB}, ${extra_dependencies}"
		else
			PKG_BIN_DEPS_DEB="$extra_dependencies"
		fi
	;;
	(*)
		# Default is to use winetricks
		PKG_BIN_DEPS="${PKG_BIN_DEPS} winetricks"
	;;
esac

# Extract game data

extract_data_from "$SOURCE_ARCHIVE"
prepare_package_layout

# Get icon

PKG='PKG_BIN'
icons_get_from_package 'APP_MAIN'

# Clean up temporary directories

rm --recursive "$PLAYIT_WORKDIR/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write 'APP_MAIN'

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
