#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Anna Lea
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Leisure Suit Larry 6
# send your bug reports to contact@dotslashplay.it
###

script_version=20231123.2

PLAYIT_COMPATIBILITY_LEVEL='2.27'

GAME_ID='leisure-suit-larry-6'
GAME_NAME='Leisure Suit Larry 6: Shape Up Or Slip Out'

ARCHIVE_BASE_SVGA_0_NAME='gog_leisure_suit_larry_6_2.0.0.1.sh'
ARCHIVE_BASE_SVGA_0_MD5='09f667d1230974bd6321bde648de687b'
ARCHIVE_BASE_SVGA_0_SIZE='550000'
ARCHIVE_BASE_SVGA_0_VERSION='1.000.000-gog2.0.0.1'
ARCHIVE_BASE_SVGA_0_URL='https://www.gog.com/game/leisure_suit_larry'

ARCHIVE_BASE_VGA_0_NAME='leisure_suit_larry_6_vga_en_gog_2_20240.sh'
ARCHIVE_BASE_VGA_0_MD5='d5e1973d126bc7750550729cbec4379f'
ARCHIVE_BASE_VGA_0_SIZE='610000'
ARCHIVE_BASE_VGA_0_VERSION='1.000.000-gog20240'
ARCHIVE_BASE_VGA_0_URL='https://www.gog.com/game/leisure_suit_larry'

CONTENT_PATH_DEFAULT='data/noarch/data'
CONTENT_GAME_MAIN_FILES='
AUD
PATCHES
SFX
RESOURCE.*
*.COM
*.DRV
*.ERR
*.EXE
*.HLP
*.SCR
*.TXT
README
VERSION'
CONTENT_DOC_MAIN_PATH='data/noarch/docs'
CONTENT_DOC_MAIN_FILES='
*.pdf'

APP_MAIN_SCUMMID_SVGA='lsl6hires'
APP_MAIN_SCUMMID_VGA='lsl6'
APP_MAIN_ICON='../support/icon.png'

PKG_MAIN_ID="$GAME_ID"
PKG_MAIN_PROVIDES="
$PKG_MAIN_ID"
PKG_MAIN_ID_SVGA="${PKG_MAIN_ID}-svga"
PKG_MAIN_ID_VGA="${PKG_MAIN_ID}-vga"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

icons_inclusion
content_inclusion_default

# Write launchers

launchers_write

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
