#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Mopi
# SPDX-FileCopyrightText: © 2017 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Grim Fandango
# send your bug reports to contact@dotslashplay.it
###

script_version=20230623.1

GAME_ID='grim-fandango'
GAME_NAME='Grim Fandango'

ARCHIVE_BASE_0='gog_grim_fandango_remastered_2.3.0.7.sh'
ARCHIVE_BASE_0_MD5='9c5d124c89521d254b0dc259635b2abe'
ARCHIVE_BASE_0_EXTRACTOR='unzip'
ARCHIVE_BASE_0_SIZE='6100000'
ARCHIVE_BASE_0_VERSION='1.4-gog2.3.0.7'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/grim_fandango_remastered'

CONTENT_PATH_DEFAULT='data/noarch/game/bin'
CONTENT_LIBS_BIN_FILES='
libchore.so
libLua.so'
CONTENT_GAME_BIN_FILES='
GrimFandango
x86'
CONTENT_GAME_MOVIES_FILES='
MoviesHD'
CONTENT_GAME_DATA_FILES='
FontsHD
patch_v2_or_v3_to_v4.bin
patch_v4_to_v5.bin
en_gagl088.lip
icon.png
controllerdef.txt
*.lab
*.LAB
*.tab'
CONTENT_DOC_DATA_FILES='
common-licenses
*License.txt'

USER_PERSISTENT_DIRECTORIES='
Saves'

APP_MAIN_EXE='GrimFandango'
APP_MAIN_ICON='icon.png'

PACKAGES_LIST='PKG_BIN PKG_MOVIES PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_MOVIES_ID="${GAME_ID}-movies"
PKG_MOVIES_DESCRIPTION='movies'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_MOVIES_ID $PKG_DATA_ID"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libgcc_s.so.1
libGL.so.1
libGLU.so.1
libm.so.6
libpthread.so.0
libSDL2-2.0.so.0
libstdc++.so.6
libX11.so.6'

# Work around a game crash on launch
# if it exited without cleaning up its temporary files

APP_MAIN_PRERUN="$APP_MAIN_PRERUN"'
# Work around a game crash on launch
# if it exited without cleaning up its temporary files
rm --force '\''c:\\temp\sector.txt'\'

# Load common functions

target_version='2.23'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# The game binary looks for libSDL2-2.0.so.1 instead of libSDL2-2.0.so.0

case "$OPTION_PACKAGE" in
	('arch')
		library_source='/usr/lib32/libSDL2-2.0.so.0'
	;;
	('deb')
		library_source='/usr/lib/i386-linux-gnu/libSDL2-2.0.so.0'
	;;
	('gentoo'|'egentoo')
		library_source='/usr/lib/libSDL2-2.0.so.0'
	;;
esac
library_destination="$(package_path 'PKG_BIN')$(path_libraries)/libSDL2-2.0.so.1"
mkdir --parents "$(dirname "$library_destination")"
ln --symbolic "$library_source" "$library_destination"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Include game icons

PKG='PKG_DATA'
icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build packages

write_metadata
build_pkg

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
