#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Frail Hearts
# send your bug reports to contact@dotslashplay.it
###

script_version=20230706.1

GAME_ID='frail-hearts'
GAME_NAME='Frail Hearts: Versicorae Domlion'

ARCHIVE_BASE_0='setup_frail_hearts_versicorae_domlion_1.1.1gog_(62511).exe'
ARCHIVE_BASE_0_MD5='0079a30ca10ed1eecc3ca0676c6134f8'
ARCHIVE_BASE_0_EXTRACTOR='innoextract'
## Do not convert file names to lowercase
ARCHIVE_BASE_0_EXTRACTOR_OPTIONS=' '
ARCHIVE_BASE_0_SIZE='610000'
ARCHIVE_BASE_0_VERSION='1.1.1-gog62511'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/frail_hearts_versicorae_domlion'

CONTENT_PATH_DEFAULT='www'
CONTENT_GAME_MAIN_FILES='
audio
data
fonts
icon
img
js
lib
locales
movies
save
www
index.html
translationengine.html
greenworks.js
package.json
steam_appid.txt.txt'

APPLICATIONS_LIST='APP_MAIN'

APP_MAIN_ICON='icon/icon.png'

PKG_MAIN_DEPS_ARCH='firefox python'
PKG_MAIN_DEPS_DEB='firefox-esr | firefox, python3-minimal, libpython3-stdlib'
PKG_MAIN_DEPS_GENTOO='|| ( www-client/firefox www-client/firefox-bin ) dev-lang/python'

# Load common functions

target_version='2.24'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Include game icons

PKG='PKG_DATA'
icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

launcher_path=$(launcher_path 'APP_MAIN')
mkdir --parents "$(dirname "$launcher_path")"
{
	launcher_headers
	cat <<- EOF
	# Set the environment

	GAME_ID='$(game_id)'
	PATH_GAME='$(path_game_data)'

	EOF
	launcher_prefix_symlinks_functions
	launcher_prefix_symlinks_build
	cat <<- 'EOF'
	cd "$PATH_PREFIX"

	# Start local Web server
	WEB_HOST='localhost'
	WEB_PORT='8000'
	python3 -m http.server \
	    --directory "$PWD" \
	    --bind "$WEB_HOST" "$WEB_PORT" &
	WEB_PID=$!

	# Open URL from local Web server
	(
	    # Use a custom $HOME path, to avoid messing up with the user Firefox profiles
	    export HOME="${PATH_PREFIX}/home"
	    mkdir --parents "$HOME"

	    WEB_PATH='/index.html'
	    WEB_URL="http://${WEB_HOST}:${WEB_PORT}${WEB_PATH}"
	    firefox -CreateProfile "$PREFIX_ID ${PWD}/firefox"
	    firefox -kiosk -no-remote -profile "${PWD}/firefox" "$@" "$WEB_URL"
	)

	# Stop local Web server
	kill -s TERM $WEB_PID

	EOF
	launcher_exit
} | sed 's/    /\t/g' > "$launcher_path"
chmod 755 "$launcher_path"
launcher_write_desktop 'APP_MAIN'

# Build packages

packages_generation

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
