#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2016 Antoine Le Gonidec <vv221@dotslahsplay.it>
# SPDX-FileCopyrightText: © 2020 Mopi
set -o errexit

###
# Divine Divinity
# send your bug reports to contact@dotslashplay.it
###

script_version=20230330.2

GAME_ID='divine-divinity'
GAME_NAME='Divine Divinity'

ARCHIVES_LIST='
ARCHIVE_BASE_EN_0
ARCHIVE_BASE_FR_0'

ARCHIVE_BASE_EN_0='setup_divine_divinity_2.0.0.21.exe'
ARCHIVE_BASE_EN_0_MD5='3798d48f04a7a8444fd9f4c32b75b41d'
ARCHIVE_BASE_EN_0_TYPE='innosetup'
ARCHIVE_BASE_EN_0_SIZE='2400000'
ARCHIVE_BASE_EN_0_VERSION='1.0062a-gog2.0.0.21'
ARCHIVE_BASE_EN_0_URL='https://www.gog.com/game/divine_divinity'

ARCHIVE_BASE_FR_0='setup_divine_divinity_french_2.1.0.32.exe'
ARCHIVE_BASE_FR_0_MD5='f755d69ad7d319fb70298844dcb3861a'
ARCHIVE_BASE_FR_0_TYPE='innosetup'
ARCHIVE_BASE_FR_0_SIZE='2400000'
ARCHIVE_BASE_FR_0_VERSION='1.0062a-gog2.1.0.32'
ARCHIVE_BASE_FR_0_URL='https://www.gog.com/game/divine_divinity'

CONTENT_PATH_DEFAULT='app'
CONTENT_GAME_BIN_FILES='
*.dll
*.exe
sound.cfg
secdrv.sys'
CONTENT_GAME_L10N_FILES='
localizations
dat/english
dat/french
config.lcl'
CONTENT_GAME_DATA_FILES='
capture
dat
fonts
global
main
sound
static
divinityevent.dat
testimage.tga
keylist.txt'
CONTENT_DOC_DATA_FILES='
*.pdf'

USER_PERSISTENT_DIRECTORIES='
dynamic
global
savegames'
USER_PERSISTENT_FILES='
config.div
config.lcl
keylist.txt
dat/usernotes.bin
static/*.000
static/imagelists/collide.*
*.cfg
*.000
persist.dat'

APP_MAIN_EXE='div.exe'

APP_CONFIG_ID="${GAME_ID}_configuration"
APP_CONFIG_NAME="${GAME_NAME} - Configuration"
APP_CONFIG_CAT='Settings'
APP_CONFIG_EXE='configtool.exe'

PACKAGES_LIST='PKG_BIN PKG_L10N PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_L10N_ID="${GAME_ID}-l10n"
PKG_L10N_ID_EN="${PKG_L10N_ID}-en"
PKG_L10N_ID_FR="${PKG_L10N_ID}-fr"
PKG_L10N_PROVIDES="
$PKG_L10N_ID"
PKG_L10N_DESCRIPTION_EN='English localization'
PKG_L10N_DESCRIPTION_FR='French localization'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID $PKG_L10N_ID"

# Load common functions

target_version='2.23'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Include game icons

PKG='PKG_DATA'
icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build packages

write_metadata
build_pkg

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
