#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Bear With Me
# send your bug reports to contact@dotslashplay.it
###

script_version=20221204.3

GAME_ID='bear-with-me'
GAME_NAME='Bear With Me'

UNITY3D_NAME='bear with me - the lost robots'

ARCHIVE_BASE_0='setup_bear_with_me_the_complete_collection_1.5_(64bit)_(31355).exe'
ARCHIVE_BASE_0_MD5='dc976c102553bfc06edab9fc2de4b1c7'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1='setup_bear_with_me_the_complete_collection_1.5_(64bit)_(31355)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='4e7acd402cd6bfd66c6df053b9a70353'
ARCHIVE_BASE_0_SIZE='4500000'
ARCHIVE_BASE_0_VERSION='1.5-gog31355'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/bear_with_me_the_complete_collection'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_BIN_FILES="
galaxy64.dll
galaxycsharpglue.dll
unityplayer.dll
${UNITY3D_NAME}_data/plugins
${UNITY3D_NAME}_data/mono
${UNITY3D_NAME}.exe"
CONTENT_GAME_DATA_FILES="
art book
ost
${UNITY3D_NAME}_data"

APP_MAIN_TYPE='wine'
APP_MAIN_EXE="${UNITY3D_NAME}.exe"
APP_MAIN_ICON="${UNITY3D_NAME}.exe"

APP_WINE_LINK_DIRS='
userdata:users/${USER}/AppData/LocalLow/Exordium Games/Bear With Me - The Lost Robots'
USER_PERSISTENT_FILES='
userdata/*.save'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID"

# Load common functions

target_version='2.18'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Include game icons

PKG='PKG_DATA'
icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build package

write_metadata
build_pkg

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
