#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Arcanum
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220712.1

GAME_ID='arcanum'
GAME_NAME='Arcanum: Of Steamworks and Magick Obscura'

ARCHIVE_BASE_2='setup_arcanum_-_of_steamworks_and_magick_obscura_1.0.7.4_hotfix_(24155).exe'
ARCHIVE_BASE_2_MD5='6d14d07f7cc8c9823cba5322cf2336f4'
ARCHIVE_BASE_2_TYPE='innosetup'
ARCHIVE_BASE_2_SIZE='1200000'
ARCHIVE_BASE_2_VERSION='1.0.7.4-gog24155'
ARCHIVE_BASE_2_URL='https://www.gog.com/game/arcanum_of_steamworks_and_magick_obscura'

ARCHIVE_BASE_1='setup_arcanum_-_of_steamworks_and_magick_obscura_1.0.7.4_(19476).exe'
ARCHIVE_BASE_1_MD5='298a3315baebf40f3cc6cee4acae9947'
ARCHIVE_BASE_1_TYPE='innosetup'
ARCHIVE_BASE_1_SIZE='1200000'
ARCHIVE_BASE_1_VERSION='1.0.7.4-gog19476'

ARCHIVE_BASE_0='setup_arcanum_2.0.0.15.exe'
ARCHIVE_BASE_0_MD5='c09523c61edd18abb97da97463e07a88'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='1200000'
ARCHIVE_BASE_0_VERSION='1.0.7.4-gog2.0.0.15'

CONTENT_PATH_DEFAULT='.'
CONTENT_PATH_DEFAULT_0='app'
ARCHIVE_DOC_DATA_FILES='
*.doc
*.htm
*.pdf
*.txt
documents'
ARCHIVE_GAME_BIN_FILES='
*.asi
*.cfg
*.dll
*.exe
*.inf'
ARCHIVE_GAME_DATA_FILES='
*.dat
data
modules'
ARCHIVE_DOC_DATA_PATH="${CONTENT_PATH_DEFAULT}/__support/app"
ARCHIVE_DOC_DATA_FILES='
eula.*'

APP_MAIN_TYPE='wine'
APP_MAIN_EXE='arcanum.exe'
APP_MAIN_ICON="${CONTENT_PATH_DEFAULT}/arcanum.exe"
APP_MAIN_ICON_0="${CONTENT_PATH_DEFAULT_0}/arcanum.exe"

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ID="$GAME_ID"
PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID wine"

# Disable 3D acceleration
# cf. https://bugs.winehq.org/show_bug.cgi?id=23676 - Arcanum essentially unusable due to graphics errors

APP_MAIN_OPTIONS="$APP_MAIN_OPTIONS -no3d"

# In some archives, the game binary is compressed using UPX

SCRIPT_DEPS='upx'

# Use persistent storage for user data

DATA_DIRS='data modules/arcanum/maps modules/arcanum/saves'
DATA_FILES='*.cfg'

# Set up a WINE virtual desktop on first launch, using the current desktop resolution

PKG_BIN_DEPS="$PKG_BIN_DEPS winetricks xrandr sed"
sed_expression='s/.*primary.* ([0-9]+x[0-9]+).*/\1/p'
sed_options="--regexp-extended --silent --expression='$sed_expression'"
APP_WINETRICKS="$APP_WINETRICKS vd=\$(LANG=C xrandr | sed $sed_options)"

# Load common functions

target_version='2.16'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Decompress UPX-packed game binary

## application_exe fails if PKG is not explicitely set
## cf. https://forge.dotslashplay.it/play.it/scripts/-/issues/322
PKG='PKG_BIN'

content_path=$(content_path_default)
application_exe=$(application_exe 'APP_MAIN')
binary_file="${PLAYIT_WORKDIR}/gamedata/${content_path}/${application_exe}"
if upx -t "$binary_file" >/dev/null 2>&1; then
	upx -d "$binary_file" >/dev/null
fi

# Include game icon

PKG='PKG_DATA'
icons_get_from_workdir 'APP_MAIN'

# Include game data

prepare_package_layout

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
