#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2016 Antoine Le Gonidec <vv221@dotslashplay.it>
# SPDX-FileCopyrightText: © 2017 Mopi
set -o errexit

###
# Zork series:
# - Zork 1: The Great Underground Empire
# - Zork 2: The Wizard of Frobozz
# - Zork 3: The Dungeon Master
# send your bug reports to contact@dotslashplay.it
###

script_version=20250115.1

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID_EPISODE1='zork-1'
GAME_ID_EPISODE2='zork-2'
GAME_ID_EPISODE3='zork-3'
GAME_NAME_EPISODE1='Zork I: The Great Underground Empire'
GAME_NAME_EPISODE2='Zork II: The Wizard of Frobozz'
GAME_NAME_EPISODE3='Zork III: The Dungeon Master'

ARCHIVE_BASE_EPISODE1_1_NAME='setup_zork_-_the_great_underground_empire_.88.84_(28046).exe'
ARCHIVE_BASE_EPISODE1_1_MD5='b527cb53e2213f13527eb9898aeab8f7'
ARCHIVE_BASE_EPISODE1_1_TYPE='innosetup'
ARCHIVE_BASE_EPISODE1_1_SIZE='17380'
ARCHIVE_BASE_EPISODE1_1_VERSION='88.84-gog28046'
ARCHIVE_BASE_EPISODE1_1_URL='https://www.gog.com/game/the_zork_anthology'

ARCHIVE_BASE_EPISODE1_0_NAME='setup_zork_2.1.0.17.exe'
ARCHIVE_BASE_EPISODE1_0_MD5='6bd42788d696f154ce363830909259d3'
ARCHIVE_BASE_EPISODE1_0_TYPE='innosetup'
ARCHIVE_BASE_EPISODE1_0_SIZE='22000'
ARCHIVE_BASE_EPISODE1_0_VERSION='1.0-gog2.1.0.17'

ARCHIVE_BASE_EPISODE2_1_NAME='setup_zork_ii_-_the_wizard_of_frobozz_48.84_(28046).exe'
ARCHIVE_BASE_EPISODE2_1_MD5='de2bbc96fc55c9e1f9bc633be3e762de'
ARCHIVE_BASE_EPISODE2_1_TYPE='innosetup'
ARCHIVE_BASE_EPISODE2_1_SIZE='18803'
ARCHIVE_BASE_EPISODE2_1_VERSION='48.84-gog28046'
ARCHIVE_BASE_EPISODE2_1_URL='https://www.gog.com/game/the_zork_anthology'

ARCHIVE_BASE_EPISODE2_0_NAME='setup_zork2_2.1.0.17.exe'
ARCHIVE_BASE_EPISODE2_0_MD5='2ea2cf45bb6cf76b0365567e81f27aab'
ARCHIVE_BASE_EPISODE2_0_TYPE='innosetup'
ARCHIVE_BASE_EPISODE2_0_SIZE='23000'
ARCHIVE_BASE_EPISODE2_0_VERSION='1.0-gog2.1.0.17'

ARCHIVE_BASE_EPISODE3_1_NAME='setup_zork_iii_-_the_dungeon_master_17.84_(28046).exe'
ARCHIVE_BASE_EPISODE3_1_MD5='eb899dd8def253f89cf6d66c2cee7dcf'
ARCHIVE_BASE_EPISODE3_1_TYPE='innosetup'
ARCHIVE_BASE_EPISODE3_1_SIZE='18366'
ARCHIVE_BASE_EPISODE3_1_VERSION='17.84-gog28046'
ARCHIVE_BASE_EPISODE3_1_URL='https://www.gog.com/game/the_zork_anthology'

ARCHIVE_BASE_EPISODE3_0_NAME='setup_zork3_2.1.0.17.exe'
ARCHIVE_BASE_EPISODE3_0_MD5='1526e9be21bf47412dc053f4097e25bd'
ARCHIVE_BASE_EPISODE3_0_TYPE='innosetup'
ARCHIVE_BASE_EPISODE3_0_SIZE='23000'
ARCHIVE_BASE_EPISODE3_0_VERSION='1.0-gog2.1.0.17'

CONTENT_PATH_DEFAULT='.'
CONTENT_PATH_DEFAULT_0='app'
CONTENT_PATH_DEFAULT_EPISODE1_0="$CONTENT_PATH_DEFAULT_0"
CONTENT_PATH_DEFAULT_EPISODE2_0="$CONTENT_PATH_DEFAULT_0"
CONTENT_PATH_DEFAULT_EPISODE3_0="$CONTENT_PATH_DEFAULT_0"
CONTENT_GAME_MAIN_FILES='
data
save
*.com
*.inf'
CONTENT_DOC_MAIN_FILES='
*.htm
*.pdf
*.txt'

USER_PERSISTENT_DIRECTORIES='
save'

APP_MAIN_EXE_EPISODE1='_zork1.com'
APP_MAIN_EXE_EPISODE2='_zork2.com'
APP_MAIN_EXE_EPISODE3='_zork3.com'
APP_MAIN_ICON_EPISODE1='goggame-1207661493.ico'
APP_MAIN_ICON_EPISODE2='goggame-1207661503.ico'
APP_MAIN_ICON_EPISODE3='goggame-1207661513.ico'

## Easier upgrade from packages generated with pre-20190303.1 scripts
PKG_MAIN_PROVIDES_EPISODE1="${PKG_MAIN_PROVIDES_EPISODE1:-}
zork"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons
content_inclusion_default

# Write launchers

launchers_generation

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
