/* OGMRip - A library for DVD ripping and encoding
 * Copyright (C) 2004-2009 Olivier Rolland <billl@users.sourceforge.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <glib/gi18n.h>
#include <gtk/gtkdialog.h>
#include <glade/glade.h>

#include <ogmrip-plugin.h>
#include <ogmrip-options-plugin.h>
#include <ogmrip-settings.h>
#include <ogmrip-helper.h>
#include <ogmrip-mpeg.h>

#define OGMRIP_GLADE_FILE "ogmrip/ogmrip-mpeg.glade"
#define OGMRIP_GLADE_ROOT "root"

#define OGMRIP_TYPE_MPEG_DIALOG          (ogmrip_mpeg_dialog_get_type ())
#define OGMRIP_MPEG_DIALOG(obj)          (G_TYPE_CHECK_INSTANCE_CAST ((obj), OGMRIP_TYPE_MPEG_DIALOG, OGMRipMpegDialog))
#define OGMRIP_MPEG_DIALOG_CLASS(klass)  (G_TYPE_CHECK_CLASS_CAST ((klass), OGMRIP_TYPE_MPEG_DIALOG, OGMRipMpegDialogClass))
#define OGMRIP_IS_MPEG_DIALOG(obj)       (G_TYPE_CHECK_INSTANCE_TYPE ((obj), OGMRIP_TYPE_MPEG_DIALOG))
#define OGMRIP_IS_MPEG_DIALOG_CLASS(obj) (G_TYPE_CHECK_CLASS_TYPE ((klass), OGMRIP_TYPE_MPEG_DIALOG))

#define OGMRIP_GCONF_MPEG       "mpeg"
#define OGMRIP_MPEG_KEY_FORMAT  OGMRIP_GCONF_MPEG "/" OGMRIP_MPEG_PROP_FORMAT

typedef struct _OGMRipMpegDialog      OGMRipMpegDialog;
typedef struct _OGMRipMpegDialogClass OGMRipMpegDialogClass;

struct _OGMRipMpegDialog
{
  OGMRipPluginDialog parent_instance;

  GtkWidget *format_combo;
};

struct _OGMRipMpegDialogClass
{
  OGMRipPluginDialogClass parent_class;
};

static void ogmrip_mpeg_dialog_set_section (OGMRipPluginDialog *dialog,
                                            const gchar        *section);

G_DEFINE_TYPE (OGMRipMpegDialog, ogmrip_mpeg_dialog, OGMRIP_TYPE_PLUGIN_DIALOG)

static void
ogmrip_mpeg_dialog_class_init (OGMRipMpegDialogClass *klass)
{
  OGMRipPluginDialogClass *dialog_class;

  dialog_class = (OGMRipPluginDialogClass *) klass;
  dialog_class->set_section = ogmrip_mpeg_dialog_set_section;
}

static void
ogmrip_mpeg_dialog_init (OGMRipMpegDialog *dialog)
{
  GtkWidget *widget;
  GladeXML *xml;

  xml = glade_xml_new (OGMRIP_DATA_DIR G_DIR_SEPARATOR_S OGMRIP_GLADE_FILE, OGMRIP_GLADE_ROOT, NULL);
  if (!xml)
  {
    g_warning ("Could not find " OGMRIP_GLADE_FILE);
    return;
  }

  gtk_dialog_add_buttons (GTK_DIALOG (dialog),
      GTK_STOCK_CLOSE, GTK_RESPONSE_CLOSE,
      NULL);
  gtk_window_set_title (GTK_WINDOW (dialog), _("MPEG Options"));
  gtk_window_set_icon_from_stock (GTK_WINDOW (dialog), GTK_STOCK_PREFERENCES);

  widget = glade_xml_get_widget (xml, OGMRIP_GLADE_ROOT);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), widget, TRUE, TRUE, 0);
  gtk_widget_show (widget);

  dialog->format_combo = glade_xml_get_widget (xml, "format-combo");

  g_object_unref (xml);
}

static void
ogmrip_mpeg_dialog_set_section (OGMRipPluginDialog *plugin_dialog, const gchar *section)
{
  OGMRipSettings *settings;

  settings = ogmrip_settings_get_default ();
  if (settings)
  {
    OGMRipMpegDialog *dialog;

    dialog = OGMRIP_MPEG_DIALOG (plugin_dialog);

    ogmrip_settings_bind (settings, section,
        OGMRIP_MPEG_KEY_FORMAT, G_OBJECT (dialog->format_combo), "active");
  }
}

static OGMRipContainerOptionsPlugin mpeg_options_plugin =
{
  NULL,
  G_TYPE_NONE,
  G_TYPE_NONE
};

OGMRipContainerOptionsPlugin *
ogmrip_init_options_plugin (void)
{
#ifdef ENABLE_NLS
  bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);
#endif /* ENABLE_NLS */

  mpeg_options_plugin.type = ogmrip_plugin_get_container_by_name ("mpeg");
  if (mpeg_options_plugin.type == G_TYPE_NONE)
    return NULL;

  mpeg_options_plugin.dialog = OGMRIP_TYPE_MPEG_DIALOG;

  return &mpeg_options_plugin;
}

