include(CheckCXXCompilerFlag)

function(check_cxx_compiler_linker_flag flag out_var)
  set(CMAKE_EXE_LINKER_FLAGS "${CMAKE_EXE_LINKER_FLAGS} ${flag}")
  check_cxx_compiler_flag(${flag} ${out_var})
endfunction()

macro(add_compiler_flag policy name flag)
  check_cxx_compiler_flag(${flag} "CXX_SUPPORTS_${name}")
  if (CXX_SUPPORTS_${name})
    add_definitions(${flag})
  elseif (NOT (${policy} STREQUAL "OPTIONAL"))
    message(FATAL_ERROR "${flag} flag is not supported by ${CMAKE_CXX_COMPILER}")
  endif()
endmacro()

macro(add_compiler_linker_flag policy name flag)
  check_cxx_compiler_linker_flag(${flag} "CXX_SUPPORTS_${name}")
  if (CXX_SUPPORTS_${name})
    set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} ${flag}")
  elseif (NOT (${policy} STREQUAL "OPTIONAL"))
    message(FATAL_ERROR "${flag} flag is not supported by ${CMAKE_CXX_COMPILER}")
  endif()
endmacro()
