/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.util.concurrent.TimeUnit;

public class SimpleTimer {
    protected static final double NANO_TO_SECOND_DOUBLE = 1.0 / (double)TimeUnit.SECONDS.toNanos(1L);
    private final String name;
    private long elapsedTimeNano = 0L;
    private long startTimeNano = 0L;
    private boolean running = false;

    public SimpleTimer() {
        this("Anonymous");
    }

    public SimpleTimer(String name) {
        if (name == null) {
            throw new IllegalArgumentException("SimpleTimer name cannot be null");
        }
        this.name = name;
    }

    public synchronized String getName() {
        return this.name;
    }

    @Ensures(value={"elapsedTimeNano == 0l"})
    public synchronized SimpleTimer start() {
        this.elapsedTimeNano = 0L;
        return this.restart();
    }

    public synchronized SimpleTimer restart() {
        this.running = true;
        this.startTimeNano = this.currentTimeNano();
        return this;
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    public long currentTime() {
        return System.currentTimeMillis();
    }

    public long currentTimeNano() {
        return System.nanoTime();
    }

    @Requires(value={"startTimeNano != 0l"})
    public synchronized SimpleTimer stop() {
        if (this.running) {
            this.running = false;
            this.elapsedTimeNano += this.currentTimeNano() - this.startTimeNano;
        }
        return this;
    }

    public synchronized double getElapsedTime() {
        return SimpleTimer.nanoToSecondsAsDouble(this.getElapsedTimeNano());
    }

    protected static double nanoToSecondsAsDouble(long nano) {
        return (double)nano * NANO_TO_SECOND_DOUBLE;
    }

    public synchronized long getElapsedTimeNano() {
        return this.running ? this.currentTimeNano() - this.startTimeNano + this.elapsedTimeNano : this.elapsedTimeNano;
    }

    public synchronized void addElapsed(SimpleTimer toAdd) {
        this.elapsedTimeNano += toAdd.getElapsedTimeNano();
    }
}

