/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.SAMSequenceRecord;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class GenomeLocSortedSet
extends AbstractSet<GenomeLoc> {
    private static Logger logger = Logger.getLogger(GenomeLocSortedSet.class);
    private GenomeLocParser genomeLocParser;
    private List<GenomeLoc> mArray = new ArrayList<GenomeLoc>();

    public GenomeLocSortedSet(GenomeLocParser parser) {
        this.genomeLocParser = parser;
    }

    public GenomeLocSortedSet(GenomeLocParser parser, GenomeLoc e) {
        this(parser);
        this.add(e);
    }

    public GenomeLocSortedSet(GenomeLocParser parser, Collection<GenomeLoc> l) {
        this(parser);
        for (GenomeLoc e : l) {
            this.add(e);
        }
    }

    public GenomeLocParser getGenomeLocParser() {
        return this.genomeLocParser;
    }

    @Override
    public Iterator<GenomeLoc> iterator() {
        return this.mArray.iterator();
    }

    @Override
    public int size() {
        return this.mArray.size();
    }

    public long coveredSize() {
        long s = 0L;
        for (GenomeLoc e : this) {
            s += (long)e.size();
        }
        return s;
    }

    public long sizeBeforeLoc(GenomeLoc loc) {
        long s = 0L;
        for (GenomeLoc e : this) {
            if (e.isBefore(loc)) {
                s += (long)e.size();
                continue;
            }
            if (e.isPast(loc)) continue;
            s += (long)(loc.getStart() - e.getStart());
        }
        return s;
    }

    @Override
    public boolean isEmpty() {
        return this.mArray.isEmpty();
    }

    public boolean overlaps(GenomeLoc loc) {
        for (GenomeLoc e : this.mArray) {
            if (!e.overlapsP(loc)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean add(GenomeLoc e) {
        if (this.mArray.size() > 0 && e.isPast(this.mArray.get(this.mArray.size() - 1))) {
            this.mArray.add(e);
            return true;
        }
        int loc = Collections.binarySearch(this.mArray, e);
        if (loc >= 0) {
            throw new ReviewedStingException("Genome Loc Sorted Set already contains the GenomicLoc " + e.toString());
        }
        this.mArray.add((loc + 1) * -1, e);
        return true;
    }

    public boolean addRegion(GenomeLoc e) {
        if (e == null) {
            return false;
        }
        boolean haveAdded = false;
        for (GenomeLoc g : this.mArray) {
            if (g.contiguousP(e)) {
                GenomeLoc c = g.merge(e);
                this.mArray.set(this.mArray.indexOf(g), c);
                haveAdded = true;
                continue;
            }
            if (g.getContigIndex() == e.getContigIndex() && e.getStart() < g.getStart() && !haveAdded) {
                this.mArray.add(this.mArray.indexOf(g), e);
                return true;
            }
            if (!haveAdded || e.getContigIndex() <= e.getContigIndex() && (g.getContigIndex() != e.getContigIndex() || e.getStart() <= g.getStart())) continue;
            return true;
        }
        if (!haveAdded) {
            this.mArray.add(e);
        }
        return true;
    }

    public GenomeLocSortedSet subtractRegions(GenomeLocSortedSet toRemoveSet) {
        LinkedList<GenomeLoc> good = new LinkedList<GenomeLoc>();
        Stack<GenomeLoc> toProcess = new Stack<GenomeLoc>();
        Stack<GenomeLoc> toExclude = new Stack<GenomeLoc>();
        toProcess.addAll(this.mArray);
        Collections.reverse(toProcess);
        toExclude.addAll(toRemoveSet.mArray);
        Collections.reverse(toExclude);
        int i = 0;
        while (!toProcess.empty()) {
            GenomeLoc e;
            if (toExclude.empty()) {
                good.addAll(toProcess);
                break;
            }
            GenomeLoc p = (GenomeLoc)toProcess.peek();
            if (p.overlapsP(e = (GenomeLoc)toExclude.peek())) {
                toProcess.pop();
                for (GenomeLoc newP : p.subtract(e)) {
                    toProcess.push(newP);
                }
            } else if (p.compareContigs(e) < 0) {
                good.add((GenomeLoc)toProcess.pop());
            } else if (p.compareContigs(e) > 0) {
                toExclude.pop();
            } else if (p.getStop() < e.getStart()) {
                good.add((GenomeLoc)toProcess.pop());
            } else if (e.getStop() < p.getStart()) {
                toExclude.pop();
            } else {
                throw new ReviewedStingException("BUG: unexpected condition: p=" + p + ", e=" + e);
            }
            if (i++ % 10000 != 0) continue;
            logger.debug((Object)("removeRegions operation: i = " + i));
        }
        return GenomeLocSortedSet.createSetFromList(this.genomeLocParser, good);
    }

    public void remove(GenomeLoc location) {
        if (!this.mArray.contains(location)) {
            throw new IllegalArgumentException("Unable to remove location: " + location + ", not in the list");
        }
        this.mArray.remove(location);
    }

    public static GenomeLocSortedSet createSetFromSequenceDictionary(SAMSequenceDictionary dict) {
        GenomeLocParser parser = new GenomeLocParser(dict);
        GenomeLocSortedSet returnSortedSet = new GenomeLocSortedSet(parser);
        for (SAMSequenceRecord record : dict.getSequences()) {
            returnSortedSet.add(parser.createGenomeLoc(record.getSequenceName(), 1, record.getSequenceLength()));
        }
        return returnSortedSet;
    }

    public static GenomeLocSortedSet createSetFromList(GenomeLocParser parser, List<GenomeLoc> locs) {
        GenomeLocSortedSet set = new GenomeLocSortedSet(parser);
        set.addAll(locs);
        return set;
    }

    public GenomeLocSortedSet clone() {
        GenomeLocSortedSet ret = new GenomeLocSortedSet(this.genomeLocParser);
        for (GenomeLoc loc : this.mArray) {
            ret.mArray.add(this.genomeLocParser.createGenomeLoc(loc.getContig(), loc.getStart(), loc.getStop()));
        }
        return ret;
    }

    public List<GenomeLoc> toList() {
        return this.mArray;
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("[");
        for (GenomeLoc e : this) {
            s.append(" ");
            s.append(e.toString());
        }
        s.append("]");
        return s.toString();
    }
}

