/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.GlobalVariable;
import net.sf.saxon.instruct.LocalVariable;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.style.XSLVariableDeclaration;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceType;

public class XSLVariable
extends XSLVariableDeclaration {
    private int state = 0;

    public void prepareAttributes() throws XPathException {
        if (this.state == 2) {
            return;
        }
        if (this.state == 1) {
            this.compileError("Circular reference to variable", "XTDE0640");
        }
        this.state = 1;
        super.prepareAttributes();
        this.state = 2;
    }

    public boolean isInstruction() {
        return true;
    }

    public SequenceType getRequiredType() {
        SequenceType defaultType;
        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
        SequenceType sequenceType = defaultType = this.requiredType == null ? SequenceType.ANY_SEQUENCE : this.requiredType;
        if (this.assignable) {
            return defaultType;
        }
        if (this.requiredType != null) {
            return this.requiredType;
        }
        if (this.select != null) {
            if (Literal.isEmptySequence(this.select)) {
                return defaultType;
            }
            try {
                return SequenceType.makeSequenceType(this.select.getItemType(th), this.select.getCardinality());
            }
            catch (Exception err) {
                return defaultType;
            }
        }
        if (this.hasChildNodes()) {
            return SequenceType.makeSequenceType(NodeKindTest.DOCUMENT, 16384);
        }
        return SequenceType.SINGLE_STRING;
    }

    public Expression compile(Executable exec) throws XPathException {
        if (this.references.isEmpty() && !this.assignable) {
            this.redundant = true;
        }
        if (!this.redundant) {
            if (this.global) {
                GlobalVariable inst = new GlobalVariable();
                inst.setExecutable(this.getExecutable());
                if (this.select != null) {
                    this.select.setContainer(inst);
                }
                this.initializeInstruction(exec, inst);
                inst.setVariableQName(this.getVariableQName());
                inst.setSlotNumber(this.getSlotNumber());
                inst.setRequiredType(this.getRequiredType());
                this.fixupBinding(inst);
                inst.setContainer(inst);
                this.compiledVariable = inst;
                return inst;
            }
            throw new AssertionError((Object)"Local variable found when compiling a global variable");
        }
        return null;
    }

    public Expression compileLocalVariable(Executable exec) throws XPathException {
        if (this.references.isEmpty() && !this.assignable) {
            this.redundant = true;
        }
        if (!this.redundant) {
            if (this.global) {
                throw new AssertionError((Object)"Global variable found when compiling local variable");
            }
            LocalVariable inst = new LocalVariable();
            inst.setContainer(this);
            if (this.select != null) {
                this.select.setContainer(this);
            }
            this.initializeInstruction(exec, inst);
            inst.setVariableQName(this.getVariableQName());
            inst.setRequiredType(this.getRequiredType());
            return inst;
        }
        return null;
    }
}

