/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.tccl.log;

import java.net.URL;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.PathableClassLoader;
import org.apache.commons.logging.PathableTestSuite;

public class TcclEnabledTestCase
extends TestCase {
    public static final String MY_LOG_PKG = "org.apache.commons.logging.tccl.custom";
    public static final String MY_LOG_IMPL = "org.apache.commons.logging.tccl.custom.MyLog";
    static /* synthetic */ Class class$org$apache$commons$logging$tccl$log$TcclEnabledTestCase;
    static /* synthetic */ Class class$junit$framework$Test;

    public static Test suite() throws Exception {
        Class thisClass = class$org$apache$commons$logging$tccl$log$TcclEnabledTestCase == null ? (class$org$apache$commons$logging$tccl$log$TcclEnabledTestCase = TcclEnabledTestCase.class$("org.apache.commons.logging.tccl.log.TcclEnabledTestCase")) : class$org$apache$commons$logging$tccl$log$TcclEnabledTestCase;
        PathableClassLoader dummy = new PathableClassLoader(null);
        dummy.useExplicitLoader("junit.", (class$junit$framework$Test == null ? (class$junit$framework$Test = TcclEnabledTestCase.class$("junit.framework.Test")) : class$junit$framework$Test).getClassLoader());
        dummy.addLogicalLib("testclasses");
        dummy.addLogicalLib("commons-logging");
        String thisClassPath = thisClass.getName().replace('.', '/') + ".class";
        URL baseUrl = dummy.findResource(thisClassPath);
        PathableClassLoader emptyLoader = new PathableClassLoader(null);
        PathableClassLoader parentLoader = new PathableClassLoader(null);
        parentLoader.useExplicitLoader("junit.", (class$junit$framework$Test == null ? (class$junit$framework$Test = TcclEnabledTestCase.class$("junit.framework.Test")) : class$junit$framework$Test).getClassLoader());
        parentLoader.addLogicalLib("commons-logging");
        parentLoader.addLogicalLib("testclasses");
        parentLoader.useExplicitLoader("org.apache.commons.logging.tccl.custom.", emptyLoader);
        URL propsEnableUrl = new URL(baseUrl, "props_enable_tccl/");
        parentLoader.addURL(propsEnableUrl);
        PathableClassLoader tcclLoader = new PathableClassLoader(parentLoader);
        tcclLoader.addLogicalLib("testclasses");
        Class<?> testClass = parentLoader.loadClass(thisClass.getName());
        return new PathableTestSuite(testClass, tcclLoader);
    }

    public void setUp() throws Exception {
        LogFactory.releaseAll();
    }

    public void tearDown() {
        LogFactory.releaseAll();
    }

    public void testLoader() throws Exception {
        Class<?> clazz;
        ClassLoader thisClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
        ClassLoader tcclLoader = Thread.currentThread().getContextClassLoader();
        Assert.assertNotSame((String)"tccl not same as test classloader", (Object)thisClassLoader, (Object)tcclLoader);
        try {
            clazz = thisClassLoader.loadClass(MY_LOG_IMPL);
            Assert.fail((String)"Unexpectedly able to load MyLog via test class classloader");
            Assert.assertNotNull(clazz);
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
        try {
            clazz = tcclLoader.loadClass(MY_LOG_IMPL);
            Assert.assertNotNull(clazz);
        }
        catch (ClassNotFoundException ex) {
            Assert.fail((String)"Unexpectedly unable to load MyLog via tccl classloader");
        }
    }

    public void testTcclLoading() throws Exception {
        LogFactory instance = LogFactory.getFactory();
        Assert.assertEquals((String)"Correct LogFactory loaded", (String)"org.apache.commons.logging.impl.LogFactoryImpl", (String)instance.getClass().getName());
        Log log = instance.getInstance("test");
        Assert.assertEquals((String)"Correct Log loaded", (String)MY_LOG_IMPL, (String)log.getClass().getName());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

