/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EC2MetadataClient {
    public static final String EC2_METADATA_SERVICE_OVERRIDE = "com.amazonaws.sdk.ec2MetadataServiceEndpointOverride";
    private static final String EC2_METADATA_SERVICE_URL = "http://169.254.169.254";
    public static final String SECURITY_CREDENTIALS_RESOURCE = "/latest/meta-data/iam/security-credentials/";
    private static final Log log = LogFactory.getLog(EC2MetadataClient.class);

    public String getDefaultCredentials() throws IOException {
        String securityCredentialsList = this.readResource(SECURITY_CREDENTIALS_RESOURCE);
        String[] securityCredentials = (securityCredentialsList = securityCredentialsList.trim()).split("\n");
        if (securityCredentials.length == 0) {
            return null;
        }
        String securityCredentialsName = securityCredentials[0];
        return this.readResource(SECURITY_CREDENTIALS_RESOURCE + securityCredentialsName);
    }

    private String readResource(String resourcePath) throws IOException {
        URL url = this.getEc2MetadataServiceUrlForResource(resourcePath);
        log.debug((Object)("Connecting to EC2 instance metadata service at URL: " + url.toString()));
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setConnectTimeout(2000);
        connection.setRequestMethod("GET");
        connection.setDoOutput(true);
        connection.connect();
        return this.readResponse(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readResponse(HttpURLConnection connection) throws IOException {
        InputStream inputStream = connection.getInputStream();
        try {
            int c;
            StringBuilder buffer = new StringBuilder();
            while ((c = inputStream.read()) != -1) {
                buffer.append((char)c);
            }
            String string = buffer.toString();
            return string;
        }
        finally {
            inputStream.close();
        }
    }

    private URL getEc2MetadataServiceUrlForResource(String resourcePath) throws IOException {
        String endpoint = EC2_METADATA_SERVICE_URL;
        if (System.getProperty(EC2_METADATA_SERVICE_OVERRIDE) != null) {
            endpoint = System.getProperty(EC2_METADATA_SERVICE_OVERRIDE);
        }
        return new URL(endpoint + resourcePath);
    }
}

