/*
 * Wrap a Collection, preserving modifications as patches
 *
 * Copyright (C) 2005,2006  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <tagcoll/coll/patched.h>
#include <tests/test-utils.h>
#include <tagcoll/coll/simple.h>

namespace tut {
using namespace std;
using namespace tagcoll;
using namespace tagcoll::tests;
using namespace tagcoll::coll;

struct tagcoll_coll_patched_shar {
};
TESTGRP(tagcoll_coll_patched);

template<> template<>
void to::test<1>()
{
	// Use a Simple as the embedded collection
	Simple<string, string> startcoll;

	Patched< Simple<string, string> > coll(startcoll);

	output_test_collection(inserter(coll));
	test_readonly_collection(coll);
}

template<> template<>
void to::test<2>()
{
	// Use a Simple as the embedded collection
	Simple<string, string> startcoll;

	Patched< Simple<string, string> > coll(startcoll);

	test_collection(coll);
}

}

#include <tagcoll/tests/test-utils.tcc>
#include <tagcoll/coll/patched.tcc>
#include <tagcoll/coll/simple.tcc>

// vim:set ts=4 sw=4:
