for f in $(find -name '*.re'); do
    echo $f
    vfile="${f%.re}.v"
    vtest="$(dirname $vfile)/example.v"

    cat "$vfile" \
        | egrep -v 'warning: rule .*matches empty string \[-Wmatch-empty-string\]' \
        | egrep -v 'warning: tag .* degree of nondeterminism \[-Wnondeterministic-tags\]' \
        > "$vtest"

    # If the autogenerated message appears more than once in the file, then
    # it must have autogenerated header appended at the end. Cut it off.
    msg='// Code generated by re2v, DO NOT EDIT.'
    if [ $(grep -c "$msg" "$vtest") -gt 1 ]; then
        # Get the line of the second message occurrence.
        l=$(grep -n "$msg" "$vtest" | tail -n +2 | cut -d : -f 1)
        # Cut off everything past that line.
        head -n $l "$vtest" > "$vtest".mod && mv "$vtest".mod "$vtest"
    fi

    v run "$vtest" || { echo "*** error ***"; exit 1; }
    rm -f "$vtest"
done

echo "All good."
