'\" t
.\" Copyright 1999 Oracle and/or its affiliates. All rights reserved.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the next
.\" paragraph) shall be included in all copies or substantial portions of the
.\" Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\" LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
.\" FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\"
.TH XkbGetControlsChanges __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbGetControlsChanges \- Updates a local copy of a keyboard description with the 
changes previously noted by one or more calls to XkbNoteControlsChanges
.SH SYNOPSIS
.HP
XkbGetControlsChanges
.BI "(\^Display *" "dpy" "\^,"
.BI "XkbDescPtr " "xkb" "\^,"
.BI "XkbNameChangesPtr " "changes" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I \- dpy
connection to X server
.TP
.I \- xkb
xkb->ctrls will be updated
.TP
.I \- changes
indicates which parts of xkb->ctrls to update
.SH DESCRIPTION
.LP
Whenever a field in the controls structure changes in the server's keyboard 
description, the server sends an XkbControlsNotify event to all interested 
clients.To receive XkbControlsNotify events under all possible conditions, use
.I XkbSelectEvents 
and pass XkbControlsNotifyMask in both 
.I bits_to_change 
and 
.I values_for_bits.

To receive XkbControlsNotify events only under certain conditions, use
.I XkbSelectEventDetails 
using XkbControlsNotify as the 
.I event_type 
and specifying the desired state changes in 
.I bits_to_change 
and 
.I values_for_bits 
using mask bits from Table 1.

Table 1 shows the actual values for the individual mask bits used to select 
controls for 
modification and to enable and disable the control. Note that the same mask bit 
is used to 
specify general modifications to the parameters used to configure the control 
(which), and to 
enable and disable the control (enabled_ctrls). The anomalies in the table (no 
"ok" in column) 
are for controls that have no configurable attributes; and for controls that are 
not boolean 
controls and therefore cannot be enabled or disabled.

.TS
c s s s
l l l l
l l l l
l l l l. 
Table 1 Controls Mask Bits
_
Mask Bit	which or	enabled	Value
	changed_ctrls	_ctrls
_
XkbRepeatKeysMask	ok	ok	(1L<<0)
XkbSlowKeysMask	ok	ok	(1L<<1)
XkbBounceKeysMask	ok	ok	(1L<<2)
XkbStickyKeysMask	ok	ok	(1L<<3)
XkbMouseKeysMask	ok	ok	(1L<<4)
XkbMouseKeysAccelMask	ok	ok	(1L<<5)
XkbAccessXKeysMask	ok	ok	(1L<<6)
XkbAccessXTimeoutMask	ok	ok	(1L<<7)
XkbAccessXFeedbackMask	ok	ok	(1L<<8)
XkbAudibleBellMask		ok	(1L<<9)
XkbOverlay1Mask		ok	(1L<<10)
XkbOverlay2Mask		ok	(1L<<11)
XkbIgnoreGroupLockMask		ok	(1L<<12)
XkbGroupsWrapMask	ok		(1L<<27)
XkbInternalModsMask	ok		(1L<<28)
XkbIgnoreLockModsMask	ok		(1L<<29)
XkbPerKeyRepeatMask	ok		(1L<<30)
XkbControlsEnabledMask	ok		(1L<<31)
XkbAccessXOptionsMask	ok	ok	(XkbStickyKeysMask | 
			XkbAccessXFeedbackMask)
XkbAllBooleanCtrlsMask		ok	(0x00001FFF) 
XkbAllControlsMask	ok		(0xF8001FFF)
.TE

The 
.I changed_ctrls 
field specifies the controls components that have changed and consists of bits 
taken from the masks defined in Table 10.7 with "ok" in the 
.I changed_ctrls 
column.

The controls currently enabled in the server are reported in the 
.I enabled_ctrls 
field. If any controls were just enabled or disabled (that is, the contents of 
the 
.I enabled_ctrls 
field changed), they are flagged in the 
.I enabled_ctrl_changes 
field. The valid bits for these fields are the masks listed in Table 10.7 with 
"ok" in the 
.I enabled_ctrls 
column. The 
.I num_groups 
field reports the number of groups bound to the key belonging to the most number 
of groups and is automatically updated when the keyboard mapping changes.

If the change was caused by a request from a client, the 
.I keycode 
and 
.I event_type 
fields are set to zero and the 
.I req_major 
and 
.I req_minor 
fields identify the request. The 
.I req_major value is the same as the major extension opcode. Otherwise,
.I event_type 
is set to the type of event that caused the change (one of KeyPress, KeyRelease, 
DeviceKeyPress, DeviceKeyRelease, ButtonPress or ButtonRelease), and 
.I req_major 
and 
.I req_minor 
are undefined. If 
.I event_type 
is KeyPress, KeyRelease, DeviceKeyPress, or DeviceKeyRelease, the 
.I keycode 
field is set to the key that caused the change. If 
.I event_type 
is ButtonPress or ButtonRelease, 
.I keycode 
contains the button number. 

When a client receives an XkbControlsNotify event, it can note the changes in a 
changes structure using 
.I XkbNoteControlsChanges.

.I XkbGetControlsChanges 
examines the 
.I changes 
parameter, queries the server for the necessary information, and copies the 
results into the 
.I xkb->ctrls 
keyboard description. If the 
.I ctrls 
field of 
.I xkb 
is NULL, 
.I XkbGetControlsChanges 
allocates and initializes it. To free the 
.I ctrls 
field, use 
XkbFreeControls.

.I XkbGetControlsChanges 
returns Success if successful and can generate BadAlloc, BadImplementation, and 
BadMatch errors.
.SH "RETURN VALUES"
.TP 15
Success
The 
.I XkbGetControlsChanges 
function returns Success if the query of the server was successful.
.SH STRUCTURES
.LP
.nf
The structure for the XkbControlsNotify event is defined as follows:

typedef struct {
    int           type;          /\&* Xkb extension base event code */
    unsigned long serial;        /\&* X server serial number for event */
    Bool          send_event;    /\&* True => synthetically generated */
    Display *     display;       /\&* server connection where event generated */
    Time          time;          /\&* server time when event generated */
    int           xkb_type;      /\&* XkbCompatMapNotify */
    int           device;        /\&* Xkb device ID, will not be XkbUseCoreKbd */
    unsigned int  changed_ctrls; /\&* bits indicating which controls data have changed*/
    unsigned int  enabled_ctrls; /\&* controls currently enabled in server */
    unsigned int  enabled_ctrl_changes; /\&* bits indicating enabled/disabled controls */
    int           num_groups;    /\&* current number of keyboard groups */
    KeyCode       keycode;       /\&* != 0 => keycode of key causing change */
    char          event_type;    /\&* Type of event causing change */
    char          req_major;     /\&* major event code of event causing change */
    char          req_minor;     /\&* minor event code of event causing change */
} XkbControlsNotifyEvent;
.fi
.SH DIAGNOSTICS
.TP 15
.B BadAlloc
Unable to allocate storage
.TP 15
.B BadImplementation
Invalid reply from server
.TP 15
.B BadMatch
A compatible version of Xkb was not available in the server or an argument has 
correct type and range, but is otherwise invalid
.SH "SEE ALSO"
.BR XkbFreeControls (__libmansuffix__),
.BR XkbNoteControlsChanges (__libmansuffix__),
.BR XkbSelectEventDetails (__libmansuffix__),
.BR XkbSelectEvents (__libmansuffix__)
