# Licensed under the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.

import sqlalchemy as sql


def upgrade(migrate_engine):
    meta = sql.MetaData()
    meta.bind = migrate_engine

    failed_auth_count = sql.Column('failed_auth_count', sql.Integer,
                                   nullable=True)
    failed_auth_at = sql.Column('failed_auth_at', sql.DateTime(),
                                nullable=True)
    local_user_table = sql.Table('local_user', meta, autoload=True)
    local_user_table.create_column(failed_auth_count)
    local_user_table.create_column(failed_auth_at)
