/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.registry;

import java.sql.Driver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schemacrawler.exceptions.InternalRuntimeException;
import schemacrawler.tools.registry.BasePluginRegistry;
import us.fatehi.utility.database.DatabaseUtility;
import us.fatehi.utility.property.PropertyName;
import us.fatehi.utility.string.StringFormat;

public class JDBCDriverRegistry
extends BasePluginRegistry {
    private static final Logger LOGGER = Logger.getLogger(JDBCDriverRegistry.class.getName());
    private static JDBCDriverRegistry jdbcDriverRegistrySingleton;
    private final Collection<PropertyName> jdbcDrivers = JDBCDriverRegistry.loadJDBCDrivers();

    public static JDBCDriverRegistry getJDBCDriverRegistry() {
        if (jdbcDriverRegistrySingleton == null) {
            jdbcDriverRegistrySingleton = new JDBCDriverRegistry();
            jdbcDriverRegistrySingleton.log();
        }
        return jdbcDriverRegistrySingleton;
    }

    private static List<PropertyName> loadJDBCDrivers() {
        CopyOnWriteArrayList<PropertyName> availableJDBCDrivers = new CopyOnWriteArrayList<PropertyName>();
        try {
            Collection drivers = DatabaseUtility.getAvailableJdbcDrivers();
            for (Driver driver : drivers) {
                String driverName = driver.getClass().getName();
                LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Found JDBC driver <%s>", new Object[]{driverName}));
                String driverDescription = String.format("%2d.%d", driver.getMajorVersion(), driver.getMinorVersion());
                availableJDBCDrivers.add(new PropertyName(driverName, driverDescription));
            }
        }
        catch (Throwable e) {
            throw new InternalRuntimeException("Could not load JDBC drivers", e);
        }
        Collections.sort(availableJDBCDrivers);
        return availableJDBCDrivers;
    }

    private JDBCDriverRegistry() {
    }

    @Override
    public Collection<PropertyName> getRegisteredPlugins() {
        return new ArrayList<PropertyName>(this.jdbcDrivers);
    }

    @Override
    public String getName() {
        return "JDBC Drivers";
    }
}

