/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.ColumnPartial;
import schemacrawler.crawl.ImmutableColumnReference;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableColumn;
import schemacrawler.crawl.MutableForeignKey;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.RetrievalCounts;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.crawl.RetrieverUtility;
import schemacrawler.crawl.SchemaSetter;
import schemacrawler.crawl.TablePartial;
import schemacrawler.schema.Column;
import schemacrawler.schema.ForeignKeyDeferrability;
import schemacrawler.schema.ForeignKeyUpdateRule;
import schemacrawler.schema.NamedObjectKey;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.InformationSchemaKey;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.Query;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaInfoMetadataRetrievalStrategy;
import schemacrawler.schemacrawler.exceptions.WrappedSQLException;
import schemacrawler.utility.MetaDataUtility;
import us.fatehi.utility.Utility;
import us.fatehi.utility.string.StringFormat;

final class ForeignKeyRetriever
extends AbstractRetriever {
    private static final Logger LOGGER = Logger.getLogger(ForeignKeyRetriever.class.getName());

    ForeignKeyRetriever(RetrieverConnection retrieverConnection, MutableCatalog catalog, SchemaCrawlerOptions options) {
        super(retrieverConnection, catalog, options);
    }

    void retrieveForeignKeys(NamedObjectList<MutableTable> allTables) throws SQLException {
        Objects.requireNonNull(allTables, "No tables provided");
        switch (this.getRetrieverConnection().get(SchemaInfoMetadataRetrievalStrategy.foreignKeysRetrievalStrategy)) {
            case data_dictionary_all: {
                LOGGER.log(Level.INFO, "Retrieving foreign keys, using fast data dictionary retrieval");
                this.retrieveForeignKeysFromDataDictionary();
                break;
            }
            case data_dictionary_over_schemas: {
                LOGGER.log(Level.INFO, "Retrieving foreign keys, using fast data dictionary retrieval over schemas");
                this.retrieveForeignKeysOverSchemas();
                break;
            }
            case metadata: {
                LOGGER.log(Level.INFO, "Retrieving foreign keys");
                this.retrieveForeignKeysFromMetadata(allTables);
                break;
            }
            default: {
                LOGGER.log(Level.INFO, "Not retrieving foreign keys");
            }
        }
    }

    private boolean createForeignKey(MetadataResultSet results, Map<NamedObjectKey, MutableForeignKey> foreignKeys) throws SQLException {
        MutableForeignKey foreignKey;
        String foreignKeyName = results.getString("FK_NAME");
        LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Retrieving foreign key <%s>", new Object[]{foreignKeyName}));
        String pkTableCatalogName = this.normalizeCatalogName(results.getString("PKTABLE_CAT"));
        String pkTableSchemaName = this.normalizeSchemaName(results.getString("PKTABLE_SCHEM"));
        String pkTableName = results.getString("PKTABLE_NAME");
        String pkColumnName = results.getString("PKCOLUMN_NAME");
        String fkTableCatalogName = this.normalizeCatalogName(results.getString("FKTABLE_CAT"));
        String fkTableSchemaName = this.normalizeSchemaName(results.getString("FKTABLE_SCHEM"));
        String fkTableName = results.getString("FKTABLE_NAME");
        String fkColumnName = results.getString("FKCOLUMN_NAME");
        Optional<MutableTable> pkTableOptional = this.lookupTable(pkTableCatalogName, pkTableSchemaName, pkTableName);
        Optional<MutableTable> fkTableOptional = this.lookupTable(fkTableCatalogName, fkTableSchemaName, fkTableName);
        if (!pkTableOptional.isPresent() && !fkTableOptional.isPresent()) {
            return false;
        }
        int keySequence = results.getInt("KEY_SEQ", 0);
        ForeignKeyUpdateRule updateRule = results.getEnumFromId("UPDATE_RULE", ForeignKeyUpdateRule.unknown);
        ForeignKeyUpdateRule deleteRule = results.getEnumFromId("DELETE_RULE", ForeignKeyUpdateRule.unknown);
        ForeignKeyDeferrability deferrability = results.getEnumFromId("DEFERRABILITY", ForeignKeyDeferrability.unknown);
        Column pkColumn = this.lookupOrCreateColumn(pkTableCatalogName, pkTableSchemaName, pkTableName, pkColumnName);
        Column fkColumn = this.lookupOrCreateColumn(fkTableCatalogName, fkTableSchemaName, fkTableName, fkColumnName);
        boolean isPkColumnPartial = pkColumn instanceof ColumnPartial;
        boolean isFkColumnPartial = fkColumn instanceof ColumnPartial;
        if (pkColumn == null || fkColumn == null || isFkColumnPartial && isPkColumnPartial) {
            return false;
        }
        Table fkTable = (Table)fkColumn.getParent();
        Table pkTable = (Table)pkColumn.getParent();
        if (Utility.isBlank((CharSequence)foreignKeyName)) {
            foreignKeyName = RetrieverUtility.constructForeignKeyName(fkTable, pkTable);
            LOGGER.log(Level.CONFIG, (Supplier<String>)new StringFormat("Identifying foreign key with blank name: %s from %s --> %s", new Object[]{foreignKeyName, fkTable, pkTable}));
        }
        NamedObjectKey fkLookupKey = new NamedObjectKey(fkTableCatalogName, fkTableSchemaName, fkTableName, foreignKeyName);
        ImmutableColumnReference columnReference = new ImmutableColumnReference(keySequence, fkColumn, pkColumn);
        Optional<MutableForeignKey> foreignKeyOptional = Optional.ofNullable(foreignKeys.get(fkLookupKey));
        if (foreignKeyOptional.isPresent()) {
            foreignKey = foreignKeyOptional.get();
            foreignKey.addColumnReference(columnReference);
        } else {
            foreignKey = new MutableForeignKey(foreignKeyName, columnReference);
            foreignKeys.put(fkLookupKey, foreignKey);
        }
        foreignKey.withQuoting(this.getRetrieverConnection().getIdentifiers());
        foreignKey.setUpdateRule(updateRule);
        foreignKey.setDeleteRule(deleteRule);
        foreignKey.setDeferrability(deferrability);
        foreignKey.addAttributes(results.getAttributes());
        if (fkColumn instanceof MutableColumn) {
            ((MutableColumn)fkColumn).setReferencedColumn(pkColumn);
            ((MutableTable)fkTable).addForeignKey(foreignKey);
        } else if (isFkColumnPartial) {
            ((ColumnPartial)fkColumn).setReferencedColumn(pkColumn);
            ((TablePartial)fkTable).addForeignKey(foreignKey);
        }
        if (pkColumn instanceof MutableColumn) {
            ((MutableTable)pkTable).addForeignKey(foreignKey);
            return true;
        }
        if (isPkColumnPartial) {
            ((TablePartial)pkTable).addForeignKey(foreignKey);
            return true;
        }
        return false;
    }

    private Column lookupOrCreateColumn(String catalogName, String schemaName, String tableName, String columnName) {
        return RetrieverUtility.lookupOrCreateColumn(this.catalog, catalogName, schemaName, tableName, columnName);
    }

    private void retrieveForeignKeysFromDataDictionary() throws WrappedSQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.FOREIGN_KEYS)) {
            LOGGER.log(Level.FINE, "Extended foreign keys SQL statement was not provided");
            return;
        }
        Query fkSql = informationSchemaViews.getQuery(InformationSchemaKey.FOREIGN_KEYS);
        String name = "foreign keys";
        RetrievalCounts retrievalCounts = new RetrievalCounts("foreign keys");
        HashMap<NamedObjectKey, MutableForeignKey> foreignKeys = new HashMap<NamedObjectKey, MutableForeignKey>();
        try (Connection connection = this.getRetrieverConnection().getConnection("foreign keys");
             Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(fkSql, statement, this.getLimitMap());){
            while (results.next()) {
                retrievalCounts.count();
                boolean added = this.createForeignKey(results, foreignKeys);
                retrievalCounts.countIfIncluded(added);
            }
        }
        catch (SQLException e) {
            throw new WrappedSQLException(String.format("Could not retrieve foreign keys from SQL:%n%s", fkSql), e);
        }
        retrievalCounts.log();
    }

    private void retrieveForeignKeysFromMetadata(NamedObjectList<MutableTable> allTables) throws SQLException {
        try (Connection connection = this.getRetrieverConnection().getConnection("foreign keys from metadata");){
            DatabaseMetaData metaData = connection.getMetaData();
            ConcurrentHashMap<NamedObjectKey, MutableForeignKey> foreignKeys = new ConcurrentHashMap<NamedObjectKey, MutableForeignKey>();
            RetrievalCounts retrievalCounts = new RetrievalCounts("foreign keys");
            for (MutableTable table : allTables) {
                boolean added;
                MetadataResultSet results;
                if (MetaDataUtility.isView(table)) continue;
                try {
                    results = new MetadataResultSet(metaData.getImportedKeys(table.getSchema().getCatalogName(), table.getSchema().getName(), table.getName()), "DatabaseMetaData::getImportedKeys");
                    try {
                        while (results.next()) {
                            retrievalCounts.count();
                            added = this.createForeignKey(results, foreignKeys);
                            retrievalCounts.countIfIncluded(added);
                        }
                    }
                    finally {
                        results.close();
                    }
                }
                catch (SQLException e) {
                    this.logPossiblyUnsupportedSQLFeature((Supplier<String>)new StringFormat("Could not retrieve foreign keys for table <%s>", new Object[]{table}), e);
                }
                try {
                    results = new MetadataResultSet(metaData.getExportedKeys(table.getSchema().getCatalogName(), table.getSchema().getName(), table.getName()), "DatabaseMetaData::getExportedKeys");
                    try {
                        while (results.next()) {
                            retrievalCounts.count();
                            added = this.createForeignKey(results, foreignKeys);
                            retrievalCounts.countIfIncluded(added);
                        }
                    }
                    finally {
                        results.close();
                    }
                }
                catch (SQLException e) {
                    this.logPossiblyUnsupportedSQLFeature((Supplier<String>)new StringFormat("Could not retrieve exported foreign keys for table <%s>", new Object[]{table}), e);
                }
            }
            retrievalCounts.log();
        }
    }

    private void retrieveForeignKeysOverSchemas() throws WrappedSQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.FOREIGN_KEYS)) {
            LOGGER.log(Level.FINE, "Extended foreign keys SQL statement was not provided");
            return;
        }
        Query fkSql = informationSchemaViews.getQuery(InformationSchemaKey.FOREIGN_KEYS);
        HashMap<NamedObjectKey, MutableForeignKey> foreignKeys = new HashMap<NamedObjectKey, MutableForeignKey>();
        String name = "foreign keys";
        RetrievalCounts retrievalCounts = new RetrievalCounts("foreign keys");
        for (Schema schema : this.getAllSchemas()) {
            if (this.catalog.getTables(schema).isEmpty()) continue;
            try (Connection connection = this.getRetrieverConnection().getConnection("foreign keys");
                 SchemaSetter schemaSetter = new SchemaSetter(connection, schema);
                 Statement statement = connection.createStatement();
                 MetadataResultSet results = new MetadataResultSet(fkSql, statement, this.getLimitMap(schema));){
                while (results.next()) {
                    retrievalCounts.count(schema.key());
                    boolean added = this.createForeignKey(results, foreignKeys);
                    retrievalCounts.countIfIncluded(schema.key(), added);
                }
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, e, (Supplier<String>)new StringFormat("Could not retrieve foreign keys for schema <%s>", new Object[]{schema}));
            }
            retrievalCounts.log(schema.key());
        }
        retrievalCounts.log();
    }
}

