/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.store;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiPredicate;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.FileSwitchDirectory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.store.NativeFSLockFactory;
import org.apache.lucene.store.SimpleFSLockFactory;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.util.io.IOUtils;
import org.opensearch.index.IndexModule;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.shard.ShardPath;
import org.opensearch.plugins.IndexStorePlugin;

public class FsDirectoryFactory
implements IndexStorePlugin.DirectoryFactory {
    public static final Setting<LockFactory> INDEX_LOCK_FACTOR_SETTING = new Setting<LockFactory>("index.store.fs.fs_lock", "native", s -> {
        switch (s) {
            case "native": {
                return NativeFSLockFactory.INSTANCE;
            }
            case "simple": {
                return SimpleFSLockFactory.INSTANCE;
            }
        }
        throw new IllegalArgumentException("unrecognized [index.store.fs.fs_lock] \"" + s + "\": must be native or simple");
    }, Setting.Property.IndexScope, Setting.Property.NodeScope);

    @Override
    public Directory newDirectory(IndexSettings indexSettings, ShardPath path) throws IOException {
        Path location = path.resolveIndex();
        LockFactory lockFactory = indexSettings.getValue(INDEX_LOCK_FACTOR_SETTING);
        Files.createDirectories(location, new FileAttribute[0]);
        return this.newFSDirectory(location, lockFactory, indexSettings);
    }

    protected Directory newFSDirectory(Path location, LockFactory lockFactory, IndexSettings indexSettings) throws IOException {
        String storeType = indexSettings.getSettings().get(IndexModule.INDEX_STORE_TYPE_SETTING.getKey(), IndexModule.Type.FS.getSettingsKey());
        IndexModule.Type type = IndexModule.Type.FS.match(storeType) ? IndexModule.defaultStoreType(IndexModule.NODE_STORE_ALLOW_MMAP.get(indexSettings.getNodeSettings())) : IndexModule.Type.fromSettingsKey(storeType);
        HashSet<String> preLoadExtensions = new HashSet<String>((Collection)indexSettings.getValue(IndexModule.INDEX_STORE_PRE_LOAD_SETTING));
        switch (type) {
            case HYBRIDFS: {
                FSDirectory primaryDirectory = FSDirectory.open((Path)location, (LockFactory)lockFactory);
                HashSet<String> nioExtensions = new HashSet<String>((Collection)indexSettings.getValue(IndexModule.INDEX_STORE_HYBRID_NIO_EXTENSIONS));
                if (primaryDirectory instanceof MMapDirectory) {
                    MMapDirectory mMapDirectory = (MMapDirectory)primaryDirectory;
                    return new HybridDirectory(lockFactory, FsDirectoryFactory.setPreload(mMapDirectory, preLoadExtensions), nioExtensions);
                }
                return primaryDirectory;
            }
            case MMAPFS: {
                return FsDirectoryFactory.setPreload(new MMapDirectory(location, lockFactory), preLoadExtensions);
            }
            case SIMPLEFS: 
            case NIOFS: {
                return new NIOFSDirectory(location, lockFactory);
            }
        }
        throw new AssertionError((Object)("unexpected built-in store type [" + String.valueOf((Object)type) + "]"));
    }

    public static MMapDirectory setPreload(MMapDirectory mMapDirectory, Set<String> preLoadExtensions) throws IOException {
        if (!preLoadExtensions.isEmpty()) {
            mMapDirectory.setPreload(FsDirectoryFactory.createPreloadPredicate(preLoadExtensions));
        }
        return mMapDirectory;
    }

    public static boolean isHybridFs(Directory directory) {
        Directory unwrap = FilterDirectory.unwrap((Directory)directory);
        return unwrap instanceof HybridDirectory;
    }

    static BiPredicate<String, IOContext> createPreloadPredicate(Set<String> preLoadExtensions) {
        if (preLoadExtensions.contains("*")) {
            return MMapDirectory.ALL_FILES;
        }
        return (s, f) -> {
            int dotIndex = s.lastIndexOf(46);
            if (dotIndex > 0) {
                return preLoadExtensions.contains(s.substring(dotIndex + 1));
            }
            return false;
        };
    }

    static final class HybridDirectory
    extends NIOFSDirectory {
        private final MMapDirectory delegate;
        private final Set<String> nioExtensions;

        HybridDirectory(LockFactory lockFactory, MMapDirectory delegate, Set<String> nioExtensions) throws IOException {
            super(delegate.getDirectory(), lockFactory);
            this.delegate = delegate;
            this.nioExtensions = nioExtensions;
        }

        public IndexInput openInput(String name, IOContext context) throws IOException {
            if (this.useDelegate(name)) {
                this.ensureOpen();
                this.ensureCanRead(name);
                return this.delegate.openInput(name, context);
            }
            return super.openInput(name, context);
        }

        boolean useDelegate(String name) {
            String extension = FileSwitchDirectory.getExtension((String)name);
            return !this.nioExtensions.contains(extension);
        }

        public void close() throws IOException {
            IOUtils.close((Closeable[])new Closeable[]{() -> super.close(), this.delegate});
        }

        MMapDirectory getDelegate() {
            return this.delegate;
        }
    }
}

