/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.response.search;

import java.io.IOException;
import org.opensearch.ExceptionsHelper;
import org.opensearch.core.action.ShardOperationFailedException;
import org.opensearch.core.common.util.CollectionUtils;
import org.opensearch.protobufs.ShardStatistics;
import org.opensearch.transport.grpc.proto.response.exceptions.shardoperationfailedexception.ShardOperationFailedExceptionProtoUtils;

public class ShardStatisticsProtoUtils {
    private ShardStatisticsProtoUtils() {
    }

    protected static ShardStatistics getShardStats(int total, int successful, int skipped, int failed, ShardOperationFailedException[] shardFailures) throws IOException {
        ShardStatistics.Builder shardStats = ShardStatistics.newBuilder();
        shardStats.setTotal(total);
        shardStats.setSuccessful(successful);
        if (skipped >= 0) {
            shardStats.setSkipped(skipped);
        }
        shardStats.setFailed(failed);
        if (!CollectionUtils.isEmpty((Object[])shardFailures)) {
            for (ShardOperationFailedException shardFailure : ExceptionsHelper.groupBy((ShardOperationFailedException[])shardFailures)) {
                shardStats.addFailures(ShardOperationFailedExceptionProtoUtils.toProto(shardFailure));
            }
        }
        return shardStats.build();
    }
}

