/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.response.search;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene.search.Explanation;
import org.opensearch.common.document.DocumentField;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.protobufs.Explanation;
import org.opensearch.protobufs.Hit;
import org.opensearch.protobufs.HitsMetadata;
import org.opensearch.protobufs.InnerHitsResult;
import org.opensearch.protobufs.NestedIdentity;
import org.opensearch.protobufs.NullValue;
import org.opensearch.protobufs.ObjectMap;
import org.opensearch.search.SearchHit;
import org.opensearch.search.SearchHits;
import org.opensearch.search.fetch.subphase.highlight.HighlightField;
import org.opensearch.transport.RemoteClusterAware;
import org.opensearch.transport.grpc.proto.response.common.ObjectMapProtoUtils;
import org.opensearch.transport.grpc.proto.response.search.HighlightFieldProtoUtils;
import org.opensearch.transport.grpc.proto.response.search.SearchHitsProtoUtils;
import org.opensearch.transport.grpc.proto.response.search.SearchSortValuesProtoUtils;

public class SearchHitProtoUtils {
    private SearchHitProtoUtils() {
    }

    protected static Hit toProto(SearchHit hit) throws IOException {
        Hit.Builder hitBuilder = Hit.newBuilder();
        SearchHitProtoUtils.toProto(hit, hitBuilder);
        return hitBuilder.build();
    }

    protected static void toProto(SearchHit hit, Hit.Builder hitBuilder) throws IOException {
        SearchHitProtoUtils.processShardInfo(hit, hitBuilder);
        SearchHitProtoUtils.processBasicInfo(hit, hitBuilder);
        SearchHitProtoUtils.processScore(hit, hitBuilder);
        SearchHitProtoUtils.processMetadataFields(hit, hitBuilder);
        SearchHitProtoUtils.processSource(hit, hitBuilder);
        SearchHitProtoUtils.processDocumentFields(hit, hitBuilder);
        SearchHitProtoUtils.processHighlightFields(hit, hitBuilder);
        SearchSortValuesProtoUtils.toProto(hitBuilder, hit.getSortValues());
        SearchHitProtoUtils.processMatchedQueries(hit, hitBuilder);
        SearchHitProtoUtils.processExplanation(hit, hitBuilder);
        SearchHitProtoUtils.processInnerHits(hit, hitBuilder);
    }

    private static void processShardInfo(SearchHit hit, Hit.Builder hitBuilder) {
        if (hit.getExplanation() != null && hit.getShard() != null) {
            hitBuilder.setShard(String.valueOf(hit.getShard().getShardId().id()));
            hitBuilder.setNode(hit.getShard().getNodeIdText().string());
        }
    }

    private static void processBasicInfo(SearchHit hit, Hit.Builder hitBuilder) {
        if (hit.getIndex() != null) {
            hitBuilder.setIndex(RemoteClusterAware.buildRemoteIndexName((String)hit.getClusterAlias(), (String)hit.getIndex()));
        }
        if (hit.getId() != null) {
            hitBuilder.setId(hit.getId());
        }
        if (hit.getNestedIdentity() != null) {
            hitBuilder.setNested(NestedIdentityProtoUtils.toProto(hit.getNestedIdentity()));
        }
        if (hit.getVersion() != -1L) {
            hitBuilder.setVersion(hit.getVersion());
        }
        if (hit.getSeqNo() != -2L) {
            hitBuilder.setSeqNo(hit.getSeqNo());
            hitBuilder.setPrimaryTerm(hit.getPrimaryTerm());
        }
    }

    private static void processScore(SearchHit hit, Hit.Builder hitBuilder) {
        Hit.Score.Builder scoreBuilder = Hit.Score.newBuilder();
        if (Float.isNaN(hit.getScore())) {
            scoreBuilder.setNullValue(NullValue.NULL_VALUE_NULL);
        } else {
            scoreBuilder.setFloatValue(hit.getScore());
        }
        hitBuilder.setScore(scoreBuilder.build());
    }

    private static void processMetadataFields(SearchHit hit, Hit.Builder hitBuilder) {
        if (hit.getMetaFields().values().stream().anyMatch(field -> !field.getValues().isEmpty())) {
            ObjectMap.Builder objectMapBuilder = ObjectMap.newBuilder();
            for (DocumentField field2 : hit.getMetaFields().values()) {
                if (field2.getValues().isEmpty()) continue;
                objectMapBuilder.putFields(field2.getName(), ObjectMapProtoUtils.toProto(field2.getValues()));
            }
            hitBuilder.setMetaFields(objectMapBuilder.build());
        }
    }

    private static void processSource(SearchHit hit, Hit.Builder hitBuilder) {
        if (hit.getSourceRef() != null) {
            hitBuilder.setSource(ByteString.copyFrom((byte[])BytesReference.toBytes((BytesReference)hit.getSourceRef())));
        }
    }

    private static void processDocumentFields(SearchHit hit, Hit.Builder hitBuilder) {
        if (!hit.getDocumentFields().isEmpty() && hit.getDocumentFields().values().stream().anyMatch(df -> !df.getValues().isEmpty())) {
            ObjectMap.Builder fieldsStructBuilder = ObjectMap.newBuilder();
            for (DocumentField field : hit.getDocumentFields().values()) {
                if (field.getValues().isEmpty()) continue;
                fieldsStructBuilder.putFields(field.getName(), ObjectMapProtoUtils.toProto(field.getValues()));
            }
            hitBuilder.setFields(fieldsStructBuilder.build());
        }
    }

    private static void processHighlightFields(SearchHit hit, Hit.Builder hitBuilder) {
        if (hit.getHighlightFields() != null && !hit.getHighlightFields().isEmpty()) {
            for (HighlightField field : hit.getHighlightFields().values()) {
                hitBuilder.putHighlight(field.getName(), HighlightFieldProtoUtils.toProto(field.getFragments()));
            }
        }
    }

    private static void processMatchedQueries(SearchHit hit, Hit.Builder hitBuilder) {
        boolean includeMatchedQueriesScore;
        if (hit.getMatchedQueries().length > 0 && !(includeMatchedQueriesScore = false)) {
            for (String matchedFilter : hit.getMatchedQueries()) {
                hitBuilder.addMatchedQueries(matchedFilter);
            }
        }
    }

    private static void processExplanation(SearchHit hit, Hit.Builder hitBuilder) throws IOException {
        if (hit.getExplanation() != null) {
            Explanation.Builder explanationBuilder = org.opensearch.protobufs.Explanation.newBuilder();
            SearchHitProtoUtils.buildExplanation(hit.getExplanation(), explanationBuilder);
            hitBuilder.setExplanation(explanationBuilder.build());
        }
    }

    private static void processInnerHits(SearchHit hit, Hit.Builder hitBuilder) throws IOException {
        if (hit.getInnerHits() != null) {
            for (Map.Entry entry : hit.getInnerHits().entrySet()) {
                HitsMetadata.Builder hitsBuilder = HitsMetadata.newBuilder();
                SearchHitsProtoUtils.toProto((SearchHits)entry.getValue(), hitsBuilder);
                hitBuilder.putInnerHits((String)entry.getKey(), InnerHitsResult.newBuilder().setHits(hitsBuilder.build()).build());
            }
        }
    }

    private static void buildExplanation(Explanation explanation, Explanation.Builder protoExplanationBuilder) throws IOException {
        protoExplanationBuilder.setValue(explanation.getValue().doubleValue());
        protoExplanationBuilder.setDescription(explanation.getDescription());
        Explanation[] innerExps = explanation.getDetails();
        if (innerExps != null) {
            for (Explanation exp : innerExps) {
                Explanation.Builder detailBuilder = org.opensearch.protobufs.Explanation.newBuilder();
                SearchHitProtoUtils.buildExplanation(exp, detailBuilder);
                protoExplanationBuilder.addDetails(detailBuilder.build());
            }
        }
    }

    protected static class NestedIdentityProtoUtils {
        private NestedIdentityProtoUtils() {
        }

        protected static NestedIdentity toProto(SearchHit.NestedIdentity nestedIdentity) {
            NestedIdentity.Builder nestedIdentityBuilder = NestedIdentity.newBuilder();
            NestedIdentityProtoUtils.toProto(nestedIdentity, nestedIdentityBuilder);
            return nestedIdentityBuilder.build();
        }

        protected static void toProto(SearchHit.NestedIdentity nestedIdentity, NestedIdentity.Builder nestedIdentityBuilder) {
            if (nestedIdentity.getField() != null) {
                nestedIdentityBuilder.setField(nestedIdentity.getField().string());
            }
            if (nestedIdentity.getOffset() != -1) {
                nestedIdentityBuilder.setOffset(nestedIdentity.getOffset());
            }
            if (nestedIdentity.getChild() != null) {
                NestedIdentity.Builder childBuilder = NestedIdentity.newBuilder();
                NestedIdentityProtoUtils.toProto(nestedIdentity.getChild(), childBuilder);
                nestedIdentityBuilder.setNested(childBuilder.build());
            }
        }
    }
}

