/*
 * Decompiled with CFR 0.152.
 */
package mdemangler.object;

import mdemangler.MDException;
import mdemangler.MDMang;
import mdemangler.MDParsableItem;
import mdemangler.datatype.MDDataTypeParser;
import mdemangler.object.MDObjectBracket;
import mdemangler.object.MDObjectC;
import mdemangler.object.MDObjectCPP;
import mdemangler.object.MDObjectCatch;
import mdemangler.object.MDObjectCatchSym;
import mdemangler.object.MDObjectCatchableType;
import mdemangler.object.MDObjectCatchableTypeArray;
import mdemangler.object.MDObjectCodeView;
import mdemangler.object.MDObjectEHHandler;
import mdemangler.object.MDObjectReserved;
import mdemangler.object.MDObjectThrowInfo;
import mdemangler.object.MDObjectTryBlockTable;
import mdemangler.object.MDObjectUnwindFunclet;
import mdemangler.object.MDObjectUnwindTable;
import mdemangler.template.MDTemplateNameAndArguments;

public class MDMangObjectParser {
    public static MDParsableItem determineItemAndParse(MDMang dmang) throws MDException {
        boolean retry = false;
        MDException firstException = null;
        MDParsableItem myItem = null;
        int index = dmang.getIndex();
        try {
            myItem = MDMangObjectParser.parseDefaultStandard(dmang);
            if (myItem != null) {
                myItem.parse();
            } else {
                retry = true;
            }
        }
        catch (MDException e) {
            retry = true;
            myItem = null;
            firstException = e;
        }
        if (!retry) {
            return myItem;
        }
        try {
            dmang.setIndex(index);
            myItem = MDMangObjectParser.parseLlvm(dmang);
            if (myItem != null) {
                myItem.parse();
            }
        }
        catch (MDException e) {
            if (firstException != null) {
                throw firstException;
            }
            throw e;
        }
        if (myItem == null && firstException != null) {
            throw firstException;
        }
        return myItem;
    }

    public static MDParsableItem parseDefaultStandard(MDMang dmang) throws MDException {
        MDParsableItem item;
        dmang.setProcessingMode(MDMang.ProcessingMode.DEFAULT_STANDARD);
        if (dmang.peek() == '?') {
            item = dmang.peek(1) == '@' ? new MDObjectCodeView(dmang) : (dmang.peek(1) == '$' ? new MDTemplateNameAndArguments(dmang) : new MDObjectCPP(dmang));
        } else if (dmang.peek() == '_' && (dmang.peek(1) == '_' || dmang.peek(1) >= 'A' && dmang.peek(1) <= 'Z')) {
            item = MDMangObjectParser.parseObjectReserved(dmang);
        } else if (dmang.peek() == '.') {
            dmang.increment();
            item = MDDataTypeParser.parseDataType(dmang, false);
        } else {
            item = new MDObjectC(dmang);
        }
        return item;
    }

    public static MDParsableItem parseLlvm(MDMang dmang) {
        if (dmang.peek() != '?' && dmang.peek(1) != '$') {
            return null;
        }
        dmang.setProcessingMode(MDMang.ProcessingMode.LLVM);
        MDObjectCPP item = new MDObjectCPP(dmang);
        return item;
    }

    public static MDParsableItem parseObjectReserved(MDMang dmang) {
        MDObjectReserved item;
        if (dmang.positionStartsWith("__TI")) {
            dmang.increment("__TI".length());
            item = new MDObjectThrowInfo(dmang);
        } else if (dmang.positionStartsWith("_TI")) {
            dmang.increment("_TI".length());
            item = new MDObjectThrowInfo(dmang);
        } else if (dmang.positionStartsWith("__CTA")) {
            dmang.increment("__CTA".length());
            item = new MDObjectCatchableTypeArray(dmang);
        } else if (dmang.positionStartsWith("__CT")) {
            dmang.increment("__CT".length());
            item = new MDObjectCatchableType(dmang);
        } else if (dmang.positionStartsWith("_CTA")) {
            dmang.increment("_CTA".length());
            item = new MDObjectCatchableTypeArray(dmang);
        } else if (dmang.positionStartsWith("_CT")) {
            dmang.increment("_CT".length());
            item = new MDObjectCatchableType(dmang);
        } else if (dmang.positionStartsWith("__catch$")) {
            dmang.increment("__catch$".length());
            item = new MDObjectCatch(dmang);
        } else if (dmang.positionStartsWith("__catchsym$")) {
            dmang.increment("__catchsym$".length());
            item = new MDObjectCatchSym(dmang);
        } else if (dmang.positionStartsWith("__unwindfunclet$")) {
            dmang.increment("__unwindfunclet$".length());
            item = new MDObjectUnwindFunclet(dmang);
        } else if (dmang.positionStartsWith("__tryblocktable$")) {
            dmang.increment("__tryblocktable$".length());
            item = new MDObjectTryBlockTable(dmang);
        } else if (dmang.positionStartsWith("__unwindtable$")) {
            dmang.increment("__unwindtable$".length());
            item = new MDObjectUnwindTable(dmang);
        } else if (dmang.positionStartsWith("__ehhandler$")) {
            dmang.increment("__ehhandler$".length());
            item = new MDObjectEHHandler(dmang);
        } else {
            item = dmang.positionStartsWith("__m2mep@") ? new MDObjectBracket(dmang) : (dmang.positionStartsWith("__mep@") ? new MDObjectBracket(dmang) : (dmang.positionStartsWith("__t2m@") ? new MDObjectBracket(dmang) : (dmang.positionStartsWith("__unep@") ? new MDObjectBracket(dmang) : new MDObjectReserved(dmang))));
        }
        return item;
    }
}

