/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.protocol.ghidra;

import ghidra.framework.client.ClientUtil;
import ghidra.framework.client.NotConnectedException;
import ghidra.framework.client.RepositoryNotFoundException;
import ghidra.framework.protocol.ghidra.GhidraProtocolConnector;
import ghidra.framework.protocol.ghidra.GhidraURL;
import ghidra.framework.protocol.ghidra.GhidraURLConnection;
import ghidra.util.Msg;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.security.auth.login.LoginException;

public class DefaultGhidraProtocolConnector
extends GhidraProtocolConnector {
    private boolean readOnly;

    DefaultGhidraProtocolConnector(URL ghidraURL) throws MalformedURLException {
        super(ghidraURL);
    }

    @Override
    public boolean isReadOnly() throws NotConnectedException {
        if (this.statusCode == null) {
            throw new NotConnectedException("not connected");
        }
        return this.readOnly;
    }

    @Override
    public GhidraURLConnection.StatusCode connect(boolean readOnlyAccess) throws IOException {
        if (this.statusCode != null) {
            throw new IllegalStateException("already connected");
        }
        this.readOnly = readOnlyAccess;
        this.statusCode = GhidraURLConnection.StatusCode.UNAVAILABLE;
        this.repositoryServerAdapter = ClientUtil.getRepositoryServer((String)this.url.getHost(), (int)this.url.getPort(), (boolean)true);
        if (this.repositoryName == null) {
            this.statusCode = GhidraURLConnection.StatusCode.OK;
            return this.statusCode;
        }
        this.repositoryAdapter = this.repositoryServerAdapter.getRepository(this.repositoryName);
        if (this.repositoryServerAdapter.isConnected()) {
            try {
                this.repositoryAdapter.connect();
            }
            catch (RepositoryNotFoundException e) {
                this.statusCode = GhidraURLConnection.StatusCode.NOT_FOUND;
                return this.statusCode;
            }
        } else if (!this.repositoryServerAdapter.isCancelled()) {
            Throwable t = this.repositoryServerAdapter.getLastConnectError();
            if (t instanceof LoginException) {
                this.statusCode = GhidraURLConnection.StatusCode.UNAUTHORIZED;
            }
            return this.statusCode;
        }
        if (this.repositoryAdapter.isConnected()) {
            this.statusCode = GhidraURLConnection.StatusCode.OK;
            if (!this.repositoryAdapter.getUser().hasWritePermission() && !this.readOnly) {
                this.readOnly = true;
                Msg.warn((Object)this, (Object)("User does not have write permission for repository: " + this.repositoryName));
            }
            this.resolveItemPath();
        } else {
            this.statusCode = GhidraURLConnection.StatusCode.UNAUTHORIZED;
        }
        return this.statusCode;
    }

    @Override
    protected URL getRepositoryRootGhidraURL() {
        if (this.repositoryName != null) {
            return GhidraURL.makeURL(this.url.getHost(), this.url.getPort(), this.repositoryName);
        }
        return null;
    }
}

