/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.model;

import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainFolderChangeListener;
import ghidra.framework.model.DomainObject;
import ghidra.framework.store.FileSystem;
import java.lang.reflect.Method;

public abstract class DomainFolderListenerAdapter
implements DomainFolderChangeListener {
    private final boolean enableStateChangeCallback;

    protected DomainFolderListenerAdapter() {
        boolean foundStateChangedMethod = false;
        try {
            Method method = this.getClass().getMethod("stateChanged", String.class, String.class, Boolean.TYPE);
            if (!method.getDeclaringClass().equals(DomainFolderListenerAdapter.class)) {
                foundStateChangedMethod = true;
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        this.enableStateChangeCallback = foundStateChangedMethod;
    }

    public void stateChanged(String affectedNewPath, String affectedOldPath, boolean isFolder) {
    }

    private String getPathname(DomainFolder parentFolder, String childName) {
        Object path = parentFolder.getPathname();
        if (((String)path).length() != FileSystem.SEPARATOR.length()) {
            path = (String)path + FileSystem.SEPARATOR;
        }
        path = (String)path + childName;
        return path;
    }

    @Override
    public void domainFolderAdded(DomainFolder folder) {
        if (this.enableStateChangeCallback) {
            this.stateChanged(folder.getPathname(), null, true);
        }
    }

    @Override
    public void domainFileAdded(DomainFile file) {
        if (this.enableStateChangeCallback) {
            this.stateChanged(file.getPathname(), null, false);
        }
    }

    @Override
    public void domainFolderRemoved(DomainFolder parent, String name) {
        if (this.enableStateChangeCallback) {
            this.stateChanged(null, this.getPathname(parent, name), true);
        }
    }

    @Override
    public void domainFileRemoved(DomainFolder parent, String name, String fileID) {
        if (this.enableStateChangeCallback) {
            this.stateChanged(null, this.getPathname(parent, name), false);
        }
    }

    @Override
    public void domainFolderRenamed(DomainFolder folder, String oldName) {
        if (this.enableStateChangeCallback) {
            this.stateChanged(folder.getPathname(), this.getPathname(folder.getParent(), oldName), true);
        }
    }

    @Override
    public void domainFileRenamed(DomainFile file, String oldName) {
        if (this.enableStateChangeCallback) {
            this.stateChanged(file.getPathname(), this.getPathname(file.getParent(), oldName), false);
        }
    }

    @Override
    public void domainFolderMoved(DomainFolder folder, DomainFolder oldParent) {
        if (this.enableStateChangeCallback) {
            this.stateChanged(folder.getPathname(), this.getPathname(oldParent, folder.getName()), true);
        }
    }

    @Override
    public void domainFileMoved(DomainFile file, DomainFolder oldParent, String oldName) {
        if (this.enableStateChangeCallback) {
            this.stateChanged(file.getPathname(), this.getPathname(oldParent, oldName), false);
        }
    }

    @Override
    public void domainFolderSetActive(DomainFolder folder) {
    }

    @Override
    public void domainFileStatusChanged(DomainFile file, boolean fileIDset) {
        if (this.enableStateChangeCallback) {
            String path = file.getPathname();
            this.stateChanged(path, path, false);
        }
    }

    @Override
    public void domainFileObjectReplaced(DomainFile file, DomainObject oldObject) {
    }

    @Override
    public void domainFileObjectOpenedForUpdate(DomainFile file, DomainObject object) {
    }

    @Override
    public void domainFileObjectClosed(DomainFile file, DomainObject object) {
    }
}

