/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.datatree;

import docking.widgets.checkbox.GCheckBox;
import docking.widgets.list.ListPanel;
import generic.theme.GThemeDefaults;
import ghidra.framework.model.DomainFile;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

class DomainFilesPanel
extends JPanel {
    private List<DomainFile> fileList;
    private GCheckBox[] checkboxes;
    private ListPanel<JCheckBox> listPanel;

    DomainFilesPanel(List<DomainFile> fileList, String listTitle) {
        this.fileList = fileList;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        JPanel innerPanel = new JPanel(new BorderLayout());
        this.checkboxes = new GCheckBox[fileList.size()];
        for (int i = 0; i < fileList.size(); ++i) {
            DomainFile df = fileList.get(i);
            this.checkboxes[i] = new GCheckBox(df.getPathname(), true);
            this.checkboxes[i].setBackground((Color)GThemeDefaults.Colors.BACKGROUND);
        }
        this.listPanel = new ListPanel();
        this.listPanel.setCellRenderer((ListCellRenderer)new DataCellRenderer());
        this.listPanel.setMouseListener((MouseListener)new ListMouseListener());
        if (listTitle != null) {
            this.listPanel.setListTitle(listTitle);
        }
        innerPanel.add((Component)this.listPanel, "Center");
        this.add((Component)innerPanel, "Center");
        this.listPanel.setListData((Object[])this.checkboxes);
        Dimension d = this.listPanel.getPreferredSize();
        if (d.width < 250) {
            this.listPanel.setPreferredSize(new Dimension(250, this.listPanel.getPreferredSize().height));
        }
    }

    DomainFile[] getSelectedDomainFiles() {
        ArrayList<DomainFile> list = new ArrayList<DomainFile>();
        for (int i = 0; i < this.checkboxes.length; ++i) {
            if (!this.checkboxes[i].isSelected()) continue;
            list.add(this.fileList.get(i));
        }
        DomainFile[] files = new DomainFile[list.size()];
        return list.toArray(files);
    }

    private class DataCellRenderer
    implements ListCellRenderer<JCheckBox> {
        private DataCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends JCheckBox> list, JCheckBox value, int index, boolean isSelected, boolean cellHasFocus) {
            if (index == -1) {
                int selected = list.getSelectedIndex();
                if (selected == -1) {
                    return null;
                }
                index = selected;
            }
            return DomainFilesPanel.this.checkboxes[index];
        }
    }

    private class ListMouseListener
    extends MouseAdapter {
        private ListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() != 1) {
                return;
            }
            JList list = (JList)e.getSource();
            int index = list.locationToIndex(e.getPoint());
            if (index < 0) {
                return;
            }
            boolean selected = DomainFilesPanel.this.checkboxes[index].isSelected();
            DomainFilesPanel.this.checkboxes[index].setSelected(!selected);
            list.repaint();
        }
    }
}

