/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.data;

import ghidra.framework.data.DomainObjectAdapterDB;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.CancelledListener;
import ghidra.util.task.TaskDialog;
import ghidra.util.task.TaskMonitor;

class LockingTaskMonitor
implements TaskMonitor {
    private DomainObjectAdapterDB dobj;
    private final String title;
    private boolean isCanceled = false;
    private boolean cancelEnabled = true;
    private final boolean hasProgress;
    private long maxProgress;
    private long curProgress;
    private boolean indeterminate;
    private boolean showProgressValue = true;
    private String msg;
    private MyTaskDialog taskDialog;

    LockingTaskMonitor(DomainObjectAdapterDB dobj, boolean hasProgress, String title) {
        this.dobj = dobj;
        this.hasProgress = hasProgress;
        this.title = title;
    }

    DomainObjectAdapterDB getDomainObject() {
        return this.dobj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForTaskCompletion() {
        LockingTaskMonitor lockingTaskMonitor = this;
        synchronized (lockingTaskMonitor) {
            if (this.dobj == null) {
                return;
            }
            if (this.taskDialog != null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return;
            }
            this.taskDialog = new MyTaskDialog();
        }
        MyTaskDialog dialog = this.taskDialog;
        if (dialog != null) {
            SystemUtilities.runSwingNow(() -> dialog.show(0));
        }
    }

    public synchronized boolean isCancelled() {
        return this.taskDialog != null ? this.taskDialog.isCancelled() : this.isCanceled;
    }

    synchronized void releaseLock() {
        if (this.dobj != null) {
            this.dobj.unlock(this);
            this.dobj = null;
        }
        if (this.taskDialog != null) {
            this.taskDialog.taskProcessed();
            this.taskDialog = null;
        }
        this.notifyAll();
    }

    public synchronized void setMessage(String msg) {
        this.msg = msg;
        if (this.taskDialog != null) {
            this.taskDialog.setMessage(msg);
        }
    }

    public synchronized String getMessage() {
        return this.msg;
    }

    public synchronized void setProgress(long value) {
        this.curProgress = value;
        if (this.taskDialog != null) {
            this.taskDialog.setProgress(value);
        }
    }

    public synchronized void initialize(long max) {
        this.setMaximum(max);
        this.setProgress(0L);
    }

    public synchronized void setMaximum(long max) {
        this.maxProgress = max;
        if (this.taskDialog != null) {
            this.taskDialog.setMaximum(max);
        }
    }

    public long getMaximum() {
        return this.maxProgress;
    }

    public void setShowProgressValue(boolean showProgressValue) {
        this.showProgressValue = showProgressValue;
        if (this.taskDialog != null) {
            this.taskDialog.setShowProgressValue(showProgressValue);
        }
    }

    public void setIndeterminate(boolean indeterminate) {
        this.indeterminate = indeterminate;
        if (this.taskDialog != null) {
            this.taskDialog.setIndeterminate(indeterminate);
        }
    }

    public boolean isIndeterminate() {
        return this.indeterminate;
    }

    public synchronized void setCancelEnabled(boolean enable) {
        this.cancelEnabled = enable;
        if (this.taskDialog != null) {
            this.taskDialog.setCancelEnabled(enable);
        }
    }

    public synchronized boolean isCancelEnabled() {
        return this.taskDialog != null ? this.taskDialog.isCancelEnabled() : this.cancelEnabled;
    }

    public synchronized void cancel() {
        this.isCanceled = true;
        if (this.taskDialog != null) {
            this.taskDialog.cancel();
        }
    }

    public void clearCanceled() {
        this.isCanceled = false;
        if (this.taskDialog != null) {
            this.taskDialog.clearCancelled();
        }
    }

    public void checkCanceled() throws CancelledException {
        if (this.isCancelled()) {
            throw new CancelledException();
        }
    }

    public void incrementProgress(long incrementAmount) {
        this.setProgress(this.curProgress + incrementAmount);
    }

    public long getProgress() {
        return this.curProgress;
    }

    public void addCancelledListener(CancelledListener listener) {
        throw new UnsupportedOperationException();
    }

    public void removeCancelledListener(CancelledListener listener) {
        throw new UnsupportedOperationException();
    }

    private class MyTaskDialog
    extends TaskDialog {
        MyTaskDialog() {
            super(LockingTaskMonitor.this.title, true, true, LockingTaskMonitor.this.hasProgress);
            this.setCancelEnabled(LockingTaskMonitor.this.cancelEnabled);
            if (LockingTaskMonitor.this.hasProgress) {
                this.initialize(LockingTaskMonitor.this.maxProgress);
                this.setProgress(LockingTaskMonitor.this.curProgress);
                this.setIndeterminate(LockingTaskMonitor.this.indeterminate);
                this.setShowProgressValue(LockingTaskMonitor.this.showProgressValue);
            }
            if (LockingTaskMonitor.this.msg != null) {
                this.setMessage(LockingTaskMonitor.this.msg);
            }
        }
    }
}

