/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.gui;

import docking.Tool;
import docking.action.builder.ActionBuilder;
import docking.theme.gui.ThemeEditorDialog;
import docking.theme.gui.ThemeUtils;
import generic.theme.GTheme;
import generic.theme.ThemeManager;
import ghidra.app.plugin.gui.CreateThemeDialog;
import ghidra.app.plugin.gui.ThemeChooserDialog;
import ghidra.framework.main.ApplicationLevelOnlyPlugin;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.util.HelpLocation;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Utility", category="Support", shortDescription="Manages themes for the Ghidra GUI", description="Adds actions and options to manage Themes within Ghidra. This plugin is available only in the Ghidra Project Window.")
public class ThemeManagerPlugin
extends Plugin
implements ApplicationLevelOnlyPlugin {
    private ThemeManager themeManager = ThemeManager.getInstance();

    public ThemeManagerPlugin(PluginTool tool) {
        super(tool);
    }

    @Override
    protected void init() {
        String owner = this.getName();
        String group = "theme";
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Switch Theme", owner).menuPath(new String[]{"Edit", "Theme", "Switch..."})).menuGroup(group, "1")).helpLocation(new HelpLocation("Theming", "Switch_Theme"))).onAction(e -> this.switchTheme())).buildAndInstall((Tool)this.tool);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Configure", owner).menuPath(new String[]{"Edit", "Theme", "Configure"})).menuGroup(group, "2")).helpLocation(new HelpLocation("Theming", "Edit_Theme"))).onAction(e -> this.configure())).buildAndInstall((Tool)this.tool);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("New Theme", owner).menuPath(new String[]{"Edit", "Theme", "New..."})).menuGroup(group, "3")).helpLocation(new HelpLocation("Theming", "New_Theme"))).onAction(e -> this.createNewTheme())).buildAndInstall((Tool)this.tool);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Import Theme", owner).menuPath(new String[]{"Edit", "Theme", "Import..."})).menuGroup(group, "4")).helpLocation(new HelpLocation("Theming", "Import_Theme"))).onAction(e -> ThemeUtils.importTheme((ThemeManager)this.themeManager))).buildAndInstall((Tool)this.tool);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Export Theme", owner).menuPath(new String[]{"Edit", "Theme", "Export..."})).menuGroup(group, "5")).helpLocation(new HelpLocation("Theming", "Export_Theme"))).onAction(e -> ThemeUtils.exportTheme((ThemeManager)this.themeManager))).buildAndInstall((Tool)this.tool);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Delete Theme", owner).menuPath(new String[]{"Edit", "Theme", "Delete..."})).menuGroup(group, "6")).helpLocation(new HelpLocation("Theming", "Delete_Theme"))).onAction(e -> ThemeUtils.deleteTheme((ThemeManager)this.themeManager))).buildAndInstall((Tool)this.tool);
    }

    private void switchTheme() {
        ThemeChooserDialog dialog = new ThemeChooserDialog(this.themeManager);
        this.tool.showDialog(dialog);
    }

    private void createNewTheme() {
        if (!ThemeUtils.askToSaveThemeChanges((ThemeManager)this.themeManager)) {
            return;
        }
        CreateThemeDialog dialog = new CreateThemeDialog(this.themeManager);
        GTheme newTheme = dialog.getNewTheme(this.tool, "New Theme");
        if (newTheme != null) {
            this.themeManager.addTheme(newTheme);
            this.themeManager.setTheme(newTheme);
            this.configure();
        }
    }

    private void configure() {
        ThemeEditorDialog dialog = ThemeEditorDialog.getRunningInstance();
        if (dialog != null) {
            dialog.toFront();
            return;
        }
        ThemeEditorDialog.editTheme((ThemeManager)this.themeManager);
    }

    @Override
    protected boolean canClose() {
        if (this.themeManager.hasThemeChanges()) {
            return ThemeUtils.askToSaveThemeChanges((ThemeManager)this.themeManager);
        }
        return true;
    }
}

