/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.model.impl;

import agent.gdb.manager.GdbRegister;
import agent.gdb.model.impl.GdbModelImpl;
import agent.gdb.model.impl.GdbModelTargetStackFrameRegisterContainer;
import ghidra.dbg.agent.AbstractDebuggerObjectModel;
import ghidra.dbg.agent.DefaultTargetObject;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetRegister;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.dbg.util.PathUtils;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;

@TargetObjectSchemaInfo(name="RegisterValue", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(type=Void.class)})
public class GdbModelTargetStackFrameRegister
extends DefaultTargetObject<TargetObject, GdbModelTargetStackFrameRegisterContainer>
implements TargetRegister {
    protected final GdbModelImpl impl;
    protected final GdbRegister register;
    protected final int bitLength;

    protected static String indexRegister(GdbRegister register) {
        String name = register.getName();
        if ("".equals(name)) {
            return "UNNAMED," + register.getNumber();
        }
        return name;
    }

    protected static String keyRegister(GdbRegister register) {
        return PathUtils.makeKey((String)GdbModelTargetStackFrameRegister.indexRegister(register));
    }

    public GdbModelTargetStackFrameRegister(GdbModelTargetStackFrameRegisterContainer registers, GdbRegister register) {
        super((AbstractDebuggerObjectModel)registers.impl, (TargetObject)registers, GdbModelTargetStackFrameRegister.keyRegister(register), "Register");
        this.impl = registers.impl;
        this.register = register;
        this.impl.addModelObject(register, (TargetObject)this);
        this.bitLength = register.getSize() * 8;
        this.changeAttributes(List.of(), Map.of("_container", registers, "_length", this.bitLength, "_display", this.getName(), "_modified", false), "Initialized");
    }

    public String getDisplay() {
        return this.getCachedAttribute("_display").toString();
    }

    public void stateChanged(byte[] bytes) {
        BigInteger bigval = new BigInteger(1, bytes);
        String value = bigval.toString(16);
        Object oldval = this.getCachedAttributes().get("_value");
        boolean modified = bigval.longValue() != 0L && value.equals(oldval);
        String newval = this.getName() + " : " + value;
        this.changeAttributes(List.of(), Map.of("_value", value, "_display", newval, "_modified", modified), "Value Updated");
    }
}

