/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.manager.impl.cmd;

import agent.gdb.manager.evt.AbstractGdbCompletedCommandEvent;
import agent.gdb.manager.evt.GdbCommandRunningEvent;
import agent.gdb.manager.evt.GdbRunningEvent;
import agent.gdb.manager.impl.GdbCommand;
import agent.gdb.manager.impl.GdbEvent;
import agent.gdb.manager.impl.GdbManagerImpl;
import agent.gdb.manager.impl.GdbPendingCommand;

public interface MixinResumeInCliGdbCommand<T>
extends GdbCommand<T> {
    default public GdbManagerImpl.Interpreter getInterpreter(GdbManagerImpl manager) {
        if (manager.hasCli()) {
            return GdbManagerImpl.Interpreter.CLI;
        }
        return GdbManagerImpl.Interpreter.MI2;
    }

    default public boolean handleExpectingRunning(GdbEvent<?> evt, GdbPendingCommand<?> pending) {
        if (this.getInterpreter() == GdbManagerImpl.Interpreter.CLI) {
            if (evt instanceof GdbRunningEvent) {
                pending.claim(evt);
                return true;
            }
            if (evt instanceof AbstractGdbCompletedCommandEvent) {
                pending.claim(evt);
                return false;
            }
        } else {
            if (evt instanceof GdbCommandRunningEvent) {
                pending.claim(evt);
                return pending.hasAny(GdbRunningEvent.class);
            }
            if (evt instanceof AbstractGdbCompletedCommandEvent) {
                pending.claim(evt);
                return true;
            }
            if (evt instanceof GdbRunningEvent) {
                pending.claim(evt);
                return pending.hasAny(GdbCommandRunningEvent.class);
            }
        }
        return false;
    }

    default public void completeOnRunning(GdbPendingCommand<?> pending) {
        if (this.getInterpreter() == GdbManagerImpl.Interpreter.CLI) {
            pending.findSingleOf(GdbRunningEvent.class);
        } else {
            pending.checkCompletion(GdbCommandRunningEvent.class);
        }
    }
}

