/*
 * Decompiled with CFR 0.152.
 */
package ghidra.debug.api.target;

import docking.ActionContext;
import ghidra.dbg.target.TargetExecutionStateful;
import ghidra.debug.api.target.ActionName;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.trace.model.Trace;
import ghidra.trace.model.breakpoint.TraceBreakpoint;
import ghidra.trace.model.breakpoint.TraceBreakpointKind;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.stack.TraceStackFrame;
import ghidra.trace.model.target.TraceObjectKeyPath;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.Swing;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.function.Function;

public interface Target {
    public static final long TIMEOUT_MILLIS = 10000L;

    public boolean isValid();

    public Trace getTrace();

    public long getSnap();

    public Map<String, ActionEntry> collectActions(ActionName var1, ActionContext var2);

    public TraceThread getThreadForSuccessor(TraceObjectKeyPath var1);

    public TargetExecutionStateful.TargetExecutionState getThreadExecutionState(TraceThread var1);

    public TraceStackFrame getStackFrameForSuccessor(TraceObjectKeyPath var1);

    public boolean isSupportsFocus();

    public TraceObjectKeyPath getFocus();

    public CompletableFuture<Void> activateAsync(DebuggerCoordinates var1, DebuggerCoordinates var2);

    public void activate(DebuggerCoordinates var1, DebuggerCoordinates var2);

    public CompletableFuture<Void> invalidateMemoryCachesAsync();

    public void invalidateMemoryCaches();

    public CompletableFuture<Void> readMemoryAsync(AddressSetView var1, TaskMonitor var2);

    public void readMemory(AddressSetView var1, TaskMonitor var2) throws CancelledException;

    public CompletableFuture<Void> writeMemoryAsync(Address var1, byte[] var2);

    public void writeMemory(Address var1, byte[] var2);

    public CompletableFuture<Void> readRegistersAsync(TracePlatform var1, TraceThread var2, int var3, Set<Register> var4);

    public void readRegisters(TracePlatform var1, TraceThread var2, int var3, Set<Register> var4);

    public CompletableFuture<Void> readRegistersAsync(TracePlatform var1, TraceThread var2, int var3, AddressSetView var4);

    public void readRegisters(TracePlatform var1, TraceThread var2, int var3, AddressSetView var4);

    public CompletableFuture<Void> writeRegisterAsync(TracePlatform var1, TraceThread var2, int var3, RegisterValue var4);

    public void writeRegister(TracePlatform var1, TraceThread var2, int var3, RegisterValue var4);

    public CompletableFuture<Void> writeRegisterAsync(TracePlatform var1, TraceThread var2, int var3, Address var4, byte[] var5);

    public void writeRegister(TracePlatform var1, TraceThread var2, int var3, Address var4, byte[] var5);

    public boolean isVariableExists(TracePlatform var1, TraceThread var2, int var3, Address var4, int var5);

    public CompletableFuture<Void> writeVariableAsync(TracePlatform var1, TraceThread var2, int var3, Address var4, byte[] var5);

    public void writeVariable(TracePlatform var1, TraceThread var2, int var3, Address var4, byte[] var5);

    public Set<TraceBreakpointKind> getSupportedBreakpointKinds();

    public CompletableFuture<Void> placeBreakpointAsync(AddressRange var1, Set<TraceBreakpointKind> var2, String var3, String var4);

    public void placeBreakpoint(AddressRange var1, Set<TraceBreakpointKind> var2, String var3, String var4);

    public boolean isBreakpointValid(TraceBreakpoint var1);

    public CompletableFuture<Void> deleteBreakpointAsync(TraceBreakpoint var1);

    public void deleteBreakpoint(TraceBreakpoint var1);

    public CompletableFuture<Void> toggleBreakpointAsync(TraceBreakpoint var1, boolean var2);

    public void toggleBreakpoint(TraceBreakpoint var1, boolean var2);

    public CompletableFuture<Void> forceTerminateAsync();

    public void forceTerminate();

    public CompletableFuture<Void> disconnectAsync();

    public void disconnect();

    public record ActionEntry(String display, ActionName name, String details, boolean requiresPrompt, BooleanSupplier enabled, Function<Boolean, CompletableFuture<?>> action) {
        public boolean isEnabled() {
            return this.enabled.getAsBoolean();
        }

        public CompletableFuture<?> invokeAsync(boolean prompt) {
            return this.action.apply(prompt).orTimeout(10000L, TimeUnit.MILLISECONDS);
        }

        public void run(boolean prompt) {
            this.get(prompt);
        }

        public Object get(boolean prompt) {
            if (Swing.isSwingThread()) {
                throw new AssertionError((Object)"Refusing to block the Swing thread. Use a Task.");
            }
            try {
                return this.invokeAsync(prompt).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }

        public boolean builtIn() {
            return this.name != null && this.name.builtIn();
        }
    }
}

