/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.manager.cmd;

import agent.frida.manager.cmd.AbstractFridaCommand;
import agent.frida.manager.impl.FridaManagerImpl;
import ghidra.program.model.address.Address;
import java.nio.ByteBuffer;

public class FridaWriteMemoryCommand
extends AbstractFridaCommand<Void> {
    private final Address addr;
    private final ByteBuffer buf;
    private final int len;

    public FridaWriteMemoryCommand(FridaManagerImpl manager, Address addr, ByteBuffer buf, int len) {
        super(manager);
        this.addr = addr;
        this.buf = buf.duplicate();
        this.len = len;
    }

    @Override
    public void invoke() {
        String bufstr = this.buf.toString();
        this.manager.loadScript(this, "write_memory", "var buf = []; var str = '" + bufstr + "';var len = " + this.len + ";for (var i = 0; i < len; ++i) {  var code = str.charCodeAt(i);  buf = buf.concat([code]);}ptr(0x" + this.addr + ").writeByteArray(buf);");
    }
}

